/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.enums;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.taxc.tsate.common.enums.TaxPeriodType;

public enum HistoryDownloadPeriodType {
    ZZSYBNSR("zzsybnsr", new TaxPeriodType[]{TaxPeriodType.MONTH, TaxPeriodType.SEASON}),
    ZDSYBS_YD("zdsybs_yd", new TaxPeriodType[]{TaxPeriodType.MONTH}),
    QYSDSJB("qysdsjb", new TaxPeriodType[]{TaxPeriodType.SEASON}),
    FR0002("FR0002", new TaxPeriodType[]{TaxPeriodType.MONTH, TaxPeriodType.SEASON}),
    FR0003("FR0003", new TaxPeriodType[]{TaxPeriodType.MONTH, TaxPeriodType.SEASON}),
    ZZSXGMNSR("zzsxgmnsr", new TaxPeriodType[]{TaxPeriodType.MONTH, TaxPeriodType.SEASON});

    private final String code;
    private final TaxPeriodType[] taxPeriodTypes;

    private HistoryDownloadPeriodType(String code, TaxPeriodType[] taxPeriodTypes) {
        this.code = code;
        this.taxPeriodTypes = taxPeriodTypes;
    }

    public String getCode() {
        return this.code;
    }

    public TaxPeriodType[] getTaxPeriodTypes() {
        return this.taxPeriodTypes;
    }

    public static HistoryDownloadPeriodType valueOfCode(String code) {
        Optional<HistoryDownloadPeriodType> op = Arrays.asList(HistoryDownloadPeriodType.values()).stream().filter(item -> item.getCode().equals(code)).findFirst();
        return op.isPresent() ? op.get() : null;
    }

    public static List<String> getTaxPeriodTypeCodesByTaxCode(String code) {
        HistoryDownloadPeriodType type = HistoryDownloadPeriodType.valueOfCode(code);
        if (type == null) {
            return new ArrayList<String>(0);
        }
        return Arrays.stream(type.getTaxPeriodTypes()).map(item -> item.getCode()).collect(Collectors.toList());
    }
}

