/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.exportdeclaration.cms;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;
import kd.taxc.tsate.business.exportdeclaration.ExportDeclarationBusiness;
import org.apache.commons.lang3.StringUtils;

public class CmsGatherFormPlugin
extends AbstractFormPlugin {
    private static final String ORG = "org";
    private static final String START_UPDATE_DATE = "startupdatedate";
    private static final String END_UPDATE_DATE = "endupdatedate";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void beforeBindData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        this.getModel().setValue(ORG, customParams.get("defaultOrgId"));
        this.getModel().setValue(START_UPDATE_DATE, customParams.get("startUpdateDate"));
        this.getModel().setValue(END_UPDATE_DATE, customParams.get("endUpdateDate"));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"collection")) {
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            Date startUpdateDate = (Date)this.getModel().getValue(START_UPDATE_DATE);
            Date endUpdateDate = (Date)this.getModel().getValue(END_UPDATE_DATE);
            String exportDeclarationno = (String)this.getModel().getValue("exportdeclarationno");
            String clearanceStatus = (String)this.getModel().getValue("clearancestatus");
            if ((startUpdateDate == null || endUpdateDate == null) && StringUtils.isBlank((CharSequence)exportDeclarationno)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u66f4\u65b0\u65e5\u671f\u201d\u6216\u201c\u51fa\u53e3\u62a5\u5173\u5355\u53f7\u201d\u3002", (String)"CmsGatherFormPlugin_0", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                return;
            }
            if (startUpdateDate != null && endUpdateDate != null && DateUtils.getDayDiff((Date)startUpdateDate, (Date)endUpdateDate) >= 31) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u65e5\u671f\u8303\u56f4\u9700\u5c0f\u4e8e31\u5929\u3002", (String)"CmsGatherFormPlugin_1", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                return;
            }
            ExportDeclarationBusiness.downloadExportDeclaration((Long)org.getLong("id"), (Date)startUpdateDate, (Date)endUpdateDate, (String)exportDeclarationno, (String)"10", (Boolean)false);
            if ("1".equals(clearanceStatus)) {
                ExportDeclarationBusiness.downloadExportDeclaration((Long)org.getLong("id"), (Date)startUpdateDate, (Date)endUpdateDate, (String)exportDeclarationno, (String)"", (Boolean)false);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u62a5\u5173\u5355\u6570\u636e\u91c7\u96c6\u4e2d\uff0c\u8bf7\u7a0d\u540e\u5237\u65b0\u754c\u9762\u67e5\u770b\u6570\u636e\u6216\u524d\u5f80\u91c7\u96c6\u4efb\u52a1\u76d1\u63a7\u67e5\u770b\u8fdb\u5ea6\u3002", (String)"CmsGatherFormPlugin_2", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
        }
    }
}

