/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.record;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.list.plugin.ListViewPluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tsate.business.TsateDeclareRecordBusiness;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.ExecuteStatusEnum;
import kd.taxc.tsate.common.enums.ExecuteTypeEnums;
import kd.taxc.tsate.common.metadata.MetadataUtil;
import kd.taxc.tsate.common.util.BaseDataUtil;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.JsonUtil;
import kd.taxc.tsate.common.util.PermissionUtils;
import kd.taxc.tsate.common.util.TreeUtils;
import kd.taxc.tsate.formplugin.enums.DeclareRecordHiddenEnums;

public class DirectDeclareRecordListPlugin
extends AbstractListPlugin {
    private static final String CONFIRMKEY_REV = "rev_confirm";
    private static Log logger = LogFactory.getLog(DirectDeclareRecordListPlugin.class);
    private static final String SEPARATOR = System.getProperty("line.separator");
    private static final String REVOCATION = "revocation";
    private BeforeCreateListColumnsArgs beforeCreateListColumnsArgs;
    private static String[] TASKTYPES = new String[]{"ZLSB", "ZLJK", "SBJT", "KKJT", "WSPZ", "TBZT", "YYJK", "LSXZ", "QCXZ", "SBZF", "SBSXXZ", "XYDJXZ", "SFZHDXX", "YQXX", "SBJGXX", "JKJGXX", "SBBFILE", "WDTX", "WDDB", "DJKXX", "SJYZ", "JKPZFX", "CKBGDXZ"};

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.btnSetting();
    }

    private void btnSetting() {
        String ishidden = this.getPageCache().get("ishidden");
        if (!"CKBGDXZ".equals(ishidden)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{REVOCATION});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{REVOCATION});
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        ArrayList<Object> orgs = new ArrayList();
        if (null != customParams.get("org")) {
            orgs = Collections.singletonList(customParams.get("org"));
        }
        String tasktypeNumber = (String)customParams.get("tasktype.number");
        this.getPageCache().put("ishidden", tasktypeNumber);
        List commonFilters = args.getFilterContainerInitEvent().getCommonFilterColumns();
        List schemeColumnList = args.getSchemeFilterColumns();
        for (FilterColumn filterColumn : commonFilters) {
            this.dealFilterColum(orgs, filterColumn, tasktypeNumber);
        }
        for (FilterColumn filterColumn : schemeColumnList) {
            this.dealFilterColum(orgs, filterColumn, tasktypeNumber);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperateKey().equals(REVOCATION)) {
            BillList billlist = (BillList)this.getControl("billlistap");
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRMKEY_REV, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"DirectDeclareRecordListPlugin_0", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"DirectDeclareRecordListPlugin_1", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            HashMap customValueMap = new HashMap();
            List pkIds = billlist.getSelectedRows().stream().map(o -> (Long)o.getPrimaryKeyValue()).collect(Collectors.toList());
            customValueMap.put("recordPkIds", pkIds);
            String msg = ResManager.loadKDString((String)"\u60a8\u5df2\u9009\u4e2d%1$s\u6761\u4efb\u52a1\uff0c\u64a4\u9500\u540e\u9700\u8981\u91cd\u65b0\u53d1\u8d77\uff0c\u786e\u5b9a\u64a4\u9500\u5417\uff1f", (String)"DirectDeclareRecordListPlugin_3", (String)"taxc-tsate-formplugin", (Object[])new Object[]{pkIds.size()});
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps, SerializationUtils.toJsonString(customValueMap));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        if (!CONFIRMKEY_REV.equals(callBackId)) {
            return;
        }
        if (event.getResult() != MessageBoxResult.Yes) {
            return;
        }
        String customValue = event.getCustomVaule();
        JSONObject jsonObject = JSONObject.parseObject((String)customValue);
        List ids = (List)jsonObject.get((Object)"recordPkIds");
        if (CONFIRMKEY_REV.equals(callBackId)) {
            DynamicObject[] recordByIds = TsateDeclareRecordBusiness.getRunningRecordByIds((List)ids);
            ArrayList<DynamicObject> needUpdateRecords = new ArrayList<DynamicObject>(16);
            for (int i = 0; i < recordByIds.length; ++i) {
                DynamicObject recordById = recordByIds[i];
                if (!ExecuteTypeEnums.CKBGDXZ.getExecuteType().equals(recordById.getString("executetype")) || SupplierEnum.CMS.getId().longValue() != recordById.getLong("declarechannel.id")) continue;
                recordById.getString("deallog");
                String message = TsateDeclareRecordBusiness.getDeallogMessage((DynamicObject)recordById);
                StringBuilder builder = new StringBuilder();
                builder.append(message).append(SEPARATOR);
                builder.append(ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0\uff1a\u624b\u5de5\u64a4\u9500\u3002", (String)"DirectDeclareRecordListPlugin_4", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                TsateDeclareRecordBusiness.uploadLogByLength((String)builder.toString(), (DynamicObject)recordById);
                recordById.set("executestatus", (Object)ExecuteStatusEnum.FAIL.getCode());
                needUpdateRecords.add(recordById);
            }
            TsateDeclareRecordBusiness.updateRecords(needUpdateRecords);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6210\u529f\u64a4\u9500%1$s\u6761\u4efb\u52a1\uff0c\u8bf7\u5173\u6ce8\u3002", (String)"DirectDeclareRecordListPlugin_5", (String)"taxc-tsate-formplugin", (Object[])new Object[]{needUpdateRecords.size()}));
            BillList billlist = (BillList)this.getControl("billlistap");
            billlist.refresh();
        }
    }

    private void dealFilterColum(List<Object> orgs, FilterColumn filterColumn, String tasktypeNumber) {
        String fieldName = filterColumn.getFieldName();
        if (fieldName.startsWith("org.")) {
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(orgs)) {
                filterColumn.setDefaultValues(orgs.stream().map(Object::toString).collect(Collectors.toList()));
            } else {
                filterColumn.setDefaultValues(new Object[]{BaseDataUtil.getDefaultOrg((IFormView)this.getView())});
            }
        }
        if (fieldName.startsWith("tasktype.")) {
            List<ComboItem> tasktypes = this.getTasktype();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(tasktypes)) {
                String defaultTask = tasktypes.get(0).getValue();
                ExecuteTypeEnums executeType = ExecuteTypeEnums.valuesOfExecuteType((String)tasktypeNumber);
                if (executeType != null) {
                    defaultTask = String.valueOf(executeType.getId());
                }
                filterColumn.setDefaultValues(new Object[]{defaultTask});
                if (filterColumn instanceof CommonFilterColumn) {
                    ((CommonFilterColumn)filterColumn).setComboItems(tasktypes);
                } else if (filterColumn instanceof SchemeFilterColumn) {
                    ((SchemeFilterColumn)filterColumn).setComboItems(tasktypes);
                }
            } else if (filterColumn instanceof CommonFilterColumn) {
                ((CommonFilterColumn)filterColumn).setComboItems(null);
            } else if (filterColumn instanceof SchemeFilterColumn) {
                ((SchemeFilterColumn)filterColumn).setComboItems(null);
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRow row = billlist.getCurrentSelectedRowInfo();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"tsate_declare_record");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (DynamicObjectType)mainEntityType);
        if ("billno".equals(args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            String log = this.dealShowMessage(dynamicObject);
            this.showEntityForm(dynamicObject, log);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject data = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        String executeStatus = data.getString("executestatus");
        if (!StringUtils.equals((CharSequence)"3", (CharSequence)executeStatus)) {
            e.setNoLinkKey(Collections.singletonList("billno"));
        }
        if ("skssqq".equals(columnDesc.getKey())) {
            String skssqq = DateUtils.format((Date)data.getDate("skssqq"), (String)new DateUtils().yyyymmddChinese());
            String skssqz = DateUtils.format((Date)data.getDate("skssqz"), (String)new DateUtils().yyyymmddChinese());
            e.setFormatValue((Object)(skssqq + "-" + skssqz));
        }
    }

    private static String getStringByInputStream(InputStream inputStream) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            int n;
            byte[] b = new byte[1024];
            while ((n = inputStream.read(b)) != -1) {
                outputStream.write(b, 0, n);
            }
        }
        catch (Exception e) {
            try {
                inputStream.close();
                outputStream.close();
            }
            catch (Exception e1) {
                logger.error((Throwable)e1);
            }
        }
        return outputStream.toString();
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List<Long> orgIds = this.getOrgListHasPermission();
        List qFilters = e.getQFilters();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)qFilters)) {
            boolean isHasOrg = qFilters.stream().filter(o -> o.getProperty().startsWith("org.")).findFirst().isPresent();
            if (!isHasOrg && !org.apache.commons.collections.CollectionUtils.isEmpty(orgIds)) {
                e.getQFilters().add(new QFilter("org", "in", orgIds));
            }
            e.getQFilters().add(new QFilter("tasktype.number", "in", (Object)TASKTYPES).and("tasktype.enable", "=", (Object)"1"));
        } else {
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(orgIds)) {
                e.getQFilters().add(new QFilter("org", "in", orgIds));
            }
            e.getQFilters().add(new QFilter("tasktype.number", "in", (Object)TASKTYPES).and("tasktype.enable", "=", (Object)"1"));
        }
    }

    private void showEntityForm(DynamicObject dynamicObject, String log) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setFormId("tsate_declare_record");
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("recordid", dynamicObject.getPkValue());
        showParameter.setCustomParam("log", (Object)log);
        this.getView().showForm(showParameter);
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        this.getPageCache().remove("ishidden");
        Map filterMap = args.getSearchClickEvent().getFilterValues();
        List customList = (List)filterMap.get("customfilter");
        List schemeFilterList = (List)filterMap.get("schemefilter");
        ArrayList filterList = new ArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)customList)) {
            filterList.addAll(customList);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)schemeFilterList)) {
            filterList.addAll(schemeFilterList);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(filterList)) {
            for (Map map : filterList) {
                DynamicObject taskTypeObj;
                List valueList;
                List fileName = (List)map.get("FieldName");
                int index = fileName.indexOf("tasktype.id");
                if (fileName.indexOf("tasktype.id") != -1) {
                    this.getPageCache().remove("ishidden");
                    valueList = (List)map.get("Value");
                    taskTypeObj = BusinessDataServiceHelper.loadSingle((String)"tsate_tasktype", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(valueList.get(0).toString()))});
                    this.getPageCache().put("ishidden", taskTypeObj.getString("number"));
                    continue;
                }
                if (fileName.indexOf("tasktype.name") == -1) continue;
                this.getPageCache().remove("ishidden");
                valueList = (List)map.get("Value");
                taskTypeObj = BusinessDataServiceHelper.loadSingle((String)"tsate_tasktype", (String)"number", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)valueList.get(0).toString())});
                if (taskTypeObj == null) continue;
                this.getPageCache().put("ishidden", taskTypeObj.getString("number"));
            }
        }
        if (this.beforeCreateListColumnsArgs != null) {
            ListViewPluginProxy formViewPluginProxy = (ListViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
            formViewPluginProxy.fireBeforeCreateListColumns(this.beforeCreateListColumnsArgs);
        }
        this.btnSetting();
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerAfterSearchClick(args);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        this.beforeCreateListColumnsArgs = args;
        String isHidden = this.getPageCache().get("ishidden");
        String hiddenColumns = DeclareRecordHiddenEnums.getHiddenColumnsByTaskType(isHidden);
        if (EmptyCheckUtils.isNotEmpty((Object)hiddenColumns)) {
            List list = args.getListColumns();
            Iterator columnIterator = list.iterator();
            while (columnIterator.hasNext()) {
                IListColumn iListColumn = (IListColumn)columnIterator.next();
                if (!Arrays.asList(hiddenColumns.split(",")).contains(iListColumn.getListFieldKey())) continue;
                columnIterator.remove();
            }
        }
    }

    private List<Long> getOrgListHasPermission() {
        DynamicObjectCollection col;
        ArrayList<Long> orgIds = new ArrayList<Long>();
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        if (hasPermOrgs != null && !hasPermOrgs.hasAllOrgPerm() && !CollectionUtils.isEmpty((Collection)(col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs, (boolean)false)))) {
            for (DynamicObject obj : col) {
                orgIds.add(obj.getLong("id"));
            }
        }
        return orgIds;
    }

    private String dealShowMessage(DynamicObject dyn) {
        List forceCodeList;
        Object forceCodeData;
        FileService fileService;
        InputStream in;
        String log;
        Map dataMap;
        String piclog;
        String picData;
        String data = dyn.getString("deallog");
        StringBuilder message = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)data)) {
            String log2 = null;
            if (data.startsWith("FILE:")) {
                FileService fileService2 = FileServiceFactory.getAttachmentFileService();
                InputStream in2 = fileService2.getInputStream(data.substring(5));
                log2 = DirectDeclareRecordListPlugin.getStringByInputStream(in2);
            } else {
                log2 = data;
            }
            message.append(log2).append(SEPARATOR);
        }
        if (EmptyCheckUtils.isNotEmpty((Object)(picData = dyn.getString("piclog"))) && StringUtils.isNotBlank((CharSequence)(piclog = dyn.getString("piclog"))) && (dataMap = (Map)JsonUtil.fromJson((String)(log = DirectDeclareRecordListPlugin.getStringByInputStream(in = (fileService = FileServiceFactory.getAttachmentFileService()).getInputStream(piclog))), Map.class)) != null && dataMap.containsKey("forceCodeList") && EmptyCheckUtils.isNotEmpty(forceCodeData = dataMap.get("forceCodeList")) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(forceCodeList = (List)forceCodeData))) {
            message.append(ResManager.loadKDString((String)"\u7cfb\u7edf\u63d0\u793a:", (String)"DirectDeclareRecordListPlugin_2", (String)"taxc-tsate-formplugin", (Object[])new Object[0])).append(SEPARATOR);
            for (Map forceCode : forceCodeList) {
                message.append(forceCode.get("forceDesc")).append(SEPARATOR);
            }
        }
        return message.toString();
    }

    private List<ComboItem> getTasktype() {
        DynamicObject[] taskObj = BusinessDataServiceHelper.load((String)"tsate_tasktype", (String)MetadataUtil.getAllFieldString((String)"tsate_tasktype"), (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)TASKTYPES).and("enable", "=", (Object)"1")});
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(taskObj.length);
        int index = -1;
        int taskIndex = -1;
        for (DynamicObject obj : taskObj) {
            ++index;
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(obj.getString("name")));
            item.setValue(obj.getString("id"));
            combos.add(item);
            if (!"ZLSB".equals(obj.getString("number"))) continue;
            taskIndex = index;
        }
        if (taskIndex > 0) {
            Collections.swap(combos, 0, taskIndex);
        }
        return combos;
    }
}

