/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.record;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.EventObject;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tsate.business.TsateDeclareRecordBusiness;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.util.EmptyCheckUtils;

public class DirectDeclareRecordPlugin
extends AbstractFormPlugin {
    public void initialize() {
        this.addClickListeners(new String[]{"btnexporterror", "viewpic"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object pkId = formShowParameter.getCustomParam("recordid");
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"tsate_declare_record");
        if (obj != null) {
            Object executestatus;
            String channel = obj.getString("channel");
            SupplierEnum supplier = SupplierEnum.valueOfCode((String)channel);
            if (SupplierEnum.YZF == supplier || SupplierEnum.QXY == supplier) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"viewpic", "vectorap1"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"viewpic", "vectorap1"});
            }
            this.getModel().setValue("billno", obj.get("billno"));
            this.getModel().setValue("org", obj.get("org"));
            this.getModel().setValue("type", obj.get("type"));
            this.getModel().setValue("skssqq", obj.get("skssqq"));
            this.getModel().setValue("skssqz", obj.get("skssqz"));
            this.getModel().setValue("tasktype", obj.get("tasktype"));
            this.getModel().setValue("executestatus", obj.get("executestatus"));
            this.getModel().setValue("createtime", obj.get("createtime"));
            this.getModel().setValue("creator", obj.get("creator"));
            this.getModel().setValue("taxtype", obj.get("taxtype"));
            if (formShowParameter.getCustomParam("log") != null) {
                this.getModel().setValue("log", formShowParameter.getCustomParam("log"));
            }
            if ((executestatus = this.getModel().getValue("executestatus")) != null && StringUtils.equals((CharSequence)String.valueOf(executestatus), (CharSequence)"2")) {
                this.getModel().setValue("logtitle", (Object)ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f", (String)"DirectDeclareRecordPlugin_2", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            } else {
                this.getModel().setValue("logtitle", (Object)ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25", (String)"DirectDeclareRecordPlugin_0", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void click(EventObject evt) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object pkId = formShowParameter.getCustomParam("recordid");
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"tsate_declare_record");
        if ("btnexporterror".equals(((Control)evt.getSource()).getKey())) {
            if (EmptyCheckUtils.isNotEmpty((Object)this.getModel().getValue("log"))) {
                String data = String.valueOf(this.getModel().getValue("log"));
                InputStream in = null;
                if (data.startsWith("FILE:")) {
                    FileService fileService = FileServiceFactory.getAttachmentFileService();
                    in = fileService.getInputStream(data.substring(5));
                } else {
                    in = new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
                }
                String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(obj.getString("billno") + ".txt", in, 5000);
                this.getView().openUrl(urls);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e5\u5fd7\u5185\u5bb9\u4e3a\u7a7a", (String)"DirectDeclareRecordPlugin_1", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            }
        } else if ("viewpic".equals(((Control)evt.getSource()).getKey()) && obj != null) {
            List piclist = TsateDeclareRecordBusiness.getPic((DynamicObject)obj);
            if (piclist.size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u56fe\u7247\u5185\u5bb9\u4e3a\u7a7a", (String)"DirectDeclareRecordPlugin_3", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showPictureView(piclist.toArray(new String[0]), 0);
            }
        }
    }

    private static String getStringByInputStream(InputStream inputStream) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            int n;
            byte[] b = new byte[1024];
            while ((n = inputStream.read(b)) != -1) {
                outputStream.write(b, 0, n);
            }
        }
        catch (Exception e) {
            try {
                inputStream.close();
                outputStream.close();
            }
            catch (Exception e1) {
                return null;
            }
        }
        return outputStream.toString();
    }
}

