/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.sbpzgl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.tsate.business.TctbTaxMainBusiness;
import kd.taxc.tsate.business.TemplateTaxtypeMappingBusiness;
import kd.taxc.tsate.business.TsateSbpzBusiness;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.DeclareTypeEnum;
import kd.taxc.tsate.common.enums.SbpzTypeEnum;
import kd.taxc.tsate.common.enums.TaxPeriodType;
import kd.taxc.tsate.common.enums.TaxSupportPeriodEnum;
import kd.taxc.tsate.common.enums.VoucherTypeEnum;
import kd.taxc.tsate.common.enums.sbpzgl.DeclareDateDisplayConditionsEnum;
import kd.taxc.tsate.common.metadata.MetadataUtil;
import kd.taxc.tsate.common.util.CommonInfoUtil;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.common.util.PermissionUtils;
import kd.taxc.tsate.common.util.TaxUtil;
import kd.taxc.tsate.formplugin.sbpzgl.enums.ChannelDeclareTypeSupportEnum;
import kd.taxc.tsate.formplugin.sbpzgl.enums.ChannelTaxTypeSupportEnum;
import kd.taxc.tsate.formplugin.utils.JobUtils;
import org.apache.commons.collections.CollectionUtils;

public class DeclareDownloadPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public static final String BTNOK = "btnok";
    public static final String ORG = "org";
    public static final String SKSSQQ = "skssqq";
    public static final String SKSSQZ = "skssqz";
    public static final String CHANNEL = "declarechannel";
    public static final String DOC_TYPE = "tasktype";
    public static final String TAX_TYPE = "taxtype";
    public static final String NUMBER = "number";
    public static final String ID = "id";
    public static final String TSATE_DECLARE_CHANNEL = "tsate_declare_channel";
    private static final String BASTAX_TAXORG = "bastax_taxorg";
    private static final String DEClARE_DATE = "declaredate";
    private static final String ZLXZ_PER = "28T/ALUDR3RZ";
    private static final List<String> FCTD_SLIP_CHANNEL_NUMBERS = Arrays.asList(SupplierEnum.QXY.getCode(), SupplierEnum.YZF.getCode());
    private static final List<DeclareTaxType> FCTD_TAXTYPES = Arrays.asList(DeclareTaxType.CZTDSYS, DeclareTaxType.FCS);
    public static final String FILD_DECLARETYPES = "declaretype";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK});
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(ORG);
        BasedataEdit channelEdit = (BasedataEdit)this.getControl(CHANNEL);
        BasedataEdit taskEdit = (BasedataEdit)this.getControl(DOC_TYPE);
        BasedataEdit taxTypeEdit = (BasedataEdit)this.getControl(TAX_TYPE);
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        channelEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        taxTypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        taskEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        long orgId = RequestContext.get().getOrgId();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"tctb_tax_main", (String)"id,number,taxoffice", (QFilter[])new QFilter[]{new QFilter("taxorg", "=", (Object)orgId).and("taxorg.istaxpayer", "=", (Object)"1")});
        if (dynamicObject != null) {
            HasPermOrgResult allPermOrgs = PermissionUtils.getAllPermOrgsByUserId((String)"tsate", (String)"tsate_sbpz_admin", (String)ZLXZ_PER, (Long)RequestContext.get().getCurrUserId());
            if (allPermOrgs != null) {
                if (allPermOrgs.getHasPermOrgs().contains(orgId) || allPermOrgs.hasAllOrgPerm()) {
                    this.getModel().setValue(ORG, (Object)orgId);
                    if (dynamicObject.getDynamicObject("taxoffice") != null) {
                        this.setChannel(dynamicObject.getString(NUMBER), dynamicObject.getDynamicObject("taxoffice").getLong(ID));
                    } else {
                        this.resetEmpty();
                    }
                } else {
                    this.resetEmpty();
                }
            } else {
                this.resetEmpty();
            }
        } else {
            this.resetEmpty();
        }
        this.declareTypeSetting();
        this.taxTypeSetting();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{DEClARE_DATE});
    }

    private void resetEmpty() {
        this.getModel().setValue(CHANNEL, null);
        this.getModel().setValue(DOC_TYPE, null);
        BasedataEdit channelEdit = (BasedataEdit)this.getControl(CHANNEL);
        channelEdit.setQFilter(new QFilter(ID, "=", (Object)-1L));
        MulBasedataEdit comb = (MulBasedataEdit)this.getView().getControl(DOC_TYPE);
        comb.setQFilter(new QFilter(ID, "=", (Object)-1L));
        this.getModel().setValue(DEClARE_DATE, null);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject dataEntity;
        String name = e.getProperty().getName();
        if (DEClARE_DATE.equals(name)) {
            return;
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{DEClARE_DATE});
        this.getModel().beginInit();
        this.getModel().setValue(DEClARE_DATE, null);
        this.getModel().endInit();
        this.getView().updateView(DEClARE_DATE);
        if (CHANNEL.equals(name) || DOC_TYPE.equals(name)) {
            this.declareTypeSetting();
            this.taxTypeSetting();
        }
        if (CHANNEL.equals(name)) {
            dataEntity = this.getModel().getDataEntity();
            DynamicObject channelObj = dataEntity.getDynamicObject(CHANNEL);
            if (channelObj != null) {
                this.setDoctype(channelObj.getString(NUMBER));
                this.getModel().setValue(FILD_DECLARETYPES, null);
                this.getModel().setValue(TAX_TYPE, null);
            } else {
                this.resetEmpty();
            }
            this.getModel().setValue(DOC_TYPE, null);
        } else if (ORG.equals(name)) {
            dataEntity = this.getModel().getDataEntity();
            if (dataEntity.get(ORG) != null) {
                long oid = ((DynamicObject)dataEntity.get(ORG)).getLong(ID);
                DynamicObject dynamicObject = TctbTaxMainBusiness.getByOrgId((Long)oid);
                if (dynamicObject != null) {
                    this.setChannel(null, ((DynamicObject)dynamicObject.get("taxoffice")).getLong(ID));
                } else {
                    this.resetEmpty();
                }
            } else {
                this.resetEmpty();
            }
        }
        DynamicObject declareChannel = this.getModel().getDataEntity().getDynamicObject(CHANNEL);
        DynamicObject declareType = this.getModel().getDataEntity().getDynamicObject(FILD_DECLARETYPES);
        Date ssqq = this.getModel().getDataEntity().getDate(SKSSQQ);
        Date ssqz = this.getModel().getDataEntity().getDate(SKSSQZ);
        if (ssqz != null) {
            this.getModel().beginInit();
            this.getModel().setValue(DEClARE_DATE, (Object)DateUtils.stringToDate((String)DateUtils.formatMonth((Date)DateUtils.addMonth((Date)ssqz, (int)1)), (String)"yyyy-MM"));
            this.getModel().endInit();
            this.getView().updateView(DEClARE_DATE);
        }
        if (declareChannel != null && DeclareDateDisplayConditionsEnum.meetRules((SupplierEnum)SupplierEnum.valueOfCode((String)declareChannel.getString(NUMBER)), null, null)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{DEClARE_DATE});
            if (declareType != null && ssqq != null && ssqz != null) {
                this.setDeclareDate(declareType.getString(NUMBER), ssqq, ssqz);
            }
        }
    }

    public void setDeclareDate(String declareType, Date ssqq, Date ssqz) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)declareType) || ssqq == null || ssqz == null) {
            return;
        }
        HashSet<String> singleDeclareType = new HashSet<String>(16);
        singleDeclareType.add("yhs");
        singleDeclareType.add("qtsf_fsstysbb");
        singleDeclareType.add("qtsf_tysbb");
        singleDeclareType.add("totf_cjrjybzj");
        singleDeclareType.add("whsyjsf");
        IDataModel model = this.getModel();
        model.beginInit();
        if (singleDeclareType.contains(declareType) && ssqq.getTime() == ssqz.getTime()) {
            model.setValue(DEClARE_DATE, (Object)DateUtils.stringToDate((String)DateUtils.formatMonth((Date)ssqz), (String)"yyyy-MM"));
            model.endInit();
            this.getView().updateView(DEClARE_DATE);
            return;
        }
        this.getModel().setValue(DEClARE_DATE, (Object)DateUtils.addMonth((Date)DateUtils.stringToDate((String)DateUtils.formatMonth((Date)ssqz), (String)"yyyy-MM"), (int)1));
        model.endInit();
        this.getView().updateView(DEClARE_DATE);
    }

    public void click(EventObject evt) {
        if (BTNOK.equals(((Control)evt.getSource()).getKey())) {
            DynamicObjectCollection taxtypes;
            String declareTypeNumber;
            Date skssqzOfView;
            if (this.checkFiling().booleanValue()) {
                return;
            }
            DynamicObject dataEntity = this.getModel().getDataEntity();
            long oid = ((DynamicObject)dataEntity.get(ORG)).getLong(ID);
            Date skssqqOfView = (Date)dataEntity.get(SKSSQQ);
            if (!this.checkPeriodMatch(skssqqOfView, skssqzOfView = (Date)dataEntity.get(SKSSQZ), declareTypeNumber = this.getDeclareTypeFromView())) {
                return;
            }
            String skssqqStr = DateUtils.format((Date)skssqqOfView);
            String skssqzStr = DateUtils.format((Date)skssqzOfView);
            Date skssqq = skssqqOfView;
            Date skssqz = skssqzOfView;
            Date sbqj = this.getSbqjFromView();
            String sbqjStr = DateUtils.formatMonth((Date)sbqj);
            DynamicObject channelObj = dataEntity.getDynamicObject(CHANNEL);
            DynamicObjectCollection doctypes = dataEntity.getDynamicObjectCollection(DOC_TYPE);
            DynamicObject mapping = null;
            DynamicObject taxType = this.getTaxTypeFromView();
            if (SupplierEnum.QXY.getCode().equals(channelObj.getString(NUMBER))) {
                mapping = TemplateTaxtypeMappingBusiness.getMappingObjByTepType((String)declareTypeNumber);
            }
            DynamicObject[] objs = BusinessDataServiceHelper.load((String)"tsate_declare_base", (String)MetadataUtil.getAllFieldString((String)"tsate_declare_base"), null);
            DynamicObject mappingType = null;
            if (taxType == null && mapping != null && (taxtypes = mapping.getDynamicObjectCollection(TAX_TYPE)).size() == 1) {
                mappingType = (DynamicObject)taxtypes.get(0);
            }
            if (objs != null && objs.length > 0) {
                HashMap<String, Object> paramMap = new HashMap<String, Object>(12);
                DynamicObject taxorg = BusinessDataServiceHelper.loadSingle((String)BASTAX_TAXORG, (String)"unifiedsocialcode", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)oid)});
                paramMap.put("nsrsbh", taxorg.get("unifiedsocialcode"));
                paramMap.put(SKSSQQ, skssqqStr);
                paramMap.put(SKSSQZ, skssqzStr);
                paramMap.put("sbqj", sbqjStr);
                paramMap.put(ORG, oid);
                if (mappingType != null) {
                    paramMap.put(TAX_TYPE, mappingType.getString("fbasedataid.number"));
                }
                if (taxType != null && taxType.getString(NUMBER) != null) {
                    paramMap.put(TAX_TYPE, taxType.getString(NUMBER));
                }
                for (DynamicObject typeObj : doctypes) {
                    Long taxTypeId;
                    String taskTypeNumber = typeObj.getDynamicObject("fbasedataid").getString(NUMBER).toLowerCase();
                    String taskTypeName = typeObj.getDynamicObject("fbasedataid").getString("name");
                    DynamicObject taskTypeDyn = typeObj.getDynamicObject("fbasedataid");
                    paramMap.put("key", taskTypeNumber);
                    paramMap.put("supplier", channelObj.getString(NUMBER));
                    paramMap.put("voucherType", VoucherTypeEnum.getVoucherType((String)channelObj.getString(NUMBER), (String)taskTypeNumber));
                    paramMap.put(taskTypeNumber, taskTypeName);
                    if (declareTypeNumber != null) {
                        paramMap.put("declareTypeNumber", declareTypeNumber);
                        paramMap.put("typeNumber", declareTypeNumber);
                    }
                    Long l = taxTypeId = taxType == null ? null : Long.valueOf(taxType.getLong(ID));
                    if (taxTypeId == null && mappingType != null) {
                        taxTypeId = mappingType.getLong("fbasedataid.id");
                    }
                    if (DeclareTypeEnum.FCSCZTDSYS.getCode().equals(declareTypeNumber) && FCTD_SLIP_CHANNEL_NUMBERS.contains(paramMap.get("supplier"))) {
                        for (DeclareTaxType taxtype : FCTD_TAXTYPES) {
                            long id = this.dealRecord(oid, sbqj, skssqq, skssqz, taskTypeDyn, channelObj, declareTypeNumber, taxtype.getBaseTaxId());
                            paramMap.put("recordid", id);
                            paramMap.put(TAX_TYPE, taxtype.getBaseTaxCode());
                            paramMap.put("typeNumber", taxtype.getBaseTaxCode());
                            JobUtils.submitJob(paramMap);
                        }
                        continue;
                    }
                    long id = this.dealRecord(oid, sbqj, skssqq, skssqz, taskTypeDyn, channelObj, declareTypeNumber, taxTypeId);
                    paramMap.put("recordid", id);
                    JobUtils.submitJob(paramMap);
                }
                HashMap<String, String> returnData = new HashMap<String, String>();
                returnData.put("message", "true");
                this.getView().setReturnData(returnData);
                this.getView().returnDataToParent(returnData);
                this.getView().close();
            }
        }
    }

    private Long dealRecord(Long orgId, Date sbqj, Date skssqq, Date skssqz, DynamicObject taskType, DynamicObject channelObj, String declareType, Long taxTypeId) {
        DynamicObject[] dynamicObjects = DeclareDownloadPlugin.assembleDeclareRecord(orgId, sbqj, skssqq, skssqz, taskType, channelObj, declareType, taxTypeId);
        return dynamicObjects[0].getLong(ID);
    }

    private static DynamicObject[] assembleDeclareRecord(Long orgid, Date sbqj, Date skssqq, Date skssqz, DynamicObject taskObj, DynamicObject channelObj, String declareType, Long taxTypeId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tsate_declare_record");
        dynamicObject.set(ORG, (Object)orgid);
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("creator", (Object)RequestContext.get().getUserId());
        dynamicObject.set("executestatus", (Object)"1");
        dynamicObject.set("sbqj", (Object)sbqj);
        dynamicObject.set("channel", (Object)channelObj.getString(NUMBER));
        dynamicObject.set(CHANNEL, (Object)channelObj.getLong(ID));
        dynamicObject.set("billstatus", (Object)"C");
        dynamicObject.set("executetype", (Object)taskObj.getString(NUMBER));
        dynamicObject.set(DOC_TYPE, (Object)taskObj.getLong(ID));
        if (skssqq != null) {
            dynamicObject.set(SKSSQQ, (Object)skssqq);
        }
        if (skssqz != null) {
            dynamicObject.set(SKSSQZ, (Object)skssqz);
        }
        if (StringUtils.isNotEmpty((String)declareType)) {
            dynamicObject.set("type", (Object)declareType);
        }
        if (taxTypeId != null) {
            dynamicObject.set(TAX_TYPE, (Object)taxTypeId);
        }
        DynamicObject[] objs = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        dynamicObject = objs[0];
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        codeRuleService.getNumber("tsate_declare_record", dynamicObject, null);
        String number = codeRuleService.readNumber("tsate_declare_record", dynamicObject, null);
        dynamicObject.set("billno", (Object)number);
        return (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7) {
        String fieldKey = beforeF7.getProperty().getName();
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)fieldKey, (CharSequence)DOC_TYPE)) {
            ListShowParameter ls = (ListShowParameter)beforeF7.getFormShowParameter();
            ls.setCaption(ResManager.loadKDString((String)"\u51ed\u8bc1\u7c7b\u578b", (String)"DeclareDownloadPlugin_3", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)fieldKey, (CharSequence)ORG)) {
            DynamicObject[] loads = BusinessDataServiceHelper.load((String)BASTAX_TAXORG, (String)ID, (QFilter[])new QFilter[]{new QFilter("istaxpayer", "=", (Object)"1")});
            if (loads != null && loads.length > 0) {
                List ids = Arrays.stream(loads).map(o -> o.getLong(ID)).collect(Collectors.toList());
                List perm = new ArrayList();
                HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
                if (!hasPermOrgResult.hasAllOrgPerm()) {
                    HasPermOrgResult tsate = PermissionUtils.getAllPermOrgsByUserId((String)"tsate", (String)"tsate_sbpz_admin", (String)ZLXZ_PER, (Long)RequestContext.get().getCurrUserId());
                    if (tsate != null) {
                        perm = tsate.getHasPermOrgs();
                    }
                    ids.retainAll(perm);
                }
                ListShowParameter ls = (ListShowParameter)beforeF7.getFormShowParameter();
                ls.getListFilterParameter().setFilter(new QFilter(ID, "in", ids));
            }
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)fieldKey, (CharSequence)TAX_TYPE)) {
            ListShowParameter ls = (ListShowParameter)beforeF7.getFormShowParameter();
            ls.getListFilterParameter().setFilter(new QFilter("enable", "=", (Object)"1"));
            Date now = new Date();
            ls.getListFilterParameter().setFilter(new QFilter("activedate", "<", (Object)now));
            ls.getListFilterParameter().setFilter(new QFilter("expdate", ">=", (Object)now));
            Set taxNumbers = this.getTaxTypesByChannelDownloadSupport(this.getChannelFromView());
            ls.getListFilterParameter().setFilter(new QFilter(NUMBER, "in", (Object)taxNumbers));
        }
    }

    private void setChannel(String number, Long taxoffice) {
        Long taxOfficeId = null;
        if (taxoffice != null) {
            taxOfficeId = CommonInfoUtil.getParentTaxauthorityById((Long)taxoffice);
        }
        QFilter qFilter = new QFilter("taxorgancopy.fbasedataid", "in", (Object)taxOfficeId).and("enable", "=", (Object)"1").and(new QFilter("declarechannel.enable", "=", (Object)"1"));
        DynamicObject[] channels = BusinessDataServiceHelper.load((String)TSATE_DECLARE_CHANNEL, (String)CHANNEL, (QFilter[])new QFilter[]{qFilter});
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(CHANNEL);
        if (channels != null && channels.length > 0) {
            List pzChannels = Arrays.stream(SbpzTypeEnum.values()).map(o -> o.getChannel()).collect(Collectors.toList());
            Set data = Arrays.stream(channels).filter(c -> pzChannels.contains(c.getDynamicObject(CHANNEL).getString(NUMBER))).collect(Collectors.toSet());
            ArrayList comboItems = new ArrayList(data);
            if (CollectionUtils.isNotEmpty(comboItems)) {
                List pkIds = comboItems.stream().map(o -> o.getDynamicObject(CHANNEL).getLong(ID)).collect(Collectors.toList());
                basedataEdit.setQFilter(new QFilter(ID, "in", pkIds).and(new QFilter("enable", "=", (Object)"1")));
                this.getModel().setValue(CHANNEL, (Object)((DynamicObject)comboItems.get(0)).getDynamicObject(CHANNEL).getLong(ID));
                this.setDoctype(((DynamicObject)comboItems.get(0)).getDynamicObject(CHANNEL).getString(NUMBER));
            }
        } else {
            this.resetEmpty();
        }
    }

    private void setDoctype(String channel) {
        MulBasedataEdit basedataEdit = (MulBasedataEdit)this.getView().getControl(DOC_TYPE);
        SbpzTypeEnum sbpzType = SbpzTypeEnum.getSbpzTypeEnumByChannel((String)channel);
        if (sbpzType != null) {
            String sbtypes = sbpzType.getType();
            String[] types = sbtypes.split(",");
            basedataEdit.setQFilter(new QFilter(NUMBER, "in", (Object)types).and(new QFilter("enable", "=", (Object)"1")));
        } else {
            basedataEdit.setQFilter(new QFilter(ID, "=", (Object)-1L));
        }
    }

    private String getDeclareTypeFromView() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject types = (DynamicObject)dataEntity.get(FILD_DECLARETYPES);
        if (types == null) {
            return null;
        }
        return types.getString(NUMBER);
    }

    private List<String> getTaskTypeFromView() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        MulBasedataDynamicObjectCollection types = (MulBasedataDynamicObjectCollection)dataEntity.get(DOC_TYPE);
        return types.stream().map(type -> {
            DynamicObject dyn = (DynamicObject)type.get("fbasedataid");
            return dyn.getString(NUMBER);
        }).collect(Collectors.toList());
    }

    private String getChannelFromView() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject channel = (DynamicObject)dataEntity.get(CHANNEL);
        if (channel != null) {
            return channel.getString(NUMBER);
        }
        return null;
    }

    private void taxTypeSetting() {
        String channelNumber = this.getChannelFromView();
        List<String> taskTypeNumbers = this.getTaskTypeFromView();
        BasedataEdit ctl = (BasedataEdit)this.getView().getControl(TAX_TYPE);
        Optional<String> opt = taskTypeNumbers.stream().filter(number -> "wspz".equalsIgnoreCase((String)number)).findFirst();
        if (opt.isPresent()) {
            Set taxtypes = this.getTaxTypesByChannelDownloadSupport(channelNumber);
            if (taxtypes.size() > 0) {
                ctl.setMustInput(true);
                this.getView().setEnable(Boolean.valueOf(true), new String[]{TAX_TYPE});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{TAX_TYPE});
            } else {
                ctl.setMustInput(false);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{TAX_TYPE});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{TAX_TYPE});
            }
        } else {
            ctl.setMustInput(false);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{TAX_TYPE});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{TAX_TYPE});
        }
    }

    private void declareTypeSetting() {
        Set types;
        String channelNumber = this.getChannelFromView();
        BasedataEdit declareTypesCtl = (BasedataEdit)this.getView().getControl(FILD_DECLARETYPES);
        if (channelNumber == null) {
            channelNumber = "none";
        }
        if ((types = this.getDeclareTypesByChannelDownloadSupport(channelNumber)).size() > 0) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{FILD_DECLARETYPES});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{FILD_DECLARETYPES});
            declareTypesCtl.setMustInput(true);
            declareTypesCtl.setQFilter(new QFilter(NUMBER, "in", (Object)types));
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FILD_DECLARETYPES});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{FILD_DECLARETYPES});
            declareTypesCtl.setMustInput(false);
        }
    }

    private Set getDeclareTypesByChannelDownloadSupport(String channelNumber) {
        HashSet<String> sets = new HashSet<String>(4);
        SupplierEnum supplier = SupplierEnum.valueOfCode((String)channelNumber);
        ChannelDeclareTypeSupportEnum declareTypeSupportEnum = ChannelDeclareTypeSupportEnum.valueOfSupplier(supplier);
        if (declareTypeSupportEnum != null) {
            sets.addAll(Arrays.asList(declareTypeSupportEnum.getDeclareTypes()));
        }
        return sets;
    }

    private Set getTaxTypesByChannelDownloadSupport(String channelNumber) {
        HashSet<String> sets = new HashSet<String>(4);
        SupplierEnum supplier = SupplierEnum.valueOfCode((String)channelNumber);
        ChannelTaxTypeSupportEnum taxTypeSupportEnum = ChannelTaxTypeSupportEnum.valueOfSupplier(supplier);
        if (taxTypeSupportEnum != null) {
            sets.addAll(Arrays.asList(taxTypeSupportEnum.getTaxTypes()));
        }
        return sets;
    }

    private Boolean checkFiling() {
        DynamicObjectCollection dyns;
        List list;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection taskTypeObjs = dataEntity.getDynamicObjectCollection(DOC_TYPE);
        Long orgId = ((DynamicObject)dataEntity.get(ORG)).getLong(ID);
        Date sbqj = this.getSbqjFromView();
        Date[] skssq = this.getSkssqFromView();
        List pzTypeNameList = taskTypeObjs.stream().map(item -> item.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.toList());
        ArrayList<String> declaretypeList = new ArrayList<String>(8);
        DynamicObject declareTypeObj = dataEntity.getDynamicObject(FILD_DECLARETYPES);
        if (declareTypeObj != null) {
            declaretypeList.add(declareTypeObj.getString(ID));
        }
        ArrayList<Long> taxtypeIds = new ArrayList<Long>();
        DynamicObject taxtypeDyn = this.getTaxTypeFromView();
        if (taxtypeDyn != null) {
            taxtypeIds.add(taxtypeDyn.getLong(ID));
        }
        if (CollectionUtils.isNotEmpty(list = (dyns = TsateSbpzBusiness.getRecord((Long)orgId, (Date)skssq[0], (Date)skssq[1], null, pzTypeNameList, declaretypeList, taxtypeIds)).stream().filter(item -> {
            boolean flag = "1".equals(item.getString("isarchive")) && DateUtils.compareDay((Date)skssq[0], (Date)item.getDate(SKSSQQ)) && DateUtils.compareDay((Date)skssq[1], (Date)item.getDate(SKSSQZ));
            return flag;
        }).collect(Collectors.toList()))) {
            String nsrmc = ((DynamicObject)dataEntity.get(ORG)).getString("name");
            StringBuilder warning = new StringBuilder();
            StringBuilder taskTypeNames = new StringBuilder();
            list.stream().forEach(item -> taskTypeNames.append(",").append(item.getString("name")));
            warning.append("\u3010").append(nsrmc).append("\u3011").append("\u3010").append(DateUtils.format((Date)skssq[0])).append("~").append(DateUtils.format((Date)skssq[1])).append("\u3011").append(ResManager.loadKDString((String)"\u5df2\u5b58\u5728", (String)"DeclareDownloadPlugin_1", (String)"taxc-tsate-formplugin", (Object[])new Object[0])).append("\u3010").append(taskTypeNames.substring(1)).append("\u3011").append(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5f52\u6863\uff0c\u8bf7\u53cd\u5f52\u6863\u540e\u518d\u8fdb\u884c\u76f4\u8fde\u4e0b\u8f7d\u64cd\u4f5c\u3002", (String)"DeclareDownloadPlugin_2", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            this.getView().showErrorNotification(warning.toString());
        }
        return list.size() > 0;
    }

    private Date getSbqjFromView() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        return dataEntity.getDate(DEClARE_DATE);
    }

    private Date[] getSkssqFromView() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Date skssqq = (Date)dataEntity.get(SKSSQQ);
        Date skssqz = (Date)dataEntity.get(SKSSQZ);
        return new Date[]{skssqq, skssqz};
    }

    private DynamicObject getTaxTypeFromView() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject taxType = (DynamicObject)dataEntity.get(TAX_TYPE);
        return taxType;
    }

    private boolean checkPeriodMatch(Date skssqq, Date skssqz, String declareType) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)declareType)) {
            return true;
        }
        TaxPeriodType periodType = TaxUtil.getTaxPeriodType((Date)skssqq, (Date)skssqz);
        List supportPeriodByTaxType = TaxSupportPeriodEnum.getSupportPeriodByTaxType((String)declareType);
        if (supportPeriodByTaxType == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7a0e\u79cd\u6682\u672a\u652f\u6301\u3002", (String)"DeclareDownloadPlugin_7", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!supportPeriodByTaxType.contains(periodType)) {
            StringBuilder message = new StringBuilder();
            Iterator iterator = supportPeriodByTaxType.iterator();
            int count = 0;
            while (iterator.hasNext()) {
                String tip = ((TaxPeriodType)iterator.next()).getTip();
                if (!iterator.hasNext() && count > 0) {
                    message.setLength(message.length() - 1);
                    message.append(ResManager.loadKDString((String)"\u6216", (String)"DeclareDownloadPlugin_10", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                }
                message.append(tip);
                if (iterator.hasNext()) {
                    message.append(ResManager.loadKDString((String)"\u3001", (String)"DeclareDownloadPlugin_8", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                }
                ++count;
            }
            String tipMessage = ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u9700\u4e3a%s\u3002", (String)"DeclareDownloadPlugin_11", (String)"taxc-tsate-formplugin", (Object[])new Object[]{message.toString()});
            this.getView().showErrorNotification(tipMessage);
            return false;
        }
        return true;
    }
}

