/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.sbpzgl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.taxc.tsate.common.helper.OrgServiceHelper;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.PermissionUtils;

public class DeclareUploadPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String DATA_SOURCE = "datasource";
    private static final String FLAG = "0";
    public static final String BILLLISTID = "billlistap";
    private static final String UPLOAD_PER = "28T//NY5Z+MY";
    public static final String DOWNLOAD_PZ_PERMISSION = "28T/6NDH==F3";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setAttFilePanelBtnVisible();
    }

    public void initialize() {
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("org");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        String id = this.getModel().getDataEntity().getPkValue().toString();
        if (id != null && !FLAG.equals(id)) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"tsate_sbpz_admin", (String)DATA_SOURCE, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(id))});
            if (dynamicObject != null && !FLAG.equals(dynamicObject.getString(DATA_SOURCE))) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"name", "org", "sbqj", "skssq", "save", "attachmentpanelap", "declaretype", "taxtype"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"org", "sbqj", "skssq", "declaretype", "taxtype"});
                if ("1".equals(this.getModel().getValue("isarchive"))) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"skssq", "attachmentpanelap", "taxtype"});
                }
            }
        } else {
            HasPermOrgResult allPermOrgs;
            long orgId = RequestContext.get().getOrgId();
            Object changeOrgIdObj = this.getModel().getValue("org");
            if (changeOrgIdObj instanceof DynamicObject) {
                DynamicObject orgDyn = (DynamicObject)changeOrgIdObj;
                this.getModel().setValue("org", orgDyn.get("id"));
                return;
            }
            if (changeOrgIdObj instanceof Long) {
                this.getModel().setValue("org", changeOrgIdObj);
                return;
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bastax_taxorg", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)orgId).and("istaxpayer", "=", (Object)"1")});
            if (dynamicObject != null && (allPermOrgs = PermissionUtils.getAllPermOrgsByUserId((String)"tsate", (String)"tsate_sbpz_admin", (String)UPLOAD_PER, (Long)RequestContext.get().getCurrUserId())) != null && (allPermOrgs.getHasPermOrgs().contains(dynamicObject.getLong("id")) || allPermOrgs.hasAllOrgPerm())) {
                this.getModel().setValue("org", (Object)orgId);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Save) {
            int attachmentpanelap = ((AttachmentPanel)this.getControl("attachmentpanelap")).getAttachmentData().size();
            if (attachmentpanelap == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u51ed\u8bc1\u9644\u4ef6\u3002", (String)"DeclareUploadPlugin_0", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.getModel().setValue(DATA_SOURCE, (Object)FLAG);
            this.getModel().setValue("modifier", (Object)RequestContext.get().getCurrUserId());
            this.getModel().setValue("modifytime", (Object)new Date());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("skssqz".equals(e.getProperty().getName())) {
            Date skssqz = (Date)this.getModel().getValue("skssqz");
            this.getModel().setValue("sbqj", (Object)DateUtils.addMonth((Date)skssqz, (int)1));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7) {
        String fieldKey = beforeF7.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"org")) {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7.getFormShowParameter();
            HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgsByUserId((String)"tsate", (String)"tsate_sbpz_admin", (String)UPLOAD_PER, (Long)RequestContext.get().getCurrUserId());
            List<Object> orgList = new ArrayList();
            if (EmptyCheckUtils.isNotEmpty((Object)hasPermOrgResult) && !hasPermOrgResult.hasAllOrgPerm()) {
                orgList = hasPermOrgResult.getHasPermOrgs();
            } else {
                DynamicObjectCollection objs = OrgServiceHelper.getOrgLists();
                if (!kd.bos.orm.util.CollectionUtils.isEmpty((Collection)objs)) {
                    orgList = objs.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
                }
            }
            if (!kd.bos.orm.util.CollectionUtils.isEmpty(orgList)) {
                orgList = DeclareUploadPlugin.excludeByTaxPayer(orgList);
            }
            QFilter idsFilter = new QFilter("id", "in", orgList);
            QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
            formShowParameter.getListFilterParameter().getQFilters().add(idsFilter.and(statusFilter));
            formShowParameter.setCustomParam("orgViewSchemeNumber", (Object)"40");
            formShowParameter.getCustomParams().put("orgFuncId", "40");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getSource() instanceof Save) {
            this.getView().close();
        }
    }

    private static List<Long> excludeByTaxPayer(List<Long> orgList) {
        List<Long> orgIds = DeclareUploadPlugin.filterByIsTaxpayer();
        orgList.removeIf(s -> !orgIds.contains(s));
        return orgList;
    }

    private static List<Long> filterByIsTaxpayer() {
        DynamicObjectCollection taxOrgs = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org.id as id", (QFilter[])new QFilter[]{new QFilter("istaxpayer", "=", (Object)Boolean.TRUE).and(new QFilter("status", "=", (Object)"1"))});
        return kd.bos.orm.util.CollectionUtils.isEmpty((Collection)taxOrgs) ? new ArrayList<Long>() : taxOrgs.parallelStream().map(s -> s.getLong("id")).collect(Collectors.toList());
    }

    protected void setAttFilePanelBtnVisible() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null && !PermissionUtils.checkPermission((Long)org.getLong("id"), (String)"tsate", (String)"tsate_sbpz_admin", (String)DOWNLOAD_PZ_PERMISSION).booleanValue()) {
            AttachmentPanel attachmentpanel = (AttachmentPanel)this.getControl("attachmentpanelap");
            List attachmentDataList = attachmentpanel.getAttachmentData();
            if (attachmentDataList == null || CollectionUtils.isEmpty((Collection)attachmentDataList)) {
                return;
            }
            for (Map attachmentMap : attachmentDataList) {
                attachmentMap.put("visible", "1011");
            }
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.setFieldProperty("attachmentpanelap", "v", (Object)attachmentDataList);
        }
    }
}

