/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.sbpzgl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.formop.Refresh;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.ExecuteTypeEnums;
import kd.taxc.tsate.common.enums.VoucherTypeEnum;
import kd.taxc.tsate.common.helper.OrgServiceHelper;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.ExceptionUtil;
import kd.taxc.tsate.common.util.FileUploadUtils;
import kd.taxc.tsate.common.util.PermissionUtils;
import kd.taxc.tsate.formplugin.tool.DownloadAttachmentFileHelper;

public class SbpzDownloadPlugin
extends AbstractListPlugin
implements IConfirmCallBack {
    private static final Log logger = LogFactory.getLog(SbpzDownloadPlugin.class);
    public static final String TOOLBARID = "toolbarap";
    public static final String BILLLISTID = "billlistap";
    public static final String TSATE_SBPZ_ADMIN = "tsate_sbpz_admin";
    public static final List<String> SBPZ_REFRESH_CHANNEL_CODES = Arrays.asList(SupplierEnum.ZWY.getCode(), SupplierEnum.QXY.getCode());
    public DownloadAttachmentFileHelper downloadFileHelper;
    public static final String DOWNLOAD_PZ_PERMISSION = "28T/6NDH==F3";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{TOOLBARID});
    }

    public void setFilter(SetFilterEvent e) {
        e.getQFilters().stream().filter(item -> "skssqq".equals(item.getProperty())).collect(Collectors.toList()).forEach(item -> {
            if ("<".equals(item.getCP())) {
                item.__setProperty("skssqz");
            } else {
                item.getNests(true).forEach(nest -> {
                    if ("<".equals(nest.getFilter().getCP()) && "skssqq".equals(nest.getFilter().getProperty())) {
                        nest.getFilter().__setProperty("skssqz");
                    }
                });
            }
        });
        super.setFilter(e);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        long orgId = RequestContext.get().getOrgId();
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgsByUserId((String)"tsate", (String)TSATE_SBPZ_ADMIN, (String)"47150e89000000ac", (Long)RequestContext.get().getCurrUserId());
        List<Object> orgList = new ArrayList();
        if (EmptyCheckUtils.isNotEmpty((Object)hasPermOrgResult) && !hasPermOrgResult.hasAllOrgPerm()) {
            orgList = hasPermOrgResult.getHasPermOrgs();
        } else {
            DynamicObjectCollection objs = OrgServiceHelper.getOrgLists();
            if (!CollectionUtils.isEmpty((Collection)objs)) {
                orgList = objs.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
            }
        }
        if (!CollectionUtils.isEmpty(orgList)) {
            orgList = SbpzDownloadPlugin.excludeByTaxPayer(orgList, true);
        }
        if (!CollectionUtils.isEmpty(orgList)) {
            if (orgList.contains(orgId)) {
                args.getFilterColumn("org.number").setDefaultValue(String.valueOf(orgId));
            } else {
                args.getFilterColumn("org.number").setDefaultValue(String.valueOf(orgList.get(0)));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing && "xzpz".equals(((Donothing)args.getSource()).getOperateKey())) {
            BillList billlist = (BillList)this.getControl(BILLLISTID);
            ListSelectedRowCollection list = billlist.getSelectedRows();
            if (list == null || list.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u8bb0\u5f55\u3002", (String)"SbpzDownloadPlugin_2", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<Object> pkIds = new ArrayList<Object>(list.size());
            for (ListSelectedRow row : list) {
                Object pkId = row.getPrimaryKeyValue();
                pkIds.add(pkId);
            }
            List urls = FileUploadUtils.getFilePaths((String)TSATE_SBPZ_ADMIN, pkIds, (String)"attachmentpanelap", (boolean)false);
            if (CollectionUtils.isEmpty((Collection)urls)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7533\u62a5\u6ca1\u6709\u9644\u4ef6\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"SbpzDownloadPlugin_3", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                return;
            }
            this.downloadPZAttachments(urls);
        } else if (args.getSource() instanceof Donothing && "zlxz".equals(((Donothing)args.getSource()).getOperateKey())) {
            FormShowParameter formshowParameter = new FormShowParameter();
            formshowParameter.setFormId("tsate_sbpz_zlxz");
            formshowParameter.setCaption(ResManager.loadKDString((String)"\u76f4\u8fde\u4e0b\u8f7d", (String)"SbpzDownloadPlugin_1", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formshowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "zlxz"));
            this.getView().showForm(formshowParameter);
        } else if (args.getSource() instanceof Donothing && "scpz".equals(((Donothing)args.getSource()).getOperateKey())) {
            BillShowParameter formshowParameter = new BillShowParameter();
            formshowParameter.setFormId(TSATE_SBPZ_ADMIN);
            formshowParameter.setCaption(ResManager.loadKDString((String)"\u4e0a\u4f20\u51ed\u8bc1", (String)"SbpzDownloadPlugin_0", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formshowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close"));
            this.getView().showForm((FormShowParameter)formshowParameter);
        } else if (args.getSource() instanceof Refresh && "refresh".equals(((Refresh)args.getSource()).getOperateKey())) {
            HashMap<String, String> executetypeMap = new HashMap<String, String>();
            executetypeMap.put("KKJT", ResManager.loadKDString((String)"\u6263\u6b3e\u8bb0\u5f55", (String)"SbpzDownloadPlugin_8", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            executetypeMap.put("SBJT", ResManager.loadKDString((String)"\u7533\u62a5\u8bb0\u5f55", (String)"SbpzDownloadPlugin_9", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            executetypeMap.put("SBBFILE", ResManager.loadKDString((String)"\u7533\u62a5\u8868\u6587\u4ef6", (String)"SbpzDownloadPlugin_11", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            executetypeMap.put(ExecuteTypeEnums.WSPZ.getExecuteType(), ResManager.loadKDString((String)"\u7533\u62a5\u51ed\u8bc1", (String)"SbpzDownloadPlugin_12", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            DynamicObject[] executerecords = BusinessDataServiceHelper.load((String)"tsate_declare_record", (String)"id,org,sbqj,executetype,tasktype,declarechannel,type,skssqq,skssqz,taxtype.number", (QFilter[])new QFilter[]{new QFilter("executestatus", "=", (Object)"1").and("declarechannel.number", "in", SBPZ_REFRESH_CHANNEL_CODES).and("tasktype.number", "in", new ArrayList(executetypeMap.keySet()))});
            if (executerecords != null) {
                for (DynamicObject executerecord : executerecords) {
                    HashMap<String, Object> paramMap = new HashMap<String, Object>();
                    DynamicObject taxorg = BusinessDataServiceHelper.loadSingle((String)"bastax_taxorg", (String)"unifiedsocialcode", (QFilter[])new QFilter[]{new QFilter("id", "=", ((DynamicObject)executerecord.get("org")).get("id"))});
                    paramMap.put("nsrsbh", taxorg.get("unifiedsocialcode"));
                    String s = DateUtils.formatMonth((Date)((Date)executerecord.get("sbqj")));
                    if (s == null || "".equals(s)) continue;
                    Date date = DateUtils.stringToDate((String)s, (String)"yyyy-MM");
                    String format = DateUtils.format((Date)date);
                    paramMap.put("sbqj", format);
                    paramMap.put("org", executerecord.get("org.id"));
                    paramMap.put("recordid", executerecord.get("id"));
                    paramMap.put("skssqq", DateUtils.format((Date)executerecord.getDate("skssqq"), (String)"yyyy-MM-dd"));
                    paramMap.put("skssqz", DateUtils.format((Date)executerecord.getDate("skssqz"), (String)"yyyy-MM-dd"));
                    String f = executerecord.getDynamicObject("tasktype").getString("number").toLowerCase();
                    paramMap.put("key", f);
                    paramMap.put("declareTypeNumber", executerecord.getString("type"));
                    paramMap.put("supplier", executerecord.getDynamicObject("declarechannel").getString("number"));
                    paramMap.put("voucherType", VoucherTypeEnum.getVoucherType((String)executerecord.getDynamicObject("declarechannel").getString("number"), (String)f));
                    paramMap.put(f, executetypeMap.get(executerecord.getDynamicObject("tasktype").getString("number")));
                    paramMap.put("taxtype", executerecord.getString("taxtype.number"));
                    paramMap.put("isQuery", Boolean.TRUE);
                    this.sendTask(paramMap);
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getSource() instanceof Donothing && "clear".equals(((Donothing)afterDoOperationEventArgs.getSource()).getOperateKey())) {
            BillList billlist = (BillList)this.getControl(BILLLISTID);
            ListSelectedRowCollection list = billlist.getSelectedRows();
            if (list == null || list.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"SbpzDownloadPlugin_5", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                return;
            }
            OperationResult deleteResult = OperationServiceHelper.executeOperate((String)"delete", (String)TSATE_SBPZ_ADMIN, (Object[])list.getPrimaryKeyValues());
            String message = deleteResult.getMessage();
            if (deleteResult.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"SbpzDownloadPlugin_6", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            } else {
                if (StringUtils.isBlank((CharSequence)message)) {
                    StringBuilder errMessage = new StringBuilder();
                    for (IOperateInfo operateInfo : deleteResult.getAllErrorOrValidateInfo()) {
                        errMessage.append(operateInfo.getMessage()).append(System.lineSeparator());
                    }
                    message = errMessage.toString();
                }
                this.getView().showErrorNotification(message);
            }
            this.getView().invokeOperation("refresh");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equalsIgnoreCase((CharSequence)"close", (CharSequence)actionId)) {
            this.getView().invokeOperation("refresh");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"zlxz", (CharSequence)actionId) && closedCallBackEvent.getReturnData() != null) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7533\u62a5\u51ed\u8bc1\u4e0b\u8f7d\u4efb\u52a1\u63d0\u4ea4\u6210\u529f\u3002", (String)"SbpzDownloadPlugin_10", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if ("org.id".equalsIgnoreCase(fieldName) || "org.number".equalsIgnoreCase(fieldName)) {
            HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgsByUserId((String)"tsate", (String)TSATE_SBPZ_ADMIN, (String)"47150e89000000ac", (Long)RequestContext.get().getCurrUserId());
            List<Object> orgList = new ArrayList();
            QFilter qFilter = null;
            if (EmptyCheckUtils.isNotEmpty((Object)hasPermOrgResult) && !hasPermOrgResult.hasAllOrgPerm()) {
                orgList = hasPermOrgResult.getHasPermOrgs();
                if (!CollectionUtils.isEmpty(orgList)) {
                    orgList = SbpzDownloadPlugin.excludeByTaxPayer(orgList, true);
                }
                qFilter = new QFilter("id", "in", orgList);
            } else {
                List<Long> ids = SbpzDownloadPlugin.filterByIsTaxpayer(true);
                qFilter = new QFilter("id", "in", ids);
            }
            if (qFilter != null) {
                args.getQfilters().add(qFilter);
            }
        }
        if ("tsate_channel".equals(args.getRefEntityId())) {
            args.addCustomParam("isshowdisabled", (Object)"true");
        }
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject data = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        if ("skssqq".equals(columnDesc.getKey())) {
            String skssqq = DateUtils.format((Date)data.getDate("skssqq"), (String)new DateUtils().yyyymmddChinese());
            String skssqz = DateUtils.format((Date)data.getDate("skssqz"), (String)new DateUtils().yyyymmddChinese());
            e.setFormatValue((Object)(skssqq + "-" + skssqz));
        }
    }

    private static List<Long> excludeByTaxPayer(List<Long> orgList, boolean isincludeNoable) {
        List<Long> orgIds = SbpzDownloadPlugin.filterByIsTaxpayer(isincludeNoable);
        orgList.removeIf(s -> !orgIds.contains(s));
        return orgList;
    }

    private static List<Long> filterByIsTaxpayer(boolean isincludeNoable) {
        DynamicObjectCollection taxOrgs;
        QFilter qFilter = new QFilter("istaxpayer", "=", (Object)Boolean.TRUE);
        if (!isincludeNoable) {
            qFilter.and(new QFilter("status", "=", (Object)"1"));
        }
        return CollectionUtils.isEmpty((Collection)(taxOrgs = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org.id as id", (QFilter[])new QFilter[]{qFilter}))) ? new ArrayList<Long>() : taxOrgs.parallelStream().map(s -> s.getLong("id")).collect(Collectors.toList());
    }

    private void sendTask(Map<String, Object> params) {
        DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tsate", (String)"MessageSendPlugin", (String)"doCustomService", (Object[])new Object[]{params});
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if ("continue_download".equals(e.getCallBackId()) && e.getResult() == MessageBoxResult.Yes) {
            this.getDownloadAttachmentFile().continueDownload(e);
        }
    }

    private DownloadAttachmentFileHelper getDownloadAttachmentFile() {
        if (this.downloadFileHelper == null) {
            this.downloadFileHelper = new DownloadAttachmentFileHelper(this, DOWNLOAD_PZ_PERMISSION);
        }
        return this.downloadFileHelper;
    }

    protected void downloadPZAttachments(List<String> urls) {
        if (urls.size() <= 10) {
            for (String url : urls) {
                this.downloadSingleAttachement(url);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4e0b\u8f7d\u9644\u4ef6\u6210\u529f", (String)"SbpzDownloadPlugin_4", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
        } else {
            try {
                this.getDownloadAttachmentFile().batchDownloadAttachmentFiles();
            }
            catch (Throwable e) {
                logger.error("SbpzDownloadPlugin.beforeDoOperation error:" + e.getMessage(), e);
                for (String url : urls) {
                    this.downloadSingleAttachement(url);
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4e0b\u8f7d\u9644\u4ef6\u6210\u529f", (String)"SbpzDownloadPlugin_4", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadSingleAttachement(String url) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            return;
        }
        FileService service = FileServiceFactory.getAttachmentFileService();
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        InputStream fis = null;
        try {
            String fileName = FileUploadUtils.extractFileName((String)url);
            int startIndex = url.indexOf("?path=") + "?path=".length();
            String path = url.substring(startIndex);
            fis = service.getInputStream(path);
            String tempUrl = tempFileCache.saveAsFullUrl(fileName, fis, 7200);
            this.getView().download(tempUrl);
            kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils.putTempFilePermissionCache((String)tempUrl, (String)this.getView().getFormShowParameter().getServiceAppId(), (String)TSATE_SBPZ_ADMIN, (String)DOWNLOAD_PZ_PERMISSION);
        }
        catch (Exception e) {
            logger.error(ExceptionUtil.toString((Exception)e));
            return;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    logger.error("Failed to close input stream", (Throwable)e);
                }
            }
        }
    }
}

