/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.setting;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class QxyXhSettingFromplugin
extends AbstractFormPlugin {
    private static String FILDS_XH = "xh";
    private static String FILDS_PHONE = "phone";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        TaxResult r;
        Object source = args.getSource();
        FormOperate opt = (FormOperate)source;
        String optKey = opt.getOperateKey();
        String xh = this.getXhFromView();
        String phone = this.getPhoneFromView();
        if (("save".equals(optKey) || "delete".equals(optKey)) && !this.checkNotEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5c0f\u53f7\u6216\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"QxyXhSettingFromplugin_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            return;
        }
        if ("save".equals(optKey)) {
            DynamicObject dyn = this.queryByXh(xh);
            if (dyn != null) {
                String dynPhone = dyn.getString("phone");
                TaxResult r2 = (TaxResult)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tsate", (String)"QxyLoginService", (String)"updateXh", (Object[])new Object[]{dynPhone, phone, xh});
                if (!r2.isSuccess()) {
                    this.getView().showErrorNotification(r2.getMessage());
                    args.setCancel(true);
                    return;
                }
            } else {
                TaxResult r3 = (TaxResult)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tsate", (String)"QxyLoginService", (String)"bindXh", (Object[])new Object[]{xh, phone});
                if (!r3.isSuccess()) {
                    this.getView().showErrorNotification(r3.getMessage());
                    args.setCancel(true);
                    return;
                }
            }
        } else if ("delete".equals(optKey) && !(r = (TaxResult)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tsate", (String)"QxyLoginService", (String)"unbindXh", (Object[])new Object[]{xh, phone})).isSuccess()) {
            this.getView().showErrorNotification(r.getMessage());
            args.setCancel(true);
        }
    }

    private String getXhFromView() {
        return this.getStringValueFromView(FILDS_XH);
    }

    private String getPhoneFromView() {
        return this.getStringValueFromView(FILDS_PHONE);
    }

    private String getStringValueFromView(String key) {
        Object o = this.getModel().getValue(key);
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    private DynamicObject queryByXh(String xh) {
        QFilter filter = new QFilter("xh", "=", (Object)xh);
        DynamicObject[] dyns = BusinessDataServiceHelper.load((String)"tsate_setting_qxy_xh", (String)"id,xh,phone", (QFilter[])new QFilter[]{filter});
        if (dyns != null && dyns.length > 0) {
            return dyns[0];
        }
        return null;
    }

    private boolean checkNotEmpty() {
        String phone = this.getPhoneFromView();
        String xh = this.getXhFromView();
        return StringUtil.isNotEmpty((CharSequence)phone) && StringUtil.isNotEmpty((CharSequence)xh);
    }
}

