/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.synchronal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.metadata.MetadataUtil;
import kd.taxc.tsate.common.util.DBUtils;
import kd.taxc.tsate.common.util.PageShowCommon;
import kd.taxc.tsate.formplugin.utils.JobUtils;

public class ShSynchronalPlugin
extends AbstractBillPlugIn {
    private static final String DYN_SH = "dynsh";
    private static final String DYN_RETRY = "dynretry";
    private static final String BASTAX_TAXORG = "bastax_taxorg";
    private static final String BAS_ORG = "bos_org";
    private static final String CHANNEL = "channel";
    private static final String LOG = "log";
    private static final String ORG = "org";
    private static final String BILLNO = "billno";
    private static final String TSATE_DYN_LOG = "tsate_dyn_log";
    private static final String ID_NUMBER_NAME_TAXPAYER_CODE = "id,number,name,taxpayer,unifiedsocialcode";
    private static final String DECLARE_RECORD_CS = "id,org,executetype,executestatus,creator,createtime,channel,detaillog,deallog";
    private static final String SEPARATOR = System.getProperty("line.separator");

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        BillList billlist;
        ListSelectedRow row;
        String pkId;
        DynamicObject dynamicObject;
        Object source = args.getSource();
        String operateKey = ((AbstractOperate)source).getOperateKey();
        if (source instanceof Donothing && DYN_SH.equals(operateKey)) {
            ListShowParameter parameter = ShowFormHelper.createShowListForm((String)BAS_ORG, (boolean)true, (int)1);
            parameter.setCustomParam("orgViewSchemeNumber", (Object)"40");
            parameter.getCustomParams().put("orgFuncId", "40");
            parameter.setFormId("bos_orgtreelistdnshf7");
            parameter.setCustomParam("ServiceAppId", (Object)"tsate");
            DynamicObject[] taxorgs = BusinessDataServiceHelper.load((String)BASTAX_TAXORG, (String)"id", (QFilter[])new QFilter[]{new QFilter("istaxpayer", "=", (Object)"1").and(new QFilter("status", "=", (Object)"1"))});
            List tids = Arrays.stream(taxorgs).map(e -> e.get("id")).collect(Collectors.toList());
            DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"tsate_declare_dynsh", (String)ORG, null);
            List oids = Arrays.stream(orgs).map(e -> ((DynamicObject)e.get(ORG)).get("id")).collect(Collectors.toList());
            tids.removeAll(oids);
            QFilter qFilter = new QFilter("id", "in", tids);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close"));
            parameter.getListFilterParameter().setFilter(qFilter);
            this.getView().showForm((FormShowParameter)parameter);
        } else if (source instanceof Donothing && DYN_RETRY.equals(operateKey)) {
            BillList billlist2 = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection list = billlist2.getSelectedRows();
            List sids = list.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            DynamicObject[] loads = BusinessDataServiceHelper.load((String)"tsate_declare_dynsh", (String)"id,org,nsrsbh", (QFilter[])new QFilter[]{new QFilter("id", "in", sids).and("status", "=", (Object)"1")});
            ArrayList<Long> ids = new ArrayList<Long>();
            if (loads != null && loads.length > 0) {
                StringBuilder sb = new StringBuilder();
                for (DynamicObject load : loads) {
                    String org = ((DynamicObject)load.get(ORG)).getString("name");
                    String nsrsbh = load.getString("nsrsbh");
                    ids.add(load.getLong("id"));
                    sb.append(String.format(ResManager.loadKDString((String)"\u6570\u636e\u540c\u6b65\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\uff1a %1$s   %2$s", (String)"ShSynchronalPlugin_0", (String)"taxc-tsate-formplugin", (Object[])new Object[0]), org, nsrsbh)).append(SEPARATOR);
                }
                this.dealMessage(sb);
            }
            sids.removeAll(ids);
            ArrayList<Long> recodes = new ArrayList<Long>();
            try {
                DynamicObject[] qys = BusinessDataServiceHelper.load((String)"tsate_declare_dynsh", (String)"id,org,nsrsbh,status,declarechannel,channel,createtime,creator", (QFilter[])new QFilter[]{new QFilter("id", "in", sids).and("status", "!=", (Object)"1")});
                Arrays.stream(qys).forEach(e -> e.set("status", (Object)"1"));
                Date date = new Date();
                Arrays.stream(qys).forEach(e -> e.set("createtime", (Object)date));
                long currUserId = RequestContext.get().getCurrUserId();
                Arrays.stream(qys).forEach(e -> e.set("creator", (Object)currUserId));
                SaveServiceHelper.save((DynamicObject[])qys);
                List collect = Arrays.stream(qys).map(o -> ((DynamicObject)o.get(ORG)).getLong("id")).collect(Collectors.toList());
                DynamicObject[] querys = BusinessDataServiceHelper.load((String)BASTAX_TAXORG, (String)ID_NUMBER_NAME_TAXPAYER_CODE, (QFilter[])new QFilter[]{new QFilter("id", "in", collect)});
                ArrayList<DynamicObject> shlist = new ArrayList<DynamicObject>(querys.length);
                ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
                DynamicObject taskObj = BusinessDataServiceHelper.loadSingle((String)"tsate_tasktype", (String)MetadataUtil.getAllFieldString((String)"tsate_tasktype"), (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"TBSH")});
                DynamicObject channelObj = BusinessDataServiceHelper.loadSingle((String)"tsate_channel", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)SupplierEnum.SZYH.getCode())});
                for (DynamicObject query : querys) {
                    DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"tsate_declare_record");
                    long id = DBUtils.getLongId((String)"tsate_declare_record");
                    recodes.add(id);
                    dy.set("id", (Object)id);
                    dy.set("executestatus", (Object)"1");
                    if (taskObj != null) {
                        dy.set("tasktype", (Object)taskObj.getLong("id"));
                        dy.set("executetype", (Object)"TBSH");
                    }
                    if (channelObj != null) {
                        dy.set(CHANNEL, (Object)"3");
                        dy.set("declarechannel", (Object)channelObj.getLong("id"));
                    }
                    dy.set("creator", (Object)currUserId);
                    dy.set(ORG, (Object)query.getLong("id"));
                    dy.set("deallog", (Object)query.getString("unifiedsocialcode"));
                    String number = codeRuleService.getNumber(TSATE_DYN_LOG, dy, null);
                    dy.set(BILLNO, (Object)number);
                    shlist.add(dy);
                }
                DynamicObject[] objs = new DynamicObject[shlist.size()];
                shlist.toArray(objs);
                SaveServiceHelper.save((DynamicObject[])objs);
                DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"tsate_declare_dynsh", (String)ORG, (QFilter[])new QFilter[]{new QFilter("id", "in", sids)});
                List oids = Arrays.stream(orgs).map(e -> ((DynamicObject)e.get(ORG)).get("id")).collect(Collectors.toList());
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("orgids", oids);
                params.put("flag", "syn_sh_retry");
                params.put("records", recodes);
                JobUtils.submitJob(params);
                billlist2.refresh();
            }
            catch (Exception e2) {
                DynamicObject[] load = BusinessDataServiceHelper.load((String)"tsate_declare_record", (String)DECLARE_RECORD_CS, (QFilter[])new QFilter[]{new QFilter("id", "in", recodes)});
                Arrays.stream(load).forEach(o -> o.set("executestatus", (Object)"3"));
                Arrays.stream(load).forEach(o -> o.set("deallog", (Object)ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25\uff0c\u7eb3\u7a0e\u8bc6\u522b\u53f7\uff1a%s", (String)"ShSynchronalPlugin_1", (String)"taxc-tsate-formplugin", (Object[])new Object[]{o.get("deallog")})));
                SaveServiceHelper.save((DynamicObject[])load);
                DynamicObject[] qys = BusinessDataServiceHelper.load((String)"tsate_declare_dynsh", (String)"id,org,nsrsbh,status,channel,createtime,creator", (QFilter[])new QFilter[]{new QFilter("id", "in", sids)});
                Arrays.stream(qys).forEach(o -> o.set("status", (Object)"3"));
                SaveServiceHelper.save((DynamicObject[])qys);
            }
        } else if (source instanceof Donothing && LOG.equals(operateKey)) {
            HashMap<String, Long> customParams = new HashMap<String, Long>();
            DynamicObject taskObj = BusinessDataServiceHelper.loadSingle((String)"tsate_tasktype", (String)MetadataUtil.getAllFieldString((String)"tsate_tasktype"), (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"TBSH")});
            customParams.put("tasktype", taskObj.getLong("id"));
            PageShowCommon.showBillList((ShowType)ShowType.MainNewTabPage, (String)TSATE_DYN_LOG, (IFormView)this.getView(), customParams);
        } else if ("modify".equals(operateKey) && (dynamicObject = BusinessDataServiceHelper.loadSingle((String)"tsate_declare_dynsh", (String)"status", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(pkId = (row = (billlist = (BillList)this.getControl("billlistap")).getCurrentSelectedRowInfo()).getPrimaryKeyValue().toString()))})) != null && !"3".equals(dynamicObject.getString("status"))) {
            args.setCancel(true);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equalsIgnoreCase((CharSequence)"close", (CharSequence)actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void dealMessage(StringBuilder message) {
        if (StringUtils.isNotBlank((CharSequence)message.toString())) {
            String[] messages = message.toString().split(System.getProperty("line.separator"));
            if (messages.length == 1) {
                this.getView().showErrorNotification(message.toString());
            } else {
                this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
                OperationResult operationResult = new OperationResult();
                operationResult.setSuccess(false);
                operationResult.setMessage(message.toString());
                this.getView().showOperationResult(operationResult);
            }
        }
    }
}

