/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.synchronal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.metadata.MetadataUtil;
import kd.taxc.tsate.common.util.DBUtils;
import kd.taxc.tsate.formplugin.utils.JobUtils;

public class ShSyntreelistf7Plugin
extends AbstractFormPlugin {
    private static final String BTNOK = "btnok";
    private static final String BILLISTAP = "billlistap";
    private static final String BASTAX_TAXORG = "bastax_taxorg";
    private static final String ID_NUMBER_NAME_TAXPAYER_CODE = "id,number,name,taxpayer,unifiedsocialcode";
    private static final String CHANNEL = "channel";
    private static final String ORG = "org";
    private static final String NSRSBH = "nsrsbh";
    private static final String UNIFIEDSOCIAL_CODE = "unifiedsocialcode";
    private static final String STATUS = "status";
    private static final String SEPARATOR = System.getProperty("line.separator");
    private static final String CREATOR = "creator";
    private static final String BILLNO = "billno";
    private static final String TSATE_DYN_LOG = "tsate_dyn_log";
    private static final String DECLARE_RECORD_CS = "id,org,executetype,executestatus,creator,createtime,channel,detaillog,deallog";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if (control.getKey().equals(BTNOK)) {
            BillList billlist = (BillList)this.getControl(BILLISTAP);
            ListSelectedRowCollection rows = billlist.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)rows)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"ShSyntreelistf7Plugin_0", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                return;
            }
            List pks = rows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            IFormView formView = this.getView();
            String entityId = formView.getEntityId();
            if (formView instanceof ListView) {
                entityId = ((ListView)formView).getBillFormId();
            }
            if ("bos_org".equals(entityId)) {
                DynamicObject[] querys = BusinessDataServiceHelper.load((String)BASTAX_TAXORG, (String)ID_NUMBER_NAME_TAXPAYER_CODE, (QFilter[])new QFilter[]{new QFilter("id", "in", pks)});
                StringBuilder sb = new StringBuilder();
                for (DynamicObject dyn : querys) {
                    if (!dyn.getString(UNIFIEDSOCIAL_CODE).equals("")) continue;
                    String name = dyn.getString(1);
                    sb.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff1a%s", (String)"ShSyntreelistf7Plugin_1", (String)"taxc-tsate-formplugin", (Object[])new Object[0]), name)).append(SEPARATOR);
                }
                if (sb.length() > 0) {
                    this.dealMessage(sb);
                    return;
                }
                ArrayList<Long> recodes = new ArrayList<Long>(12);
                ArrayList<Long> shs = new ArrayList<Long>(12);
                try {
                    long currUserId = RequestContext.get().getCurrUserId();
                    ArrayList<DynamicObject> shlist = new ArrayList<DynamicObject>(12);
                    ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
                    DynamicObject taskObj = BusinessDataServiceHelper.loadSingle((String)"tsate_tasktype", (String)MetadataUtil.getAllFieldString((String)"tsate_tasktype"), (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"TBSH")});
                    DynamicObject channelObj = BusinessDataServiceHelper.loadSingle((String)"tsate_channel", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)SupplierEnum.SZYH.getCode())});
                    for (DynamicObject query : querys) {
                        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"tsate_declare_record");
                        long id = DBUtils.getLongId((String)"tsate_declare_record");
                        recodes.add(id);
                        dy.set("id", (Object)id);
                        dy.set("executestatus", (Object)"1");
                        if (taskObj != null) {
                            dy.set("tasktype", (Object)taskObj.getLong("id"));
                            dy.set("executetype", (Object)"TBSH");
                        }
                        if (channelObj != null) {
                            dy.set(CHANNEL, (Object)"3");
                            dy.set("declarechannel", (Object)channelObj.getLong("id"));
                        }
                        dy.set(CREATOR, (Object)currUserId);
                        dy.set(ORG, (Object)query.getLong("id"));
                        dy.set("deallog", (Object)query.getString(UNIFIEDSOCIAL_CODE));
                        String number = codeRuleService.getNumber(TSATE_DYN_LOG, dy, null);
                        dy.set(BILLNO, (Object)number);
                        shlist.add(dy);
                    }
                    DynamicObject[] objs = new DynamicObject[shlist.size()];
                    shlist.toArray(objs);
                    Object[] save = SaveServiceHelper.save((DynamicObject[])objs);
                    shlist.clear();
                    for (DynamicObject query : querys) {
                        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"tsate_declare_dynsh");
                        long id = DBUtils.getLongId((String)"tsate_declare_dynsh");
                        shs.add(id);
                        dy.set("id", (Object)id);
                        dy.set(NSRSBH, (Object)query.getString(UNIFIEDSOCIAL_CODE));
                        dy.set(STATUS, (Object)"1");
                        dy.set(CHANNEL, (Object)"3");
                        dy.set(CREATOR, (Object)currUserId);
                        dy.set(ORG, (Object)query.getLong("id"));
                        shlist.add(dy);
                    }
                    DynamicObject[] obs = new DynamicObject[shlist.size()];
                    shlist.toArray(obs);
                    SaveServiceHelper.save((DynamicObject[])obs);
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("orgids", pks);
                    params.put("flag", "syn_sh_submit");
                    params.put("records", recodes);
                    JobUtils.submitJob(params);
                }
                catch (Exception e) {
                    DynamicObject[] load = BusinessDataServiceHelper.load((String)"tsate_declare_record", (String)DECLARE_RECORD_CS, (QFilter[])new QFilter[]{new QFilter("id", "in", recodes)});
                    Arrays.stream(load).forEach(o -> o.set("executestatus", (Object)"3"));
                    Arrays.stream(load).forEach(o -> o.set("deallog", (Object)ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25\uff0c\u7eb3\u7a0e\u8bc6\u522b\u53f7\uff1a%s", (String)"ShSyntreelistf7Plugin_2", (String)"taxc-tsate-formplugin", (Object[])new Object[]{o.get("deallog")})));
                    SaveServiceHelper.save((DynamicObject[])load);
                    DynamicObject[] qys = BusinessDataServiceHelper.load((String)"tsate_declare_dynsh", (String)"id,org,nsrsbh,status,channel,createtime,creator", (QFilter[])new QFilter[]{new QFilter("id", "in", shs)});
                    Arrays.stream(qys).forEach(o -> o.set(STATUS, (Object)"3"));
                    SaveServiceHelper.save((DynamicObject[])qys);
                }
                finally {
                    HashMap<String, String> returnData = new HashMap<String, String>();
                    returnData.put("key", BTNOK);
                    this.getView().returnDataToParent(returnData);
                    this.getView().close();
                }
            }
        }
    }

    private void dealMessage(StringBuilder message) {
        if (StringUtils.isNotBlank((CharSequence)message.toString())) {
            String[] messages = message.toString().split(System.getProperty("line.separator"));
            if (messages.length == 1) {
                this.getView().showErrorNotification(message.toString());
            } else {
                this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
                OperationResult operationResult = new OperationResult();
                operationResult.setSuccess(false);
                operationResult.setMessage(message.toString());
                this.getView().showOperationResult(operationResult);
            }
        }
    }
}

