/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.synchronal;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.list.plugin.ListViewPluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.InputStreamUtils;
import org.apache.commons.collections.CollectionUtils;

public class SynLogPlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(SynLogPlugin.class);
    private BeforeCreateListColumnsArgs beforeCreateListColumnsArgs;

    public void initialize() {
        super.initialize();
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null) {
            if ("TBYH".equals(customParams.get("executetype"))) {
                this.getPageCache().put("ishidden", "TBYH");
            }
            args.getFilterColumn("tasktype.name").setDefaultValue(String.valueOf(customParams.get("tasktype")));
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        this.getPageCache().remove("ishidden");
        Map filterMap = args.getSearchClickEvent().getFilterValues();
        List customList = (List)filterMap.get("customfilter");
        List schemeFilterList = (List)filterMap.get("schemefilter");
        ArrayList filterList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)customList)) {
            filterList.addAll(customList);
        }
        if (CollectionUtils.isNotEmpty((Collection)schemeFilterList)) {
            filterList.addAll(schemeFilterList);
        }
        if (CollectionUtils.isNotEmpty(filterList)) {
            for (Map map : filterList) {
                List fileName = (List)map.get("FieldName");
                int index = fileName.indexOf("tasktype.id");
                if (index == -1) continue;
                this.getPageCache().remove("ishidden");
                List valueList = (List)map.get("Value");
                DynamicObject taskTypeObj = BusinessDataServiceHelper.loadSingle((String)"tsate_tasktype", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(valueList.get(0).toString()))});
                this.getPageCache().put("ishidden", taskTypeObj.getString("number"));
            }
        }
        if (this.beforeCreateListColumnsArgs != null) {
            ListViewPluginProxy formViewPluginProxy = (ListViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
            formViewPluginProxy.fireBeforeCreateListColumns(this.beforeCreateListColumnsArgs);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        this.beforeCreateListColumnsArgs = args;
        String isHidden = this.getPageCache().get("ishidden");
        if (EmptyCheckUtils.isNotEmpty((Object)isHidden) && isHidden.equals("TBYH")) {
            List list = args.getListColumns();
            Iterator columnIterator = list.iterator();
            while (columnIterator.hasNext()) {
                IListColumn iListColumn = (IListColumn)columnIterator.next();
                if (!iListColumn.getListFieldKey().equals("org.name")) continue;
                columnIterator.remove();
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRow row = billlist.getCurrentSelectedRowInfo();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"tsate_dyn_log");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (DynamicObjectType)mainEntityType);
        if ("billno".equals(args.getHyperLinkClickEvent().getFieldName())) {
            String executestatus;
            args.setCancel(true);
            String data = dynamicObject.getString("deallog");
            String executetype = dynamicObject.getString("executetype");
            if ("TBYH".equals(executetype) && "1".equals(executestatus = dynamicObject.getString("executestatus"))) {
                data = "";
            }
            if (StringUtils.isNotBlank((CharSequence)data)) {
                InputStream in = null;
                String log = null;
                if (data.startsWith("FILE:")) {
                    FileService fileService = FileServiceFactory.getAttachmentFileService();
                    in = fileService.getInputStream(data.substring(5));
                    log = InputStreamUtils.getStringByInputStream((InputStream)in);
                } else {
                    log = data;
                }
                this.showEntityForm(dynamicObject, log);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e5\u5fd7\u5185\u5bb9\u4e3a\u7a7a", (String)"SynLogPlugin_0", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (!CollectionUtils.isEmpty((Collection)qFilters)) {
            boolean isHasTaskType = qFilters.stream().filter(o -> o.getProperty().startsWith("tasktype.")).findFirst().isPresent();
            if (!isHasTaskType) {
                if ("TBYH".equals(customParams.get("executetype"))) {
                    e.getQFilters().add(new QFilter("tasktype.number", "=", (Object)"TBYH"));
                } else {
                    e.getQFilters().add(new QFilter("tasktype.number", "=", (Object)"TBSH"));
                }
            }
            e.getQFilters().add(new QFilter("tasktype.number", "in", (Object)new String[]{"TBYH", "TBSH"}));
        } else if ("TBYH".equals(customParams.get("executetype"))) {
            e.getQFilters().add(new QFilter("tasktype.number", "=", (Object)"TBYH"));
        } else {
            e.getQFilters().add(new QFilter("tasktype.number", "=", (Object)"TBSH"));
        }
    }

    private void showEntityForm(DynamicObject dynamicObject, String log) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setFormId("tsate_dyn_log");
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("recordid", dynamicObject.getPkValue());
        showParameter.setCustomParam("billno", dynamicObject.get("billno"));
        showParameter.setCustomParam("org", dynamicObject.get("org"));
        showParameter.setCustomParam("type", dynamicObject.get("type"));
        showParameter.setCustomParam("tasktype", (Object)dynamicObject.getDynamicObject("tasktype").getLong("id"));
        showParameter.setCustomParam("executestatus", dynamicObject.get("executestatus"));
        showParameter.setCustomParam("creator", dynamicObject.get("creator"));
        showParameter.setCustomParam("createtime", dynamicObject.get("createtime"));
        showParameter.setCustomParam("log", (Object)log);
        showParameter.setCustomParam("deallog", dynamicObject.get("deallog"));
        this.getView().showForm(showParameter);
    }
}

