/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.synchronal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.metadata.MetadataUtil;
import kd.taxc.tsate.common.util.DBUtils;
import kd.taxc.tsate.formplugin.utils.JobUtils;

public class UserSynrtreelistf7Plugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(UserSynrtreelistf7Plugin.class);
    private static final String BTNOK = "btnok";
    private static final String BILLISTAP = "billlistap";
    private static final String USER_IDS = "user_ids";
    private static final String ID_NUMBER_NAME = "id,number,name";
    private static final String CHANNEL = "channel";
    private static final String SEPARATOR = System.getProperty("line.separator");
    private static final String CREATOR = "creator";
    private static final String BILLNO = "billno";
    private static final String TSATE_DYN_LOG = "tsate_dyn_log";
    private static final String DECLARE_RECORD_CS = "id,org,executetype,executestatus,creator,createtime,channel,detaillog,deallog";
    private static final String DECLARE_RECORD_YH = "id,executetype,executestatus,creator,createtime,channel,detaillog,deallog";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if (control.getKey().equals(BTNOK)) {
            log.info(ResManager.loadKDString((String)"\u7528\u6237\u540c\u6b65\u63d0\u4ea4", (String)"UserSynrtreelistf7Plugin_1", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            BillList billlist = (BillList)this.getControl(BILLISTAP);
            ListSelectedRowCollection rows = billlist.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)rows)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"UserSynrtreelistf7Plugin_2", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                return;
            }
            List pks = rows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            IFormView formView = this.getView();
            String entityId = formView.getEntityId();
            if (formView instanceof ListView) {
                entityId = ((ListView)formView).getBillFormId();
            }
            if ("bos_user".equals(entityId)) {
                DynamicObject[] querys = BusinessDataServiceHelper.load((String)"bos_user", (String)ID_NUMBER_NAME, (QFilter[])new QFilter[]{new QFilter("id", "in", pks)});
                StringBuilder sb = new StringBuilder();
                for (DynamicObject dyn : querys) {
                    if (!dyn.getString("number").equals("")) continue;
                    String name = dyn.getString("name");
                    sb.append(String.format(ResManager.loadKDString((String)"\u5de5\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff1a %1$s", (String)"UserSynrtreelistf7Plugin_3", (String)"taxc-tsate-formplugin", (Object[])new Object[0]), name)).append(SEPARATOR);
                }
                if (sb.length() > 0) {
                    this.dealMessage(sb);
                    return;
                }
                ArrayList<Long> recodes = new ArrayList<Long>();
                ArrayList<Long> yhs = new ArrayList<Long>();
                try {
                    long currUserId = RequestContext.get().getCurrUserId();
                    ArrayList<DynamicObject> shlist = new ArrayList<DynamicObject>(12);
                    ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
                    DynamicObject taskObj = BusinessDataServiceHelper.loadSingle((String)"tsate_tasktype", (String)MetadataUtil.getAllFieldString((String)"tsate_tasktype"), (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"TBYH")});
                    DynamicObject channelObj = BusinessDataServiceHelper.loadSingle((String)"tsate_channel", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)SupplierEnum.SZYH.getCode())});
                    for (DynamicObject query : querys) {
                        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"tsate_declare_record");
                        long id = DBUtils.getLongId((String)"tsate_declare_record");
                        recodes.add(id);
                        dy.set("id", (Object)id);
                        dy.set("executestatus", (Object)"1");
                        if (taskObj != null) {
                            dy.set("tasktype", (Object)taskObj.getLong("id"));
                            dy.set("executetype", (Object)"TBYH");
                        }
                        if (channelObj != null) {
                            dy.set(CHANNEL, (Object)"3");
                            dy.set("declarechannel", (Object)channelObj.getLong("id"));
                        }
                        dy.set(CREATOR, (Object)currUserId);
                        dy.set("deallog", (Object)query.getString("id"));
                        dy.set("sbbid", (Object)query.getString("number"));
                        String number = codeRuleService.getNumber(TSATE_DYN_LOG, dy, null);
                        dy.set(BILLNO, (Object)number);
                        shlist.add(dy);
                    }
                    DynamicObject[] objs = new DynamicObject[shlist.size()];
                    shlist.toArray(objs);
                    Object[] save = SaveServiceHelper.save((DynamicObject[])objs);
                    shlist.clear();
                    for (DynamicObject query : querys) {
                        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"tsate_declare_dynuser");
                        long id = DBUtils.getLongId((String)"tsate_declare_dynuser");
                        yhs.add(id);
                        dy.set("id", (Object)id);
                        dy.set("status", (Object)"1");
                        dy.set(CHANNEL, (Object)"3");
                        dy.set(CREATOR, (Object)currUserId);
                        dy.set("user", (Object)query.getLong("id"));
                        shlist.add(dy);
                    }
                    DynamicObject[] obs = new DynamicObject[shlist.size()];
                    shlist.toArray(obs);
                    SaveServiceHelper.save((DynamicObject[])obs);
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put(USER_IDS, pks);
                    params.put("flag", "syn_user_submit");
                    params.put("records", recodes);
                    log.info(ResManager.loadKDString((String)"\u7528\u6237\u540c\u6b65submitJob\u63d0\u4ea4", (String)"UserSynrtreelistf7Plugin_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                    JobUtils.submitJob(params);
                }
                catch (Exception e) {
                    DynamicObject[] load = BusinessDataServiceHelper.load((String)"tsate_declare_record", (String)DECLARE_RECORD_CS, (QFilter[])new QFilter[]{new QFilter("id", "in", recodes)});
                    Arrays.stream(load).forEach(o -> o.set("executestatus", (Object)"3"));
                    Arrays.stream(load).forEach(o -> o.set("deallog", (Object)ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25\uff0c\u5de5\u53f7\uff1a%s", (String)"UserSynrtreelistf7Plugin_4", (String)"taxc-tsate-formplugin", (Object[])new Object[]{o.get("deallog")})));
                    SaveServiceHelper.save((DynamicObject[])load);
                    DynamicObject[] ys = BusinessDataServiceHelper.load((String)"tsate_declare_dynuser", (String)"id,user,status,channel,createtime,creator", (QFilter[])new QFilter[]{new QFilter("id", "in", yhs)});
                    Arrays.stream(ys).forEach(o -> o.set("status", (Object)"3"));
                    SaveServiceHelper.save((DynamicObject[])ys);
                }
            }
            HashMap<String, String> returnData = new HashMap<String, String>();
            returnData.put("key", BTNOK);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    private void dealMessage(StringBuilder message) {
        if (StringUtils.isNotBlank((CharSequence)message.toString())) {
            String[] messages = message.toString().split(System.getProperty("line.separator"));
            if (messages.length == 1) {
                this.getView().showErrorNotification(message.toString());
            } else {
                this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
                OperationResult operationResult = new OperationResult();
                operationResult.setSuccess(false);
                operationResult.setMessage(message.toString());
                this.getView().showOperationResult(operationResult);
            }
        }
    }
}

