/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tsate.business.BastaxTaxorgBusiness;
import kd.taxc.tsate.business.TsateChannelBusiness;
import kd.taxc.tsate.business.TsateDeclareRecordBusiness;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.ExecuteStatusEnum;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.formplugin.task.AbstractTsateTask;

public class CreditLevelDownLoadTask
extends AbstractTsateTask {
    private static Log logger = LogFactory.getLog(CreditLevelDownLoadTask.class);
    private static final String ENTITY_ID = "tsate_credit_level_list";
    private static final String ZLXZ_DOWNLOAD_PER = "2RG4L2631EU3";
    private static final Integer DOWNLOAD_YEARS = 10;
    private static final String DATE_FORMAT = "YYYY";
    private static final String TASKTYPE_XYDJXZ = "XYDJXZ";

    @Override
    public void doExecute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Long userId = requestContext.getCurrUserId();
        Integer downLoadYears = DOWNLOAD_YEARS;
        Object downloadyears = map.get("downloadyears");
        if (downloadyears != null) {
            try {
                downLoadYears = Integer.valueOf((String)downloadyears);
            }
            catch (NumberFormatException e) {
                throw new KDException(new ErrorCode("0099", ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25,\u7c7b\u578b\u8f6c\u6362\u6709\u8bef,\u8bf7\u8f93\u5165\u53c2\u6570\u7c7b\u578b\u4e3a\u6574\u6570", (String)"CreditLevelDownLoadTask_0", (String)"taxc-tsate-formplugin", (Object[])new Object[0])), new Object[0]);
            }
        }
        if (downLoadYears < 1) {
            return;
        }
        this.batchJob(TsateChannelBusiness.getValueOrgs((List)BastaxTaxorgBusiness.getHasPremOrgIds((String)ENTITY_ID, (Long)userId, (String)ZLXZ_DOWNLOAD_PER), (SupplierEnum)SupplierEnum.GXSJ), userId.toString(), downLoadYears);
    }

    private int batchJob(Map<Long, Map<String, Object>> maps, String userId, Integer downLoadYears) {
        Long taskTypeId = this.getTaskType();
        int count = 0;
        Date endYear = DateUtils.addYear((Date)new Date(), (int)-1);
        ArrayList<String> downloadYears = new ArrayList<String>(downLoadYears);
        for (int i = 0; i < downLoadYears; ++i) {
            downloadYears.add(DateUtils.format((Date)endYear, (String)DATE_FORMAT));
            endYear = DateUtils.addYear((Date)endYear, (int)-1);
        }
        Long channelId = null;
        for (Map<String, Object> org : maps.values()) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            Long orgId = (Long)org.get("id");
            String nsrsbh = (String)org.get("nsrsbh");
            if (StringUtils.isBlank((CharSequence)nsrsbh)) {
                logger.info("tsate-\u4fe1\u7528\u7b49\u7ea7\u4e0b\u8f7d\u7ec4\u7ec7\u4fe1\u606f\u5f02\u5e38\uff0c\u4e0d\u5b58\u5728\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7,orgId={}", (Object)orgId);
                continue;
            }
            if (channelId == null) {
                Map valueChannel = (Map)org.get("valueChannel");
                channelId = (Long)valueChannel.get("channelid");
            }
            DynamicObject record = this.assembleDeclareRecord(orgId, userId, channelId, taskTypeId);
            params.put("org", orgId);
            params.put("nsrsbh", nsrsbh);
            params.put("recordid", record.getLong("id"));
            params.put("downLoadYears", downloadYears);
            params.put("key", "xydjxz");
            params.put("supplier", SupplierEnum.GXSJ.getCode());
            this.sendTask(params);
            ++count;
        }
        logger.info("tsate-\u4fe1\u7528\u7b49\u7ea7\u4e0b\u8f7d\u6267\u884c\u6210\u529f ,\u7ec4\u7ec7\u6570\u91cf={},\u6279\u91cf\u6267\u884c\u6570\u91cf={},\u4e0b\u8f7d\u5e74\u5ea6\u8303\u56f4={},userId={}", new Object[]{maps.size(), count, DOWNLOAD_YEARS, userId});
        return count;
    }

    private void sendTask(Map<String, Object> params) {
        DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tsate", (String)"MessageSendPlugin", (String)"doCustomService", (Object[])new Object[]{params});
    }

    private DynamicObject assembleDeclareRecord(Long orgId, String userId, Long channelId, Long taskTypeId) {
        Date createTime = new Date();
        ExecuteStatusEnum executestatus = ExecuteStatusEnum.PROCESSING;
        return TsateDeclareRecordBusiness.save((Long)orgId, (Date)createTime, (String)userId, (ExecuteStatusEnum)executestatus, null, (String)SupplierEnum.GXSJ.getCode(), (Long)channelId, (String)TASKTYPE_XYDJXZ, (Long)taskTypeId);
    }

    private Long getTaskType() {
        QFilter filter = new QFilter("number", "=", (Object)TASKTYPE_XYDJXZ);
        DynamicObject object = QueryServiceHelper.queryOne((String)"tsate_tasktype", (String)"id", (QFilter[])new QFilter[]{filter});
        return object.getLong("id");
    }
}

