/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.task;

import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.tsate.formplugin.task.AbstractTsateTask;

public class DirectDeclareTask
extends AbstractTsateTask {
    private static final Log LOGGER = LogFactory.getLog(DirectDeclareTask.class);
    private static final String DIRECT_DECLARE = "directdeclare";
    private static final String DIRECT_PAY = "fastpay";

    @Override
    public void doExecute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        if (map == null) {
            LOGGER.error("DirectDeclareTask doExecute:map is null");
            return;
        }
        String flag = Optional.ofNullable(map.get("flag")).map(Object::toString).orElse("");
        String key = Optional.ofNullable(map.get("key")).map(Object::toString).orElse("");
        if (flag.startsWith("syn_user")) {
            this.handleSynUser(map);
        } else if (flag.startsWith("syn_sh")) {
            this.handleSynSh(map);
        } else if (this.isDirectDeclareOrRelatedTask(key)) {
            this.handleDirectDeclareOrRelated(map);
        } else {
            this.handleDefault(map);
        }
    }

    private void handleSynUser(Map<String, Object> map) throws KDException {
        DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tsate", (String)"UserMessageSendPlugin", (String)"doCustomService", (Object[])new Object[]{map});
    }

    private void handleSynSh(Map<String, Object> map) throws KDException {
        DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tsate", (String)"ShMessageSendPlugin", (String)"doCustomService", (Object[])new Object[]{map});
    }

    private boolean isDirectDeclareOrRelatedTask(String key) {
        return DIRECT_DECLARE.equals(key) || DIRECT_PAY.equals(key) || "yyjk".equals(key) || "undo".equals(key) || "qzsb".equals(key);
    }

    private void handleDirectDeclareOrRelated(Map<String, Object> map) throws KDException {
        DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tsate", (String)"DirectDeclarePlugin", (String)"doCustomService", (Object[])new Object[]{map});
    }

    private void handleDefault(Map<String, Object> map) throws KDException {
        DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tsate", (String)"MessageSendPlugin", (String)"doCustomService", (Object[])new Object[]{map});
    }
}

