/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.task;

import com.alibaba.fastjson.JSON;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;
import kd.taxc.tsate.business.TsateDeclareRecordBusiness;
import kd.taxc.tsate.business.exportdeclaration.ExportDeclarationBusiness;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.ExecuteTypeEnums;
import kd.taxc.tsate.common.util.ExceptionUtil;

public class ExportDeclarationSyncTask
extends AbstractTask {
    private static Log LOGGER = LogFactory.getLog(ExportDeclarationSyncTask.class);
    public static final Long TIMEOUT = 2592000000L;
    public static final Long BEFORTIMEOUT = 20000L;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Optional<DynamicObject> first = TsateDeclareRecordBusiness.queryRunningRecord((Long)TIMEOUT, (Long)BEFORTIMEOUT, (SupplierEnum)SupplierEnum.CMS, (ExecuteTypeEnums)ExecuteTypeEnums.CKBGDXZ).stream().sorted(new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                Date createtime = o1.getDate("createtime");
                Date createtime2 = o2.getDate("createtime");
                if (createtime.getTime() == createtime2.getTime()) {
                    return 0;
                }
                if (createtime.before(createtime2)) {
                    return 1;
                }
                return -1;
            }
        }).findFirst();
        DynamicObject runningRecord = null;
        if (first.isPresent()) {
            runningRecord = first.get();
        }
        if (runningRecord == null) {
            return;
        }
        String detaillogJson = runningRecord.getString("detaillog_tag");
        if (StringUtil.isBlank((CharSequence)detaillogJson) || JSON.parseObject((String)detaillogJson).get((Object)"downLoadData") == null) {
            return;
        }
        HashMap<String, Object> originParams = new HashMap<String, Object>(16);
        originParams.put("vo", JSON.parseObject((String)detaillogJson).getJSONObject("requestData").toJSONString());
        originParams.put("isScheduleSync", true);
        originParams.put("syncPageSize", Integer.parseInt((String)map.get("pageSize")));
        originParams.put("recordId", runningRecord.getLong("id"));
        try {
            ExportDeclarationBusiness.downloadExportDeclaration(originParams);
        }
        catch (Exception e) {
            LOGGER.error("sync  ExportDeclaration fail msg={}", (Object)ExceptionUtil.toString((Exception)e));
        }
    }
}

