/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.tsate.business.TsateChannelBusiness;
import kd.taxc.tsate.business.declare.declaremain.DeclarationMainFormBusniess;
import kd.taxc.tsate.business.sbbfile.SbbfileTaskStrategyFactory;
import kd.taxc.tsate.business.sbpz.SbpzHelper;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.DeclareStatusEnum;
import kd.taxc.tsate.common.enums.ExecuteTypeEnums;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.formplugin.task.AbstractTsateTask;

public class SbbfileDownloadTask
extends AbstractTsateTask {
    Log LOGGER = LogFactory.getLog(SbbfileDownloadTask.class);
    private static final String TSATESBPZ = "tsate_sbpz_admin";

    @Override
    public void doExecute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.LOGGER.info(ResManager.loadKDString((String)"\u7533\u62a5\u6587\u4ef6\u4e0b\u8f7d\u4efb\u52a1\u5f00\u59cb\u542f\u52a8(SbwjDownloadTask)...", (String)"SbbfileDownloadTask_0", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
        List<DynamicObject> declareMains = this.queryDeclaredRecord();
        this.LOGGER.info(ResManager.loadKDString((String)"\u5f53\u6708\u5df2\u7533\u62a5\u6570\u91cf\uff1a", (String)"SbbfileDownloadTask_1", (String)"taxc-tsate-formplugin", (Object[])new Object[0]) + declareMains.size());
        if (declareMains.size() == 0) {
            this.LOGGER.info(ResManager.loadKDString((String)"\u7533\u62a5\u6587\u4ef6\u4e0b\u8f7d\u4efb\u52a1\u5b8c\u6210", (String)"SbbfileDownloadTask_2", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection sbpzs = this.queryAlreadyDownloadRecord();
        this.LOGGER.info(ResManager.loadKDString((String)"\u5f53\u6708\u5df2\u4e0b\u8f7d\u6587\u4ef6\u6570\u91cf\uff1a", (String)"SbbfileDownloadTask_3", (String)"taxc-tsate-formplugin", (Object[])new Object[0]) + sbpzs.size());
        List<DynamicObject> taskRecords = this.genTaskRecordByDeclareMain(declareMains);
        List<DynamicObject> tobeCreateRecords = this.filteRecord(taskRecords, sbpzs);
        this.LOGGER.info(ResManager.loadKDString((String)"\u5f53\u6708\u9700\u8981\u7ee7\u7eed\u4e0b\u8f7d\u6587\u4ef6\u6570\u91cf\uff08\u8fc7\u6ee4\u540e\uff09\uff1a", (String)"SbbfileDownloadTask_4", (String)"taxc-tsate-formplugin", (Object[])new Object[0]) + tobeCreateRecords.size());
        if (tobeCreateRecords.size() == 0) {
            this.LOGGER.info(ResManager.loadKDString((String)"\u7533\u62a5\u6587\u4ef6\u4e0b\u8f7d\u4efb\u52a1\u5b8c\u6210", (String)"SbbfileDownloadTask_2", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            return;
        }
        SaveServiceHelper.save((DynamicObject[])tobeCreateRecords.toArray(new DynamicObject[0]));
        this.LOGGER.info(ResManager.loadKDString((String)"\u521b\u5efa\u7533\u62a5\u76d1\u63a7\u6570\u91cf\uff1a", (String)"SbbfileDownloadTask_5", (String)"taxc-tsate-formplugin", (Object[])new Object[0]) + taskRecords.size());
        List<Map<String, Object>> taskParams = this.genTaskParansByRecord(tobeCreateRecords, declareMains);
        this.sendTask(taskParams);
        this.LOGGER.info(ResManager.loadKDString((String)"\u7533\u62a5\u6587\u4ef6\u4e0b\u8f7d\u4efb\u52a1\u5b8c\u6210", (String)"SbbfileDownloadTask_2", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
    }

    private void sendTask(List<Map<String, Object>> params) {
        for (Map<String, Object> param : params) {
            this.doSend(param);
        }
    }

    private boolean doSend(Map<String, Object> map) {
        if (map == null) {
            return false;
        }
        String flagValue = map.getOrDefault("flag", "").toString();
        String keyValue = map.getOrDefault("key", "").toString();
        if (flagValue.startsWith("syn_user")) {
            DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tsate", (String)"UserMessageSendPlugin", (String)"doCustomService", (Object[])new Object[]{map});
        } else if (flagValue.startsWith("syn_sh")) {
            DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tsate", (String)"ShMessageSendPlugin", (String)"doCustomService", (Object[])new Object[]{map});
        } else if (this.isDirectDeclareOrRelatedTask(keyValue)) {
            DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tsate", (String)"DirectDeclarePlugin", (String)"doCustomService", (Object[])new Object[]{map});
        } else {
            DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tsate", (String)"MessageSendPlugin", (String)"doCustomService", (Object[])new Object[]{map});
        }
        return true;
    }

    private boolean isDirectDeclareOrRelatedTask(String key) {
        return "directdeclare".equals(key) || "fastpay".equals(key) || "yyjk".equals(key) || "undo".equals(key) || "qzsb".equals(key);
    }

    public List<DynamicObject> queryDeclaredRecord() {
        List dyns = DeclarationMainFormBusniess.queryDeclareMainBySbrqAndStatus((Date)DateUtils.getFirstDateOfMonth((Date)new Date()), (Date)DateUtils.getLastDateOfMonth((Date)new Date()), Collections.singletonList(DeclareStatusEnum.DECLARED.getCode()), null);
        return dyns;
    }

    private DynamicObjectCollection queryAlreadyDownloadRecord() {
        QFilter filterSkssqz = new QFilter("createtime", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)new Date())).and("createtime", "<=", (Object)DateUtils.getLastDateOfMonth((Date)new Date()));
        QFilter filter = new QFilter("datasource", "=", (Object)"1").and(filterSkssqz);
        filter.and("name", "=", (Object)SbpzHelper.getPznameByExecuteType((ExecuteTypeEnums)ExecuteTypeEnums.SBBFILE));
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)TSATESBPZ, (String)MetadataUtil.getAllFieldString((String)TSATESBPZ), (QFilter[])new QFilter[]{filter});
        return dyns;
    }

    private List<DynamicObject> filteRecord(List<DynamicObject> records, DynamicObjectCollection sbpzs) {
        List orgIds = records.stream().map(dyn -> dyn.getLong("org")).collect(Collectors.toList());
        Map channelConfig = TsateChannelBusiness.getDeclareConfigByOrgId(orgIds, (Boolean)true, (Boolean)true, (Boolean)true);
        ArrayList<DynamicObject> tobeCreate = new ArrayList<DynamicObject>(16);
        for (DynamicObject record : records) {
            String declareType;
            Long orgId = record.getLong("org");
            Map<String, Object> channelInfo = this.getChannelByOrg(orgId, declareType = record.getString("type"), channelConfig);
            if (channelInfo == null && (channelInfo = this.getChannelByOrg(orgId, null, channelConfig)) == null) {
                this.LOGGER.info(orgId + ResManager.loadKDString((String)"-\u8df3\u8fc7\uff08\u901a\u9053\u914d\u7f6e\u4e3a\u7a7a\uff09", (String)"SbbfileDownloadTask_6", (String)"taxc-tsate-formplugin", (Object[])new Object[0]) + declareType);
                continue;
            }
            boolean exist = false;
            for (DynamicObject item : sbpzs) {
                if (!SbpzHelper.matchSbbfileRecord((DynamicObject)record, (DynamicObject)item)) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            tobeCreate.add(record);
        }
        return tobeCreate;
    }

    private Map<String, Object> getChannelByOrg(Long orgId, String declareType, Map<Long, Map<String, Object>> channelConfig) {
        HashMap<String, Object> channel = new HashMap<String, Object>();
        Map orgInfos = channelConfig.getOrDefault(orgId, new HashMap(0));
        List channelInfos = orgInfos.getOrDefault("channelinfos", new ArrayList(0));
        if (declareType == null) {
            return channelInfos.size() > 0 ? (Map)channelInfos.get(0) : null;
        }
        for (Map channelItem : channelInfos) {
            String channelDeclareType = channelItem.getOrDefault("declaretype", "none");
            if (!channelDeclareType.equals(declareType)) continue;
            channel.put("channelid", channelItem.get("channelid"));
            channel.put("channelnumber", channelItem.get("channelnumber"));
            channel.put("channelname", channelItem.get("channelname"));
            return channel;
        }
        return null;
    }

    private List<DynamicObject> genTaskRecordByDeclareMain(List<DynamicObject> tobeDownloads) {
        ArrayList<DynamicObject> taskRecords = new ArrayList<DynamicObject>(10);
        List orgIds = tobeDownloads.stream().map(item -> DeclarationMainFormBusniess.getPropertyIdFromDeclare((DynamicObject)item, (String)"org")).collect(Collectors.toList());
        Map channelConfigs = TsateChannelBusiness.getDeclareConfigByOrgId(orgIds, (Boolean)true, (Boolean)true, (Boolean)true);
        for (DynamicObject declaremain : tobeDownloads) {
            Map<String, Object> map = this.getChannelByDelcareMain(declaremain, channelConfigs);
            if (map == null) {
                this.LOGGER.info(ResManager.loadKDString((String)"\u901a\u9053\u672a\u914d\u7f6e\uff0c\u4e0d\u751f\u6210\u5bf9\u5e94\u4efb\u52a1\uff1a", (String)"SbbfileDownloadTask_7", (String)"taxc-tsate-formplugin", (Object[])new Object[0]) + declaremain.toString());
                continue;
            }
            String channelCode = (String)map.get("channelnumber");
            SupplierEnum supplier = SupplierEnum.valueOfCode((String)channelCode);
            List records = SbbfileTaskStrategyFactory.get((SupplierEnum)supplier).genTaskRecordByDeclaremain(declaremain, supplier);
            taskRecords.addAll(records);
        }
        return taskRecords;
    }

    private List<Map<String, Object>> genTaskParansByRecord(List<DynamicObject> records, List<DynamicObject> tobeDownloads) {
        ArrayList<Map<String, Object>> taskParams = new ArrayList<Map<String, Object>>();
        HashMap<Long, String> nsrsbhMap = new HashMap<Long, String>(8);
        for (DynamicObject declaremainDyn : tobeDownloads) {
            nsrsbhMap.put(DeclarationMainFormBusniess.getPropertyIdFromDeclare((DynamicObject)declaremainDyn, (String)"org"), declaremainDyn.getString("nsrsbh"));
        }
        for (DynamicObject recordDyn : records) {
            String nsrsbh = (String)nsrsbhMap.get(recordDyn.getLong("org"));
            SupplierEnum supplier = SupplierEnum.valueOfId((Long)recordDyn.getLong("declarechannel"));
            List params = SbbfileTaskStrategyFactory.get((SupplierEnum)supplier).genTaskParamsByRecord(recordDyn, nsrsbh, supplier);
            taskParams.addAll(params);
        }
        return taskParams;
    }

    private Map<String, Object> getChannelByDelcareMain(DynamicObject declaremainRecord, Map<Long, Map<String, Object>> channelConfig) {
        HashMap<String, Object> channel = new HashMap<String, Object>();
        Long orgId = DeclarationMainFormBusniess.getPropertyIdFromDeclare((DynamicObject)declaremainRecord, (String)"org");
        String declareType = DeclarationMainFormBusniess.getDeclareTypeByModel3((DynamicObject)declaremainRecord);
        Map orgInfos = channelConfig.getOrDefault(orgId, new HashMap(0));
        List channelInfos = orgInfos.getOrDefault("channelinfos", new ArrayList(0));
        for (Map channelItem : channelInfos) {
            String channelDeclareType = channelItem.getOrDefault("declaretype", "none");
            if (!channelDeclareType.equals(declareType)) continue;
            channel.put("channelid", channelItem.get("channelid"));
            channel.put("channelnumber", channelItem.get("channelnumber"));
            channel.put("channelname", channelItem.get("channelname"));
            return channel;
        }
        return null;
    }
}

