/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.tsate.business.TsateChannelBusiness;
import kd.taxc.tsate.business.TsateDeclareRecordBusiness;
import kd.taxc.tsate.business.declare.declaremain.DeclarationMainFormBusniess;
import kd.taxc.tsate.business.sbpz.SbpzHelper;
import kd.taxc.tsate.common.enums.ExecuteStatusEnum;
import kd.taxc.tsate.common.enums.ExecuteTypeEnums;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.formplugin.task.AbstractTsateTask;
import kd.taxc.tsate.formplugin.task.sbpz.ISbpzChannelStrategy;
import kd.taxc.tsate.formplugin.task.sbpz.SbpzChannelStrategyAnnotationBaseFactory;

public class SbpzDownloadTask
extends AbstractTsateTask {
    Log LOGGER = LogFactory.getLog(SbpzDownloadTask.class);
    private static final String TSATESBPZ = "tsate_sbpz_admin";
    private static final String TSATETASKTYPE = "tsate_tasktype";
    private static final String BDTAXTYPE = "bd_taxcategory";

    @Override
    public void doExecute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.LOGGER.info("\u7533\u62a5\u51ed\u8bc1\u4e0b\u8f7d\u4efb\u52a1\u5f00\u59cb\u542f\u52a8(SbpzDownloadTask)...");
        List<DynamicObject> declareMains = this.queryPaidRecord();
        this.LOGGER.info("\u5f53\u6708\u7533\u62a5\u5df2\u7f34\u6b3e\u6570\u91cf\uff1a" + declareMains.size());
        if (declareMains.isEmpty()) {
            this.LOGGER.info("\u7533\u62a5\u51ed\u8bc1\u4e0b\u8f7d\u4efb\u52a1\u5b8c\u6210");
        }
        DynamicObjectCollection sbpzs = this.queryAlreadyDownloadRecord();
        this.LOGGER.info("\u5f53\u6708\u5df2\u4e0b\u8f7d\u51ed\u8bc1\u6570\u91cf\uff1a" + sbpzs.size());
        List<Map<String, Object>> tobeDownloads = this.filterNeedDownload(declareMains, sbpzs);
        this.LOGGER.info("\u5f53\u6708\u9700\u8981\u7ee7\u7eed\u4e0b\u8f7d\u51ed\u8bc1\u6570\u91cf\uff08\u8fc7\u6ee4\u540e\uff09\uff1a" + tobeDownloads.size());
        if (tobeDownloads.isEmpty()) {
            this.LOGGER.info("\u7533\u62a5\u51ed\u8bc1\u4e0b\u8f7d\u4efb\u52a1\u5b8c\u6210");
            return;
        }
        Map<String, DynamicObject> declareRecordsMap = this.saveDeclareRecordBatch(tobeDownloads);
        this.LOGGER.info("\u521b\u5efa\u7533\u62a5\u76d1\u63a7\u6570\u91cf\uff1a" + declareRecordsMap.size());
        this.sendTask(declareRecordsMap, tobeDownloads);
        this.LOGGER.info("\u7533\u62a5\u51ed\u8bc1\u4e0b\u8f7d\u4efb\u52a1\u5b8c\u6210");
    }

    private void sendTask(Map<String, DynamicObject> declareRecordsMap, List<Map<String, Object>> tobeDownloads) {
        for (Map<String, Object> tobeDownload : tobeDownloads) {
            String recordBillno = (String)tobeDownload.get("declarerecordbillno");
            DynamicObject recordDyn = declareRecordsMap.get(recordBillno);
            Long recordId = recordDyn.getLong("id");
            Map map = this.getSbpzParams(recordId, tobeDownload);
            this.doSend(map);
        }
    }

    private boolean doSend(Map<String, Object> map) {
        if (map == null) {
            return false;
        }
        String flagValue = map.getOrDefault("flag", "").toString();
        String keyValue = map.getOrDefault("key", "").toString();
        if (flagValue.startsWith("syn_user")) {
            DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tsate", (String)"UserMessageSendPlugin", (String)"doCustomService", (Object[])new Object[]{map});
        } else if (flagValue.startsWith("syn_sh")) {
            DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tsate", (String)"ShMessageSendPlugin", (String)"doCustomService", (Object[])new Object[]{map});
        } else if (this.isDirectDeclareOrRelatedTask(keyValue)) {
            DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tsate", (String)"DirectDeclarePlugin", (String)"doCustomService", (Object[])new Object[]{map});
        } else {
            DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tsate", (String)"MessageSendPlugin", (String)"doCustomService", (Object[])new Object[]{map});
        }
        return true;
    }

    private boolean isDirectDeclareOrRelatedTask(String key) {
        return "directdeclare".equals(key) || "fastpay".equals(key) || "yyjk".equals(key) || "undo".equals(key) || "qzsb".equals(key);
    }

    public List<DynamicObject> queryPaidRecord() {
        List dynamicObjects = DeclarationMainFormBusniess.queryDeclareMainBySbrqAndStatus((Date)DateUtils.getFirstDateOfMonth((Date)new Date()), (Date)DateUtils.getLastDateOfMonth((Date)new Date()), Collections.singletonList("declared"), Collections.singletonList("paid"));
        return dynamicObjects;
    }

    private DynamicObjectCollection queryAlreadyDownloadRecord() {
        QFilter filterSkssqz = new QFilter("createtime", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)new Date())).and("createtime", "<=", (Object)DateUtils.getLastDateOfMonth((Date)new Date()));
        QFilter filter = new QFilter("datasource", "=", (Object)"1").and(filterSkssqz);
        String fields = MetadataUtil.getAllFieldString((String)TSATESBPZ) + ",taxtype.number,declaretype.number";
        filter.and("name", "=", (Object)SbpzHelper.getPznameByExecuteType((ExecuteTypeEnums)ExecuteTypeEnums.WSPZ));
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)TSATESBPZ, (String)fields, (QFilter[])new QFilter[]{filter});
        return dyns;
    }

    private List<Map<String, Object>> filterNeedDownload(List<DynamicObject> declaremains, DynamicObjectCollection sbpzs) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(8);
        List orgIds = declaremains.stream().map(dyn -> DeclarationMainFormBusniess.getPropertyIdFromDeclare((DynamicObject)dyn, (String)"org")).collect(Collectors.toList());
        Map channelConfig = TsateChannelBusiness.getDeclareConfigByOrgId(orgIds, (Boolean)true, (Boolean)true, (Boolean)true);
        for (DynamicObject declareMain : declaremains) {
            Long orgId = DeclarationMainFormBusniess.getPropertyIdFromDeclare((DynamicObject)declareMain, (String)"org");
            Map<String, Object> channelInfo = this.getChannelByDelcareMain(declareMain, channelConfig);
            if (channelInfo == null) {
                this.LOGGER.info(orgId + "-\u8df3\u8fc7\uff08\u901a\u9053\u914d\u7f6e\u4e3a\u7a7a\uff09");
                continue;
            }
            Long channelId = (Long)channelInfo.get("channelid");
            String channelNumber = (String)channelInfo.get("channelnumber");
            ISbpzChannelStrategy strategy = SbpzChannelStrategyAnnotationBaseFactory.getStrategy(channelId, channelNumber);
            if (!strategy.checkSupport()) {
                this.LOGGER.info(orgId + "-\u8df3\u8fc7\uff08\u901a\u9053\u4e0d\u652f\u6301\uff09");
                continue;
            }
            List<Map<String, Object>> listParams = strategy.genDownloadSbpzParams(declareMain);
            this.LOGGER.info(orgId + "-\u751f\u6210\u53c2\u6570\uff1a" + listParams.size());
            for (DynamicObject sbpz : sbpzs) {
                Iterator<Map<String, Object>> it = listParams.iterator();
                while (it.hasNext()) {
                    Map<String, Object> params = it.next();
                    if (!strategy.match(params, sbpz)) continue;
                    this.LOGGER.info(orgId + "-\u8df3\u8fc7\uff08\u51ed\u8bc1\u5df2\u4e0b\u8f7d\uff09");
                    it.remove();
                }
            }
            list.addAll(listParams);
        }
        return list;
    }

    private Map getSbpzParams(Long recordId, Map<String, Object> info) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("recordid", recordId);
        map.put("nsrsbh", info.get("nsrsbh"));
        map.put("org", info.get("orgid"));
        map.put("skssqq", info.get("skssqq"));
        map.put("skssqz", info.get("skssqz"));
        map.put("supplier", info.get("channelnumber"));
        map.put("declareTypeNumber", info.get("declaretype"));
        map.put("sbqj", info.get("sbqj"));
        map.put("typeNumber", info.get("typeNumber"));
        String executeType = "WSPZ";
        String key = "wspz";
        map.put("key", key);
        map.put(key, SbpzHelper.getPznameByExecuteType((String)executeType));
        map.put("taxtype", info.get("taxtype"));
        map.put("msgsource", "schtask");
        map.put("voucherType", info.get("voucherType"));
        return map;
    }

    private Map<String, DynamicObject> saveDeclareRecordBatch(List<Map<String, Object>> infos) {
        List taxtypeCodes = infos.stream().map(item -> (String)item.get("taxtype")).collect(Collectors.toList());
        QFilter taxtypeQuery = new QFilter("number", "in", taxtypeCodes);
        DynamicObjectCollection taxtypes = QueryServiceHelper.query((String)BDTAXTYPE, (String)"id,number,name", (QFilter[])new QFilter[]{taxtypeQuery});
        Map<String, Long> taxtypeNumberToIds = taxtypes.stream().collect(Collectors.toMap(item -> item.getString("number"), item -> item.getLong("id")));
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(8);
        QFilter filter = new QFilter("number", "=", (Object)"WSPZ");
        DynamicObject dyn = QueryServiceHelper.queryOne((String)TSATETASKTYPE, (String)MetadataUtil.getAllFieldString((String)TSATETASKTYPE), (QFilter[])new QFilter[]{filter});
        for (Map<String, Object> info : infos) {
            Long orgid = (Long)info.get("orgid");
            Date createTime = new Date();
            ExecuteStatusEnum executestatus = ExecuteStatusEnum.PROCESSING;
            Date skssqq = (Date)info.get("skssqq");
            Date skssqz = (Date)info.get("skssqz");
            Date sbqj = (Date)info.get("sbqj");
            String channel = (String)info.get("channelnumber");
            Long declarechannel = (Long)info.get("channelid");
            String executetype = "WSPZ";
            Long tasktype = dyn.getLong("id");
            String declaretype = (String)info.get("declaretype");
            String taxtype = (String)info.get("taxtype");
            HashMap<String, Object> objParams = new HashMap<String, Object>(16);
            objParams.put("orgid", orgid);
            objParams.put("createtime", createTime);
            objParams.put("creatorid", null);
            objParams.put("executestatus", executestatus.getCode());
            objParams.put("sbqj", sbqj);
            objParams.put("skssqq", skssqq);
            objParams.put("skssqz", skssqz);
            objParams.put("channelnumber", channel);
            objParams.put("channelid", declarechannel);
            objParams.put("executetype", executetype);
            objParams.put("tasktypeid", tasktype);
            objParams.put("declaretype", declaretype);
            objParams.put("taxtype", taxtypeNumberToIds.getOrDefault(taxtype, 0L));
            DynamicObject recordDyn = TsateDeclareRecordBusiness.newObject(objParams);
            String billno = recordDyn.getString("billno");
            info.put("declarerecordbillno", billno);
            map.put(billno, recordDyn);
        }
        SaveServiceHelper.save((DynamicObject[])map.values().toArray(new DynamicObject[0]));
        return map;
    }

    private Map<String, Object> getChannelByDelcareMain(DynamicObject declaremainRecord, Map<Long, Map<String, Object>> channelConfig) {
        HashMap<String, Object> channel = new HashMap<String, Object>();
        Long orgId = DeclarationMainFormBusniess.getPropertyIdFromDeclare((DynamicObject)declaremainRecord, (String)"org");
        String declareType = DeclarationMainFormBusniess.getDeclareTypeByModel3((DynamicObject)declaremainRecord);
        Map orgInfos = channelConfig.getOrDefault(orgId, new HashMap(0));
        List channelInfos = orgInfos.getOrDefault("channelinfos", new ArrayList(0));
        for (Map channelItem : channelInfos) {
            String channelDeclareType = channelItem.getOrDefault("declaretype", "none");
            if (!channelDeclareType.equals(declareType)) continue;
            channel.put("channelid", channelItem.get("channelid"));
            channel.put("channelnumber", channelItem.get("channelnumber"));
            channel.put("channelname", channelItem.get("channelname"));
            return channel;
        }
        return null;
    }
}

