/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.task;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tsate.business.TsateChannelBusiness;
import kd.taxc.tsate.business.TsateDeclareRecordBusiness;
import kd.taxc.tsate.common.enums.ExecuteStatusEnum;
import kd.taxc.tsate.common.helper.OrgServiceHelper;
import kd.taxc.tsate.common.metadata.MetadataUtil;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.PermissionUtils;
import kd.taxc.tsate.formplugin.task.AbstractTsateTask;
import org.apache.commons.collections.CollectionUtils;

public class SbsxDownloadTask
extends AbstractTsateTask {
    private static Log logger = LogFactory.getLog(SbsxDownloadTask.class);
    private static final String TASKTYPE_SBSXXZ = "SBSXXZ";
    private static final String SBSX_DOWNLOAD_PER = "28T/ALUDR3RZ";

    @Override
    public void doExecute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        List<Long> list = this.getValuableOrg();
        this.batchJob(list);
    }

    private List<Long> getValuableOrg() {
        ArrayList<Long> ids2 = new ArrayList<Long>();
        List<Long> ids = this.buildOrgs();
        Map channelInfos = TsateChannelBusiness.getDeclareConfigByOrgId(ids, (Boolean)true, (Boolean)true, (Boolean)true);
        block0: for (Long orgid : ids) {
            List channelList;
            Map orgChannelInfo = (Map)channelInfos.get(orgid);
            if (orgChannelInfo == null || (channelList = (List)orgChannelInfo.computeIfAbsent("channelinfos", key -> new ArrayList())).size() < 1) continue;
            for (Map channel : channelList) {
                String channelNumber = (String)channel.get("channelnumber");
                if (!"6".equals(channelNumber)) continue;
                ids2.add(orgid);
                continue block0;
            }
        }
        return ids2;
    }

    private int batchJob(List<Long> orgIdList) {
        Map maps = TsateChannelBusiness.getDeclareConfigByOrgId(orgIdList, (Boolean)true, (Boolean)true, (Boolean)true);
        int count = 0;
        for (Map org : maps.values()) {
            List channelConfigs = (List)org.computeIfAbsent("channelinfos", key -> new ArrayList(2));
            if (channelConfigs.size() <= 0) continue;
            Map item = (Map)channelConfigs.get(0);
            String supplier = (String)item.get("channelnumber");
            if (supplier == null) {
                logger.warn("tsate-\u7533\u62a5\u4e8b\u9879\u4e0b\u8f7d,\u7a0e\u53f7\u65e0\u53ef\u7528\u901a\u9053\uff0c\u8be6\u7ec6\uff1a" + JSON.toJSONString((Object)item));
                continue;
            }
            Long taxorgid = (Long)org.get("taxofficeid");
            Long orgid = (Long)org.get("id");
            Long channelId = (Long)item.get("channelid");
            String channelNumber = (String)item.get("channelnumber");
            DynamicObject record = this.addDeclareRecord(orgid, channelId, channelNumber);
            String nsrsbh = (String)org.get("nsrsbh");
            Long recordId = record.getLong("id");
            HashMap<String, Object> paramMap = new HashMap<String, Object>(12);
            paramMap.put("taxorgid", taxorgid);
            paramMap.put("nsrsbh", nsrsbh);
            paramMap.put("org", orgid);
            paramMap.put("recordid", recordId);
            paramMap.put("key", "sbsxxz");
            paramMap.put("supplier", supplier);
            paramMap.put("operatetime", System.currentTimeMillis());
            paramMap.put("datasource", "1");
            this.send(paramMap);
            ++count;
        }
        logger.info("tsate-\u7533\u62a5\u4e8b\u9879\u4e0b\u8f7d ,\u7ec4\u7ec7\u6570\u91cf:" + orgIdList.size() + " \u6279\u91cf\u6267\u884c\u6570\u91cf\uff1a" + count);
        return count;
    }

    private List<Long> buildOrgs() {
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgsByUserId((String)"tsate", (String)"tsate_declare_checklist", (String)SBSX_DOWNLOAD_PER, (Long)RequestContext.get().getCurrUserId());
        List<Object> orgList = new ArrayList();
        if (EmptyCheckUtils.isNotEmpty((Object)hasPermOrgResult) && !hasPermOrgResult.hasAllOrgPerm()) {
            orgList = hasPermOrgResult.getHasPermOrgs();
        } else {
            DynamicObjectCollection objs = OrgServiceHelper.getOrgLists();
            if (!CollectionUtils.isEmpty((Collection)objs)) {
                orgList = objs.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
            }
        }
        return orgList;
    }

    private DynamicObject addDeclareRecord(Long orgid, Long channelId, String channelNumber) {
        DynamicObject taskObj = this.getTaskType();
        Date sbqj = new Date();
        Date createTime = new Date();
        Long creatorId = RequestContext.get().getCurrUserId();
        ExecuteStatusEnum executestatus = ExecuteStatusEnum.PROCESSING;
        Long taskId = taskObj.getLong("id");
        return TsateDeclareRecordBusiness.save((Long)orgid, (Date)createTime, (String)creatorId.toString(), (ExecuteStatusEnum)executestatus, (Date)sbqj, (String)channelNumber, (Long)channelId, (String)TASKTYPE_SBSXXZ, (Long)taskId);
    }

    private DynamicObject getTaskType() {
        QFilter filter = new QFilter("number", "=", (Object)TASKTYPE_SBSXXZ);
        return QueryServiceHelper.queryOne((String)"tsate_tasktype", (String)MetadataUtil.getAllFieldString((String)"tsate_tasktype"), (QFilter[])new QFilter[]{filter});
    }

    private void send(Map<String, Object> map) {
        if (map == null) {
            logger.info("SbsxDownloadTask.send map is null");
            return;
        }
        String flag = map.getOrDefault("flag", "").toString();
        String key = map.getOrDefault("key", "").toString();
        if (flag.startsWith("syn_user")) {
            this.invokeService("UserMessageSendPlugin", map);
        } else if (flag.startsWith("syn_sh")) {
            this.invokeService("ShMessageSendPlugin", map);
        } else if (this.isDirectDeclareOrRelatedTask(key)) {
            this.invokeService("DirectDeclarePlugin", map);
        } else {
            this.invokeService("MessageSendPlugin", map);
        }
    }

    private void invokeService(String pluginName, Map<String, Object> map) {
        DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tsate", (String)pluginName, (String)"doCustomService", (Object[])new Object[]{map});
    }

    private boolean isDirectDeclareOrRelatedTask(String key) {
        return "directdeclare".equals(key) || "fastpay".equals(key) || "yyjk".equals(key) || "undo".equals(key) || "qzsb".equals(key);
    }
}

