/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tsate.SyncCancelStatusServiceHelper;
import kd.taxc.tsate.common.enums.PayStatusEnum;
import kd.taxc.tsate.formplugin.task.AbstractTsateTask;

public class SynYYJKSatusTask
extends AbstractTsateTask {
    private static Log LOGGER = LogFactory.getLog(SynYYJKSatusTask.class);
    private static final String ENTITY_DECLARE_MAIN = "tsate_declare_query_list";

    @Override
    void doExecute(RequestContext context, Map<String, Object> params) {
        List<DynamicObject> declareMainList = this.getDeclareList();
        List<Long> declareIds = this.validateData(declareMainList);
        this.senTask(declareIds);
    }

    private List<DynamicObject> getDeclareList() {
        QFilter q1 = new QFilter("paystatus", "=", (Object)PayStatusEnum.YYPAID.getCode());
        QFilter q2 = new QFilter("paydate", "<=", (Object)new Date());
        DynamicObject[] declareMain = BusinessDataServiceHelper.load((String)ENTITY_DECLARE_MAIN, (String)"id", (QFilter[])new QFilter[]{q1, q2});
        List<DynamicObject> returnList = new ArrayList<DynamicObject>(10);
        if (declareMain != null && declareMain.length > 0) {
            returnList = Arrays.asList(declareMain);
        }
        return returnList;
    }

    private List<Long> validateData(List<DynamicObject> declares) {
        if (declares == null || declares.isEmpty()) {
            return null;
        }
        ArrayList<Long> declareIds = new ArrayList<Long>(8);
        for (DynamicObject declare : declares) {
            declareIds.add(declare.getLong("id"));
        }
        Map validateInfos = (Map)SyncCancelStatusServiceHelper.validateSyncData(declareIds).getData();
        if (validateInfos.size() > 0) {
            ArrayList erros = new ArrayList(8);
            erros.addAll(validateInfos.values());
            LOGGER.error("\u540c\u6b65\u9884\u7ea6\u7f34\u6b3e\u7f34\u6b3e\u72b6\u6001\u5b9a\u65f6\u4efb\u52a1\uff0c\u4e1a\u52a1\u6821\u9a8c\u5931\u8d25" + erros);
            declareIds.removeAll(validateInfos.keySet());
        }
        return declareIds;
    }

    private void senTask(List<Long> declareIds) {
        if (declareIds == null || declareIds.isEmpty()) {
            LOGGER.info("\u540c\u6b65\u9884\u7ea6\u7f34\u6b3e\u7f34\u6b3e\u72b6\u6001\u5b9a\u65f6\u4efb\u52a1\uff0c\u65e0\u53ef\u540c\u6b65\u7684\u7533\u62a5\u8868\u6570\u636e");
            return;
        }
        List executeInfos = (List)SyncCancelStatusServiceHelper.sendTask(declareIds).getData();
        int totalSize = executeInfos.size();
        int failSize = 0;
        ArrayList<String> faildetail = new ArrayList<String>();
        for (Map info : executeInfos) {
            Boolean isfail = (Boolean)info.get("isfail");
            if (!isfail.booleanValue()) continue;
            ++failSize;
            String failmsg = (String)info.get("failmsg");
            faildetail.add(failmsg);
        }
        LOGGER.info(ResManager.loadKDString((String)"\u9009\u4e2d%1$s\u6761\u8bb0\u5f55\uff0c%2$s\u6761\u64cd\u4f5c\u6210\u529f\uff0c%3$s\u6761\u64cd\u4f5c\u5931\u8d25\u3002", (String)"SynYYJKSatusTask_0", (String)"taxc-tsate-formplugin", (Object[])new Object[]{totalSize, totalSize - failSize, failSize}) + "\r\n" + ((Object)faildetail).toString());
    }
}

