/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.tsate.business.BastaxTaxorgBusiness;
import kd.taxc.tsate.business.TsateChannelBusiness;
import kd.taxc.tsate.business.declare.declaremain.DeclarationMainFormBusniess;
import kd.taxc.tsate.business.sbbfile.SbbfileTaskStrategyFactory;
import kd.taxc.tsate.business.sbpz.SbpzHelper;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.ExecuteStatusEnum;
import kd.taxc.tsate.common.enums.ExecuteTypeEnums;
import kd.taxc.tsate.common.enums.VoucherTypeEnum;
import kd.taxc.tsate.common.metadata.MetadataUtil;
import kd.taxc.tsate.common.util.CommonInfoUtil;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.common.util.ExceptionUtil;
import kd.taxc.tsate.formplugin.task.AbstractTsateTask;
import kd.taxc.tsate.formplugin.task.helper.QxySyncTaskStatusHelper;
import kd.taxc.tsate.formplugin.task.helper.SyncTaskStatusBaseHelper;
import org.apache.commons.collections.CollectionUtils;

public class SyncDeclareStatusTask
extends AbstractTsateTask {
    private static final Log LOGGER = LogFactory.getLog(SyncDeclareStatusTask.class);
    private static final String ENTITY_DECLARE_RECORD = "tsate_declare_record";
    private static final String DIRECT_DECLARE = "directdeclare";
    private static final String DIRECT_PAY = "fastpay";
    public static final Long SBPZ_TIMEOUT = 2592000000L;
    public static final Long SBPZ_BEFORTIMEOUT = 60000L;
    private static final String[] WSPZ_TYPE = new String[]{"WSPZ"};
    private static final String[] WSPZ_CHANNELE = new String[]{SupplierEnum.YZF.getCode(), SupplierEnum.ZWY.getCode(), SupplierEnum.QXY.getCode()};
    private static final String[] DECLARING_STATUS = new String[]{"declaring", "submitted", "importing"};

    @Override
    public void doExecute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        QxySyncTaskStatusHelper.doQxyTaskSync();
        int n1 = this.doSync(this.queryDeclaringRecord());
        int n2 = this.doSync(this.queryPayingRecord());
        int n3 = this.doSyncSbpz((Collection<DynamicObject>)this.querySbpzRecord());
        int n4 = this.doSyncSbpz((Collection<DynamicObject>)this.querySbjlRecord());
        int n5 = this.doSyncSbpz((Collection<DynamicObject>)this.queryKkjlRecord());
        int n6 = 0;
        try {
            n6 = this.doSyncTbzt((Collection<DynamicObject>)this.queryTbztRecord());
        }
        catch (Exception e) {
            LOGGER.error("\u540c\u6b65\u7a0e\u5c40\u72b6\u6001\u5f02\u5e38\uff1a" + ExceptionUtil.toString((Exception)e));
        }
        int n7 = 0;
        try {
            n7 = this.doSyncSbzf((Collection<DynamicObject>)this.querySbzfRecord());
        }
        catch (Exception e) {
            LOGGER.error("\u4f5c\u5e9f\u4efb\u52a1\u72b6\u6001\u5f02\u5e38\uff1a" + ExceptionUtil.toString((Exception)e));
        }
        int n8 = 0;
        try {
            n8 = this.doSyncLsxz((Collection<DynamicObject>)this.queryLsxzRecord());
        }
        catch (Exception e) {
            LOGGER.error("\u5386\u53f2\u4e0b\u8f7d\u72b6\u6001\u5f02\u5e38\uff1a" + ExceptionUtil.toString((Exception)e));
        }
        int n9 = 0;
        try {
            n9 = this.doSyncSbbfile(this.querySbbfileRecord());
        }
        catch (Exception e) {
            LOGGER.error("\u540c\u6b65\u7533\u62a5\u8868\u6587\u4ef6\uff1a" + ExceptionUtil.toString((Exception)e));
        }
        int n10 = 0;
        try {
            n10 = this.doSyncQcxz((Collection<DynamicObject>)this.queryQcxzRecord());
        }
        catch (Exception e) {
            LOGGER.error("\u5386\u53f2\u4e0b\u8f7d\u72b6\u6001\u5f02\u5e38\uff1a" + ExceptionUtil.toString((Exception)e));
        }
        int n11 = 0;
        try {
            n11 = this.doSyncSbqc((Collection<DynamicObject>)this.querySbqcRecord());
        }
        catch (Exception e) {
            LOGGER.error("\u4e0b\u8f7d\u7533\u62a5\u6e05\u518c\u4fe1\u606f\u5f02\u5e38\uff1a" + ExceptionUtil.toString((Exception)e));
        }
        String sb = ResManager.loadKDString((String)"\u7a0e\u4f01\u76f4\u8fde\u5b9a\u65f6\u540c\u6b65\u72b6\u6001\u4efb\u52a1\u6570\u91cf - \u7533\u62a5\u72b6\u6001\uff1a%1$s \u7f34\u6b3e\u72b6\u6001\uff1a%2$s \u7533\u62a5\u51ed\u8bc1\uff1a%3$s \u7533\u62a5\u8bb0\u5f55\uff1a%4$s \u6263\u6b3e\u8bb0\u5f55\uff1a%5$s \u540c\u6b65\u7a0e\u5c40\u72b6\u6001\uff1a%6$s \u4f5c\u5e9f\u4efb\u52a1\uff1a%7$s \u5386\u53f2\u4e0b\u8f7d\u4efb\u52a1\uff1a%8$s \u7533\u62a5\u8868pdf\u6587\u4ef6\u4efb\u52a1\uff1a%9$s \u671f\u521d\u4e0b\u8f7d\u4efb\u52a1\uff1a%10$s \u4e0b\u8f7d\u7533\u62a5\u6e05\u518c\u4efb\u52a1\uff1a%11$s", (String)"SyncDeclareStatusTask_0", (String)"taxc-tsate-formplugin", (Object[])new Object[]{n1, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11});
        LOGGER.info(sb);
    }

    private int doSyncSbbfile(DynamicObjectCollection querySbbfileRecord) {
        int count = 0;
        ArrayList allParams = new ArrayList(8);
        for (DynamicObject record : querySbbfileRecord) {
            SupplierEnum supplier = this.getSupplierFromRecord(record);
            List params = SbbfileTaskStrategyFactory.get((SupplierEnum)supplier).genTaskParamsByRecord(record, null, supplier);
            allParams.addAll(params);
        }
        for (Map map : allParams) {
            try {
                map.put("isQuery", true);
                if (!SyncTaskStatusBaseHelper.send(map)) continue;
                ++count;
            }
            catch (Exception e) {
                LOGGER.error("tsate \u5b9a\u65f6\u540c\u6b65\u4efb\u52a1\u51fa\u9519\uff0c\u4efb\u52a1\u53c2\u6570\uff1a" + JSON.toJSONString((Object)map));
                LOGGER.error(ExceptionUtil.toString((Exception)e));
            }
        }
        return count;
    }

    private List<DynamicObject> queryDeclaringRecord() {
        Date now = new Date();
        Date start = DateUtils.getFirstDateOfMonth((Date)now);
        Date end = new Date(System.currentTimeMillis() - SBPZ_BEFORTIMEOUT);
        List dynamicObjects = DeclarationMainFormBusniess.queryDeclareMainBySbrqAndStatus((Date)start, (Date)end, (List)Lists.newArrayList((Object[])DECLARING_STATUS), null);
        return dynamicObjects;
    }

    private List<DynamicObject> queryPayingRecord() {
        Date now = new Date();
        Date start = DateUtils.getFirstDateOfMonth((Date)now);
        Date end = new Date(System.currentTimeMillis() - SBPZ_BEFORTIMEOUT);
        List declareMains = DeclarationMainFormBusniess.queryDeclareMainBySbrqAndStatus((Date)start, (Date)end, null, Collections.singletonList("paying"));
        DynamicObjectCollection runningRecord = SyncTaskStatusBaseHelper.queryRunningRecord(SupplierEnum.SZYH, ExecuteTypeEnums.ZLJK);
        if (CollectionUtils.isEmpty((Collection)runningRecord)) {
            return declareMains;
        }
        List sbbid = runningRecord.stream().map(o -> o.getLong("sbbid")).collect(Collectors.toList());
        List yhCollection = DeclarationMainFormBusniess.queryByIdsThrowEx(sbbid);
        if (!CollectionUtils.isEmpty((Collection)yhCollection)) {
            declareMains.addAll(yhCollection);
        }
        return declareMains;
    }

    private DynamicObjectCollection querySbpzRecord() {
        QFilter filter = new QFilter("executestatus", "=", (Object)"1");
        filter.and("channel", "in", (Object)WSPZ_CHANNELE);
        filter.and("executetype", "in", (Object)WSPZ_TYPE);
        Date timeout = new Date(System.currentTimeMillis() - SBPZ_TIMEOUT);
        filter.and("createtime", ">=", (Object)timeout);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)ENTITY_DECLARE_RECORD, (String)(MetadataUtil.getAllFieldString((String)ENTITY_DECLARE_RECORD) + ",taxtype.number"), (QFilter[])new QFilter[]{filter});
        return collection;
    }

    private DynamicObjectCollection querySbjlRecord() {
        QFilter filter = new QFilter("executestatus", "=", (Object)"1");
        filter.and("channel", "=", (Object)"1");
        filter.and("executetype", "=", (Object)"SBJT");
        Date timeout = new Date(System.currentTimeMillis() - SBPZ_TIMEOUT);
        Date beforTimeOut = new Date(System.currentTimeMillis() - SBPZ_BEFORTIMEOUT);
        filter.and("createtime", ">=", (Object)timeout);
        filter.and("createtime", "<=", (Object)beforTimeOut);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)ENTITY_DECLARE_RECORD, (String)MetadataUtil.getAllFieldString((String)ENTITY_DECLARE_RECORD), (QFilter[])new QFilter[]{filter});
        return collection;
    }

    private DynamicObjectCollection queryKkjlRecord() {
        QFilter filter = new QFilter("executestatus", "=", (Object)"1");
        filter.and("channel", "=", (Object)"1");
        filter.and("executetype", "=", (Object)"KKJT");
        Date timeout = new Date(System.currentTimeMillis() - SBPZ_TIMEOUT);
        Date beforTimeOut = new Date(System.currentTimeMillis() - SBPZ_BEFORTIMEOUT);
        filter.and("createtime", ">=", (Object)timeout);
        filter.and("createtime", "<=", (Object)beforTimeOut);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)ENTITY_DECLARE_RECORD, (String)MetadataUtil.getAllFieldString((String)ENTITY_DECLARE_RECORD), (QFilter[])new QFilter[]{filter});
        return collection;
    }

    private DynamicObjectCollection queryTbztRecord() {
        QFilter filter = new QFilter("executestatus", "=", (Object)"1");
        filter.and("executetype", "=", (Object)"TBZT");
        Date timeout = new Date(System.currentTimeMillis() - SBPZ_TIMEOUT);
        Date beforTimeOut = new Date(System.currentTimeMillis() - SBPZ_BEFORTIMEOUT);
        filter.and("createtime", ">=", (Object)timeout);
        filter.and("createtime", "<=", (Object)beforTimeOut);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)ENTITY_DECLARE_RECORD, (String)MetadataUtil.getAllFieldString((String)ENTITY_DECLARE_RECORD), (QFilter[])new QFilter[]{filter});
        return collection;
    }

    private DynamicObjectCollection querySbzfRecord() {
        QFilter filter = new QFilter("executestatus", "=", (Object)ExecuteStatusEnum.PROCESSING.getCode());
        String[] suppliers = new String[]{SupplierEnum.YZF.getCode(), SupplierEnum.QXY.getCode()};
        filter.and("channel", "in", (Object)suppliers);
        filter.and("executetype", "=", (Object)ExecuteTypeEnums.SBZF.getExecuteType());
        Date timeout = new Date(System.currentTimeMillis() - SBPZ_TIMEOUT);
        Date beforTimeOut = new Date(System.currentTimeMillis() - SBPZ_BEFORTIMEOUT);
        filter.and("createtime", ">=", (Object)timeout);
        filter.and("createtime", "<=", (Object)beforTimeOut);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)ENTITY_DECLARE_RECORD, (String)MetadataUtil.getAllFieldString((String)ENTITY_DECLARE_RECORD), (QFilter[])new QFilter[]{filter});
        return collection;
    }

    private DynamicObjectCollection queryLsxzRecord() {
        QFilter filter = new QFilter("executestatus", "=", (Object)"1");
        filter.and("executetype", "=", (Object)ExecuteTypeEnums.LSXZ.getExecuteType());
        Date timeout = new Date(System.currentTimeMillis() - SBPZ_TIMEOUT);
        Date beforTimeOut = new Date(System.currentTimeMillis() - SBPZ_BEFORTIMEOUT);
        filter.and("createtime", ">=", (Object)timeout);
        filter.and("createtime", "<=", (Object)beforTimeOut);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)ENTITY_DECLARE_RECORD, (String)MetadataUtil.getAllFieldString((String)ENTITY_DECLARE_RECORD), (QFilter[])new QFilter[]{filter});
        return collection;
    }

    private DynamicObjectCollection queryQcxzRecord() {
        QFilter filter = new QFilter("executestatus", "=", (Object)"1");
        filter.and("executetype", "=", (Object)ExecuteTypeEnums.QCXZ.getExecuteType());
        Date timeout = new Date(System.currentTimeMillis() - SBPZ_TIMEOUT);
        Date beforTimeOut = new Date(System.currentTimeMillis() - SBPZ_BEFORTIMEOUT);
        filter.and("createtime", ">=", (Object)timeout);
        filter.and("createtime", "<=", (Object)beforTimeOut);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)ENTITY_DECLARE_RECORD, (String)MetadataUtil.getAllFieldString((String)ENTITY_DECLARE_RECORD), (QFilter[])new QFilter[]{filter});
        return collection;
    }

    private DynamicObjectCollection querySbbfileRecord() {
        QFilter filter = new QFilter("executestatus", "=", (Object)ExecuteStatusEnum.PROCESSING.getCode());
        ArrayList<String> suppliers = new ArrayList<String>(4);
        suppliers.add(SupplierEnum.ZWY.getCode());
        suppliers.add(SupplierEnum.YZF.getCode());
        suppliers.add(SupplierEnum.QXY.getCode());
        filter.and("channel", "in", suppliers);
        filter.and("tasktype", "=", (Object)ExecuteTypeEnums.SBBFILE.getId());
        Date timeout = new Date(System.currentTimeMillis() - SBPZ_TIMEOUT);
        Date beforTimeOut = new Date(System.currentTimeMillis() - SBPZ_BEFORTIMEOUT);
        filter.and("createtime", ">=", (Object)timeout);
        filter.and("createtime", "<=", (Object)beforTimeOut);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)ENTITY_DECLARE_RECORD, (String)(MetadataUtil.getAllFieldString((String)ENTITY_DECLARE_RECORD) + ",taxtype.number"), (QFilter[])new QFilter[]{filter});
        return collection;
    }

    private DynamicObjectCollection querySbqcRecord() {
        QFilter filter = new QFilter("executestatus", "=", (Object)ExecuteStatusEnum.PROCESSING.getCode());
        filter.and("channel", "=", (Object)SupplierEnum.QXY.getCode());
        filter.and("tasktype", "=", (Object)ExecuteTypeEnums.SBQC.getId());
        Date timeout = new Date(System.currentTimeMillis() - SBPZ_TIMEOUT);
        Date beforTimeOut = new Date(System.currentTimeMillis() - SBPZ_BEFORTIMEOUT);
        filter.and("createtime", ">=", (Object)timeout);
        filter.and("createtime", "<=", (Object)beforTimeOut);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)ENTITY_DECLARE_RECORD, (String)(MetadataUtil.getAllFieldString((String)ENTITY_DECLARE_RECORD) + ",taxtype.number"), (QFilter[])new QFilter[]{filter});
        return collection;
    }

    private int doSync(Collection<DynamicObject> collection) {
        int count = 0;
        List<Map<String, Object>> listParams = this.getParams(collection);
        for (Map<String, Object> map : listParams) {
            try {
                if (!SyncTaskStatusBaseHelper.send(map)) continue;
                ++count;
            }
            catch (Exception e) {
                LOGGER.error("tsate \u5b9a\u65f6\u540c\u6b65\u4efb\u52a1\u51fa\u9519\uff0c\u4efb\u52a1\u53c2\u6570\uff1a" + JSON.toJSONString(map));
                LOGGER.error(ExceptionUtil.toString((Exception)e));
            }
        }
        return count;
    }

    private int doSyncSbpz(Collection<DynamicObject> collection) {
        int count = 0;
        List<Map<String, Object>> listParams = this.getSbpzParams(collection);
        for (Map<String, Object> map : listParams) {
            try {
                if (!SyncTaskStatusBaseHelper.send(map)) continue;
                ++count;
            }
            catch (Exception e) {
                LOGGER.error("tsate \u5b9a\u65f6\u540c\u6b65\u4efb\u52a1\u51fa\u9519\uff0c\u4efb\u52a1\u53c2\u6570\uff1a" + JSON.toJSONString(map));
                LOGGER.error(ExceptionUtil.toString((Exception)e));
            }
        }
        return count;
    }

    private int doSyncSbzf(Collection<DynamicObject> collection) {
        int count = 0;
        List<Map<String, Object>> listParams = this.getSbzfParams(collection);
        for (Map<String, Object> map : listParams) {
            try {
                if (!SyncTaskStatusBaseHelper.send(map)) continue;
                ++count;
            }
            catch (Exception e) {
                LOGGER.error("tsate \u5b9a\u65f6\u540c\u6b65\u4efb\u52a1\u51fa\u9519\uff0c\u4efb\u52a1\u53c2\u6570\uff1a" + JSON.toJSONString(map));
                LOGGER.error(ExceptionUtil.toString((Exception)e));
            }
        }
        return count;
    }

    private int doSyncTbzt(Collection<DynamicObject> collection) {
        int count = 0;
        List<Map<String, Object>> listParams = this.getTbztParams(collection);
        for (Map<String, Object> map : listParams) {
            try {
                if (!SyncTaskStatusBaseHelper.send(map)) continue;
                ++count;
            }
            catch (Exception e) {
                LOGGER.error("tsate \u5b9a\u65f6\u540c\u6b65\u4efb\u52a1\u51fa\u9519\uff0c\u4efb\u52a1\u53c2\u6570\uff1a" + JSON.toJSONString(map));
                LOGGER.error(ExceptionUtil.toString((Exception)e));
            }
        }
        return count;
    }

    private int doSyncLsxz(Collection<DynamicObject> collection) {
        int count = 0;
        List<Map<String, Object>> listParams = this.getLsxzParams(collection);
        for (Map<String, Object> map : listParams) {
            try {
                if (!SyncTaskStatusBaseHelper.send(map)) continue;
                ++count;
            }
            catch (Exception e) {
                LOGGER.error("tsate \u5b9a\u65f6\u540c\u6b65\u4efb\u52a1\u51fa\u9519\uff0c\u4efb\u52a1\u53c2\u6570\uff1a" + JSON.toJSONString(map));
                LOGGER.error(ExceptionUtil.toString((Exception)e));
            }
        }
        return count;
    }

    private int doSyncQcxz(Collection<DynamicObject> collection) {
        int count = 0;
        List<Map<String, Object>> listParams = this.getQcxzParams(collection);
        for (Map<String, Object> map : listParams) {
            try {
                if (!SyncTaskStatusBaseHelper.send(map)) continue;
                ++count;
            }
            catch (Exception e) {
                LOGGER.error("tsate \u5b9a\u65f6\u540c\u6b65\u4efb\u52a1\u51fa\u9519\uff0c\u4efb\u52a1\u53c2\u6570\uff1a" + JSON.toJSONString(map));
                LOGGER.error(ExceptionUtil.toString((Exception)e));
            }
        }
        return count;
    }

    private int doSyncSbqc(Collection<DynamicObject> collection) {
        int count = 0;
        List<Map<String, Object>> listParams = this.getSbqcParams(collection);
        for (Map<String, Object> map : listParams) {
            try {
                if (!SyncTaskStatusBaseHelper.send(map)) continue;
                ++count;
            }
            catch (Exception e) {
                LOGGER.error("tsate \u5b9a\u65f6\u540c\u6b65\u4efb\u52a1\u51fa\u9519\uff0c\u4efb\u52a1\u53c2\u6570\uff1a" + JSON.toJSONString(map));
                LOGGER.error(ExceptionUtil.toString((Exception)e));
            }
        }
        return count;
    }

    private List<Map<String, Object>> getLsxzParams(Collection<DynamicObject> collection) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(8);
        for (DynamicObject executerecord : collection) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            TaxResult taxResult = TaxcOrgDataServiceHelper.queryTaxcOrgByOrgId((Long)executerecord.getLong("org"));
            DynamicObject taxorg = (DynamicObject)taxResult.getData();
            paramMap.put("nsrsbh", taxorg.get("unifiedsocialcode"));
            paramMap.put("skssqq", DateUtils.format((Date)executerecord.getDate("skssqq"), (String)"yyyy-MM-dd"));
            paramMap.put("skssqz", DateUtils.format((Date)executerecord.getDate("skssqz"), (String)"yyyy-MM-dd"));
            paramMap.put("org", taxorg.getLong("id"));
            paramMap.put("recordid", executerecord.getLong("id"));
            paramMap.put("key", "lsxz");
            Long supplierId = executerecord.getLong("declarechannel");
            paramMap.put("supplier", SupplierEnum.valueOfId((Long)supplierId).getCode());
            paramMap.put("type", executerecord.getString("type"));
            paramMap.put("isQuery", Boolean.TRUE);
            list.add(paramMap);
        }
        return list;
    }

    private List<Map<String, Object>> getQcxzParams(Collection<DynamicObject> collection) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(8);
        for (DynamicObject executerecord : collection) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            TaxResult taxResult = TaxcOrgDataServiceHelper.queryTaxcOrgByOrgId((Long)executerecord.getLong("org"));
            DynamicObject taxorg = (DynamicObject)taxResult.getData();
            paramMap.put("nsrsbh", taxorg.get("unifiedsocialcode"));
            paramMap.put("skssqq", DateUtils.format((Date)executerecord.getDate("skssqq"), (String)"yyyy-MM-dd"));
            paramMap.put("skssqz", DateUtils.format((Date)executerecord.getDate("skssqz"), (String)"yyyy-MM-dd"));
            paramMap.put("org", taxorg.getLong("id"));
            paramMap.put("recordid", executerecord.getLong("id"));
            paramMap.put("key", "qcxz");
            Long supplierId = executerecord.getLong("declarechannel");
            paramMap.put("supplier", SupplierEnum.valueOfId((Long)supplierId).getCode());
            paramMap.put("type", executerecord.getString("type"));
            paramMap.put("isQuery", Boolean.TRUE);
            list.add(paramMap);
        }
        return list;
    }

    private List<Map<String, Object>> getTbztParams(Collection<DynamicObject> collection) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(8);
        List orgIds = collection.stream().map(o -> o.getLong("org")).collect(Collectors.toList());
        DynamicObjectCollection orgDynList = BastaxTaxorgBusiness.getByIds(orgIds, null, null);
        Map<Long, String> orgInfoMap = orgDynList.stream().collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getString("unifiedsocialcode")));
        for (DynamicObject record : collection) {
            String supplier;
            Long sbbid = Long.parseLong(record.getString("sbbid"));
            Long orgId = record.getLong("org");
            JSONObject customMap = new JSONObject();
            customMap.put("messageId", UUID.randomUUID().toString().replaceAll("-", ""));
            customMap.put("transrc", DIRECT_DECLARE);
            customMap.put("isQuery", true);
            customMap.put("businessId", record.getString("sbbid"));
            customMap.put("type", record.getString("type"));
            customMap.put("nsrsbh", orgInfoMap.get(orgId));
            Date skssqqDate = record.getDate("skssqq");
            customMap.put("skssqq", DateUtils.format((Date)skssqqDate, (String)"yyyy-MM-dd"));
            Date skssqzDate = record.getDate("skssqz");
            customMap.put("skssqz", DateUtils.format((Date)skssqzDate, (String)"yyyy-MM-dd"));
            customMap.put("recordid", record.getLong("id"));
            customMap.put("key", "tbzt");
            DynamicObject dqdmObj = TsateChannelBusiness.getAreaInfo((Long)sbbid);
            if (dqdmObj != null) {
                customMap.put("sbdq", dqdmObj.getString("xzqh"));
            }
            if ((supplier = record.getString("channel")) != null) {
                customMap.put("supplier", supplier);
            }
            list.add((Map<String, Object>)customMap);
        }
        return list;
    }

    private List<Map<String, Object>> getSbzfParams(Collection<DynamicObject> collection) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(8);
        List orgIds = collection.stream().map(o -> o.getLong("org")).collect(Collectors.toList());
        for (DynamicObject record : collection) {
            Long sbbid = Long.parseLong(record.getString("sbbid"));
            HashMap<String, Object> customMap = new HashMap<String, Object>(8);
            customMap.put("messageId", UUID.randomUUID().toString().replaceAll("-", ""));
            customMap.put("transrc", DIRECT_DECLARE);
            customMap.put("businessId", sbbid);
            customMap.put("isQuery", true);
            customMap.put("operationType", "undo");
            customMap.put("recordtype", "SBZF");
            customMap.put("recordid", record.getLong("id"));
            customMap.put("key", "undo");
            list.add(customMap);
        }
        return list;
    }

    private List<Map<String, Object>> getSbpzParams(Collection<DynamicObject> collection) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(8);
        List orgIds = collection.stream().map(o -> o.getLong("org")).collect(Collectors.toList());
        DynamicObjectCollection orgDynList = BastaxTaxorgBusiness.getByIds(orgIds, null, null);
        Map<Long, String> orgInfoMap = orgDynList.stream().collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getString("unifiedsocialcode")));
        for (DynamicObject dyn2 : collection) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            String sbqj = DateUtils.format((Date)dyn2.getDate("sbqj"));
            String skssqq = DateUtils.format((Date)dyn2.getDate("skssqq"));
            String skssqz = DateUtils.format((Date)dyn2.getDate("skssqz"));
            String executeType = dyn2.getString("executetype");
            Long orgId = dyn2.getLong("org");
            map.put("recordid", dyn2.getLong("id"));
            map.put("nsrsbh", orgInfoMap.get(orgId));
            map.put("org", orgId);
            map.put("skssqq", skssqq);
            map.put("skssqz", skssqz);
            map.put("supplier", dyn2.getString("channel"));
            map.put("declareTypeNumber", dyn2.get("type"));
            map.put("sbqj", sbqj);
            map.put("voucherType", VoucherTypeEnum.getVoucherType((String)dyn2.getString("channel"), (String)executeType));
            String key = executeType.toLowerCase();
            map.put("key", key);
            map.put(key, SbpzHelper.getPznameByExecuteType((String)executeType));
            map.put("isQuery", true);
            map.put("msgsource", "schtask");
            map.put("taxtype", dyn2.getString("taxtype.number"));
            list.add(map);
        }
        return list;
    }

    private List<Map<String, Object>> getSbqcParams(Collection<DynamicObject> collection) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(8);
        List orgIds = collection.stream().map(o -> o.getLong("org")).collect(Collectors.toList());
        DynamicObjectCollection orgDynList = BastaxTaxorgBusiness.getByIds(orgIds, null, null);
        Map<Long, String> orgInfoMap = orgDynList.stream().collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getString("unifiedsocialcode")));
        for (DynamicObject executerecord : collection) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            TaxResult taxResult = TaxcOrgDataServiceHelper.queryTaxcOrgByOrgId((Long)executerecord.getLong("org.id"));
            Long orgId = executerecord.getLong("org");
            paramMap.put("nsrsbh", orgInfoMap.get(orgId));
            paramMap.put("org", orgId);
            paramMap.put("recordid", executerecord.getLong("id"));
            paramMap.put("key", ExecuteTypeEnums.SBQC.getKey());
            paramMap.put("supplier", SupplierEnum.QXY.getCode());
            paramMap.put("type", executerecord.getString("type"));
            paramMap.put("isQuery", Boolean.TRUE);
            paramMap.put("operatorid", UserServiceHelper.getCurrentUserId());
            paramMap.put("operatetime", System.currentTimeMillis());
            paramMap.put("taskId", ExecuteTypeEnums.SBQC.getId());
            try {
                list.add(paramMap);
            }
            catch (Exception e) {}
        }
        return list;
    }

    private List<Map<String, Object>> getParams(Collection<DynamicObject> collection) {
        DynamicObject[] dynamicObjects = collection.toArray(new DynamicObject[0]);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(8);
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            List pkIds = Arrays.asList(dynamicObjects).stream().map(o -> o.getString("id")).collect(Collectors.toList());
            DynamicObject[] records = BusinessDataServiceHelper.load((String)ENTITY_DECLARE_RECORD, (String)MetadataUtil.getAllFieldString((String)ENTITY_DECLARE_RECORD), (QFilter[])new QFilter[]{new QFilter("sbbid", "in", pkIds).and(new QFilter("tasktype.number", "in", Arrays.asList("ZLSB", "ZLJK", "YYJK"))).or("tasktype.number", "in", (Object)"SFZHDXX").and(new QFilter("executestatus", "=", (Object)"1"))});
            if (records != null && records.length > 0) {
                DynamicObjectCollection sbRecord = new DynamicObjectCollection();
                DynamicObjectCollection sfzxzRecord = new DynamicObjectCollection();
                for (DynamicObject obj : records) {
                    String taskTypeName = obj.getDynamicObject("tasktype").getString("number");
                    if ("SFZHDXX".equals(taskTypeName)) {
                        sfzxzRecord.add((Object)obj);
                        continue;
                    }
                    sbRecord.add((Object)obj);
                }
                Map recordMap = sbRecord.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getString("sbbid"))).collect(Collectors.toMap(a -> a.getString("sbbid"), Function.identity(), (key1, key2) -> key2));
                for (DynamicObject mainObj : dynamicObjects) {
                    DynamicObject recordObj = (DynamicObject)recordMap.get(mainObj.getString("id"));
                    if (recordObj == null) continue;
                    LOGGER.info("sbbid={} executetype={}", (Object)mainObj.getString("id"), (Object)recordObj.getString("executetype"));
                    JSONObject customMap = new JSONObject();
                    customMap.put("messageId", UUID.randomUUID().toString().replaceAll("-", ""));
                    customMap.put("transrc", DIRECT_DECLARE);
                    customMap.put("isQuery", true);
                    customMap.put("businessId", mainObj.getString("id"));
                    DynamicObject channelObj = CommonInfoUtil.getChannel((Long)mainObj.getLong("id"));
                    if (channelObj != null) {
                        DynamicObject tysbbDeclare;
                        String channel = channelObj.getDynamicObject("declarechannel").getString("number");
                        String sbStatus = mainObj.getString("declarestatus");
                        String kkStatus = mainObj.getString("paystatus");
                        if (("qtsf_tysbb".equals(DeclarationMainFormBusniess.getDeclareTypeByModel3((DynamicObject)mainObj)) || "qtsf_fsstysbb".equals(DeclarationMainFormBusniess.getDeclareTypeByModel3((DynamicObject)mainObj))) && SupplierEnum.SZYH.getCode().equals(channel) && (tysbbDeclare = this.dealTysbb(mainObj)) != null) {
                            customMap.put("relationid", tysbbDeclare.getLong("id"));
                        }
                        if (StringUtils.equals((CharSequence)sbStatus, (CharSequence)"declared") && (StringUtils.equals((CharSequence)kkStatus, (CharSequence)"unpaid") || StringUtils.equals((CharSequence)kkStatus, (CharSequence)"payfailed")) && (StringUtils.equals((CharSequence)channel, (CharSequence)SupplierEnum.CLOUDCC.getCode()) || StringUtils.equals((CharSequence)channel, (CharSequence)SupplierEnum.SZYH.getCode()))) {
                            customMap.put("key", DIRECT_PAY);
                            customMap.put("recordid", recordObj.getLong("id"));
                        } else {
                            String executeType = recordObj.getString("executetype");
                            customMap.put("recordid", recordObj.getLong("id"));
                            customMap.put("key", ExecuteTypeEnums.getKeyByExecuteType((String)executeType));
                        }
                    }
                    list.add((Map<String, Object>)customMap);
                }
                for (DynamicObject executerecord : sfzxzRecord) {
                    HashMap<String, Object> paramMap = new HashMap<String, Object>();
                    paramMap.put("org", executerecord.getDynamicObject("org").getLong("id"));
                    paramMap.put("recordid", executerecord.getLong("id"));
                    paramMap.put("key", "sfzhdxx");
                    paramMap.put("supplier", executerecord.getDynamicObject("declarechannel").getString("number"));
                    paramMap.put("isQuery", Boolean.TRUE);
                    list.add(paramMap);
                }
            }
        }
        return list;
    }

    private DynamicObject dealTysbb(DynamicObject declare) {
        try {
            if (declare != null) {
                DynamicObject channelObj;
                DynamicObject org = declare.getDynamicObject("org");
                Date skssqq = declare.getDate("skssqq");
                Date skssqz = declare.getDate("skssqz");
                QFilter qFilter = new QFilter("org", "=", (Object)org.getLong("id"));
                QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)"C");
                QFilter declareTypeQfilter = new QFilter("declaretype", "!=", (Object)"0");
                QFilter typeFilter = "qtsf_fsstysbb".equals(DeclarationMainFormBusniess.getDeclareTypeByModel3((DynamicObject)declare)) ? new QFilter("type", "=", (Object)"qtsf_tysbb") : new QFilter("type", "=", (Object)"qtsf_fsstysbb");
                QFilter skssqqzFilter = new QFilter("skssqq", ">=", (Object)skssqq).and(new QFilter("skssqz", "<=", (Object)skssqz));
                QFilter delcareStatusQfilter = new QFilter("declarestatus", "!=", (Object)"declared");
                DynamicObject tysbDeclare = BusinessDataServiceHelper.loadSingle((String)"tcvat_nsrxx", (String)MetadataUtil.getAllFieldString((String)"tcvat_nsrxx"), (QFilter[])new QFilter[]{qFilter, typeFilter, skssqqzFilter, declareTypeQfilter, billstatusFilter, delcareStatusQfilter});
                if (tysbDeclare != null && (channelObj = CommonInfoUtil.getChannel((Long)tysbDeclare.getLong("id"))) != null) {
                    String channelNumber = channelObj.getDynamicObject("declarechannel").getString("number");
                    if (SupplierEnum.SZYH.getCode().equals(channelNumber)) {
                        return tysbDeclare;
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5408\u5e76\u5904\u7406\u5931\u8d25 sbbid={} erro={}", (Object)declare.getString("id"), (Object)ExceptionUtil.toString((Exception)e));
        }
        return null;
    }

    private SupplierEnum getSupplierFromRecord(DynamicObject tsateDeckarerecord) {
        Long channel = tsateDeckarerecord.getLong("declarechannel");
        return SupplierEnum.valueOfId((Long)channel);
    }
}

