/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.task.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.taxc.tsate.business.BastaxTaxorgBusiness;
import kd.taxc.tsate.business.TsateChannelBusiness;
import kd.taxc.tsate.common.enums.ExecuteTypeEnums;
import kd.taxc.tsate.common.util.DateUtils;

public class SyncTaskBuildParamHelper {
    public static List<Map<String, Object>> getVerifyParams(DynamicObjectCollection verifyRecords) {
        return SyncTaskBuildParamHelper.buildCommonParamList(verifyRecords, ExecuteTypeEnums.SJYZ);
    }

    private static List<Map<String, Object>> buildCommonParamList(DynamicObjectCollection records, ExecuteTypeEnums type) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(8);
        if (records.isEmpty()) {
            return list;
        }
        Map<Long, String> orgInfoMap = SyncTaskBuildParamHelper.buildNsrsbhMap(records);
        for (DynamicObject record : records) {
            JSONObject customMap = new JSONObject();
            SyncTaskBuildParamHelper.buildCommonParam(record, (Map<String, Object>)customMap, orgInfoMap);
            customMap.put("key", type.getKey());
            list.add((Map<String, Object>)customMap);
        }
        return list;
    }

    private static void buildCommonParam(DynamicObject record, Map<String, Object> customMap, Map<Long, String> orgInfoMap) {
        Long sbbid = record.getLong("sbbid");
        Long orgId = record.getLong("org");
        customMap.put("messageId", UUID.randomUUID().toString().replaceAll("-", ""));
        customMap.put("org", orgId);
        customMap.put("isQuery", true);
        customMap.put("businessId", record.getString("sbbid"));
        customMap.put("type", record.getString("type"));
        customMap.put("nsrsbh", orgInfoMap.get(orgId));
        customMap.put("supplier", record.getString("channel"));
        Date skssqqDate = record.getDate("skssqq");
        if (skssqqDate != null) {
            customMap.put("skssqq", DateUtils.format((Date)skssqqDate, (String)"yyyy-MM-dd"));
        }
        Date skssqzDate = record.getDate("skssqz");
        if (skssqqDate != null) {
            customMap.put("skssqz", DateUtils.format((Date)skssqzDate, (String)"yyyy-MM-dd"));
        }
        customMap.put("recordid", record.getLong("id"));
        DynamicObject dqdmObj = TsateChannelBusiness.getAreaInfo((Long)sbbid);
        if (dqdmObj != null) {
            customMap.put("sbdq", dqdmObj.getString("xzqh"));
        }
    }

    private static Map<Long, String> buildNsrsbhMap(DynamicObjectCollection verifyRecords) {
        List orgIds = verifyRecords.stream().map(o -> o.getLong("org")).collect(Collectors.toList());
        DynamicObjectCollection orgDynList = BastaxTaxorgBusiness.getByIds(orgIds, null, null);
        if (orgDynList.isEmpty()) {
            return new HashMap<Long, String>();
        }
        return orgDynList.stream().collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getString("unifiedsocialcode")));
    }
}

