/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.task.sbpz;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.taxc.tsate.business.declare.declaremain.DeclarationMainFormBusniess;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.constant.annotation.Supplier;
import kd.taxc.tsate.formplugin.task.sbpz.AbstractSbpzChannelStrategy;
import kd.taxc.tsate.formplugin.task.sbpz.enums.SbpzDeclareTypeToTaxTypeEnum;

@Supplier(values={SupplierEnum.SZYH})
public class SzyhSbpzStrategy
extends AbstractSbpzChannelStrategy {
    private static final String PARAMS_TAXTYPE = "taxtype";

    @Override
    public List<Map<String, Object>> genDownloadSbpzParams(DynamicObject declareMain) {
        ArrayList<Map<String, Object>> paramsList = new ArrayList<Map<String, Object>>(15);
        String declareType = DeclarationMainFormBusniess.getDeclareTypeByModel3((DynamicObject)declareMain);
        List<String> list = this.getTaxTypeByDeclareType(declareType);
        for (String taxType : list) {
            Map<String, Object> map = this.genBaseSbpzParams(declareMain);
            map.put(PARAMS_TAXTYPE, taxType);
            paramsList.add(map);
        }
        return paramsList;
    }

    @Override
    public boolean match(Map sbpzParam, DynamicObject sbpzRecord) {
        return this.checkPeriodMatch(sbpzParam, sbpzRecord) && this.checkOtherMatch(sbpzParam, sbpzRecord);
    }

    boolean checkOtherMatch(Map sbpzParam, DynamicObject sbpzRecord) {
        String taxType = (String)sbpzParam.get(PARAMS_TAXTYPE);
        return taxType != null && taxType.equals(sbpzRecord.getString("taxtype.number"));
    }

    @Override
    public boolean checkSupport() {
        return true;
    }

    private List<String> getTaxTypeByDeclareType(String declareType) {
        ArrayList<String> types = new ArrayList<String>(4);
        SbpzDeclareTypeToTaxTypeEnum mapEnum = SbpzDeclareTypeToTaxTypeEnum.valueOfDeclareType(declareType);
        if (mapEnum != null) {
            types.addAll(Arrays.asList(mapEnum.getTaxTypeNumbers()));
        }
        return types;
    }
}

