/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.taxdialog;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.tsate.business.taxdialog.TasteDeclarePopupBusiness;
import kd.taxc.tsate.common.constant.taxdialog.vo.OptionTypeEnums;
import kd.taxc.tsate.common.constant.taxdialog.vo.PopupFromDataVo;
import kd.taxc.tsate.common.constant.taxdialog.vo.SelectOptionVo;
import kd.taxc.tsate.common.constant.taxdialog.vo.TaxDialogOptionVo;
import kd.taxc.tsate.common.constant.taxdialog.vo.TaxDialogPopupVo;
import kd.taxc.tsate.common.util.PermissionUtils;
import org.apache.commons.collections.CollectionUtils;

public class TaxDialogFormPlugin
extends AbstractFormPlugin {
    protected static final String DROPDOWN_PREFIX = "dropdown_";
    protected static final String NODE_LEVEL = "nodeLevel";
    protected static final String VISIBLE_FIELD_PREFIX = "levelVisibleField_";
    protected static final String BUTTON_KEY = "btnok";
    protected static final String UNDER_LINE = "_";
    protected static final String MOMO = "momo";
    protected static final String VISIBLE_FILED = "visibleFiled";
    protected static final String PROJECT_NAME = "projectName";
    protected static final String POPUP_NAMBER = "number";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BUTTON_KEY});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String eventName = e.getProperty().getName();
        String dropdownValue = (String)this.getModel().getValue(eventName);
        String[] fieldKey = eventName.split(UNDER_LINE);
        String nodeCacheKey = fieldKey[0] + UNDER_LINE + dropdownValue + UNDER_LINE + fieldKey[1];
        String childrenNodesString = this.getPageCache().get(nodeCacheKey);
        Integer selectedLevel = Integer.valueOf(fieldKey[1]);
        if (StringUtils.isBlank((CharSequence)childrenNodesString)) {
            this.reLoadNodeValueAndVisable(eventName, selectedLevel);
        } else {
            List taxDialogOptionVos = JSON.parseArray((String)childrenNodesString, TaxDialogOptionVo.class);
            this.dynamicLoadFormFields(taxDialogOptionVos, selectedLevel + 1);
        }
    }

    private void reLoadNodeValueAndVisable(String eventName, Integer selectedLevel) {
        int highLevel;
        String level = this.getPageCache().get(NODE_LEVEL);
        if (StringUtils.isBlank((CharSequence)level)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6b64\u9875\u9762\u7f13\u5b58\u5931\u6548,\u8bf7\u91cd\u65b0\u52a0\u8f7d", (String)"TaxDialogFormPlugin_0", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
        }
        if ((highLevel = Integer.parseInt(level) - selectedLevel) < 0) {
            return;
        }
        for (int i = 0; i <= highLevel; ++i) {
            this.clearVisibleFields(selectedLevel + i);
        }
        this.setVisible(true, eventName);
    }

    public void beforeBindData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        if (EmptyCheckUtils.isEmpty((Object)customParams)) {
            return;
        }
        Map allFields = EntityMetadataCache.getDataEntityType((String)this.getView().getEntityId()).getAllFields();
        for (String field : allFields.keySet()) {
            if (MOMO.equals(field)) continue;
            this.setVisible(false, field);
        }
        if (OperationStatus.EDIT == parameter.getStatus()) {
            this.buildHistoryData(this.buildFormData(customParams));
            return;
        }
        TaxDialogPopupVo popupVo = this.buildPopupVo(customParams);
        if (EmptyCheckUtils.isEmpty((Object)popupVo)) {
            return;
        }
        this.getPageCache().put(PROJECT_NAME, popupVo.getProjectName());
        this.getPageCache().put(POPUP_NAMBER, popupVo.getDialogCode());
        this.getView().setFormTitle(new LocaleString(popupVo.getProjectName()));
        this.getModel().setValue(MOMO, (Object)popupVo.getMemo());
        this.inItPopupAndFormCache(popupVo);
    }

    private void buildHistoryData(PopupFromDataVo fromData) {
        if (fromData == null) {
            return;
        }
        this.getView().setFormTitle(new LocaleString(fromData.getProjectName()));
        this.getModel().setValue(MOMO, (Object)fromData.getMomo());
        List selectOptions = fromData.getSelectOptions();
        for (SelectOptionVo option : selectOptions) {
            String filedKey = option.getFiledKey();
            String filedValue = null;
            String optionName = option.getOptionName();
            String optionCode = option.getOptionCode();
            this.setVisible(true, filedKey);
            OptionTypeEnums typeEnums = TasteDeclarePopupBusiness.getFieldTypeEnum((String)filedKey);
            if (typeEnums == OptionTypeEnums.TEXT) {
                this.updateTextField(filedKey, optionName);
                filedValue = option.getOptionValue();
            }
            if (typeEnums == OptionTypeEnums.DROPDOWN) {
                ComboEdit edit = (ComboEdit)this.getControl(filedKey);
                filedValue = optionCode;
                edit.setComboItems(Collections.singletonList(this.buildComboItem(optionCode, optionName)));
            }
            this.getModel().setValue(filedKey, (Object)filedValue);
        }
    }

    protected PopupFromDataVo buildFormData(Map<String, Object> customParams) {
        return null;
    }

    public void click(EventObject evt) {
        if (BUTTON_KEY.equals(((Control)evt.getSource()).getKey())) {
            if (!this.checkPermission("tsate", (String)this.getModel().getValue("entirynumber"), (String)this.getModel().getValue("preid")).booleanValue()) {
                this.getView().showErrorNotification(this.buildNoPermissioMsg());
                return;
            }
            this.doBusiness(this.buildFormSelectData());
        }
    }

    private PopupFromDataVo buildFormSelectData() {
        String selectedFieldsCache = this.getPageCache().get(VISIBLE_FILED);
        if (StringUtils.isBlank((CharSequence)selectedFieldsCache)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5df2\u9009\u62e9\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u9009\u62e9", (String)"TaxDialogFormPlugin_1", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            return null;
        }
        PopupFromDataVo fromData = new PopupFromDataVo();
        fromData.setMomo((String)this.getModel().getValue(MOMO));
        fromData.setProjectName(this.getPageCache().get(PROJECT_NAME));
        fromData.setNumber(this.getPageCache().get(POPUP_NAMBER));
        ArrayList<SelectOptionVo> selectOptions = new ArrayList<SelectOptionVo>(8);
        List selectedFields = JSON.parseArray((String)selectedFieldsCache, String.class);
        int nowMaxNodeLevel = 0;
        for (String field : selectedFields) {
            Object value;
            SelectOptionVo selectOptionVo = null;
            try {
                value = this.getModel().getValue(field);
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u51fa\u73b0\u672a\u914d\u7f6e\u7684\u8282\u70b9\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\u3002\u8282\u70b9\uff1a%s", (String)"TaxDialogFormPlugin_2", (String)"taxc-tsate-formplugin", (Object[])new Object[]{field}));
            }
            String[] fieldSplit = field.split(UNDER_LINE);
            OptionTypeEnums typeEnums = TasteDeclarePopupBusiness.getFieldTypeEnum((String)field);
            if (typeEnums == OptionTypeEnums.DROPDOWN) {
                selectOptionVo = new SelectOptionVo(field, (String)value, "", this.getPageCache().get(field + value));
            }
            if (typeEnums == OptionTypeEnums.TEXT) {
                selectOptionVo = new SelectOptionVo(field, this.getPageCache().get(field + UNDER_LINE + "code"), (String)value, this.getPageCache().get(field + UNDER_LINE + "name"));
            }
            selectOptions.add(selectOptionVo);
            int nodeLevel = Integer.parseInt(fieldSplit[fieldSplit.length - 1]);
            if (nodeLevel < nowMaxNodeLevel) continue;
            nowMaxNodeLevel = nodeLevel;
            fromData.setSelectNode(selectOptionVo);
        }
        fromData.setSelectOptions(selectOptions);
        return fromData;
    }

    protected void doBusiness(PopupFromDataVo popupFromDataVo) {
    }

    protected String buildNoPermissioMsg() {
        return "";
    }

    protected Boolean checkPermission(String appNumber, String entityName, String permItemId) {
        return PermissionUtils.checkPermission((String)appNumber, (String)entityName, (String)permItemId);
    }

    private void inItPopupAndFormCache(TaxDialogPopupVo popupVo) {
        List dialogOptionList = popupVo.getTaxDialogOptionList();
        this.dynamicLoadFormFields(dialogOptionList, 1);
    }

    private void dynamicLoadFormFields(List<TaxDialogOptionVo> dialogOptionList, int level) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(8);
        ArrayList<String> levelVisibleFields = new ArrayList<String>();
        this.clearVisibleFields(level);
        String dropdownCode = DROPDOWN_PREFIX + level;
        ComboEdit dropdownNode = (ComboEdit)this.getControl(dropdownCode);
        for (TaxDialogOptionVo optionVo : dialogOptionList) {
            OptionTypeEnums type = optionVo.getOptionType();
            if (type == null) continue;
            if (level == 1) {
                this.buildCache(optionVo, level);
            }
            String optionName = optionVo.getOptionName();
            String optionCode = optionVo.getOptionCode();
            if (OptionTypeEnums.DROPDOWN == type) {
                comboItems.add(this.buildComboItem(optionCode, optionName));
                this.getPageCache().put(dropdownCode + optionCode, optionName);
            }
            if (OptionTypeEnums.TEXT != type) continue;
            String fieldKey = this.buildTextFileKey(optionVo, level);
            levelVisibleFields.add(fieldKey);
            this.getPageCache().put(fieldKey + UNDER_LINE + "code", optionCode);
            this.getPageCache().put(fieldKey + UNDER_LINE + "name", optionName);
            this.setVisible(true, fieldKey);
            this.updateTextField(fieldKey, optionName);
        }
        if (CollectionUtils.isNotEmpty(comboItems)) {
            levelVisibleFields.add(dropdownCode);
            this.setVisible(true, dropdownCode);
            dropdownNode.setComboItems(comboItems);
        }
        this.getPageCache().put(VISIBLE_FIELD_PREFIX + level, JSON.toJSONString(levelVisibleFields));
    }

    private void updateTextField(String fieldKey, String optionName) {
        HashMap<String, LocaleString> fieldMap = new HashMap<String, LocaleString>();
        fieldMap.put("caption", new LocaleString(optionName));
        this.getView().updateControlMetadata(fieldKey, fieldMap);
    }

    private ComboItem buildComboItem(String optionCode, String optionName) {
        ComboItem comboItem = new ComboItem();
        comboItem.setCaption(new LocaleString(optionName));
        comboItem.setValue(optionCode);
        return comboItem;
    }

    private void setVisible(boolean isVisible, String field) {
        String visibleFiledCache = this.getPageCache().get(VISIBLE_FILED);
        Set visibleFiled = visibleFiledCache == null ? new HashSet() : (Set)JSON.parseObject((String)visibleFiledCache, Set.class);
        if (isVisible) {
            visibleFiled.add(field);
        } else {
            visibleFiled.remove(field);
        }
        this.getPageCache().put(VISIBLE_FILED, JSON.toJSONString(visibleFiled));
        this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{field});
    }

    private void clearVisibleFields(int level) {
        String levelVisibleFieldByLevel = this.getPageCache().get(VISIBLE_FIELD_PREFIX + level);
        if (levelVisibleFieldByLevel != null) {
            List visibleField = JSON.parseArray((String)levelVisibleFieldByLevel, String.class);
            for (String field : visibleField) {
                this.setVisible(false, field);
            }
        }
    }

    private void buildCache(TaxDialogOptionVo optionVo, int level) {
        Boolean leafNode = optionVo.getLeafNode();
        List children = optionVo.getChildren();
        if (CollectionUtils.isEmpty((Collection)children) || leafNode.booleanValue()) {
            String nodeLevel = this.getPageCache().get(NODE_LEVEL);
            Integer nowLevel = nodeLevel == null ? 0 : Integer.parseInt(nodeLevel);
            this.getPageCache().put(NODE_LEVEL, String.valueOf(level > nowLevel ? level : nowLevel));
            return;
        }
        ArrayList<TaxDialogOptionVo> childrenWithoutGrandchildren = new ArrayList<TaxDialogOptionVo>(16);
        for (TaxDialogOptionVo child : children) {
            this.buildCache(child, level + 1);
            child.setChildren(null);
            childrenWithoutGrandchildren.add(child);
        }
        this.getPageCache().put(optionVo.getOptionType().getFieldKey() + UNDER_LINE + optionVo.getOptionCode() + UNDER_LINE + level, JSON.toJSONString(childrenWithoutGrandchildren));
    }

    protected String buildTextFileKey(TaxDialogOptionVo optionVo, int level) {
        return optionVo.getOptionType().getFieldKey() + UNDER_LINE + level;
    }

    protected TaxDialogPopupVo buildPopupVo(Map<String, Object> customParams) {
        return null;
    }
}

