/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.tool;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Control;
import kd.bos.form.field.LargeTextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tsate.common.metadata.MetadataUtil;
import kd.taxc.tsate.common.util.EmptyCheckUtils;

public class GenJmxzdmToolPlugin
extends AbstractFormPlugin {
    private static final String ZB_TREE = "tpo_discount_tree";
    private static final String FB_TREE = "tpo_yearitems_tree";
    private static final String SAVAE_TREE = "tsate_jmxzdm_mapping";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String itemKey = control.getKey();
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)"btnok")) {
            LargeTextEdit fbLargeTextEdit = (LargeTextEdit)this.getView().getControl("fbtext");
            LargeTextEdit zbLargeTextEdit = (LargeTextEdit)this.getView().getControl("zbtext");
            String fbDm = "";
            String zbDm = "";
            if (EmptyCheckUtils.isNotEmpty((Object)fbLargeTextEdit)) {
                fbDm = (String)this.getModel().getValue(fbLargeTextEdit.getTagFieldKey());
            }
            if (EmptyCheckUtils.isNotEmpty((Object)zbLargeTextEdit)) {
                zbDm = (String)this.getModel().getValue(zbLargeTextEdit.getTagFieldKey());
            }
            if (StringUtils.isNotBlank((CharSequence)fbDm)) {
                this.genData(fbDm, Boolean.FALSE);
            }
            if (StringUtils.isNotBlank((CharSequence)zbDm)) {
                this.genData(zbDm, Boolean.TRUE);
            }
        }
    }

    private void genData(String s, Boolean flag) {
        String meatdata;
        String discountFlag;
        ArrayList<DynamicObject> savaData = new ArrayList<DynamicObject>();
        if (flag.booleanValue()) {
            discountFlag = "discount";
            meatdata = ZB_TREE;
        } else {
            discountFlag = "discountfb";
            meatdata = FB_TREE;
        }
        List result = null;
        try {
            result = JSON.parseArray((String)s, JmxzdmVo.class);
        }
        catch (Exception e) {
            this.getView().showErrorNotification("parse Json error");
            return;
        }
        for (JmxzdmVo jmxzdm : result) {
            String swsxdm = jmxzdm.getSwsxdm();
            QFilter[] numbers = new QFilter("number", "=", (Object)swsxdm).toArray();
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)meatdata, (String)MetadataUtil.getAllFieldString((String)meatdata), (QFilter[])numbers);
            if (!EmptyCheckUtils.isNotEmpty((Object)dynamicObject)) continue;
            String jmxzmc = jmxzdm.getJmxzmc();
            String jmxzdm2 = jmxzdm.getJmxzdm();
            String name = dynamicObject.getString("name");
            String jmxzdm1 = dynamicObject.getString("deductiontype.number");
            jmxzdm1 = "00" + jmxzdm1;
            if (jmxzmc.equals(name) && jmxzdm2.equals(jmxzdm1) || EmptyCheckUtils.isNotEmpty((Object)QueryServiceHelper.queryOne((String)SAVAE_TREE, (String)"id", (QFilter[])numbers))) continue;
            DynamicObject mapping = BusinessDataServiceHelper.newDynamicObject((String)SAVAE_TREE);
            mapping.set("group", (Object)QueryServiceHelper.queryOne((String)"tsate_channel", (String)"id", (QFilter[])new QFilter("number", "=", (Object)"5").toArray()).getLong("id"));
            mapping.set("enable", (Object)"1");
            mapping.set("number", (Object)swsxdm);
            mapping.set("sbtype", (Object)"qysdsjb");
            mapping.set(discountFlag, dynamicObject.getPkValue());
            mapping.set("jmxzdm", (Object)jmxzdm2);
            mapping.set("name", (Object)jmxzmc);
            savaData.add(mapping);
        }
        DynamicObject[] objects = new DynamicObject[savaData.size()];
        SaveServiceHelper.save((DynamicObject[])savaData.toArray(objects));
        this.getView().showSuccessNotification("gen data success!");
    }

    static class JmxzdmVo {
        private String jmxzmc;
        private String swsxdm;
        private String jmxzdm;

        JmxzdmVo() {
        }

        public String getJmxzmc() {
            return this.jmxzmc;
        }

        public String getSwsxdm() {
            return this.swsxdm;
        }

        public String getJmxzdm() {
            return this.jmxzdm;
        }

        public void setJmxzmc(String jmxzmc) {
            this.jmxzmc = jmxzmc;
        }

        public void setSwsxdm(String swsxdm) {
            this.swsxdm = swsxdm;
        }

        public void setJmxzdm(String jmxzdm) {
            this.jmxzdm = jmxzdm;
        }
    }
}

