/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.upgrade;

import java.util.EventObject;
import java.util.UUID;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.taxc.tsate.common.upgrade.ITsateUpgradService;
import kd.taxc.tsate.common.upgrade.UpgradeResult;

public class TsateUpgradePlugin
extends AbstractFormPlugin
implements IConfirmCallBack {
    private Log logger = LogFactory.getLog(TsateUpgradePlugin.class);
    private static final String TXT_EXPLAIN = "explain";
    private static final String TXT_CLASSPATH = "path";
    private static final String TXT_ID = "taskid";
    private static final String BTN_UPGRADE = "upgrade";
    private static final String BTN_RESULT = "result";
    private static final String CACHE_KEY_TASKID = "tsate_dataupgrade_id";
    private static final String CONFIRMCALLBAK_ID = "upgrade_confirm";

    public void beforeBindData(EventObject e) {
        StringBuilder explain = new StringBuilder(ResManager.loadKDString((String)"\u5347\u7ea7\u4efb\u52a1\u9700\u8981\u5b9e\u73b0kd.taxc.tsate.common.upgrade.ITsateUpgradService", (String)"TsateUpgradePlugin_0", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
        this.getModel().setValue(TXT_EXPLAIN, (Object)explain);
        String taskId = this.getPageCache().get(CACHE_KEY_TASKID);
        if (taskId != null) {
            this.getModel().setValue(TXT_ID, (Object)taskId);
        }
        super.beforeBindData(e);
    }

    public void initialize() {
        this.addClickListeners(new String[]{BTN_UPGRADE, BTN_RESULT});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String btnKey = ((Control)evt.getSource()).getKey();
        if (btnKey.equals(BTN_UPGRADE)) {
            ITsateUpgradService service = this.checkService();
            if (service == null) {
                return;
            }
            String explin = service.getExplain();
            this.getView().showConfirm(explin, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRMCALLBAK_ID));
        } else if (btnKey.equals(BTN_RESULT)) {
            ITsateUpgradService service;
            String taskId = this.getIdFromView();
            if (StringUtils.isEmpty((String)taskId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5347\u7ea7\u4efb\u52a1\uff0c\u8bf7\u5148\u53d1\u8d77\u5347\u7ea7", (String)"TsateUpgradePlugin_1", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            }
            if ((service = this.checkService()) == null) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            UpgradeResult result = service.getResult(taskId);
            if (result.getMsg() != null) {
                this.getView().showMessage(sb.toString());
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u7ed3\u679c\u4fe1\u606f", (String)"TsateUpgradePlugin_2", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callbackId = messageBoxClosedEvent.getCallBackId();
        String resultValue = messageBoxClosedEvent.getResultValue();
        if (CONFIRMCALLBAK_ID.equals(callbackId) && !"Cancel".equals(resultValue)) {
            ITsateUpgradService service = this.getService(this.getPathFromView());
            if (service == null) {
                return;
            }
            UUID id = UUID.randomUUID();
            String taskId = id.toString().replace("-", "");
            try {
                service.upgrade(taskId);
            }
            catch (Exception e) {
                this.getView().showTipNotification("update error :" + e.getMessage());
            }
            this.getPageCache().put(CACHE_KEY_TASKID, taskId);
            this.getModel().setValue(TXT_ID, (Object)taskId);
        }
    }

    private String getPathFromView() {
        Object value = this.getModel().getValue(TXT_CLASSPATH);
        return value == null ? null : value.toString();
    }

    private String getIdFromView() {
        Object value = this.getModel().getValue(TXT_ID);
        return value == null ? null : value.toString();
    }

    private ITsateUpgradService getService(String path) {
        StringBuilder erro = new StringBuilder(ResManager.loadKDString((String)"\u83b7\u53d6\u5347\u7ea7\u670d\u52a1\u5931\u8d25\u539f\u56e0,\u7c7b\u8def\u5f84\uff1a", (String)"TsateUpgradePlugin_9", (String)"taxc-tsate-formplugin", (Object[])new Object[0])).append(path).append(";");
        try {
            ITsateUpgradService service = (ITsateUpgradService)Class.forName(path).newInstance();
            return service;
        }
        catch (ClassNotFoundException e) {
            erro.append(ResManager.loadKDString((String)"\u7c7b\u4e0d\u5b58\u5728", (String)"TsateUpgradePlugin_10", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
        }
        catch (IllegalAccessException e) {
            erro.append(ResManager.loadKDString((String)"\u65e0\u6743\u9650\u8bbf\u95ee\u8be5\u7c7b", (String)"TsateUpgradePlugin_11", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
        }
        catch (InstantiationException e) {
            erro.append(ResManager.loadKDString((String)"\u65e0\u7a7a\u53c2\u6784\u9020\u51fd\u6570", (String)"TsateUpgradePlugin_12", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
        }
        this.logger.error(erro.toString());
        return null;
    }

    private ITsateUpgradService checkService() {
        String path = this.getPathFromView();
        if (StringUtils.isEmpty((String)path)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u5347\u7ea7\u4efb\u52a1", (String)"TsateUpgradePlugin_7", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            return null;
        }
        ITsateUpgradService service = this.getService(path);
        if (service == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u670d\u52a1\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff08\u67e5\u770b\u540e\u53f0\u65e5\u5fd7\u4fe1\u606f\uff09", (String)"TsateUpgradePlugin_8", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            return null;
        }
        return service;
    }
}

