/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.verification;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tsate.business.TsateChannelBusiness;
import kd.taxc.tsate.common.helper.OrgServiceHelper;
import kd.taxc.tsate.common.metadata.MetadataUtil;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.PermissionUtils;
import kd.taxc.tsate.formplugin.utils.JobUtils;
import org.apache.commons.lang3.StringUtils;

public class VerificationDownloadPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String SEPARATOR = System.getProperty("line.separator");
    private static final String[] CHANNEL = new String[]{"3", "5", "1", "8"};
    private static Log logger = LogFactory.getLog(VerificationDownloadPlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
        MulBasedataEdit orgEdit = (MulBasedataEdit)this.getControl("org");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null) {
            List<Long> orgList = this.buildOrgs();
            if (EmptyCheckUtils.isNotEmpty(customParams.get("org"))) {
                Object orgId = customParams.get("org");
                if (!org.apache.commons.collections.CollectionUtils.isEmpty(orgList)) {
                    if (!orgList.contains(Long.valueOf((String)orgId))) {
                        orgId = orgList.get(0);
                    }
                    this.getModel().setValue("org", (Object)new Object[]{orgId});
                }
            } else if (!org.apache.commons.collections.CollectionUtils.isEmpty(orgList)) {
                this.getModel().setValue("org", (Object)new Object[]{orgList.get(0)});
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"org")) {
            List<Long> orgList = this.buildOrgs();
            QFilter idsFilter = new QFilter("id", "in", orgList);
            QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
            formShowParameter.getListFilterParameter().setFilter(idsFilter.and(statusFilter));
            formShowParameter.setCustomParam("orgViewSchemeNumber", (Object)"40");
            formShowParameter.getCustomParams().put("orgFuncId", "40");
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7", (String)"VerificationDownloadPlugin_0", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
        }
    }

    private List<Long> buildOrgs() {
        List<Long> channelTaxorganIds;
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((String)"tsate", (String)"tsate_taxtype_verify", (String)"2VX/+C7KENM+");
        List<Object> orgList = new ArrayList();
        if (EmptyCheckUtils.isNotEmpty((Object)hasPermOrgResult) && !hasPermOrgResult.hasAllOrgPerm()) {
            orgList = hasPermOrgResult.getHasPermOrgs();
        } else {
            DynamicObjectCollection objs = OrgServiceHelper.getOrgLists();
            if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)objs)) {
                orgList = objs.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
            }
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(orgList)) {
            orgList = VerificationDownloadPlugin.excludeByTaxPayer(orgList);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(channelTaxorganIds = VerificationDownloadPlugin.getTaxorganIds(Arrays.asList(CHANNEL)))) {
            DynamicObject[] taxMains;
            ArrayList<Long> taxorganIds = new ArrayList<Long>();
            List<Long> childTaxauthorityByIds = this.getChildTaxauthorityByIds(taxorganIds, channelTaxorganIds);
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(childTaxauthorityByIds)) {
                taxMains = BusinessDataServiceHelper.load((String)"tctb_tax_main", (String)"id,taxoffice,orgid", (QFilter[])new QFilter[]{new QFilter("taxoffice.id", "in", childTaxauthorityByIds)});
                if (taxMains == null || taxMains.length <= 0) {
                    return new ArrayList<Long>();
                }
            } else {
                return new ArrayList<Long>();
            }
            List orgIds = Arrays.stream(taxMains).filter(o -> o.getDynamicObject("orgid") != null).map(o -> o.getDynamicObject("orgid").getLong("id")).collect(Collectors.toList());
            orgList.retainAll(orgIds);
            return orgList;
        }
        return new ArrayList<Long>();
    }

    public void click(EventObject evt) {
        DynamicObject dataEntity;
        DynamicObjectCollection orgs;
        Control control = (Control)evt.getSource();
        String itemKey = control.getKey();
        if ("btnok".equals(itemKey) && !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(orgs = (dataEntity = this.getModel().getDataEntity()).getDynamicObjectCollection("org")))) {
            ArrayList<String> messageList = new ArrayList<String>();
            StringBuilder detailMsg = new StringBuilder();
            List<Long> orgIds = orgs.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            Map<String, String> recordMap = this.buildRecordMap(orgIds);
            for (DynamicObject org : orgs) {
                long orgId = org.getDynamicObject("fbasedataid").getLong("id");
                if (!recordMap.containsKey(String.valueOf(orgId))) continue;
                messageList.add(String.format(ResManager.loadKDString((String)"%1$s", (String)"VerificationDownloadPlugin_1", (String)"taxc-tsate-formplugin", (Object[])new Object[0]), org.getDynamicObject("fbasedataid").getString("name")));
            }
            if (org.apache.commons.collections.CollectionUtils.isEmpty(messageList)) {
                if (StringUtils.isBlank((CharSequence)detailMsg)) {
                    this.doDownloadVerification();
                } else {
                    this.verificationDownloadConfirmTips("sfzhdxxdownload", detailMsg.toString());
                }
            } else {
                this.dealMessage(messageList);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        if (event.getResult() == MessageBoxResult.Yes && "sfzhdxxdownload".equals(callBackId)) {
            this.doDownloadVerification();
        }
    }

    private void doDownloadVerification() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection orgs = dataEntity.getDynamicObjectCollection("org");
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)orgs)) {
            List<Long> orgIds = orgs.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            Map channelMap = TsateChannelBusiness.getChannel(orgIds, Arrays.asList(CHANNEL));
            Map<Long, String> orgMap = this.buildTaxorgMap(orgIds);
            DynamicObject taskObj = BusinessDataServiceHelper.loadSingle((String)"tsate_tasktype", (String)MetadataUtil.getAllFieldString((String)"tsate_tasktype"), (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"SFZHDXX")});
            for (DynamicObject org : orgs) {
                Long orgId = org.getDynamicObject("fbasedataid").getLong("id");
                if (channelMap == null || !channelMap.containsKey(orgId)) {
                    logger.error(String.format("\u7ec4\u7ec7%1$s\u672a\u627e\u5230\u5bf9\u5e94\u901a\u9053", orgId));
                    continue;
                }
                HashMap<String, Object> paramMap = new HashMap<String, Object>(12);
                paramMap.put("nsrsbh", orgMap.get(orgId));
                paramMap.put("org", org.getDynamicObject("fbasedataid").getLong("id"));
                DynamicObject[] dynamicObjects = VerificationDownloadPlugin.assembleDeclareRecord(orgId, taskObj, (DynamicObject)channelMap.get(orgId));
                paramMap.put("recordid", dynamicObjects[0].getLong("id"));
                paramMap.put("key", "sfzhdxx");
                paramMap.put("supplier", ((DynamicObject)channelMap.get(orgId)).getString("declarechannel.number"));
                JobUtils.submitJob(paramMap);
            }
            this.getView().close();
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u7a0e\u8d39\u79cd\u6838\u5b9a\u4fe1\u606f\u4e0b\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e\u5237\u65b0\u754c\u9762\u67e5\u770b\u4e0b\u8f7d\u7ed3\u679c\uff0c\u6216\u524d\u5f80\u62a5\u7a0e\u4efb\u52a1\u76d1\u63a7\u67e5\u770b\u8fdb\u5ea6\u3002", (String)"VerificationDownloadPlugin_2", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    private Map<Long, String> buildTaxorgMap(List<Long> orgIds) {
        DynamicObject[] taxorgs = BusinessDataServiceHelper.load((String)"bastax_taxorg", (String)"unifiedsocialcode,org", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)});
        HashMap<Long, String> taxOrgMap = new HashMap<Long, String>();
        if (taxorgs != null && taxorgs.length > 0) {
            Map<Long, String> map = Arrays.stream(taxorgs).collect(Collectors.toMap(o -> o.getDynamicObject("org").getLong("id"), o -> o.getString("unifiedsocialcode")));
            taxOrgMap.putAll(map);
        }
        return taxOrgMap;
    }

    private Map<String, String> buildRecordMap(List<Long> orgIds) {
        QFilter qFilter = new QFilter("org", "in", orgIds).and(new QFilter("executestatus", "=", (Object)"1")).and(new QFilter("tasktype.number", "=", (Object)"SFZHDXX"));
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"tsate_declare_record", (String)MetadataUtil.getAllFieldString((String)"tsate_declare_record"), (QFilter[])new QFilter[]{qFilter});
        HashMap<String, String> recordMap = new HashMap<String, String>();
        if (records != null && records.length > 0) {
            Map<String, String> map = Arrays.stream(records).collect(Collectors.toMap(o -> o.getDynamicObject("org").getString("id"), o -> o.getString("id"), (key1, key2) -> key2));
            recordMap.putAll(map);
        }
        return recordMap;
    }

    private void verificationDownloadConfirmTips(String key, String details) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(key, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"VerificationDownloadPlugin_3", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"VerificationDownloadPlugin_4", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f4\u8fde\u4e0b\u8f7d\u7684\u8bb0\u5f55\uff0c\u786e\u8ba4\u662f\u5426\u8981\u91cd\u65b0\u4e0b\u8f7d\uff1f", (String)"VerificationDownloadPlugin_5", (String)"taxc-tsate-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, details, options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    private void dealMessage(List<String> messages) {
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("bos_operationresult");
        parameters.setShowTitle(true);
        parameters.setCustomParam("operateName", (Object)"");
        String title = String.format(ResManager.loadKDString((String)"\u60a8\u5df2\u9009\u4e2d%1$s\u4e2a\u7a0e\u52a1\u7ec4\u7ec7\u7684\u7a0e\u79cd\u6838\u5b9a\u4fe1\u606f\u6b63\u5728\u4e0b\u8f7d\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"VerificationDownloadPlugin_6", (String)"taxc-tsate-formplugin", (Object[])new Object[0]), messages.size());
        parameters.setCustomParam("title", (Object)title);
        parameters.setCustomParam("errorMsg", messages);
        this.getView().showForm(parameters);
    }

    private static List<Long> filterByIsTaxpayer() {
        DynamicObjectCollection taxOrgs = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org.id as id", (QFilter[])new QFilter[]{new QFilter("istaxpayer", "=", (Object)Boolean.TRUE).and(new QFilter("status", "=", (Object)"1"))});
        return CollectionUtils.isEmpty((Collection)taxOrgs) ? new ArrayList<Long>() : taxOrgs.parallelStream().map(s -> s.getLong("id")).collect(Collectors.toList());
    }

    private static List<Long> excludeByTaxPayer(List<Long> orgList) {
        List<Long> orgIds = VerificationDownloadPlugin.filterByIsTaxpayer();
        orgList.removeIf(s -> !orgIds.contains(s));
        return orgList;
    }

    private static DynamicObject[] assembleDeclareRecord(Long orgId, DynamicObject taskObj, DynamicObject channelObj) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tsate_declare_record");
        dynamicObject.set("org", (Object)orgId);
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("creator", (Object)RequestContext.get().getUserId());
        dynamicObject.set("executestatus", (Object)"1");
        dynamicObject.set("billstatus", (Object)"C");
        if (channelObj != null) {
            dynamicObject.set("channel", (Object)channelObj.getString("declarechannel.number"));
            dynamicObject.set("declarechannel", (Object)channelObj.getLong("declarechannel.id"));
        }
        if (taskObj != null) {
            dynamicObject.set("executetype", (Object)"SFZHDXX");
            dynamicObject.set("tasktype", (Object)taskObj.getLong("id"));
        }
        DynamicObject[] objs = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        dynamicObject = objs[0];
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        codeRuleService.getNumber("tsate_declare_record", dynamicObject, null);
        String number = codeRuleService.readNumber("tsate_declare_record", dynamicObject, null);
        dynamicObject.set("billno", (Object)number);
        return (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private static List<Long> getTaxorganIds(List<String> channels) {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1").and(new QFilter("declarechannel.number", "in", channels));
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"tsate_declare_channel", (String)"id,declarechannel,taxorgancopy", (QFilter[])new QFilter[]{qFilter});
        HashSet taxorganIds = new HashSet();
        if (objs != null && objs.length > 0) {
            for (DynamicObject obj : objs) {
                obj.getDynamicObjectCollection("taxorgancopy").stream().forEach(o -> taxorganIds.add(o.getDynamicObject("fbasedataid").getLong("id")));
            }
            return new ArrayList<Long>(taxorganIds);
        }
        return null;
    }

    private List<Long> getChildTaxauthorityByIds(List<Long> ids, List<Long> taxauthorityIds) {
        ids.addAll(taxauthorityIds);
        QFilter qFilter = new QFilter("parent", "in", taxauthorityIds);
        ArrayList<Long> tempIds = new ArrayList<Long>();
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"bastax_taxorgan", (String)"id,number,name", (QFilter[])new QFilter[]{qFilter});
        if (objs != null && objs.length > 0) {
            for (DynamicObject obj : objs) {
                tempIds.add(obj.getLong("id"));
            }
            this.getChildTaxauthorityByIds(ids, tempIds);
        }
        return ids;
    }
}

