/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineBusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.tsate.common.helper.OrgServiceHelper;
import kd.taxc.tsate.common.metadata.MetadataUtil;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.PermissionUtils;
import kd.taxc.tsate.common.util.servicehelperutils.ServiceHelperBaseUtils;
import org.apache.commons.collections.CollectionUtils;

public class BastaxTaxorgBusiness {
    private static final String APP_NUMBER = "tsate";

    public static List<Long> getHasPremOrgIds(String entityId, Long userId, String premNumber) {
        if (StringUtils.isBlank((Object)userId)) {
            userId = RequestContext.get().getCurrUserId();
        }
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgsByUserId((String)APP_NUMBER, (String)entityId, (String)premNumber, (Long)userId);
        List<Object> orgList = new ArrayList();
        if (EmptyCheckUtils.isNotEmpty((Object)hasPermOrgResult) && !hasPermOrgResult.hasAllOrgPerm()) {
            orgList = hasPermOrgResult.getHasPermOrgs();
        } else {
            DynamicObjectCollection objs = OrgServiceHelper.getOrgLists();
            if (!CollectionUtils.isEmpty((Collection)objs)) {
                orgList = objs.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
            }
        }
        return orgList;
    }

    public static List<Long> queryIsTaxpayerAndCheckedOrgIds(List<Long> orgIds) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return null;
        }
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainOrgIdByOrgIdAndIsTaxpayer(orgIds);
        ServiceHelperBaseUtils.checkTaxResultAndThrowEx((TaxResult)result);
        return (List)result.getData();
    }

    public static DynamicObject queryTaxcOrgInfoByOrgId(Long orgId) {
        if (orgId == null) {
            return null;
        }
        TaxResult result = TaxcOrgDataServiceHelper.queryTaxcOrgByOrgId((Long)orgId);
        ServiceHelperBaseUtils.checkTaxResultAndThrowEx((TaxResult)result);
        if (result.getData() == null) {
            return null;
        }
        DynamicObjectCollection taxOrgs = ((DynamicObject)result.getData()).getDynamicObjectCollection("entryentity");
        return (DynamicObject)taxOrgs.get(0);
    }

    public static Long queryTopTaxauthorityByOrgId(Long orgId) {
        if (orgId == null) {
            return null;
        }
        TaxResult result = TaxcCombineBusinessDataServiceHelper.queryTopTaxauthorityByOrgId((Long)orgId);
        ServiceHelperBaseUtils.checkTaxResultAndThrowEx((TaxResult)result);
        return (Long)result.getData();
    }

    public static DynamicObjectCollection getByIds(Collection<Long> orgids, Boolean isTaxPayer, Boolean enableOrg) {
        QFilter qFilter = new QFilter("id", "in", orgids);
        if (isTaxPayer != null) {
            qFilter.and(new QFilter("istaxpayer", "=", (Object)(isTaxPayer != false ? "1" : "0")));
        }
        if (enableOrg != null) {
            qFilter.and(new QFilter("status", "=", (Object)(enableOrg != false ? "1" : "0")));
        }
        StringBuilder filds = new StringBuilder(MetadataUtil.getAllFieldString((String)"bastax_taxorg"));
        filds.append(",org.number");
        DynamicObjectCollection collections = QueryServiceHelper.query((String)"bastax_taxorg", (String)filds.toString(), (QFilter[])new QFilter[]{qFilter});
        return collections;
    }

    public static DynamicObjectCollection getByNumber(Collection<String> numbers, Boolean isTaxPayer, Boolean enableOrg) {
        QFilter qFilter = new QFilter("org.number", "in", numbers);
        if (isTaxPayer != null) {
            qFilter.and(new QFilter("istaxpayer", "=", (Object)(isTaxPayer != false ? "1" : "0")));
        }
        if (enableOrg != null) {
            qFilter.and(new QFilter("status", "=", (Object)(enableOrg != false ? "1" : "0")));
        }
        StringBuilder filds = new StringBuilder(MetadataUtil.getAllFieldString((String)"bastax_taxorg"));
        filds.append(",org.number");
        DynamicObjectCollection collections = QueryServiceHelper.query((String)"bastax_taxorg", (String)filds.toString(), (QFilter[])new QFilter[]{qFilter});
        return collections;
    }

    public static TaxResult<Map<Long, Map<String, Boolean>>> queryTaxTypeEnableByOrgIds(List<Long> orgIds) {
        return TaxcMainDataServiceHelper.isTaxcMainCategoryEnableByOrgIds(orgIds);
    }

    public static Map<Long, Boolean> queryTaxTypesEnableStatus(List<Long> orgIds, String taxTypes) {
        TaxResult<Map<Long, Map<String, Boolean>>> result = BastaxTaxorgBusiness.queryTaxTypeEnableByOrgIds(orgIds);
        HashMap<Long, Boolean> statusMap = new HashMap<Long, Boolean>(32);
        if (ServiceHelperBaseUtils.checkTaxResult(result)) {
            Map data = (Map)result.getData();
            for (Map.Entry entry : data.entrySet()) {
                Long key = (Long)entry.getKey();
                Map value = (Map)entry.getValue();
                String[] types = taxTypes.split(",");
                Boolean flag = Boolean.TRUE;
                for (String type : types) {
                    if (!flag.booleanValue()) break;
                    Boolean enable = (Boolean)value.get(type);
                    flag = flag != false && EmptyCheckUtils.isNotEmpty((Object)enable) && enable != false;
                }
                statusMap.put(key, flag);
            }
        }
        return statusMap;
    }

    public static String getTaxOrganNameById(Long taxOrganId) {
        DynamicObject organById = QueryServiceHelper.queryOne((String)"bastax_taxorgan", (String)"name", (QFilter[])new QFilter("id", "=", (Object)taxOrganId).toArray());
        if (EmptyCheckUtils.isNotEmpty((Object)organById)) {
            return organById.getString("name");
        }
        return "";
    }
}

