/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.taxc.tsate.business.TsateCcxwsBussiness;
import kd.taxc.tsate.business.TsateDeclareQueryListBusiness;
import kd.taxc.tsate.business.checklist.CompareResultEnum;
import kd.taxc.tsate.business.checklist.SbjgEnum;
import kd.taxc.tsate.business.checklist.SbztEnum;
import kd.taxc.tsate.business.datafetch.Fetcher;
import kd.taxc.tsate.business.datafetch.params.CalCommand;
import kd.taxc.tsate.business.datafetch.params.FetchParam;
import kd.taxc.tsate.business.datafetch.params.FetchParamHelper;
import kd.taxc.tsate.business.datafetch.params.FetcherStep;
import kd.taxc.tsate.common.enums.DeclareStatusEnum;
import kd.taxc.tsate.common.enums.TaxEnum;
import kd.taxc.tsate.common.enums.TaxPeriodType;
import kd.taxc.tsate.common.util.DateUtils;

public class CheckListCompareBusiness {
    private static final String TSATE_CHECKLIST_GROUP = "tsate_checklist_group";
    private static final String KEY_CONDITIONCOMMAND = "compareCommand";
    private static final String KEY_DATAEXISTMMAND = "dataexistCommand";
    private static final String KEY_STEPCOMMAND = "stepCommand";
    private static final String KEY_ZSXM = "zsxm";
    private static final String KEY_ZSXMID = "zsxmid";
    private static final String KEY_ZSPM = "zspm";
    private static final String KEY_ZSPMID = "zspmid";
    private static final String KEY_SBZT = "sbzt";
    private static final String KEY_SBJG = "sbjg";
    private static final String KEY_FETCH_DECLAREMAIN = "declaremain";
    private static SbjgEnum[] SBJG_NODECLARED = new SbjgEnum[]{SbjgEnum.WSBWDR, SbjgEnum.SWSB, SbjgEnum.WTX, SbjgEnum.WSB, SbjgEnum.TXSBB, SbjgEnum.WBS, SbjgEnum.DSB, SbjgEnum.YSBWDR};
    private static SbjgEnum[] SBJG_DECLARED = new SbjgEnum[]{SbjgEnum.YSB, SbjgEnum.YSBYDR, SbjgEnum.SBCG, SbjgEnum.YSBYJK, SbjgEnum.YSBWJK, SbjgEnum.YBS};
    private static List<Long> CCXWS_TAX_IDS = Arrays.asList(TaxEnum.YHS.getId(), TaxEnum.FCS.getId());
    private static String[] KD_SBZT_NODECLARED = new String[]{"declaring", "importing", "declarefailed", "submitted", "editing"};
    private static String[] KD_SBZT_DECLARED = new String[]{"declared"};

    public static DynamicObjectCollection checkBeforCompare(List<Long> entryIdList) {
        QFilter filter = new QFilter("checklist.id", "in", entryIdList);
        filter.and("checklist.compareresult", "=", (Object)CompareResultEnum.COMPARING.getCode());
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)TSATE_CHECKLIST_GROUP, (String)"checklist.id,org.name,org.id", (QFilter[])new QFilter[]{filter});
        return dyns;
    }

    public static void compare(List<Long> entryIdList) {
        DynamicObjectCollection dyns = CheckListCompareBusiness.qurySbsxData(entryIdList);
        for (DynamicObject obj : dyns) {
            CompareResultEnum compare = CheckListCompareBusiness.check(obj);
            Long entryId = obj.getLong("checklist.id");
            CheckListCompareBusiness.updateChecklist(entryId, compare);
        }
    }

    private static DynamicObjectCollection qurySbsxData(List<Long> entryIds) {
        QFilter filter = new QFilter("checklist.id", "in", entryIds);
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)TSATE_CHECKLIST_GROUP, (String)"id,org.id,checklist.id,checklist.sbsx,checklist.zsxm.name,checklist.zsxm.id,checklist.zspm.name,checklist.zspm.id,checklist.skssqq,checklist.skssqz,checklist.sbzt,checklist.sbjg", (QFilter[])new QFilter[]{filter});
        return dyns;
    }

    private static CompareResultEnum check(DynamicObject obj) {
        Long orgId = obj.getLong("org.id");
        String zsxm = obj.getString("checklist.zsxm.name");
        Long zsxmId = obj.getLong("checklist.zsxm.id");
        String zspm = obj.getString("checklist.zspm.name");
        Long zspmId = obj.getLong("checklist.zspm.id");
        Date skssqq = obj.getDate("checklist.skssqq");
        Date skssqz = obj.getDate("checklist.skssqz");
        Long entryId = obj.getLong("checklist.id");
        String sbzt = obj.getString("checklist.sbzt");
        String sbjg = obj.getString("checklist.sbjg");
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("orgid", orgId);
        map.put(KEY_ZSXM, zsxm);
        map.put(KEY_ZSPM, zspm);
        map.put(KEY_ZSXMID, zsxmId);
        map.put(KEY_ZSPMID, zspmId);
        map.put("skssqq", skssqq);
        map.put("skssqz", skssqz);
        map.put(KEY_SBZT, sbzt);
        map.put(KEY_SBJG, sbjg);
        if (skssqq == null || skssqz == null) {
            return CompareResultEnum.NONE_COMPARE_DATA;
        }
        TaxPeriodType periodType = DateUtils.getTaxLimit3((Date)skssqq, (Date)skssqz);
        map.put("periodtype", periodType.name());
        if (!CheckListCompareBusiness.checkDataValid(skssqq, skssqz)) {
            return CompareResultEnum.NONE_COMPARE_DATA;
        }
        Fetcher fetcher = new Fetcher();
        if (!CheckListCompareBusiness.checkExistRule(fetcher, zsxmId, zspmId)) {
            return CompareResultEnum.NONE_COMPARE_DATA;
        }
        fetcher.initContext(map);
        if (!CCXWS_TAX_IDS.contains(zsxmId)) {
            CheckListCompareBusiness.exeFetchSteps(fetcher);
        }
        if (!CheckListCompareBusiness.checkStatusValid(fetcher)) {
            return CompareResultEnum.NONE_COMPARE_DATA;
        }
        if (!CheckListCompareBusiness.checkExistData(fetcher)) {
            return CompareResultEnum.NONE_COMPARE_DATA;
        }
        if (!CheckListCompareBusiness.checkFetcherCondition(fetcher)) {
            return CompareResultEnum.DIFF;
        }
        String declareStatus = "editing";
        if (CCXWS_TAX_IDS.contains(zsxmId)) {
            declareStatus = CheckListCompareBusiness.getCcxwsDeclareStatus(orgId, skssqq, skssqz, zspm, zsxm);
        }
        if (!CheckListCompareBusiness.checkDelcareStatus(fetcher, declareStatus)) {
            return CompareResultEnum.DIFF;
        }
        return CompareResultEnum.NO_DIFF;
    }

    private static String getCcxwsDeclareStatus(Long orgId, Date skssqq, Date skssqz, String zspm, String zsxm) {
        DynamicObjectCollection ccxwsDeclareMain = TsateDeclareQueryListBusiness.queryMainDataByBusinessData(orgId, skssqq, skssqz, "ccxws");
        if (CollectionUtils.isEmpty((Collection)ccxwsDeclareMain)) {
            return "editing";
        }
        Map<String, List<Map<String, String>>> taxInfo = TsateCcxwsBussiness.queryCcxwsSbbTaxInfo(ccxwsDeclareMain.stream().map(o -> o.getString("id")).collect(Collectors.toList()));
        for (DynamicObject dynamicObject : ccxwsDeclareMain) {
            List<Map<String, String>> ccxwsInfolist = taxInfo.get(dynamicObject.getString("id"));
            for (Map<String, String> infoMap : ccxwsInfolist) {
                if (!zsxm.equals(infoMap.get("taxtype")) || !DateUtils.format((Date)skssqq, (String)"yyyy-MM-dd").equals(infoMap.get("skssqq")) || !DateUtils.format((Date)skssqz, (String)"yyyy-MM-dd").equals(infoMap.get("skssqz")) || !StringUtils.isEmpty((String)zspm) && !zspm.equals(infoMap.get("sm"))) continue;
                return dynamicObject.getString("declarestatus");
            }
        }
        return "editing";
    }

    private static boolean checkDataValid(Date qq, Date qz) {
        return qq != null && qz != null;
    }

    private static boolean checkExistRule(Fetcher fetcher, Long zsxmId, Long zspmId) {
        Map<String, Object> cfg = CheckListCompareBusiness.getFetchConfig(zsxmId, zspmId);
        if (cfg == null) {
            return false;
        }
        fetcher.getContext().setData(cfg);
        return true;
    }

    private static boolean checkExistData(Fetcher fetcher) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        Object obj = fetcher.getContext().getData(KEY_DATAEXISTMMAND);
        if (obj == null) {
            return true;
        }
        String str = obj.toString();
        Object j = JSON.parse((String)str);
        if (j instanceof JSONObject) {
            QFilter filter = FetchParamHelper.buildFilter((JSONObject)j, fetcher.getContext());
            filters.add(filter);
        } else if (j instanceof JSONArray) {
            JSONArray jArray = (JSONArray)j;
            for (Object item : jArray) {
                if (!(item instanceof JSONObject)) continue;
                QFilter filter = FetchParamHelper.buildFilter((JSONObject)item, fetcher.getContext());
                filters.add(filter);
            }
        }
        boolean r = true;
        for (QFilter q : filters) {
            if (r = r && fetcher.condition(q)) continue;
            break;
        }
        return r;
    }

    private static boolean checkDelcareStatus(Fetcher fetcher, String declareStatus) {
        String sbzt = (String)fetcher.getContext().getData(KEY_SBZT);
        String sbjg = (String)fetcher.getContext().getData(KEY_SBJG);
        List declares = (List)fetcher.getContext().getData(KEY_FETCH_DECLAREMAIN);
        if (declares != null && declares.size() > 0) {
            declareStatus = (String)((Map)declares.get(0)).get("declarestatus");
        }
        if (StringUtils.isNotEmpty((String)sbzt)) {
            return CheckListCompareBusiness.checkSbzt(sbzt, declareStatus);
        }
        if (StringUtils.isNotEmpty((String)sbjg)) {
            return CheckListCompareBusiness.checkSbjg(sbjg, declareStatus);
        }
        return false;
    }

    private static boolean checkStatusValid(Fetcher fetcher) {
        String sbzt = (String)fetcher.getContext().getData(KEY_SBZT);
        String sbjg = (String)fetcher.getContext().getData(KEY_SBJG);
        if (StringUtils.isNotEmpty((String)sbzt)) {
            SbztEnum sbztEnum = SbztEnum.valueOfCode(sbzt);
            return sbztEnum != null;
        }
        if (StringUtils.isNotEmpty((String)sbjg)) {
            SbjgEnum sbjgEnum = SbjgEnum.valueOfName(sbjg);
            return sbjgEnum != null;
        }
        return false;
    }

    private static boolean checkSbzt(String sbzt, String declareStatus) {
        block4: {
            SbztEnum sbztEnum;
            block3: {
                if (StringUtils.isEmpty((String)declareStatus)) {
                    return false;
                }
                sbztEnum = SbztEnum.valueOfCode(sbzt);
                if (SbztEnum.NONEDECLARE != sbztEnum) break block3;
                for (String status : KD_SBZT_NODECLARED) {
                    if (!status.equals(declareStatus)) continue;
                    return true;
                }
                break block4;
            }
            if (SbztEnum.DECLARED != sbztEnum) break block4;
            for (String status : KD_SBZT_DECLARED) {
                if (!status.equals(declareStatus)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkSbjg(String sbjg, String declareStatus) {
        if (StringUtils.isEmpty((String)declareStatus)) {
            return false;
        }
        SbjgEnum sbjgEnum = SbjgEnum.valueOfName(sbjg);
        for (SbjgEnum item : SBJG_NODECLARED) {
            if (item != sbjgEnum) continue;
            return DeclareStatusEnum.EDITING.getCode().equals(declareStatus);
        }
        for (SbjgEnum item : SBJG_DECLARED) {
            if (item != sbjgEnum) continue;
            return DeclareStatusEnum.DECLARED.getCode().equals(declareStatus);
        }
        return false;
    }

    private static void exeFetchSteps(Fetcher fetcher) {
        Object o = fetcher.getContext().getData(KEY_STEPCOMMAND);
        if (o == null) {
            return;
        }
        String str = o.toString();
        if (StringUtils.isEmpty((String)str)) {
            return;
        }
        JSONArray jArray = JSON.parseArray((String)str);
        for (Object item : jArray) {
            if (!(item instanceof JSONObject)) continue;
            FetcherStep step = FetchParamHelper.buildFetcherStep((JSONObject)item, fetcher.getContext());
            Object param = step.getStepParam();
            if (param instanceof FetchParam) {
                fetcher.fetch((FetchParam)param);
                continue;
            }
            if (!(param instanceof CalCommand)) continue;
            fetcher.cal((CalCommand)param);
        }
    }

    private static boolean checkFetcherCondition(Fetcher fetcher) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        Object obj = fetcher.getContext().getData(KEY_CONDITIONCOMMAND);
        if (obj == null) {
            return true;
        }
        String str = obj.toString();
        Object j = JSON.parse((String)str);
        if (j instanceof JSONObject) {
            QFilter filter = FetchParamHelper.buildFilter((JSONObject)j, fetcher.getContext());
            filters.add(filter);
        } else if (j instanceof JSONArray) {
            JSONArray jArray = (JSONArray)j;
            for (Object item : jArray) {
                if (!(item instanceof JSONObject)) continue;
                QFilter filter = FetchParamHelper.buildFilter((JSONObject)item, fetcher.getContext());
                filters.add(filter);
            }
        }
        boolean r = true;
        for (QFilter q : filters) {
            if (r = r && fetcher.condition(q)) continue;
            break;
        }
        return r;
    }

    private static Map<String, Object> getFetchConfig(Long zsxmId, Long zspmId) {
        QFilter filter = new QFilter("zsxm.id", "=", (Object)zsxmId);
        QFilter zspmFilter = new QFilter(KEY_ZSPM, "=", (Object)0L);
        if (zspmId != null) {
            zspmFilter.or("zspm.id", "=", (Object)zspmId);
        }
        filter.and(zspmFilter);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"tsate_checklist_config", (String)"conditioncfg_tag,stepcfg_tag,dataexistcfg_tag", (QFilter[])new QFilter[]{filter});
        if (dyn == null) {
            return null;
        }
        String conditioncfg = dyn.getString("conditioncfg_tag");
        String dataexistCfg = dyn.getString("dataexistcfg_tag");
        String stepCfg = dyn.getString("stepcfg_tag");
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put(KEY_CONDITIONCOMMAND, conditioncfg);
        map.put(KEY_DATAEXISTMMAND, dataexistCfg);
        map.put(KEY_STEPCOMMAND, stepCfg);
        return map;
    }

    private static void updateChecklist(Long entryId, CompareResultEnum compare) {
        QFilter filter = new QFilter("checklist.id", "=", (Object)entryId);
        DynamicObject dyn = BusinessDataServiceHelper.loadSingle((String)TSATE_CHECKLIST_GROUP, (String)"checklist.id,checklist.compareresult", (QFilter[])new QFilter[]{filter});
        DynamicObjectCollection checklists = dyn.getDynamicObjectCollection("checklist");
        for (DynamicObject item : checklists) {
            if (entryId.compareTo(item.getLong("id")) != 0) continue;
            item.set("compareresult", (Object)compare.getCode());
            break;
        }
        SaveServiceHelper.update((DynamicObject)dyn);
    }
}

