/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.tsate.business.BastaxTaxorgBusiness;
import kd.taxc.tsate.common.util.servicehelperutils.ServiceHelperBaseUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class TctbTaxMainBusiness {
    public static DynamicObjectCollection getByNsrsbh(List<String> nsrsbhList) {
        QFilter qFilter = new QFilter("taxorg.unifiedsocialcode", "in", nsrsbhList);
        DynamicObjectCollection collections = QueryServiceHelper.query((String)"tctb_tax_main", (String)"taxorg.unifiedsocialcode,taxoffice.id,taxoffice.longnumber", (QFilter[])new QFilter[]{qFilter});
        return collections;
    }

    public static List<DynamicObject> getByOrgId(List<Long> ogrIds) {
        return (List)TaxcMainDataServiceHelper.queryTaxcMainByOrgIds(ogrIds).getData();
    }

    public static DynamicObject getByNsrshb(String nsrshb) {
        if (StringUtils.isBlank((String)nsrshb)) {
            return null;
        }
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByUnifiedsocialCode((String)nsrshb);
        ServiceHelperBaseUtils.checkTaxResultAndThrowEx((TaxResult)result);
        if (result.getData() == null) {
            return null;
        }
        return (DynamicObject)result.getData();
    }

    public static DynamicObject getByOrgId(Long orgId) {
        List list = (List)TaxcMainDataServiceHelper.queryTaxcMainByOrgIds(Collections.singletonList(orgId)).getData();
        if (list != null && list.size() > 0) {
            return (DynamicObject)list.get(0);
        }
        return null;
    }

    public static Map<Long, Map<String, Object>> getOrgInfo(Collection<Long> orgIds, Boolean isTaxPayer, Boolean enable) {
        HashMap<Long, Map<String, Object>> orgMaps = new HashMap<Long, Map<String, Object>>(8);
        DynamicObjectCollection dyns = BastaxTaxorgBusiness.getByIds(orgIds, isTaxPayer, enable);
        for (DynamicObject dyn : dyns) {
            Long orgid = dyn.getLong("id");
            Map orgMap = orgMaps.computeIfAbsent(orgid, key -> new HashMap(8));
            orgMap.put("istaxpayer", dyn.getBoolean("istaxpayer"));
            orgMap.put("id", orgid);
            orgMap.put("status", dyn.getString("status"));
            orgMap.put("number", dyn.getString("org.number"));
            orgMap.put("nsrsbh", dyn.getString("unifiedsocialcode"));
        }
        QFilter qFilter = new QFilter("orgid.id", "in", orgMaps.keySet());
        StringBuilder filds = new StringBuilder();
        filds.append("orgid.id,taxoffice.id,taxoffice.name,taxoffice.number,taxoffice.longnumber");
        DynamicObjectCollection collections = QueryServiceHelper.query((String)"tctb_tax_main", (String)filds.toString(), (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject dyn : collections) {
            Long orgId = dyn.getLong("orgid.id");
            Map orgMap = orgMaps.computeIfAbsent(orgId, key -> new HashMap(8));
            orgMap.put("taxofficeid", dyn.getLong("taxoffice.id"));
            orgMap.put("taxofficenumber", dyn.getString("taxoffice.number"));
            orgMap.put("taxofficename", dyn.getString("taxoffice.name"));
        }
        return orgMaps;
    }

    public static String getTripleAggrementInfo(Long orgId) {
        Optional<DynamicObject> optional;
        DynamicObjectCollection objs;
        TaxResult r = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgId);
        DynamicObject d = (DynamicObject)r.getData();
        if (null != d && CollectionUtils.isNotEmpty((Collection)(objs = d.getDynamicObjectCollection("entryentity"))) && (optional = objs.stream().filter(a -> a.getBoolean("taxacct")).findFirst()).isPresent()) {
            return optional.get().getString("tripleaggrement");
        }
        return null;
    }
}

