/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tsate.business.declare.declaremain.DeclarationMainFormBusniess;
import kd.taxc.tsate.business.enums.CcxwsSplitTypeEnums;
import kd.taxc.tsate.business.enums.CcxwsSupportTypeEnums;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.DeclareTypeEnum;
import kd.taxc.tsate.common.enums.TaxEnum;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import org.apache.commons.collections.CollectionUtils;

public class TsateCcxwsBussiness {
    private static final String DATA_TYPE = "datatype";
    private static final String ID = "id";
    private static final String SBB_ID = "sbbid";
    private static final String DECLARE_TYPE = "declaretype";
    private static final List<String> FCTD_SLIP_CHANNEL_NUMBERS = Arrays.asList(SupplierEnum.QXY.getCode(), SupplierEnum.YZF.getCode());
    private static final List<SupplierEnum> NEEDS_DETAIL_DECLARE_SUPIILIER = Arrays.asList(SupplierEnum.SZYH, SupplierEnum.YZF);
    private static final List<SupplierEnum> FCTDS_NEED_HB_DECLARE = Arrays.asList(SupplierEnum.SZYH, SupplierEnum.ZWY);
    private static final List<SupplierEnum> FCTDS_NEED_SINGLE_DECLARE = Collections.singletonList(SupplierEnum.YZF);
    private static final List<TaxEnum> NEED_CHECK_IMPORT = Arrays.asList(TaxEnum.FCS, TaxEnum.CZTDSYS, TaxEnum.YHS);

    public static DynamicObjectCollection queryCcxwsJmfbInfoBySbbId(String entityNumber, String fields, String sbbId) {
        return QueryServiceHelper.query((String)entityNumber, (String)fields, (QFilter[])new QFilter(SBB_ID, "=", (Object)sbbId).toArray());
    }

    public static boolean declareValidate(StringBuilder message, DynamicObject declare, Map<Long, Boolean> statusMap, Map<String, Set<String>> taxTypesMap, Map<String, Boolean> isDetailMap, Map<Long, SupplierEnum> declareChannels) {
        String orgName = declare.getString("org.name");
        return TsateCcxwsBussiness.validateIsImport(declare, message, orgName, taxTypesMap) && TsateCcxwsBussiness.validateSupportTaxcType(declare, message, orgName, taxTypesMap, statusMap, isDetailMap, declareChannels);
    }

    private static boolean validateSupportTaxcType(DynamicObject declare, StringBuilder message, String orgName, Map<String, Set<String>> taxTypesMap, Map<Long, Boolean> statusMap, Map<String, Boolean> isDetailMap, Map<Long, SupplierEnum> declareChannels) {
        Set<String> taxTypes = taxTypesMap.get(declare.getString(ID));
        Set<String> commonTypes = CcxwsSupportTypeEnums.getSupportTaxTypeBySize(-1);
        int size = taxTypes.size();
        StringBuilder hbMessage = new StringBuilder();
        StringBuilder commonMessage = new StringBuilder();
        boolean isFcsFlag = false;
        boolean hbMessageFlag = false;
        Set<String> typeBySizeTypes = CcxwsSupportTypeEnums.getSupportTaxTypeBySize(size);
        Iterator<String> iterator = taxTypes.iterator();
        while (iterator.hasNext()) {
            String type = iterator.next();
            hbMessage.append(type);
            if (iterator.hasNext()) {
                hbMessage.append("\u3001");
            } else {
                String hbMessageStr = hbMessage.toString();
                int indexOf = hbMessageStr.lastIndexOf("\u3001");
                if (indexOf != -1) {
                    hbMessage.setLength(0);
                    hbMessage.append(hbMessageStr.substring(0, indexOf));
                    hbMessage.append(ResManager.loadKDString((String)"\u4e0e", (String)"TsateCcxwsBussiness_6", (String)"taxc-tsate-business", (Object[])new Object[0]));
                    hbMessage.append(type);
                }
            }
            if (!commonTypes.contains(type)) {
                commonMessage.append(type).append("\u3001");
            }
            if (!StringUtils.isBlank((CharSequence)commonMessage.toString())) {
                message.append(commonMessage.substring(0, commonMessage.length() - 1)).append(String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u76f4\u8fde\u7533\u62a5\uff0c\u8bf7\u8c03\u6574\u7533\u62a5\u8868\u540e\u518d\u7533\u62a5\uff1a%s\u4e0d\u7b26\u5408\u3002", (String)"TsateCcxwsBussiness_0", (String)"taxc-tsate-business", (Object[])new Object[0]), orgName)).append(System.lineSeparator());
                return false;
            }
            if (CcxwsSplitTypeEnums.CZFZTDS.getTaxTypes().contains(type)) {
                isFcsFlag = true;
            }
            if (typeBySizeTypes.contains(type)) continue;
            hbMessageFlag = true;
        }
        if (hbMessageFlag) {
            message.append((CharSequence)hbMessage).append(String.format(ResManager.loadKDString((String)"\u8fd9\u4e9b\u7a0e\u79cd\u6682\u4e0d\u652f\u6301\u540c\u65f6\u7533\u62a5\uff0c\u8bf7\u8c03\u6574\u7533\u62a5\u8868\u540e\u518d\u7533\u62a5\uff1a%s\u4e0d\u7b26\u5408\u3002", (String)"TsateCcxwsBussiness_1", (String)"taxc-tsate-business", (Object[])new Object[0]), orgName)).append(System.lineSeparator());
            return false;
        }
        if (isFcsFlag) {
            Boolean isDetail;
            SupplierEnum supplierEnum = declareChannels.get(Long.parseLong(declare.getString(ID)));
            if (NEEDS_DETAIL_DECLARE_SUPIILIER.contains(supplierEnum) && !(isDetail = isDetailMap.get(declare.getString(ID))).booleanValue()) {
                message.append(String.format(ResManager.loadKDString((String)"\u975e\u660e\u7ec6\u7533\u62a5\u8868\u6682\u4e0d\u652f\u6301\u76f4\u8fde\u7533\u62a5\uff0c\u8bf7\u8c03\u6574\u7533\u62a5\u8868\u540e\u518d\u7533\u62a5\uff1a%s\u4e0d\u7b26\u5408\u3002", (String)"TsateCcxwsBussiness_2", (String)"taxc-tsate-business", (Object[])new Object[0]), orgName)).append(System.lineSeparator());
                return false;
            }
            if (size == 1 && FCTDS_NEED_HB_DECLARE.contains(supplierEnum)) {
                Boolean enable = statusMap.get(declare.getLong("org.id"));
                if (EmptyCheckUtils.isEmpty((Object)enable)) {
                    message.append(String.format(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u7684\u623f\u4ea7\u7a0e\u548c\u571f\u5730\u7a0e\u5f00\u5173\u72b6\u6001\uff0c\u8bf7\u7ef4\u62a4\u76f8\u5173\u4fe1\u606f\uff1a%s\u4e0d\u7b26\u5408\u3002", (String)"TsateCcxwsBussiness_3", (String)"taxc-tsate-business", (Object[])new Object[0]), orgName)).append(System.lineSeparator());
                    return false;
                }
                if (enable.booleanValue()) {
                    message.append(String.format(ResManager.loadKDString((String)"\u623f\u4ea7\u7a0e\u548c\u571f\u5730\u4f7f\u7528\u7a0e\u9700\u8981\u4e00\u540c\u7533\u62a5\uff0c\u8bf7\u8c03\u6574\u7533\u62a5\u8868\u540e\u518d\u7533\u62a5\uff1a%s\u4e0d\u7b26\u5408\u3002", (String)"TsateCcxwsBussiness_4", (String)"taxc-tsate-business", (Object[])new Object[0]), orgName)).append(System.lineSeparator());
                    return false;
                }
            }
            if (size == 2 && FCTDS_NEED_SINGLE_DECLARE.contains(supplierEnum)) {
                message.append(String.format(ResManager.loadKDString((String)"\u623f\u4ea7\u7a0e\u548c\u57ce\u9547\u571f\u5730\u4f7f\u7528\u7a0e\u6682\u4e0d\u652f\u6301\u540c\u65f6\u7533\u62a5\uff0c\u8bf7\u8c03\u6574\u7533\u62a5\u8868\u540e\u518d\u7533\u62a5\uff1a%s\u4e0d\u7b26\u5408\u3002", (String)"TsateCcxwsBussiness_7", (String)"taxc-tsate-business", (Object[])new Object[0]), orgName)).append(System.lineSeparator());
                return false;
            }
        }
        return true;
    }

    public static boolean validateIsImport(DynamicObject declare, StringBuilder message, String orgName, Map<String, Set<String>> taxTypesMap) {
        boolean isSuccess = true;
        String dataType = declare.getString(DATA_TYPE);
        HashSet taxTypes = new HashSet();
        List needCheckList = NEED_CHECK_IMPORT.stream().map(TaxEnum::getName).collect(Collectors.toList());
        if ("2".equals(dataType) && CollectionUtils.isNotEmpty((Collection)CollectionUtils.intersection(taxTypes, needCheckList))) {
            message.append(String.format(ResManager.loadKDString((String)"\u624b\u5de5\u5f15\u5165\u7684\u7533\u62a5\u8868\u6570\u636e\u7f3a\u5c11\u7a0e\u6e90\u4fe1\u606f\uff0c\u6682\u4e0d\u652f\u6301\u76f4\u8fde\u7533\u62a5\uff0c\u8bf7\u8c03\u6574\u7533\u62a5\u8868\u540e\u518d\u7533\u62a5\uff1a%s\u4e0d\u7b26\u5408", (String)"TsateCcxwsBussiness_5", (String)"taxc-tsate-business", (Object[])new Object[0]), orgName)).append(System.lineSeparator());
            isSuccess = false;
        }
        return isSuccess;
    }

    public static Map<String, Set<String>> queryCcxwsSbbTaxType(List<String> ids) {
        QFilter sbbidFilter = new QFilter(SBB_ID, "in", ids);
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(16);
        DynamicObjectCollection tcretCcxwsZbs = QueryServiceHelper.query((String)"tcret_ccxws_zb_hb", (String)"sbbid,taxtype", (QFilter[])new QFilter[]{sbbidFilter});
        if (CollectionUtils.isEmpty((Collection)tcretCcxwsZbs)) {
            return map;
        }
        for (String id : ids) {
            HashSet<String> typeSet = new HashSet<String>(16);
            for (DynamicObject ccxwsZb : tcretCcxwsZbs) {
                String sbbid = ccxwsZb.getString(SBB_ID);
                String taxtype = ccxwsZb.getString("taxtype");
                if (!id.equals(sbbid) || typeSet.contains(taxtype)) continue;
                typeSet.add(taxtype);
            }
            map.put(id, typeSet);
        }
        return map;
    }

    public static Map<String, List<Map<String, String>>> queryCcxwsSbbTaxInfo(List<String> ids) {
        QFilter sbbidFilter = new QFilter(SBB_ID, "in", ids);
        HashMap<String, List<Map<String, String>>> map = new HashMap<String, List<Map<String, String>>>(16);
        DynamicObjectCollection tcretCcxwsZbs = QueryServiceHelper.query((String)"tcret_ccxws_zb_hb", (String)"sbbid,taxtype,sm,startdate,enddate", (QFilter[])new QFilter[]{sbbidFilter});
        if (CollectionUtils.isEmpty((Collection)tcretCcxwsZbs)) {
            return map;
        }
        for (String id : ids) {
            ArrayList infoList = new ArrayList(16);
            for (DynamicObject ccxwsZb : tcretCcxwsZbs) {
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("taxtype", ccxwsZb.getString("taxtype"));
                info.put("sm", ccxwsZb.getString("sm"));
                info.put("skssqq", DateUtils.format((Date)ccxwsZb.getDate("startdate"), (String)"yyyy-MM-dd"));
                info.put("skssqz", DateUtils.format((Date)ccxwsZb.getDate("enddate"), (String)"yyyy-MM-dd"));
                infoList.add(info);
            }
            map.put(id, infoList);
        }
        return map;
    }

    public static Map<String, Set<TaxEnum>> queryCcxwsSbbTaxType2(List<String> ids) {
        QFilter sbbidFilter = new QFilter(SBB_ID, "in", ids);
        HashMap<String, Set<TaxEnum>> map = new HashMap<String, Set<TaxEnum>>(16);
        DynamicObjectCollection tcretCcxwsZbs = QueryServiceHelper.query((String)"tcret_ccxws_zb_hb", (String)"sbbid,taxtype", (QFilter[])new QFilter[]{sbbidFilter});
        if (CollectionUtils.isEmpty((Collection)tcretCcxwsZbs)) {
            return map;
        }
        for (String id : ids) {
            HashSet<TaxEnum> typeSet = new HashSet<TaxEnum>(16);
            for (DynamicObject ccxwsZb : tcretCcxwsZbs) {
                String sbbid = ccxwsZb.getString(SBB_ID);
                String taxtype = ccxwsZb.getString("taxtype");
                TaxEnum tax = TaxEnum.valueOfName((String)taxtype);
                if (!id.equals(sbbid) || typeSet.contains(tax) || tax == null) continue;
                typeSet.add(tax);
            }
            map.put(id, typeSet);
        }
        return map;
    }

    public static Map<String, Boolean> queryCcxwsIsDetailDeclare(List<String> ids) {
        QFilter sbbidFilter = new QFilter(SBB_ID, "in", ids.stream().map(id -> Long.valueOf(id)).collect(Collectors.toList()));
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(16);
        DynamicObjectCollection tcretCcxwsZbs = QueryServiceHelper.query((String)"tcret_declare_main", (String)"sbbid,detaildeclare", (QFilter[])new QFilter[]{sbbidFilter});
        if (CollectionUtils.isEmpty((Collection)tcretCcxwsZbs)) {
            return map;
        }
        for (String id2 : ids) {
            Boolean isDetail = false;
            for (DynamicObject ccxwsZb : tcretCcxwsZbs) {
                String sbbid = ccxwsZb.getString(SBB_ID);
                String detailInfo = ccxwsZb.getString("detaildeclare");
                if (!id2.equals(sbbid) || !Boolean.TRUE.toString().equals(detailInfo)) continue;
                isDetail = true;
                break;
            }
            map.put(id2, isDetail);
        }
        return map;
    }

    @Deprecated
    public static List<Map<String, Object>> getTaskParamByDeclareMain(DynamicObject declareMain, Map<String, Object> taskParams) {
        ArrayList<Map<String, Object>> ccxwsTaskParams = new ArrayList<Map<String, Object>>(8);
        Long declareId = declareMain.getLong(ID);
        String type = declareMain.getString("type");
        DeclareTypeEnum declareType = DeclareTypeEnum.valueOfCode((String)type);
        if (DeclareTypeEnum.CCXWS != declareType) {
            ccxwsTaskParams.add(taskParams);
            return ccxwsTaskParams;
        }
        Map<String, Set<TaxEnum>> ccxwsTax = TsateCcxwsBussiness.queryCcxwsSbbTaxType2(Collections.singletonList(declareId.toString()));
        Set<TaxEnum> taxs = ccxwsTax.get(declareId.toString());
        for (TaxEnum tax : taxs) {
            HashMap<String, Object> taskMap = new HashMap<String, Object>(16);
            taskParams.put("taxtype", tax.getCode());
            taskParams.put("taxTypeId", tax.getId());
            if (tax == TaxEnum.YHS) {
                taskParams.put(DECLARE_TYPE, DeclareTypeEnum.YHS.getCode());
                taskParams.put("typeNumber", DeclareTypeEnum.YHS.getCode());
                ccxwsTaskParams.add(taskParams);
                break;
            }
            if (tax != TaxEnum.FCS && tax != TaxEnum.CZTDSYS) continue;
            taskParams.put(DECLARE_TYPE, DeclareTypeEnum.FCSCZTDSYS.getCode());
            if (!FCTD_SLIP_CHANNEL_NUMBERS.contains(taskParams.get("channelnumber"))) {
                taskParams.remove("taxtype");
                taskParams.remove("taxTypeId");
                ccxwsTaskParams.add(taskParams);
                break;
            }
            taskParams.put("typeNumber", tax.getCode());
            taskMap.putAll(taskParams);
            ccxwsTaskParams.add(taskMap);
        }
        return ccxwsTaskParams;
    }

    public static List<Map<String, Object>> getTaskParamByDeclareMainModel3(DynamicObject declareMain, Map<String, Object> taskParams) {
        ArrayList<Map<String, Object>> ccxwsTaskParams = new ArrayList<Map<String, Object>>(8);
        Long declareId = declareMain.getLong(ID);
        String type = DeclarationMainFormBusniess.getDeclareTypeByModel3(declareMain);
        DeclareTypeEnum declareType = DeclareTypeEnum.valueOfCode((String)type);
        if (DeclareTypeEnum.CCXWS != declareType) {
            ccxwsTaskParams.add(taskParams);
            return ccxwsTaskParams;
        }
        Map<String, Set<TaxEnum>> ccxwsTax = TsateCcxwsBussiness.queryCcxwsSbbTaxType2(Collections.singletonList(declareId.toString()));
        Set<TaxEnum> taxs = ccxwsTax.get(declareId.toString());
        for (TaxEnum tax : taxs) {
            HashMap<String, Object> taskMap = new HashMap<String, Object>(16);
            taskParams.put("taxtype", tax.getCode());
            taskParams.put("taxTypeId", tax.getId());
            if (tax == TaxEnum.YHS) {
                taskParams.put(DECLARE_TYPE, DeclareTypeEnum.YHS.getCode());
                taskParams.put("typeNumber", DeclareTypeEnum.YHS.getCode());
                ccxwsTaskParams.add(taskParams);
                break;
            }
            if (tax == TaxEnum.FCS || tax == TaxEnum.CZTDSYS) {
                taskParams.put(DECLARE_TYPE, DeclareTypeEnum.FCSCZTDSYS.getCode());
                if (!FCTD_SLIP_CHANNEL_NUMBERS.contains(taskParams.get("channelnumber"))) {
                    taskParams.remove("taxtype");
                    taskParams.remove("taxTypeId");
                    ccxwsTaskParams.add(taskParams);
                    break;
                }
                taskParams.put("typeNumber", tax.getCode());
                taskMap.putAll(taskParams);
                ccxwsTaskParams.add(taskMap);
            }
            if (tax != TaxEnum.HBS) continue;
            ccxwsTaskParams.add(taskParams);
            break;
        }
        return ccxwsTaskParams;
    }
}

