/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.tsate.business.AbstractBaseBusiness;
import kd.taxc.tsate.business.BastaxTaxorgBusiness;
import kd.taxc.tsate.business.TctbTaxMainBusiness;
import kd.taxc.tsate.business.declare.declaremain.DeclarationMainFormBusniess;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.metadata.MetadataUtil;
import kd.taxc.tsate.common.util.CommonInfoUtil;

public class TsateChannelBusiness
extends AbstractBaseBusiness {
    public static final String TSATE_DECLARE_CHANNEL = "tsate_declare_channel";
    private static final Log logger = LogFactory.getLog(TsateChannelBusiness.class);

    public static Map<Long, Map<String, Object>> getValueOrgs(List<Long> ids, SupplierEnum channel) {
        return TsateChannelBusiness.getValueOrgs(ids, null, null, null, channel);
    }

    public static Set<SupplierEnum> getChannelInfoByOrganId(Long organId) {
        return TsateChannelBusiness.getChannelInfoByOrganId(organId, null);
    }

    public static Set<SupplierEnum> getChannelInfoByOrganId(Long organId, List<SupplierEnum> channels) {
        DynamicObject[] channelInfos;
        HashSet<SupplierEnum> supplierEnums = new HashSet<SupplierEnum>(8);
        Long taxOfficeId = CommonInfoUtil.getParentTaxauthorityById((Long)organId);
        if (taxOfficeId == null || taxOfficeId == 0L) {
            return supplierEnums;
        }
        QFilter qFilter = new QFilter("enable", "=", (Object)"1").and(new QFilter("taxorgancopy.fbasedataid", "=", (Object)taxOfficeId));
        if (channels != null) {
            List channelIds = channels.stream().map(channel -> channel.getId()).collect(Collectors.toList());
            qFilter.and(new QFilter("declarechannel", "in", channelIds));
        }
        if ((channelInfos = BusinessDataServiceHelper.load((String)TSATE_DECLARE_CHANNEL, (String)"id,declarechannel,declarechannel.number", (QFilter[])new QFilter[]{qFilter})) == null) {
            return supplierEnums;
        }
        for (DynamicObject channelInfo : channelInfos) {
            SupplierEnum supplierEnum = SupplierEnum.valueOfCode((String)channelInfo.getString("declarechannel.number"));
            supplierEnums.add(supplierEnum);
        }
        return supplierEnums;
    }

    public static Map<Long, Map<String, Object>> getValueOrgs(List<Long> ids, Boolean isTaxPayer, Boolean enable, Boolean enableChannel, SupplierEnum channel) {
        HashMap<Long, Map<String, Object>> valueMap = new HashMap<Long, Map<String, Object>>();
        if (CollectionUtils.isEmpty(ids) || channel == null) {
            return valueMap;
        }
        if (isTaxPayer == null) {
            isTaxPayer = Boolean.TRUE;
        }
        if (enable == null) {
            enable = Boolean.TRUE;
        }
        if (enableChannel == null) {
            enableChannel = Boolean.TRUE;
        }
        String code = channel.getCode();
        Map<Long, Map<String, Object>> channelInfos = TsateChannelBusiness.getDeclareConfigByOrgId(ids, isTaxPayer, enable, enableChannel);
        block0: for (Long orgid : ids) {
            List channelList;
            Map<String, Object> orgChannelInfo = channelInfos.get(orgid);
            if (orgChannelInfo == null || (channelList = (List)orgChannelInfo.computeIfAbsent("channelinfos", key -> new ArrayList())).size() < 1) continue;
            for (Map achannel : channelList) {
                String channelNumber = (String)achannel.get("channelnumber");
                if (!code.equals(channelNumber)) continue;
                orgChannelInfo.put("valueChannel", achannel);
                valueMap.put(orgid, orgChannelInfo);
                continue block0;
            }
        }
        return valueMap;
    }

    public static Map<String, Map<String, Object>> getDeclareConfigByOrgNumber(Collection<String> orgNumbers, Boolean isTaxPayer, Boolean enableOrg, Boolean enableChannel) {
        DynamicObjectCollection orgs = BastaxTaxorgBusiness.getByNumber(orgNumbers, null, null);
        HashMap<Long, String> idMaps = new HashMap<Long, String>(8);
        for (DynamicObject dyn : orgs) {
            idMaps.put(dyn.getLong("id"), dyn.getString("org.number"));
        }
        Map<Long, Map<String, Object>> channelMaps = TsateChannelBusiness.getDeclareConfigByOrgId(idMaps.keySet(), isTaxPayer, enableOrg, enableChannel);
        HashMap<String, Map<String, Object>> targetMap = new HashMap<String, Map<String, Object>>(8);
        for (Map.Entry<Long, Map<String, Object>> entry : channelMaps.entrySet()) {
            Long id = entry.getKey();
            Map<String, Object> value = entry.getValue();
            String number = (String)idMaps.get(id);
            targetMap.put(number, value);
        }
        return targetMap;
    }

    public static Map<Long, SupplierEnum> getDeclareChannelByData(List<DynamicObject> declares) {
        return TsateChannelBusiness.getDeclareChannelByData(declares, null);
    }

    public static Map<Long, SupplierEnum> getDeclareChannelByData(List<DynamicObject> declares, Map<Long, Map<String, Object>> channelConfigInfo) {
        if (CollectionUtils.isEmpty(declares)) {
            return new HashMap<Long, SupplierEnum>(8);
        }
        HashSet<Long> orgIds = new HashSet<Long>(8);
        for (DynamicObject declare : declares) {
            Long orgId = declare.getLong("org.id");
            orgIds.add(orgId);
        }
        HashMap<Long, SupplierEnum> declareSuppliers = new HashMap<Long, SupplierEnum>(8);
        Map<Long, Map<String, Object>> channelConfigs = TsateChannelBusiness.getDeclareConfigByOrgId(orgIds, true, true, true);
        for (DynamicObject declare : declares) {
            Long declareId = declare.getLong("id");
            SupplierEnum supplier = TsateChannelBusiness.getFusionDeclareSupplierFromConfigFusion(channelConfigs, declare);
            declareSuppliers.put(declareId, supplier);
        }
        if (channelConfigInfo != null) {
            channelConfigInfo.putAll(channelConfigs);
        }
        return declareSuppliers;
    }

    @Deprecated
    public static Map<Long, SupplierEnum> getDeclareChannel(List<Long> declareIds) {
        return TsateChannelBusiness.getDeclareChannel(declareIds, null);
    }

    @Deprecated
    public static Map<Long, SupplierEnum> getDeclareChannel(List<Long> declareIds, Map<Long, Map<String, Object>> channelConfigInfo) {
        DynamicObject[] declares = BusinessDataServiceHelper.load((String)"tsate_declare_query_list", (String)MetadataUtil.getAllFieldString((String)"tsate_declare_query_list"), (QFilter[])new QFilter[]{new QFilter("id", "in", declareIds)});
        HashSet<Long> orgIds = new HashSet<Long>(8);
        for (DynamicObject declare : declares) {
            Long orgId = declare.getLong("org.id");
            orgIds.add(orgId);
        }
        HashMap<Long, SupplierEnum> declareSuppliers = new HashMap<Long, SupplierEnum>(8);
        Map<Long, Map<String, Object>> channelConfigs = TsateChannelBusiness.getDeclareConfigByOrgId(orgIds, true, true, true);
        for (DynamicObject declare : declares) {
            Long declareId = declare.getLong("id");
            SupplierEnum supplier = TsateChannelBusiness.getDeclareSupplierFromConfig(channelConfigs, declare);
            declareSuppliers.put(declareId, supplier);
        }
        if (channelConfigInfo != null) {
            channelConfigInfo.putAll(channelConfigs);
        }
        return declareSuppliers;
    }

    public static Map<Long, Map<String, Object>> getDeclareConfigByOrgId(Collection<Long> orgids, Boolean isTaxPayer, Boolean enableOrg, Boolean enableChannel) {
        Long orgid;
        HashMap<Long, Map<String, Object>> orgs = new HashMap<Long, Map<String, Object>>(8);
        Map<Long, Map<String, Object>> orgInfos = TctbTaxMainBusiness.getOrgInfo(orgids, isTaxPayer, enableOrg);
        HashSet<Long> taxOfficesIds = new HashSet<Long>(8);
        for (Map<String, Object> orgInfo : orgInfos.values()) {
            HashMap<String, Object> org = new HashMap<String, Object>();
            orgid = (Long)orgInfo.get("id");
            org.put("id", orgid);
            org.put("name", orgInfo.get("name"));
            org.put("number", orgInfo.get("number"));
            org.put("status", orgInfo.get("status"));
            org.put("istaxpayer", orgInfo.get("istaxpayer"));
            org.put("nsrsbh", orgInfo.get("nsrsbh"));
            Long taxofficeid = (Long)orgInfo.get("taxofficeid");
            org.put("taxofficeid", taxofficeid);
            org.put("taxofficename", orgInfo.get("taxofficename"));
            org.put("taxofficenumber", orgInfo.get("taxofficenumber"));
            orgs.put(orgid, org);
            taxOfficesIds.add(taxofficeid);
        }
        Map<Long, List<Map<String, Object>>> officeChannelMap = TsateChannelBusiness.getByTaxOfficeIds(taxOfficesIds, enableChannel);
        for (Map.Entry entry : orgs.entrySet()) {
            orgid = (Long)entry.getKey();
            Map org = (Map)entry.getValue();
            Long taxofficeId = org.getOrDefault("taxofficeid", -1L);
            List channelinfos = (List)org.computeIfAbsent("channelinfos", key -> new ArrayList(8));
            List<Map<String, Object>> configs = officeChannelMap.get(taxofficeId);
            for (Map<String, Object> config : configs) {
                Long parentTaxofficeId = (Long)config.get("parentid");
                Long channelId = (Long)config.get("channelid");
                String channelName = (String)config.get("channelname");
                String channelnumber = (String)config.get("channelnumber");
                String declaretype = (String)config.get("declaretype");
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("taxId", taxofficeId);
                item.put("parentTaxId", parentTaxofficeId);
                item.put("channelid", channelId);
                item.put("channelname", channelName);
                item.put("channelnumber", channelnumber);
                item.put("declaretype", declaretype);
                channelinfos.add(item);
            }
        }
        return orgs;
    }

    public static Map<Long, List<Map<String, Object>>> getByTaxOfficeIds(Collection<Long> ids, Boolean enable) {
        HashMap<Long, List<Map<String, Object>>> taxofficeChannelMaps = new HashMap<Long, List<Map<String, Object>>>(8);
        HashSet targetTaxOfficeIds = new HashSet(8);
        HashMap taxIdMap = new HashMap(8);
        ids.forEach(id -> {
            Long parentid = CommonInfoUtil.getParentTaxauthorityById((Long)id);
            if (parentid == null) {
                logger.error("\u67e5\u8be2\u7a0e\u52a1\u673a\u5173\u7236\u673a\u5173\u5f02\u5e38\uff0cid-" + id);
                parentid = id;
            }
            taxIdMap.put(id, parentid);
            targetTaxOfficeIds.add(parentid);
        });
        QFilter qFilter = new QFilter("taxorgancopy.fbasedataid", "in", targetTaxOfficeIds);
        if (enable != null) {
            qFilter.and(new QFilter("declarechannel.enable", "=", (Object)(enable != false ? "1" : "0")));
            qFilter.and(new QFilter("enable", "=", (Object)(enable != false ? "1" : "0")));
        }
        DynamicObjectCollection channels = QueryServiceHelper.query((String)TSATE_DECLARE_CHANNEL, (String)"declarechannel.id,declarechannel.name,declarechannel.number,taxorgancopy.fbasedataid,id,taxtypecopy.fbasedataid", (QFilter[])new QFilter[]{qFilter});
        HashMap targetChannelMap = new HashMap();
        channels.forEach(channel -> {
            Long taxOfficeid = channel.getLong("taxorgancopy.fbasedataid");
            List items = targetChannelMap.computeIfAbsent(taxOfficeid, key -> new ArrayList());
            items.add(channel);
        });
        ids.forEach(taxid -> {
            Long targetTaxid = (Long)taxIdMap.get(taxid);
            List channelDyns = targetChannelMap.computeIfAbsent(targetTaxid, key -> new ArrayList());
            List list = taxofficeChannelMaps.computeIfAbsent((Long)taxid, key -> new ArrayList(8));
            for (DynamicObject dyn : channelDyns) {
                Long channelid = dyn.getLong("declarechannel.id");
                String channelname = dyn.getString("declarechannel.name");
                String channelnumber = dyn.getString("declarechannel.number");
                String declareType = dyn.getString("taxtypecopy.fbasedataid");
                HashMap<String, Object> infoMap = new HashMap<String, Object>(8);
                infoMap.put("taxid", taxid);
                infoMap.put("parenttaxid", targetTaxid);
                infoMap.put("channelid", channelid);
                infoMap.put("channelname", channelname);
                infoMap.put("channelnumber", channelnumber);
                infoMap.put("declaretype", declareType);
                list.add(infoMap);
            }
        });
        return taxofficeChannelMaps;
    }

    public static String getChannelNumberFromConfig(Long orgId, String declareType, Map<Long, Map<String, Object>> config) {
        List list;
        if (config.containsKey(orgId) && (list = (List)config.get(orgId).getOrDefault("channelinfos", new ArrayList(0))) != null) {
            Object channelNumber = null;
            for (Map item : list) {
                if (declareType == null) {
                    channelNumber = item.get("channelnumber");
                    break;
                }
                if (!declareType.equals(item.get("declaretype"))) continue;
                channelNumber = item.get("channelnumber");
                break;
            }
            if (channelNumber != null) {
                return channelNumber.toString();
            }
        }
        return null;
    }

    public static Map<Long, DynamicObject> getChannel(List<Long> orgIds, List<String> channelNumber) {
        TaxResult taxMainQueryResult = TaxcMainDataServiceHelper.queryTaxcMainByOrgIds(orgIds);
        if (!taxMainQueryResult.isSuccess()) {
            logger.error(String.format("%1$s get taxmain fail", String.valueOf(orgIds)));
            return null;
        }
        List orgMainObjs = (List)taxMainQueryResult.getData();
        if (!CollectionUtils.isEmpty((Collection)orgMainObjs)) {
            Map<Long, DynamicObject> orgMap = orgMainObjs.stream().collect(Collectors.toMap(o -> o.getLong("orgid.id"), o -> o, (key1, key2) -> key1));
            HashMap<Long, Long> orgTaxMap = new HashMap<Long, Long>(orgMap.size());
            for (Map.Entry<Long, DynamicObject> orgEntry : orgMap.entrySet()) {
                orgTaxMap.put(orgEntry.getKey(), CommonInfoUtil.getParentTaxauthorityById((Long)orgEntry.getValue().getLong("taxoffice.id")));
            }
            List<Long> taxofficeIds = orgMainObjs.stream().map(o -> o.getLong("taxoffice.id")).collect(Collectors.toList());
            List<Long> parentOfficeIds = new ArrayList<Long>();
            if (!CollectionUtils.isEmpty(parentOfficeIds = TsateChannelBusiness.getParentTaxauthorityById(parentOfficeIds, taxofficeIds))) {
                QFilter qFilter = new QFilter("enable", "=", (Object)"1").and(new QFilter("taxorgancopy.fbasedataid", "in", parentOfficeIds)).and(new QFilter("declarechannel.number", "in", channelNumber));
                DynamicObjectCollection objs = QueryServiceHelper.query((String)TSATE_DECLARE_CHANNEL, (String)"id,declarechannel.number,declarechannel.id,taxorgancopy.fbasedataid", (QFilter[])new QFilter[]{qFilter});
                if (!CollectionUtils.isEmpty((Collection)objs)) {
                    Map<Long, List<DynamicObject>> channelMap = objs.stream().collect(Collectors.groupingBy(a -> a.getLong("taxorgancopy.fbasedataid")));
                    HashMap<Long, DynamicObject> orgChannelMap = new HashMap<Long, DynamicObject>();
                    for (Map.Entry orgEntry : orgTaxMap.entrySet()) {
                        if (!channelMap.containsKey(orgEntry.getValue())) continue;
                        orgChannelMap.put((Long)orgEntry.getKey(), channelMap.get(orgEntry.getValue()).get(0));
                    }
                    return orgChannelMap;
                }
            }
        }
        return null;
    }

    public static Set<String> getAllDeclareTYpeFromBaseConfig() {
        DynamicObject[] configs = BusinessDataServiceHelper.load((String)"tsate_declare_base", (String)MetadataUtil.getAllFieldString((String)"tsate_declare_base"), (QFilter[])new QFilter[0]);
        HashSet<String> declareTypes = new HashSet<String>(8);
        for (DynamicObject config : configs) {
            if (!"1".equals(config.getString("enable"))) continue;
            DynamicObjectCollection templates = config.getDynamicObjectCollection("sblx");
            for (DynamicObject dyn : templates) {
                declareTypes.add(dyn.getDynamicObject("fbasedataid").getString("number"));
            }
        }
        return declareTypes;
    }

    public static Set<String> getAllDeclareTYpeIdFromBaseConfig() {
        DynamicObject[] configs = BusinessDataServiceHelper.load((String)"tsate_declare_base", (String)MetadataUtil.getAllFieldString((String)"tsate_declare_base"), (QFilter[])new QFilter[0]);
        HashSet<String> declareTypes = new HashSet<String>(8);
        for (DynamicObject config : configs) {
            if (!"1".equals(config.getString("enable"))) continue;
            DynamicObjectCollection templates = config.getDynamicObjectCollection("sblx");
            for (DynamicObject dyn : templates) {
                declareTypes.add(dyn.getDynamicObject("fbasedataid").getString("id"));
            }
        }
        return declareTypes;
    }

    public static Set<String> getOrgDeclareTypeId(List<Long> orgIds) {
        DynamicObject[] taxOffices;
        List<DynamicObject> taxMainDyns = TctbTaxMainBusiness.getByOrgId(orgIds);
        if (taxMainDyns == null) {
            logger.error("\u672a\u67e5\u8be2\u5230\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f,\u7ec4\u7ec7id\uff1a{}", (Object)JSON.toJSONString(orgIds));
            return new HashSet<String>(0);
        }
        HashMap<Long, DynamicObject> taxOfficeMap = new HashMap<Long, DynamicObject>(64);
        for (DynamicObject dyn : taxOffices = BusinessDataServiceHelper.load((String)"bastax_taxorgan", (String)MetadataUtil.getAllFieldString((String)"bastax_taxorgan"), (QFilter[])new QFilter[0])) {
            taxOfficeMap.put(dyn.getLong("id"), dyn);
        }
        HashMap<Long, Long> orgTopOfficeMap = new HashMap<Long, Long>(16);
        for (DynamicObject taxmain : taxMainDyns) {
            DynamicObject parentTaxOfice;
            Long taxofficeId = taxmain.getLong("taxoffice.id");
            if (taxofficeId == null || (parentTaxOfice = TsateChannelBusiness.getTopTaxOffice(taxofficeId, taxOfficeMap)) == null) continue;
            orgTopOfficeMap.put(taxofficeId, parentTaxOfice.getLong("id"));
        }
        QFilter filter = new QFilter("taxorgan", "in", orgTopOfficeMap.values());
        DynamicObject[] configs = BusinessDataServiceHelper.load((String)"tsate_declare_base", (String)MetadataUtil.getAllFieldString((String)"tsate_declare_base"), (QFilter[])new QFilter[]{filter});
        HashSet<String> declareTypes = new HashSet<String>(8);
        for (DynamicObject config : configs) {
            if (!"1".equals(config.getString("enable"))) continue;
            DynamicObjectCollection templates = config.getDynamicObjectCollection("sblx");
            for (DynamicObject dyn : templates) {
                declareTypes.add(dyn.getDynamicObject("fbasedataid").getString("id"));
            }
        }
        return declareTypes;
    }

    public static Set<String> getOrgDeclareTypeFromBaseConfig(List<Long> orgIds) {
        DynamicObject[] taxOffices;
        List<DynamicObject> taxMainDyns = TctbTaxMainBusiness.getByOrgId(orgIds);
        if (taxMainDyns == null) {
            logger.error("\u672a\u67e5\u8be2\u5230\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f,\u7ec4\u7ec7id\uff1a{}", (Object)JSON.toJSONString(orgIds));
            return new HashSet<String>(0);
        }
        HashMap<Long, DynamicObject> taxOfficeMap = new HashMap<Long, DynamicObject>(64);
        for (DynamicObject dyn : taxOffices = BusinessDataServiceHelper.load((String)"bastax_taxorgan", (String)MetadataUtil.getAllFieldString((String)"bastax_taxorgan"), (QFilter[])new QFilter[0])) {
            taxOfficeMap.put(dyn.getLong("id"), dyn);
        }
        HashMap<Long, Long> orgTopOfficeMap = new HashMap<Long, Long>(16);
        for (DynamicObject taxmain : taxMainDyns) {
            DynamicObject parentTaxOfice;
            Long taxofficeId = taxmain.getLong("taxoffice.id");
            if (taxofficeId == null || (parentTaxOfice = TsateChannelBusiness.getTopTaxOffice(taxofficeId, taxOfficeMap)) == null) continue;
            orgTopOfficeMap.put(taxofficeId, parentTaxOfice.getLong("id"));
        }
        QFilter filter = new QFilter("taxorgan", "in", orgTopOfficeMap.values());
        DynamicObject[] configs = BusinessDataServiceHelper.load((String)"tsate_declare_base", (String)MetadataUtil.getAllFieldString((String)"tsate_declare_base"), (QFilter[])new QFilter[]{filter});
        HashSet<String> declareTypes = new HashSet<String>(8);
        for (DynamicObject config : configs) {
            DynamicObjectCollection templates = config.getDynamicObjectCollection("sblx");
            for (DynamicObject dyn : templates) {
                declareTypes.add(dyn.getDynamicObject("fbasedataid").getString("id"));
            }
        }
        return declareTypes;
    }

    private static List<Long> getParentTaxauthorityById(List<Long> taxauthorityIds, List<Long> ids) {
        ArrayList<Long> tempIds = new ArrayList<Long>();
        QFilter qFilter = new QFilter("id", "in", ids);
        Map taxorganMap = BusinessDataServiceHelper.loadFromCache((String)"bastax_taxorgan", (String)"id,parent.id", (QFilter[])new QFilter[]{qFilter});
        if (taxorganMap != null && taxorganMap.size() > 0) {
            for (Map.Entry obj : taxorganMap.entrySet()) {
                if (((DynamicObject)obj.getValue()).getLong("parent.id") == 0L) {
                    taxauthorityIds.add(((DynamicObject)obj.getValue()).getLong("id"));
                    continue;
                }
                tempIds.add(((DynamicObject)obj.getValue()).getLong("parent.id"));
            }
            TsateChannelBusiness.getParentTaxauthorityById(taxauthorityIds, tempIds);
        }
        return taxauthorityIds;
    }

    public static Long getParentTaxauthorityById(Long taxauthorityId) {
        QFilter qFilter = new QFilter("id", "=", (Object)taxauthorityId);
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"bastax_taxorgan", (String)"id,parent.id", (QFilter[])new QFilter[]{qFilter});
        if (objs != null && objs.length > 0) {
            DynamicObject obj = objs[0];
            if (obj.getLong("parent.id") == 0L) {
                return obj.getLong("id");
            }
            return TsateChannelBusiness.getParentTaxauthorityById(obj.getLong("parent.id"));
        }
        return 0L;
    }

    private static List<Long> getParentTaxauthorityById(List<Long> taxauthorityIds) {
        ArrayList<Long> tempIds = new ArrayList<Long>();
        QFilter qFilter = new QFilter("1", "=", (Object)1);
        Map taxorganMap = BusinessDataServiceHelper.loadFromCache((String)"bastax_taxorgan", (String)"id,parent.id", (QFilter[])new QFilter[]{qFilter});
        if (taxorganMap != null && taxorganMap.size() > 0) {
            for (Map.Entry obj : taxorganMap.entrySet()) {
                if (((DynamicObject)obj.getValue()).getLong("parent.id") == 0L) {
                    taxauthorityIds.add(((DynamicObject)obj.getValue()).getLong("id"));
                    continue;
                }
                tempIds.add(((DynamicObject)obj.getValue()).getLong("parent.id"));
            }
            TsateChannelBusiness.getParentTaxauthorityById(taxauthorityIds, tempIds);
        }
        return taxauthorityIds;
    }

    private static DynamicObject getTopTaxOffice(Long taxOfficeId, Map<Long, DynamicObject> taxOfficeMap) {
        DynamicObject dyn = taxOfficeMap.get(taxOfficeId);
        if (dyn == null) {
            return null;
        }
        DynamicObject parent = dyn.getDynamicObject("parent");
        if (parent == null) {
            return dyn;
        }
        Long parntId = parent.getLong("id");
        return TsateChannelBusiness.getTopTaxOffice(parntId, taxOfficeMap);
    }

    @Deprecated
    private static SupplierEnum getDeclareSupplierFromConfig(Map<Long, Map<String, Object>> channelInfosMaps, DynamicObject declareDyn) {
        List list;
        Object org = declareDyn.get("org");
        Long orgId = org instanceof DynamicObject ? Long.valueOf(declareDyn.getLong("org.id")) : Long.valueOf(declareDyn.getLong("org"));
        String declareType = declareDyn.getString("type");
        Map<String, Object> map = channelInfosMaps.get(orgId);
        if (map != null && (list = (List)map.get("channelinfos")) != null) {
            for (Map channel : list) {
                String type = (String)channel.get("declaretype");
                if (!declareType.equals(type)) continue;
                String supplierCode = (String)channel.get("channelnumber");
                return SupplierEnum.valueOfCode((String)supplierCode);
            }
        }
        return null;
    }

    private static SupplierEnum getFusionDeclareSupplierFromConfigFusion(Map<Long, Map<String, Object>> channelInfosMaps, DynamicObject declareDyn) {
        List list;
        Object org = declareDyn.get("org");
        Long orgId = org instanceof DynamicObject ? Long.valueOf(declareDyn.getLong("org.id")) : Long.valueOf(declareDyn.getLong("org"));
        String declareType = DeclarationMainFormBusniess.getDeclareTypeByModel3(declareDyn);
        Map<String, Object> map = channelInfosMaps.get(orgId);
        if (map != null && (list = (List)map.get("channelinfos")) != null) {
            for (Map channel : list) {
                String type = (String)channel.get("declaretype");
                if (!declareType.equals(type)) continue;
                String supplierCode = (String)channel.get("channelnumber");
                return SupplierEnum.valueOfCode((String)supplierCode);
            }
        }
        return null;
    }

    public static String serializeConfig(Map<Long, Map<String, Object>> config) {
        return JSON.toJSONString(config);
    }

    public static Map<Long, Map<String, Object>> deSerializeConfig(String configStr) {
        Map data = (Map)JSONObject.parse((String)configStr);
        for (Map orgMap : data.values()) {
            TsateChannelBusiness.formatLongValue(orgMap, "id");
            TsateChannelBusiness.formatLongValue(orgMap, "taxofficeid");
            List channelInfos = (List)orgMap.get("channelinfos");
            if (channelInfos == null) continue;
            for (Map channelItem : channelInfos) {
                TsateChannelBusiness.formatLongValue(channelItem, "parentTaxId");
                TsateChannelBusiness.formatLongValue(channelItem, "taxId");
                TsateChannelBusiness.formatLongValue(channelItem, "channelid");
            }
        }
        return data;
    }

    private static void formatLongValue(Map<String, Object> map, String key) {
        map.put(key, TsateChannelBusiness.fomatLong(map.get(key)));
    }

    private static Long fomatLong(Object data) {
        if (data instanceof Long) {
            return (Long)data;
        }
        if (data instanceof Integer) {
            Integer d = (Integer)data;
            return d.longValue();
        }
        if (data instanceof String) {
            return Long.parseLong((String)data);
        }
        return null;
    }

    public static DynamicObject getChannel(Long sbbId) {
        DynamicObject declareObj = DeclarationMainFormBusniess.queryOneByIdNotThrowEx(sbbId);
        return TsateChannelBusiness.getChannelByData(declareObj);
    }

    public static DynamicObject getChannelByData(DynamicObject declareData) {
        Long taxOrganId;
        if (declareData != null && (taxOrganId = CommonInfoUtil.getParentTaxauthorityById((Long)declareData.getLong("taxauthority.id"))) != null && taxOrganId != 0L) {
            QFilter qFilter = new QFilter("enable", "=", (Object)"1").and(new QFilter("taxorgancopy.fbasedataid", "=", (Object)taxOrganId)).and(new QFilter("taxtypecopy.fbasedataid", "=", (Object)DeclarationMainFormBusniess.getDeclareTypeByModel3(declareData)));
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)TSATE_DECLARE_CHANNEL, (String)"id,declarechannel", (QFilter[])new QFilter[]{qFilter});
            return obj;
        }
        return null;
    }

    public static DynamicObject getAreaInfo(Long sbbId) {
        DynamicObject declareObj = DeclarationMainFormBusniess.queryOneByIdNotThrowEx(sbbId);
        return TsateChannelBusiness.getAreaInfoByData(declareObj);
    }

    public static DynamicObject getAreaInfoByData(DynamicObject declareData) {
        String declareTypeByModel3;
        QFilter qFilter;
        DynamicObject obj;
        Long taxOrganId;
        if (declareData != null && (taxOrganId = TsateChannelBusiness.getParentTaxauthorityById(declareData.getLong("taxauthority.id"))) != null && taxOrganId != 0L && (obj = BusinessDataServiceHelper.loadSingle((String)TSATE_DECLARE_CHANNEL, (String)"id,channel,declarechannel", (QFilter[])new QFilter[]{qFilter = new QFilter("taxorgancopy.fbasedataid", "=", (Object)taxOrganId).and(new QFilter("taxtypecopy.fbasedataid", "=", (Object)(declareTypeByModel3 = DeclarationMainFormBusniess.getDeclareTypeByModel3(declareData)))).and(new QFilter("enable", "=", (Object)"1"))})) != null) {
            QFilter baseFilter = new QFilter("taxorgan", "=", (Object)taxOrganId).and(new QFilter("declarechannel", "=", (Object)obj.getDynamicObject("declarechannel").getLong("id")));
            return QueryServiceHelper.queryOne((String)"tsate_declare_base", (String)"xzqh,isspecial", (QFilter[])new QFilter[]{baseFilter});
        }
        return null;
    }
}

