/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.tsate.business.AbstractBaseBusiness;

public class TsateChannelDbBusiness
extends AbstractBaseBusiness {
    private static Log logger = LogFactory.getLog(TsateChannelDbBusiness.class);
    private static final String ALGOKEY = "TsateChannelDbBusiness";
    private static final String DBKEY_TAX = "taxc";
    private static final String DBKEY_SYS = "sys";

    public static Map<Long, Map<String, Object>> getChannelConfigByOrgId(Collection orgIds) {
        List<Map<String, Object>> taxMainList = TsateChannelDbBusiness.queryTaxmain(orgIds, true);
        Set<Long> taxofficeIds = taxMainList.stream().map(map -> (Long)map.get("taxofficeid")).collect(Collectors.toSet());
        Map<Long, Long> taxofficeIdWithParent = TsateChannelDbBusiness.getTaxofficIdWithParent(taxofficeIds);
        List<Map<String, Object>> configList = TsateChannelDbBusiness.queryChannelConfig(true);
        HashMap<Long, Map<String, Object>> maps = new HashMap<Long, Map<String, Object>>(8);
        taxMainList.forEach(taxmain -> {
            HashMap<String, Object> orgConfig = new HashMap<String, Object>(8);
            Long id = (Long)taxmain.get("orgid");
            Long taxofficeid = (Long)taxmain.get("taxofficeid");
            Long parenttaxofficeid = (Long)taxofficeIdWithParent.get(taxofficeid);
            List<Map<String, Object>> taxofficeConfigList = TsateChannelDbBusiness.filterConfigList(configList, parenttaxofficeid);
            orgConfig.put("orgid", id);
            orgConfig.put("taxofficeid", taxofficeid);
            orgConfig.put("channelinfos", taxofficeConfigList);
            maps.put(id, orgConfig);
        });
        return maps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Map<String, Object>> queryTaxmain(Collection<Long> orgIds, Boolean enable) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(8);
        StringBuilder sql = new StringBuilder();
        sql.append("select t1.forgid ,t1.ftaxoffice from t_tctb_tax_main t1 where 1=1");
        if (orgIds != null && orgIds.size() > 0) {
            sql.append(" and forgid in (");
            orgIds.forEach(orgId -> sql.append(orgId).append(","));
            sql.deleteCharAt(sql.length() - 1);
            sql.append(")");
        }
        try (DataSet datas = null;){
            datas = DB.queryDataSet((String)ALGOKEY, (DBRoute)DBRoute.of((String)DBKEY_TAX), (String)sql.toString());
            while (datas.hasNext()) {
                Row row = datas.next();
                Long forgid = row.getLong("forgid");
                Long ftaxoffice = row.getLong("ftaxoffice");
                HashMap<String, Long> map = new HashMap<String, Long>(8);
                map.put("orgid", forgid);
                map.put("taxofficeid", ftaxoffice);
                list.add(map);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Map<String, Object>> queryTaxoffice(Collection<Long> taxofficeIds, Collection<String> numbers, Boolean enable) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(8);
        StringBuilder sql = new StringBuilder();
        sql.append("select fid,fnumber,flongnumber  from t_bastax_taxorgan t1 where 1=1 ");
        if (taxofficeIds != null && taxofficeIds.size() > 0) {
            sql.append(" and fid in (");
            taxofficeIds.forEach(id -> sql.append(id).append(","));
            sql.deleteCharAt(sql.length() - 1);
            sql.append(")");
        }
        if (numbers != null && numbers.size() > 0) {
            sql.append(" and fnumber in (");
            numbers.forEach(num -> sql.append("'").append((String)num).append("'").append(","));
            sql.deleteCharAt(sql.length() - 1);
            sql.append(")");
        }
        if (enable != null) {
            if (enable.booleanValue()) {
                sql.append(" and t1.fenable='1'");
            } else {
                sql.append(" and t1.fenable='0'");
            }
        }
        try (DataSet datas = null;){
            datas = DB.queryDataSet((String)ALGOKEY, (DBRoute)DBRoute.of((String)DBKEY_SYS), (String)sql.toString());
            while (datas.hasNext()) {
                Row row = datas.next();
                Long fid = row.getLong("fid");
                String fnumber = row.getString("fnumber");
                String flongnumber = row.getString("flongnumber");
                HashMap<String, Object> map = new HashMap<String, Object>(8);
                map.put("id", fid);
                map.put("number", fnumber);
                map.put("longnumber", flongnumber);
                String[] ns = flongnumber.split("\\.");
                if (ns.length > 0) {
                    String parentnumber = ns[0];
                    map.put("parentnumber", parentnumber);
                }
                list.add(map);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Map<String, Object>> queryChannelConfig(Boolean configEnable) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(8);
        StringBuilder sql = new StringBuilder();
        sql.append("select t1.fid configid,t1.fdeclarechannel channelid ,t4.fnumber channelnumber ,t4.fname channelname,t2.fbasedataid taxofficeid,t3.fbasedataid declaretypeid,t5.fnumber declaretypenumber");
        sql.append(" from t_tsate_channel_config t1");
        sql.append(" left join t_tsate_declare_taxorgan t2 on t1.fid=t2.fid");
        sql.append(" left join t_tsate_declare_taxtype t3 on t1.fid=t3.fid");
        sql.append(" left join t_tsate_channel t4 on t1.fdeclarechannel =t4.fid");
        sql.append(" left join t_tctb_template_type t5 on t3.fbasedataid =t5.fid");
        sql.append(" where 1=1 ");
        if (configEnable != null) {
            if (configEnable.booleanValue()) {
                sql.append(" and t1.fenable='1'");
            } else {
                sql.append(" and t1.fenable='0'");
            }
        }
        try (DataSet datas = null;){
            datas = DB.queryDataSet((String)ALGOKEY, (DBRoute)DBRoute.of((String)DBKEY_TAX), (String)sql.toString());
            while (datas.hasNext()) {
                Row row = datas.next();
                Long id = row.getLong("configid");
                Long taxofficeid = row.getLong("taxofficeid");
                String channelid = row.getString("channelid");
                String channelnumber = row.getString("channelnumber");
                String channelname = row.getString("channelname");
                String declaretypeid = row.getString("declaretypeid");
                String declaretypenumber = row.getString("declaretypenumber");
                HashMap<String, Object> map = new HashMap<String, Object>(8);
                map.put("id", id);
                map.put("taxofficeid", taxofficeid);
                map.put("channelid", channelid);
                map.put("channelnumber", channelnumber);
                map.put("channelname", channelname);
                map.put("declaretypeid", declaretypeid);
                map.put("declaretypenumber", declaretypenumber);
                list.add(map);
            }
        }
        return list;
    }

    private static Map<Long, Long> getTaxofficIdWithParent(Collection<Long> ids) {
        List<Map<String, Object>> taxOfficeList = TsateChannelDbBusiness.queryTaxoffice(ids, null, true);
        Set<String> taxofficeLongparentnumbers = taxOfficeList.stream().map(map -> {
            String[] numbers;
            String longnumber = (String)map.get("longnumber");
            String parentnumber = null;
            if (longnumber != null && (numbers = longnumber.split("\\.")).length > 0) {
                parentnumber = numbers[0];
                map.put("parentnumber", parentnumber);
            }
            return parentnumber;
        }).collect(Collectors.toSet());
        List<Map<String, Object>> parentTaxofficeList = TsateChannelDbBusiness.queryTaxoffice(null, taxofficeLongparentnumbers, true);
        HashMap numberWithId = new HashMap(8);
        parentTaxofficeList.stream().forEach(map -> {
            String number = (String)map.get("number");
            Long id = (Long)map.get("id");
            numberWithId.put(number, id);
        });
        HashMap<Long, Long> taxofficeidWithParentId = new HashMap<Long, Long>(8);
        taxOfficeList.forEach(map -> {
            Long officeid = (Long)map.get("id");
            String parentNumber = (String)map.get("parentnumber");
            Long parentOfficeid = (Long)numberWithId.get(parentNumber);
            taxofficeidWithParentId.put(officeid, parentOfficeid);
        });
        return taxofficeidWithParentId;
    }

    private static List<Map<String, Object>> filterConfigList(List<Map<String, Object>> configList, Long taxofficeId) {
        if (taxofficeId == null) {
            return new ArrayList<Map<String, Object>>(0);
        }
        List<Map<String, Object>> map = configList.stream().filter(config -> {
            Long configTaxofficceId = (Long)config.get("taxofficeid");
            return taxofficeId.equals(configTaxofficceId);
        }).collect(Collectors.toList());
        return map;
    }

    public static String getChannelNumberFromConfig(Long orgId, String declareType, Map<Long, Map<String, Object>> config) {
        List list;
        if (config.containsKey(orgId) && (list = (List)config.get(orgId).getOrDefault("channelinfos", new ArrayList(0))) != null) {
            Object channelNumber = null;
            for (Map item : list) {
                if (declareType == null) {
                    channelNumber = item.get("channelnumber");
                    break;
                }
                if (!declareType.equals(item.get("declaretypenumber"))) continue;
                channelNumber = item.get("channelnumber");
                break;
            }
            if (channelNumber != null) {
                return channelNumber.toString();
            }
        }
        return null;
    }
}

