/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tsate.business.AbstractBaseBusiness;
import kd.taxc.tsate.business.TsateTaskTypeBusiness;
import kd.taxc.tsate.common.ext.cloudcc.utils.Md5Utils;
import kd.taxc.tsate.common.metadata.MetadataUtil;
import kd.taxc.tsate.common.util.DateUtils;

public class TsateDeclareChecklistBusiness
extends AbstractBaseBusiness {
    private static final String META_ENTITYID = "tsate_declare_checklist";
    private static final String NEW_META_ENTITYID = "tsate_checklist_group";
    private static final String COPY_FIELDS = "taxorg,sbsx,zsxm,zspm,skssqz,skssqq,sbqx,sbrq,sbzt,jkzt";
    private static final String DOWNLOAD_SOURCE = "1";
    private static final String HANDWORK_SOURCE = "2";

    public static DynamicObject newInstance(Long orgId, Long taxorgId, String sbsx, Long zsxmId, Long zspmId, Date ssqq, Date ssqz, Date sbqx, Date sbrq, String declareStatus, String payStatus, String source, Long createor, Date operateTime) {
        return TsateDeclareChecklistBusiness.newInstance(null, orgId, taxorgId, sbsx, zsxmId, zspmId, ssqq, ssqz, sbqx, sbrq, declareStatus, payStatus, source, createor, operateTime);
    }

    public static void newInstanceExtFill(DynamicObject dyn, String key, String value) {
        dyn.set(key, (Object)value);
    }

    public static DynamicObject newInstance(Long id, Long orgId, Long taxorgId, String sbsx, Long zsxmId, Long zspmId, Date ssqq, Date ssqz, Date sbqx, Date sbrq, String declareStatus, String payStatus, String source, Long createor, Date operateTime) {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)NEW_META_ENTITYID);
        if (id != null) {
            obj.set("id", (Object)id);
        }
        obj.set("org", (Object)orgId);
        obj.set("taxorg", (Object)taxorgId);
        obj.set("sbsx", (Object)sbsx);
        obj.set("zsxm", (Object)zsxmId);
        if (zspmId != null) {
            obj.set("zspm", (Object)zspmId);
        }
        obj.set("skssqz", (Object)ssqz);
        obj.set("skssqq", (Object)ssqq);
        obj.set("sbqx", (Object)sbqx);
        obj.set("sbrq", (Object)sbrq);
        obj.set("sbzt", (Object)declareStatus);
        obj.set("jkzt", (Object)payStatus);
        obj.set("gxsj", (Object)new Date());
        obj.set("creator", (Object)createor);
        obj.set("createtime", (Object)operateTime);
        obj.set("datasource", (Object)source);
        String uniqueCode = TsateDeclareChecklistBusiness.getUniqueCode(orgId, zsxmId, zspmId, ssqq, ssqz);
        obj.set("uniquecode", (Object)uniqueCode);
        obj.set("gxsj", (Object)new Date());
        obj.set("billstatus", (Object)"A");
        return obj;
    }

    public static DynamicObjectCollection getByOrg(Long[] orgids, Date sbqxStart, Date sbqxEnd) {
        QFilter orgFilter = new QFilter("org.id", "in", (Object)orgids);
        QFilter sbqxFilter = new QFilter("sbqx", ">=", (Object)sbqxStart).and(new QFilter("sbqx", "<=", (Object)sbqxEnd));
        return QueryServiceHelper.query((String)META_ENTITYID, (String)MetadataUtil.getAllFieldString((String)META_ENTITYID), (QFilter[])new QFilter[]{orgFilter, sbqxFilter});
    }

    public static DynamicObject[] getByOrgAndSkssq(Long[] orgids, Date ssqqMin, Date ssqzMax) {
        QFilter orgFilter = new QFilter("org.id", "in", (Object)orgids);
        QFilter sbqxFilter = new QFilter("skssqq", ">=", (Object)ssqqMin).and(new QFilter("skssqz", "<=", (Object)ssqzMax));
        return BusinessDataServiceHelper.load((String)META_ENTITYID, (String)MetadataUtil.getAllFieldString((String)META_ENTITYID), (QFilter[])new QFilter[]{orgFilter, sbqxFilter});
    }

    public static DynamicObjectCollection getByUniqueCode(String[] uniqueCodes, Date sbqxStart, Date sbqxEnd) {
        QFilter orgFilter = new QFilter("uniquecode", "in", (Object)uniqueCodes);
        QFilter sbqxFilter = new QFilter("sbqx", ">=", (Object)sbqxStart).and(new QFilter("sbqx", "<=", (Object)sbqxEnd));
        StringBuilder filds = new StringBuilder(MetadataUtil.getAllFieldString((String)META_ENTITYID));
        filds.append(",org.number");
        filds.append(",zsxm.number");
        filds.append(",zspm.number");
        return QueryServiceHelper.query((String)META_ENTITYID, (String)filds.toString(), (QFilter[])new QFilter[]{orgFilter, sbqxFilter});
    }

    public static DynamicObjectCollection getByUniqueCodeAndSkssq(String[] uniqueCodes, Date skssqq, Date skssqz) {
        QFilter orgFilter = new QFilter("uniquecode", "in", (Object)uniqueCodes);
        QFilter sbqxFilter = new QFilter("skssqq", ">=", (Object)skssqq).and(new QFilter("skssqz", "<=", (Object)skssqz));
        StringBuilder filds = new StringBuilder(MetadataUtil.getAllFieldString((String)META_ENTITYID));
        filds.append(",org.number");
        filds.append(",zsxm.number");
        filds.append(",zspm.number");
        return QueryServiceHelper.query((String)META_ENTITYID, (String)filds.toString(), (QFilter[])new QFilter[]{orgFilter, sbqxFilter});
    }

    public static String getUniqueCode(DynamicObject obj) {
        Long orgId = TsateDeclareChecklistBusiness.getIdParam(obj, "org");
        Long xmid = TsateDeclareChecklistBusiness.getIdParam(obj, "zsxm");
        Long pmid = TsateDeclareChecklistBusiness.getIdParam(obj, "zspm");
        Date qq = obj.getDate("skssqq");
        Date qz = obj.getDate("skssqz");
        return TsateDeclareChecklistBusiness.getUniqueCode(orgId, xmid, pmid, qq, qz);
    }

    public static String getUniqueCode(Long orgId, Long zsxmId, Long zspmId, Date skssqq, Date skssqz) {
        if (zspmId == null) {
            zspmId = 0L;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(orgId).append(DateUtils.format((Date)skssqq)).append(DateUtils.format((Date)skssqz)).append(zsxmId).append(zspmId);
        try {
            return Md5Utils.getEncode((byte[])sb.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static int[] batchUpdateOrSave(List<DynamicObject> sources, Date ssqqMin, Date ssqzMax) {
        Map<String, List<DynamicObject>> comparemap = TsateDeclareChecklistBusiness.compareAddOrUpdate(sources, ssqqMin, ssqzMax);
        List<DynamicObject> addList = comparemap.get("add");
        List<DynamicObject> updateList = comparemap.get("update");
        SaveServiceHelper.save((DynamicObject[])addList.toArray(new DynamicObject[addList.size()]));
        SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[updateList.size()]));
        int[] count = new int[]{sources.size(), addList.size(), updateList.size(), -1};
        return count;
    }

    public static Map<String, List<DynamicObject>> compareAddOrUpdate(List<DynamicObject> sources, Date ssqqMin, Date ssqzMax) {
        HashMap<String, List<DynamicObject>> target = new HashMap<String, List<DynamicObject>>(4);
        List add = target.computeIfAbsent("add", k -> new ArrayList());
        List update = target.computeIfAbsent("update", k -> new ArrayList());
        HashMap uniqueCodeSourceMaps = new HashMap();
        sources.forEach(dyn -> {
            String key = TsateDeclareChecklistBusiness.getUniqueCode(dyn);
            List list = uniqueCodeSourceMaps.computeIfAbsent(key, k -> new ArrayList());
            list.add(dyn);
        });
        Set<Long> orgIds = sources.parallelStream().map(obj -> obj.getLong("org")).collect(Collectors.toSet());
        DynamicObject[] records = TsateDeclareChecklistBusiness.getByOrgAndSkssq(orgIds.toArray(new Long[0]), ssqqMin, ssqzMax);
        HashMap<String, List> uniqueCodeRecordMaps = new HashMap<String, List>();
        for (DynamicObject dyn2 : records) {
            String key = TsateDeclareChecklistBusiness.getUniqueCode(dyn2);
            List list = uniqueCodeRecordMaps.computeIfAbsent(key, k -> new ArrayList());
            list.add(dyn2);
        }
        uniqueCodeSourceMaps.entrySet().forEach(kv -> {
            String uniqueCode = (String)kv.getKey();
            List sourcelist = (List)kv.getValue();
            for (DynamicObject objSource : sourcelist) {
                boolean dbExist = false;
                boolean dbSame = false;
                List recordList = (List)uniqueCodeRecordMaps.get(uniqueCode);
                if (recordList != null) {
                    for (DynamicObject objRecord : recordList) {
                        if (!TsateDeclareChecklistBusiness.uniqueCheck(objSource, objRecord)) continue;
                        dbExist = true;
                        objSource.set("id", objRecord.get("id"));
                        TsateDeclareChecklistBusiness.copyParams(objSource, objRecord);
                        objSource = objRecord;
                    }
                }
                if (!dbExist) {
                    add.add(objSource);
                    continue;
                }
                if (dbSame) continue;
                update.add(objSource);
            }
        });
        return target;
    }

    public static boolean uniqueCheck(DynamicObject o1, DynamicObject o2) {
        Long zspm2;
        Long zsxm2;
        Long orgId2;
        Long orgId1 = TsateDeclareChecklistBusiness.getIdParam(o1, "org");
        if (!TsateDeclareChecklistBusiness.equelLong(orgId1, orgId2 = TsateDeclareChecklistBusiness.getIdParam(o2, "org"))) {
            return false;
        }
        Long zsxm1 = TsateDeclareChecklistBusiness.getIdParam(o1, "zsxm");
        if (!TsateDeclareChecklistBusiness.equelLong(zsxm1, zsxm2 = TsateDeclareChecklistBusiness.getIdParam(o2, "zsxm"))) {
            return false;
        }
        Long zspm1 = TsateDeclareChecklistBusiness.getIdParam(o1, "zspm");
        if (!TsateDeclareChecklistBusiness.equelLong(zspm1, zspm2 = TsateDeclareChecklistBusiness.getIdParam(o2, "zspm"))) {
            return false;
        }
        Date skssqq1 = o1.getDate("skssqq");
        Date skssqq2 = o2.getDate("skssqq");
        if (!DateUtils.format((Date)skssqq1).equals(DateUtils.format((Date)skssqq2))) {
            return false;
        }
        Date skssqz1 = o1.getDate("skssqz");
        Date skssqz2 = o2.getDate("skssqz");
        return DateUtils.format((Date)skssqz1).equals(DateUtils.format((Date)skssqz2));
    }

    public static boolean sameCheck(DynamicObject o1, DynamicObject o2) {
        if (!TsateDeclareChecklistBusiness.uniqueCheck(o1, o2)) {
            return false;
        }
        String pay1 = o1.getString("jkzt");
        String pay2 = o2.getString("jkzt");
        String declare1 = o1.getString("sbzt");
        String declare2 = o2.getString("sbzt");
        boolean payflag = false;
        if (pay1 == null && pay2 == null) {
            payflag = true;
        } else if (pay1 != null && pay2 != null && pay1.equals(pay2)) {
            payflag = true;
        }
        boolean declareflag = false;
        if (declare1 == null && declare2 == null) {
            declareflag = true;
        } else if (declare1 != null && declare2 != null && declare1.equals(declare2)) {
            declareflag = true;
        }
        return payflag && declareflag;
    }

    public static DynamicObject getZsxmByName(String name) {
        QFilter filter = new QFilter("name", "=", (Object)name);
        return QueryServiceHelper.queryOne((String)"bd_taxcategory", (String)"id,number,name", (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObjectCollection getZsxmByNames(List<String> names) {
        QFilter filter = new QFilter("name", "in", names);
        return QueryServiceHelper.query((String)"bd_taxcategory", (String)"id,number,name", (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObject getZsxmByNumber(String number) {
        QFilter filter = new QFilter("number", "=", (Object)number);
        return QueryServiceHelper.queryOne((String)"bd_taxcategory", (String)"id,number,name", (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObject getZspmByName(String name) {
        QFilter filter = new QFilter("name", "=", (Object)name);
        return QueryServiceHelper.queryOne((String)"tpo_zspm", (String)"id,number,name", (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObjectCollection getZspmByNames(List<String> names) {
        QFilter filter = new QFilter("name", "in", names);
        return QueryServiceHelper.query((String)"tpo_zspm", (String)"id,number,name", (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObject getZspmByNumber(String number) {
        QFilter filter = new QFilter("number", "=", (Object)number);
        StringBuilder filds = new StringBuilder(MetadataUtil.getAllFieldString((String)"tpo_zspm"));
        return QueryServiceHelper.queryOne((String)"tpo_zspm", (String)filds.toString(), (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObjectCollection getZsxmByNumbers(Collection<String> numbers) {
        QFilter filter = new QFilter("number", "in", numbers);
        StringBuilder filds = new StringBuilder(MetadataUtil.getAllFieldString((String)"bd_taxcategory"));
        return QueryServiceHelper.query((String)"bd_taxcategory", (String)filds.toString(), (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObjectCollection getZspmByNumbers(Collection<String> numbers) {
        QFilter filter = new QFilter("number", "in", numbers);
        StringBuilder filds = new StringBuilder(MetadataUtil.getAllFieldString((String)"tpo_zspm"));
        return QueryServiceHelper.query((String)"tpo_zspm", (String)filds.toString(), (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObjectCollection checkIfExistTask(Collection<Long> orgids) {
        QFilter filter = new QFilter("org", "in", orgids).and(new QFilter("tasktype.number", "=", (Object)"SBSXXZ")).and(new QFilter("executestatus", "=", (Object)DOWNLOAD_SOURCE));
        StringBuilder filds = new StringBuilder(MetadataUtil.getAllFieldString((String)"tsate_declare_record"));
        filds.append(",org.name");
        return QueryServiceHelper.query((String)"tsate_declare_record", (String)filds.toString(), (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObject[] getExistTask(Collection<Long> orgids, List<DynamicObject> taskType) {
        List typeIds = taskType.stream().map(type -> type.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
        QFilter filter = new QFilter("org", "in", orgids).and(new QFilter("tasktype", "in", typeIds)).and(new QFilter("executestatus", "=", (Object)DOWNLOAD_SOURCE));
        StringBuilder filds = new StringBuilder(MetadataUtil.getAllFieldString((String)"tsate_declare_record"));
        filds.append(",org.name");
        DynamicObject[] target = BusinessDataServiceHelper.load((String)"tsate_declare_record", (String)filds.toString(), (QFilter[])new QFilter[]{filter});
        if (target == null) {
            target = new DynamicObject[]{};
        }
        return target;
    }

    public static void copyParams(DynamicObject source, DynamicObject target) {
        TsateDeclareChecklistBusiness.copyParam(source, target, "sbsx");
        TsateDeclareChecklistBusiness.copyParam(source, target, "sbqx");
        TsateDeclareChecklistBusiness.copyParam(source, target, "sbrq");
        TsateDeclareChecklistBusiness.copyParam(source, target, "sbzt");
        TsateDeclareChecklistBusiness.copyParam(source, target, "jkzt");
        TsateDeclareChecklistBusiness.copyParam(source, target, "gxsj");
        TsateDeclareChecklistBusiness.copyParam(source, target, "creator");
        TsateDeclareChecklistBusiness.copyParam(source, target, "createtime");
        TsateDeclareChecklistBusiness.copyParam(source, target, "datasource");
        TsateDeclareChecklistBusiness.copyParam(source, target, "gxsj");
        TsateDeclareChecklistBusiness.copyParam(source, target, "swjgmc");
    }

    public static void deleteByModifyDate(Long orgId, Date downLoadTime, Long taskId) {
        QFilter filter = new QFilter("org", "=", (Object)orgId).and("tasktype", "=", (Object)taskId);
        filter.and("datasource", "=", (Object)DOWNLOAD_SOURCE).and("rqfz", "=", (Object)downLoadTime);
        DeleteServiceHelper.delete((String)NEW_META_ENTITYID, (QFilter[])new QFilter[]{filter});
    }

    public static void deleteByCurrentMonth(Long orgId, Date downLoadTime, Long taskId) {
        TsateDeclareChecklistBusiness.deleteByModifyDate(orgId, downLoadTime, taskId);
    }

    private static void copyParam(DynamicObject source, DynamicObject target, String paramKey) {
        target.set(paramKey, source.get(paramKey));
    }

    private static Long getIdParam(DynamicObject obj, String paramKey) {
        Object value = obj.get(paramKey);
        if (value instanceof DynamicObject) {
            String realKey = paramKey + ".id";
            return obj.getLong(realKey);
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return null;
    }

    private static boolean equelLong(Long l1, Long l2) {
        if (l1 != null) {
            return l1.equals(l2);
        }
        if (l2 != null) {
            return l2.equals(l1);
        }
        return true;
    }

    public static DynamicObject newGroupInstance(Long orgId, String source, Long createor, Date operateTime, Date downLoadTime, Long type, String xqzs) {
        DynamicObject checklistGroup = BusinessDataServiceHelper.newDynamicObject((String)NEW_META_ENTITYID);
        checklistGroup.set("billstatus", (Object)"A");
        checklistGroup.set("org", (Object)orgId);
        checklistGroup.set("gxsj", (Object)operateTime);
        checklistGroup.set("datasource", (Object)source);
        checklistGroup.set("xqzs", (Object)xqzs);
        checklistGroup.set("creator", (Object)createor);
        checklistGroup.set("rqfz", (Object)downLoadTime);
        checklistGroup.set("historyflag", (Object)"0");
        if (type == null) {
            DynamicObjectCollection byTakeNumber = TsateTaskTypeBusiness.getByTakeNumber("SBSXXZ", null);
            type = ((DynamicObject)byTakeNumber.get(0)).getLong("id");
        }
        checklistGroup.set("tasktype", (Object)type);
        return checklistGroup;
    }

    public static DynamicObject newInstanceBody(DynamicObjectCollection checklist, Long taxorgId, String sbsx, long zsxmId, Long zspmId, Date ssqq, Date ssqz, Date sbqx, Date sbrq, String declareStatus, String payStatus) {
        DynamicObject abody = new DynamicObject(checklist.getDynamicObjectType());
        abody.set("taxorg", (Object)taxorgId);
        abody.set("sbsx", (Object)sbsx);
        abody.set("zsxm", (Object)zsxmId);
        if (zspmId != null) {
            abody.set("zspm", (Object)zspmId);
        }
        abody.set("skssqz", (Object)ssqz);
        abody.set("skssqq", (Object)ssqq);
        abody.set("sbqx", (Object)sbqx);
        abody.set("sbrq", (Object)sbrq);
        abody.set("sbzt", (Object)declareStatus);
        abody.set("jkzt", (Object)payStatus);
        abody.set("compareresult", (Object)"0");
        checklist.add((Object)abody);
        return abody;
    }

    public static DynamicObject newInstanceBody(DynamicObjectCollection checklist, Map<String, Object> dataMap) {
        DynamicObject abody = new DynamicObject(checklist.getDynamicObjectType());
        for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
            abody.set(entry.getKey(), entry.getValue());
        }
        return abody;
    }

    public static void savaGroupByCurrentMonth(DynamicObject checklistGroup, Date downLoadTime, Long taskId) {
        TsateDeclareChecklistBusiness.deleteByCurrentMonth(checklistGroup.getLong("org"), downLoadTime, taskId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checklistGroup});
    }

    public static DynamicObjectCollection newBodyByChecklisHead(DynamicObject checklistGroup) {
        return checklistGroup.getDynamicObjectCollection("checklist");
    }

    public static void createBodyByObject(DynamicObjectCollection checklist, DynamicObject object, String fields, String regx) {
        DynamicObject abody = new DynamicObject(checklist.getDynamicObjectType());
        TsateDeclareChecklistBusiness.copyFieldsByString(object, abody, fields, regx);
        checklist.add((Object)abody);
    }

    public static DynamicObject[] getHistoryData() {
        QFilter filter = new QFilter("historyflag", "=", (Object)DOWNLOAD_SOURCE);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)NEW_META_ENTITYID, (String)"checklist", (QFilter[])filter.toArray());
        return load;
    }

    public static DynamicObject getById(Long id) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        DynamicObject groupData = BusinessDataServiceHelper.loadSingle((String)NEW_META_ENTITYID, (String)"id,org.name,billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,org,gxsj,datasource,checklist,xqzs,rqfz,swjgmc,tasktype,historyflag,checklist.seq,checklist.bodymodifier,checklist.bodymodifydatefied,checklist.taxorg,checklist.sbsx,checklist.zsxm,checklist.zspm,checklist.skssqq,checklist.skssqz,checklist.sbqx,checklist.jkqx,checklist.sbzt,checklist.jkzt,checklist.ybtse,checklist.ynse,checklist.skzt,checklist.sbrq,checklist.jkrq,checklist.znj,checklist.yjse,checklist.sjje,checklist.yzpzxh,checklist.sksx,checklist.dzsph,checklist.sbjg,checklist.compareresult,checklist.releasedate,checklist.yzpzzlmc", (QFilter[])filter.toArray());
        if (groupData == null) {
            return null;
        }
        return groupData;
    }
}

