/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.taxc.tsate.business.config.TsateCommonConfig;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.DeclareTypeEnum;
import kd.taxc.tsate.common.enums.SupportHistoryDataEnum;
import kd.taxc.tsate.common.enums.SupportQcDataEnum;

public class TsateDeclareHistoryBusiness {
    public static final String DECLAREDATATYPE_INIT = "0";
    public static final String DECLAREDATATYPE_HISTORY = "1";

    public static Set<SupplierEnum> selectSupportSupplier(Set<SupplierEnum> orgSuppliers, String dataType, DeclareTypeEnum declareType) {
        HashSet<SupplierEnum> sets = new HashSet<SupplierEnum>(8);
        if (DECLAREDATATYPE_INIT.equals(dataType)) {
            for (SupplierEnum supplier : orgSuppliers) {
                SupportQcDataEnum support = SupportQcDataEnum.valueOfSupplier((SupplierEnum)supplier);
                if (support == null || !support.containsType(declareType)) continue;
                sets.add(supplier);
            }
        } else {
            for (SupplierEnum supplier : orgSuppliers) {
                SupportHistoryDataEnum support = SupportHistoryDataEnum.valueOfSupplier((SupplierEnum)supplier);
                if (support == null || !support.containsType(declareType)) continue;
                sets.add(supplier);
            }
        }
        return sets;
    }

    public static SupplierEnum selectSupportSupplierFirst(Set<SupplierEnum> orgSuppliers, String dataType, DeclareTypeEnum declareType) {
        Set<SupplierEnum> sets = TsateDeclareHistoryBusiness.selectSupportSupplier(orgSuppliers, dataType, declareType);
        if (sets.size() > 0) {
            ArrayList<SupplierEnum> list = new ArrayList<SupplierEnum>();
            list.addAll(sets);
            return (SupplierEnum)list.get(0);
        }
        return null;
    }

    public static Set<String> getDeclareDataType(List<Long> orgIds, DeclareTypeEnum declareType) {
        HashSet<String> supportDeclareDataType = new HashSet<String>();
        if (orgIds == null || orgIds.isEmpty()) {
            return supportDeclareDataType;
        }
        HashSet<SupplierEnum> supportSuppliers = new HashSet<SupplierEnum>();
        supportSuppliers.add(SupplierEnum.QXY);
        supportSuppliers.add(SupplierEnum.ZWY);
        HashSet<SupplierEnum> supplierSet = new HashSet<SupplierEnum>();
        TsateCommonConfig instance = TsateCommonConfig.getInstance();
        for (Long orgId : orgIds) {
            Set<SupplierEnum> suppliers = instance.getAllSupplier(orgId);
            if (suppliers == null || suppliers.isEmpty()) continue;
            for (SupplierEnum supplier : suppliers) {
                if (!supportSuppliers.contains(supplier)) continue;
                supplierSet.add(supplier);
            }
            if (supplierSet.size() != supportSuppliers.size()) continue;
            break;
        }
        if (supplierSet.isEmpty()) {
            return supportDeclareDataType;
        }
        for (SupplierEnum supplier : supplierSet) {
            SupportHistoryDataEnum supportHistoryDataEnum;
            SupportQcDataEnum supportQcDataEnum = SupportQcDataEnum.valueOfSupplier((SupplierEnum)supplier);
            if (supportQcDataEnum != null && supportQcDataEnum.containsType(declareType)) {
                supportDeclareDataType.add(DECLAREDATATYPE_INIT);
            }
            if ((supportHistoryDataEnum = SupportHistoryDataEnum.valueOfSupplier((SupplierEnum)supplier)) != null && supportHistoryDataEnum.containsType(declareType)) {
                supportDeclareDataType.add(DECLAREDATATYPE_HISTORY);
            }
            if (supportDeclareDataType.size() != supportSuppliers.size()) continue;
            break;
        }
        return supportDeclareDataType;
    }
}

