/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;
import kd.taxc.tsate.business.TsateDeclareChecklistBusiness;
import kd.taxc.tsate.business.declare.declaremain.DeclarationMainFormBusniess;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.DeclareStatusEnum;
import kd.taxc.tsate.common.enums.DeclareTypeEnum;
import kd.taxc.tsate.common.enums.ExecuteStatusEnum;
import kd.taxc.tsate.common.enums.ExecuteTypeEnums;
import kd.taxc.tsate.common.metadata.MetadataUtil;
import kd.taxc.tsate.common.task.TaskBaseVo;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.FileUploadUtils;
import kd.taxc.tsate.common.util.InputStreamUtils;
import org.apache.commons.collections.CollectionUtils;

public class TsateDeclareRecordBusiness {
    private static Log LOGGER = LogFactory.getLog(TsateDeclareRecordBusiness.class);
    private static final String META_KEY = "tsate_declare_record";
    public static final String NUMBER = "number";
    public static final String ID = "id";
    public static final Integer LOG_MAX_LENGTH = 1000;
    public static final String SUFFIX = "...";
    private static final String PICLOG_URLLIST = "imageUrlList";

    public static DynamicObject[] loadBySbbIdsAndExecuteType(List<String> sbbIds, ExecuteTypeEnums executeType) {
        return BusinessDataServiceHelper.load((String)META_KEY, (String)"id,billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,org,skssqq,skssqz,executetype,executestatus,deallog,type,detaillog,detaillog_tag,channel,sbbid,sbqj,piclog,declarechannel,tasktype,taxtype", (QFilter[])new QFilter[]{new QFilter("sbbid", "in", sbbIds).and("tasktype", "=", (Object)executeType.getId())});
    }

    public static DynamicObjectCollection queryBySbbIdExecuteStatusDescByCreateTime(String sbbid, ExecuteStatusEnum status, ExecuteTypeEnums executeType) {
        return QueryServiceHelper.query((String)META_KEY, (String)"id,billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,org,skssqq,skssqz,executetype,executestatus,deallog,type,detaillog,detaillog_tag,channel,sbbid,sbqj,piclog,declarechannel,tasktype,taxtype", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)sbbid).and("executestatus", "=", (Object)status.getCode()).and("executetype", "=", (Object)executeType.getExecuteType())}, (String)"createtime desc");
    }

    public static DynamicObjectCollection queryRunningRecord(Long timeOut, Long beforRunTime, SupplierEnum supplier, ExecuteTypeEnums executeType) {
        QFilter filter = new QFilter("executestatus", "=", (Object)ExecuteStatusEnum.PROCESSING.getCode());
        filter.and("channel", "=", (Object)supplier.getCode());
        filter.and("executetype", "=", (Object)executeType.getExecuteType());
        Date timeout = new Date(System.currentTimeMillis() - timeOut);
        Date beforTimeOut = new Date(System.currentTimeMillis() - beforRunTime);
        filter.and("createtime", ">=", (Object)timeout);
        filter.and("createtime", "<=", (Object)beforTimeOut);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)META_KEY, (String)"id,billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,org,skssqq,skssqz,executetype,executestatus,deallog,type,detaillog,detaillog_tag,channel,sbbid,sbqj,piclog,declarechannel,tasktype,taxtype", (QFilter[])new QFilter[]{filter});
        return collection;
    }

    public static DynamicObjectCollection queryAllRunningRecordByTimeOrSbbid(Long timeOut, Long beforeRunTime, List<ExecuteTypeEnums> executeTypes, List<Long> sbbIds) {
        QFilter timeFilter = new QFilter("executestatus", "=", (Object)ExecuteStatusEnum.PROCESSING.getCode());
        if (CollectionUtils.isNotEmpty(executeTypes)) {
            List executeTypesCode = executeTypes.stream().map(o -> o.getExecuteType()).collect(Collectors.toList());
            timeFilter.and("executetype", "in", executeTypesCode);
        }
        Date timeout = new Date(System.currentTimeMillis() - timeOut);
        Date beforeTimeOut = new Date(System.currentTimeMillis() - beforeRunTime);
        timeFilter.and("createtime", ">=", (Object)timeout);
        timeFilter.and("createtime", "<=", (Object)beforeTimeOut);
        if (CollectionUtils.isNotEmpty(sbbIds)) {
            QFilter sbbFilter = timeFilter.__copy(false);
            sbbFilter = sbbFilter.and("sbbid", "in", sbbIds.stream().map(sbbid -> sbbid + "").collect(Collectors.toList()));
            timeFilter.or(sbbFilter);
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)META_KEY, (String)"id,billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,org,skssqq,skssqz,executetype,executestatus,deallog,type,detaillog,channel,sbbid,sbqj,piclog,declarechannel,tasktype,taxtype", (QFilter[])new QFilter[]{timeFilter});
        return collection;
    }

    public static void setLogDetail(DynamicObject dynamicObject, StringBuilder log) {
        if (log == null) {
            return;
        }
        String logDetail = log.toString();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)logDetail)) {
            return;
        }
        TsateDeclareRecordBusiness.setLogDetail(dynamicObject, logDetail);
    }

    public static void setLogDetail(DynamicObject dynamicObject, String logDetail) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)logDetail)) {
            return;
        }
        if (logDetail.length() > LOG_MAX_LENGTH) {
            logDetail = logDetail.substring(0, LOG_MAX_LENGTH - SUFFIX.length()) + SUFFIX;
        }
        dynamicObject.set("logdetail", (Object)logDetail);
    }

    public static DynamicObject assembleDeclareRecord(String orgId, ExecuteTypeEnums type, SupplierEnum supplier) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)META_KEY);
        dynamicObject.set("org", (Object)orgId);
        dynamicObject.set("skssqq", null);
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("creator", (Object)RequestContext.get().getUserId());
        dynamicObject.set("executestatus", (Object)"1");
        dynamicObject.set("skssqz", null);
        dynamicObject.set("type", null);
        dynamicObject.set("billstatus", (Object)"C");
        dynamicObject.set("executetype", (Object)type.getExecuteType());
        dynamicObject.set("tasktype", (Object)type.getId());
        dynamicObject.set("channel", (Object)supplier.getCode());
        dynamicObject.set("declarechannel", (Object)supplier.getId());
        DynamicObject[] objs = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        dynamicObject = objs[0];
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        codeRuleService.getNumber(META_KEY, dynamicObject, null);
        String number = codeRuleService.readNumber(META_KEY, dynamicObject, null);
        dynamicObject.set("billno", (Object)number);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
        return dynamicObject;
    }

    public static DynamicObject getRecordBySbbid(Long sbbid, DeclareStatusEnum declareStatus) {
        DynamicObjectCollection dyns;
        QFilter q = new QFilter("sbbid", "=", (Object)(sbbid + ""));
        if (declareStatus != null) {
            ExecuteStatusEnum executeStatus = TsateDeclareRecordBusiness.getExecuteStatusByDeclareStatus(declareStatus);
            q.and("executestatus", "=", (Object)executeStatus.getCode());
        }
        if ((dyns = QueryServiceHelper.query((String)META_KEY, (String)MetadataUtil.getAllFieldString((String)META_KEY), (QFilter[])new QFilter[]{q}, (String)"createtime desc")).size() > 0) {
            return (DynamicObject)dyns.get(0);
        }
        return null;
    }

    public static DynamicObject getRecordById(Long recordId) {
        return BusinessDataServiceHelper.loadSingle((String)META_KEY, (String)"id,billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,importlogs,org,skssqq,skssqz,executetype,executestatus,deallog,type,detaillog,detaillog_tag,channel,sbbid,sbqj,piclog,declarechannel,tasktype,taxtype,importlogs.seq,importlogs.logtitle,importlogs.log,logdetail", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)recordId)});
    }

    public static DynamicObject[] getRunningRecordByIds(List<Long> recordIds) {
        return BusinessDataServiceHelper.load((String)META_KEY, (String)"id,billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,importlogs,org,skssqq,skssqz,executetype,executestatus,deallog,type,detaillog,detaillog_tag,channel,sbbid,sbqj,piclog,declarechannel,tasktype,taxtype,importlogs.seq,importlogs.logtitle,importlogs.log,logdetail", (QFilter[])new QFilter[]{new QFilter(ID, "in", recordIds).and("executestatus", "=", (Object)ExecuteStatusEnum.PROCESSING.getCode())});
    }

    public static DynamicObject getRecordByIdAndStatus(Long recordId, ExecuteStatusEnum executeStatus) {
        return BusinessDataServiceHelper.loadSingle((String)META_KEY, (String)"id,billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,importlogs,org,skssqq,skssqz,executetype,executestatus,deallog,type,detaillog,detaillog_tag,channel,sbbid,sbqj,piclog,declarechannel,tasktype,taxtype,importlogs.seq,importlogs.logtitle,importlogs.log", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)recordId).and("executestatus", "=", (Object)executeStatus.getCode())});
    }

    public static String getDeallogMessage(DynamicObject dyn) {
        String data = dyn.getString("deallog");
        StringBuilder message = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)data)) {
            String log = null;
            if (data.startsWith("FILE:")) {
                FileService fileService = FileServiceFactory.getAttachmentFileService();
                InputStream in = fileService.getInputStream(data.substring(5));
                log = InputStreamUtils.getStringByInputStream((InputStream)in);
            } else {
                log = data;
            }
            message.append(log);
        }
        return message.toString();
    }

    public static DynamicObject getRecordByBusinessField(String orgId, String taskCode, String channelCode, ExecuteStatusEnum executeStatus) {
        if (orgId == null) {
            return null;
        }
        QFilter q = new QFilter("org", "=", (Object)Long.valueOf(orgId)).and("executetype", "=", (Object)taskCode).and("executestatus", "=", (Object)executeStatus.getCode()).and("channel", "=", (Object)channelCode);
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)META_KEY, (String)MetadataUtil.getAllFieldString((String)META_KEY), (QFilter[])new QFilter[]{q}, (String)"createtime desc");
        if (CollectionUtils.isEmpty((Collection)dyns)) {
            return null;
        }
        return (DynamicObject)dyns.get(0);
    }

    public static boolean existLogInfo(Long sbbid, DeclareStatusEnum declareStatus) {
        DynamicObject obj = TsateDeclareRecordBusiness.getRecordBySbbid(sbbid, declareStatus);
        if (obj == null) {
            return false;
        }
        return org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)obj.getString("deallog"));
    }

    public static ExecuteStatusEnum getExecuteStatusByDeclareStatus(DeclareStatusEnum declareStatus) {
        if (DeclareStatusEnum.DECLARED == declareStatus) {
            return ExecuteStatusEnum.SUCCESS;
        }
        if (DeclareStatusEnum.DECLAREFAILED == declareStatus) {
            return ExecuteStatusEnum.FAIL;
        }
        return ExecuteStatusEnum.PROCESSING;
    }

    public static DynamicObject save(Long orgid, Date sbqj, ExecuteStatusEnum executestatus, DynamicObject taskObj, DynamicObject channelObj) {
        Date createTime = new Date();
        String creatorId = RequestContext.get().getCurrUserId() + "";
        String channel = channelObj.getString(NUMBER);
        Long declarechannel = channelObj.getLong(ID);
        String executetype = taskObj.getString(NUMBER);
        Long tasktype = taskObj.getLong(ID);
        return TsateDeclareRecordBusiness.save(orgid, createTime, creatorId, executestatus, sbqj, channel, declarechannel, executetype, tasktype);
    }

    public static DynamicObject save(Long orgid, Date createTime, String creatorId, ExecuteStatusEnum executestatus, Date sbqj, String channel, Long declarechannel, String executetype, Long tasktype) {
        DynamicObject dynamicObject = TsateDeclareRecordBusiness.newObject(orgid, createTime, creatorId, executestatus, sbqj, null, null, channel, declarechannel, executetype, tasktype);
        Object obj = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject})[0];
        return (DynamicObject)obj;
    }

    public static DynamicObject newObjectByMetakey(Map<String, Object> map) {
        ExecuteTypeEnums executeType;
        SupplierEnum supplier;
        DynamicObject record = BusinessDataServiceHelper.newDynamicObject((String)META_KEY);
        String fildsStr = MetadataUtil.getAllFieldString((String)META_KEY);
        Set filds = Arrays.stream(fildsStr.split(",")).collect(Collectors.toSet());
        for (Map.Entry<String, Object> kv : map.entrySet()) {
            if (!filds.contains(kv.getKey())) continue;
            record.set(kv.getKey().toString(), kv.getValue());
        }
        record.set("billstatus", (Object)"C");
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        codeRuleService.getNumber(META_KEY, record, null);
        String number = codeRuleService.readNumber(META_KEY, record, null);
        record.set("billno", (Object)number);
        String executestatus = record.getString("executestatus");
        if (executestatus == null || executestatus.length() == 0) {
            record.set("executestatus", (Object)ExecuteStatusEnum.PROCESSING.getCode());
        }
        if ((supplier = SupplierEnum.valueOfId((Long)record.getLong("declarechannel"))) != null) {
            record.set("channel", (Object)supplier.getCode());
        }
        if ((executeType = ExecuteTypeEnums.valuesOfId((Long)record.getLong("tasktype"))) != null) {
            record.set("executetype", (Object)executeType.getExecuteType());
        }
        if (!map.containsKey("creator")) {
            record.set("creator", (Object)RequestContext.get().getCurrUserId());
        }
        record.set("detaillog_tag", map.get("detaillog_tag"));
        return record;
    }

    public static void dealDetailLog(String log, Long id) {
        if (EmptyCheckUtils.isNotEmpty((Object)id)) {
            DynamicObject recordObj = BusinessDataServiceHelper.loadSingle((Object)id, (String)META_KEY);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)recordObj.getString("detaillog_tag"))) {
                StringBuilder recordLog = new StringBuilder(recordObj.getString("detaillog_tag")).append(System.getProperty("line.separator"));
                recordLog.append(log);
                recordObj.set("detaillog_tag", (Object)recordLog.toString());
            } else {
                recordObj.set("detaillog_tag", (Object)log);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recordObj});
        }
    }

    public static void dealDetailLog(Object logData, Long id, String key, String dealLog) {
        DynamicObject recordObj = BusinessDataServiceHelper.loadSingle((Object)id, (String)META_KEY);
        if (recordObj != null) {
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dealLog)) {
                TsateDeclareRecordBusiness.uploadLogByLength(dealLog, recordObj);
            }
            JSONObject detailLogTagJson = new JSONObject();
            String detailLogTag = recordObj.getString("detaillog_tag");
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)detailLogTag)) {
                detailLogTagJson = JSON.parseObject((String)detailLogTag);
            }
            detailLogTagJson.put(key, logData);
            recordObj.set("detaillog_tag", (Object)JSON.toJSONString((Object)detailLogTagJson));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recordObj});
        }
    }

    public static void dealDetailLog(Map<String, Object> detailLog, Long id, String dealLog) {
        DynamicObject recordObj = BusinessDataServiceHelper.loadSingle((Object)id, (String)META_KEY);
        if (recordObj != null) {
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dealLog)) {
                TsateDeclareRecordBusiness.uploadLogByLength(dealLog, recordObj);
            }
            JSONObject detailLogTagJson = new JSONObject();
            String detailLogTag = recordObj.getString("detaillog_tag");
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)detailLogTag)) {
                detailLogTagJson = JSON.parseObject((String)detailLogTag);
            }
            detailLogTagJson.putAll(detailLog);
            recordObj.set("detaillog_tag", (Object)JSON.toJSONString((Object)detailLogTagJson));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recordObj});
        }
    }

    @Deprecated
    public static DynamicObject newObject(Map<String, Object> map) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)META_KEY);
        dynamicObject.set("org", map.get("orgid"));
        dynamicObject.set("createtime", map.get("createtime"));
        Object creatorid = map.get("creatorid");
        if (creatorid != null) {
            dynamicObject.set("creator", map.get("creatorid"));
        } else {
            dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        }
        Object executestatus = map.get("executestatus");
        if (executestatus == null) {
            executestatus = ExecuteStatusEnum.PROCESSING.getCode();
        }
        dynamicObject.set("executestatus", executestatus);
        dynamicObject.set("sbqj", map.get("sbqj"));
        dynamicObject.set("skssqq", map.get("skssqq"));
        dynamicObject.set("skssqz", map.get("skssqz"));
        dynamicObject.set("channel", map.get("channelnumber"));
        dynamicObject.set("declarechannel", map.get("channelid"));
        dynamicObject.set("billstatus", (Object)"C");
        dynamicObject.set("executetype", map.get("executetype"));
        dynamicObject.set("tasktype", map.get("tasktypeid"));
        dynamicObject.set("taxtype", map.get("taxtype"));
        dynamicObject.set("type", map.get("declaretype"));
        DynamicObject[] objs = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        dynamicObject = objs[0];
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        codeRuleService.getNumber(META_KEY, dynamicObject, null);
        String number = codeRuleService.readNumber(META_KEY, dynamicObject, null);
        dynamicObject.set("billno", (Object)number);
        return dynamicObject;
    }

    @Deprecated
    public static DynamicObject newObject(Long orgid, Date createTime, String creatorId, ExecuteStatusEnum executestatus, Date sbqj, Date skssqq, Date skssqz, String channel, Long declarechannel, String executetype, Long tasktype) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)META_KEY);
        dynamicObject.set("org", (Object)orgid);
        dynamicObject.set("createtime", (Object)createTime);
        dynamicObject.set("creator", (Object)creatorId);
        if (executestatus == null) {
            executestatus = ExecuteStatusEnum.PROCESSING;
        }
        dynamicObject.set("executestatus", (Object)executestatus.getCode());
        dynamicObject.set("sbqj", (Object)sbqj);
        dynamicObject.set("skssqq", (Object)skssqq);
        dynamicObject.set("skssqz", (Object)skssqz);
        dynamicObject.set("channel", (Object)channel);
        dynamicObject.set("declarechannel", (Object)declarechannel);
        dynamicObject.set("billstatus", (Object)"C");
        dynamicObject.set("executetype", (Object)executetype);
        dynamicObject.set("tasktype", (Object)tasktype);
        DynamicObject[] objs = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        dynamicObject = objs[0];
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        codeRuleService.getNumber(META_KEY, dynamicObject, null);
        String number = codeRuleService.readNumber(META_KEY, dynamicObject, null);
        dynamicObject.set("billno", (Object)number);
        return dynamicObject;
    }

    public static void updateRecord(Long recordId, String dealLog, String detailLog, ExecuteStatusEnum executeStatus) {
        DynamicObject record = BusinessDataServiceHelper.loadSingle((Object)recordId, (String)META_KEY);
        if (executeStatus != null) {
            record.set("executestatus", (Object)executeStatus.getCode());
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)detailLog)) {
            record.set("detaillog", (Object)detailLog);
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dealLog)) {
            TsateDeclareRecordBusiness.uploadLogByLength(dealLog, record);
        }
        SaveServiceHelper.update((DynamicObject)record);
    }

    public static void updateRecords(List<DynamicObject> records) {
        SaveServiceHelper.update((DynamicObject[])records.toArray(new DynamicObject[records.size()]));
    }

    public static void updateRecordByBoolean(Long recordId, String dealLog, String detailLog, Boolean executeStatus) {
        DynamicObject record = BusinessDataServiceHelper.loadSingle((Object)recordId, (String)META_KEY);
        if (executeStatus != null) {
            if (executeStatus.booleanValue()) {
                record.set("executestatus", (Object)ExecuteStatusEnum.SUCCESS.getCode());
            } else {
                record.set("executestatus", (Object)ExecuteStatusEnum.FAIL.getCode());
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)detailLog)) {
            record.set("detaillog", (Object)detailLog);
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dealLog)) {
            TsateDeclareRecordBusiness.uploadLogByLength(dealLog, record);
        }
        SaveServiceHelper.update((DynamicObject)record);
    }

    public static void uploadLogByLength(String log, DynamicObject record) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)log)) {
            return;
        }
        TsateDeclareRecordBusiness.uploadLog(log, record);
    }

    private static void uploadLog(String log, DynamicObject dynamicObject) {
        TsateDeclareRecordBusiness.setLogDetail(dynamicObject, log);
        if (log.length() > 240) {
            try (ByteArrayInputStream is = new ByteArrayInputStream(log.getBytes(StandardCharsets.UTF_8));){
                String billNo = dynamicObject.getString("billno");
                if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)billNo)) {
                    if (log != null && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)log)) {
                        String storePath = "/taxc/tsate/msg/" + dynamicObject.getString("billno");
                        String url = FileUploadUtils.upload((String)(storePath + ".txt"), (String)(dynamicObject.getString("billno") + ".txt"), (InputStream)is);
                        dynamicObject.set("deallog", (Object)("FILE:" + url));
                    } else {
                        LOGGER.info(ResManager.loadKDString((String)"\u65e5\u5fd7\u4fe1\u606f\u4e3a\u7a7a\u4e0d\u8bb0\u5f55", (String)"TsateDeclareRecordBusiness_0", (String)"taxc-tsate-business", (Object[])new Object[0]));
                        dynamicObject.set("deallog", (Object)"");
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("uploadLog error", (Object)e.getMessage());
            }
        } else {
            dynamicObject.set("deallog", (Object)log);
        }
    }

    public static void failRecord(Long recordId, String dealLog, String detailLog) {
        TsateDeclareRecordBusiness.failRecord(recordId, dealLog, detailLog, null);
    }

    public static void failRecord(Long recordId, String dealLog, String detailLog, String detailLogtag) {
        DynamicObject record = BusinessDataServiceHelper.loadSingle((Object)recordId, (String)META_KEY);
        record.set("executestatus", (Object)"3");
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)detailLog)) {
            record.set("detaillog", (Object)detailLog);
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dealLog)) {
            TsateDeclareRecordBusiness.uploadLogByLength(dealLog, record);
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)detailLogtag)) {
            record.set("detaillog_tag", (Object)detailLogtag);
        }
        SaveServiceHelper.update((DynamicObject)record);
    }

    public static void updateRecordByTaxResult(TaxResult result, Long recordId) {
        if (result.isSuccess()) {
            TsateDeclareRecordBusiness.updateRecord(recordId, result.getMessage(), null, ExecuteStatusEnum.SUCCESS);
            return;
        }
        TsateDeclareRecordBusiness.updateRecord(recordId, result.getMessage(), null, ExecuteStatusEnum.FAIL);
    }

    public static void successRecord(Long recordId, String dealLog, String detailLog, String detailLogTag) {
        QFilter filter = new QFilter(ID, "=", (Object)recordId);
        DynamicObject record = BusinessDataServiceHelper.loadSingle((Object)recordId, (String)META_KEY);
        record.set("executestatus", (Object)"2");
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)detailLog)) {
            record.set("detaillog", (Object)detailLog);
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dealLog)) {
            record.set("dealLog", (Object)dealLog);
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)detailLogTag)) {
            record.set("detaillog_tag", (Object)detailLogTag);
        }
        SaveServiceHelper.update((DynamicObject)record);
    }

    public static List<DynamicObject> checkTimeoutRecord(List<Long> orgids, Long timeout, List<DynamicObject> taskType) {
        DynamicObject[] originDatas = TsateDeclareChecklistBusiness.getExistTask(orgids, taskType);
        ArrayList<DynamicObject> timeoutList = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> normalList = new ArrayList<DynamicObject>(8);
        for (DynamicObject obj : originDatas) {
            Date startTime = obj.getDate("createtime");
            if (startTime != null && System.currentTimeMillis() - startTime.getTime() > timeout) {
                obj.set("executestatus", (Object)"3");
                obj.set("detailLog", (Object)ResManager.loadKDString((String)"\u4efb\u52a1\u8d85\u65f6", (String)"TsateDeclareRecordBusiness_1", (String)"taxc-tsate-business", (Object[])new Object[0]));
                obj.set("dealLog", (Object)ResManager.loadKDString((String)"\u4efb\u52a1\u8d85\u65f6", (String)"TsateDeclareRecordBusiness_1", (String)"taxc-tsate-business", (Object[])new Object[0]));
                obj.set("detaillog_tag", (Object)ResManager.loadKDString((String)"\u4efb\u52a1\u8d85\u65f6%s", (String)"TsateDeclareRecordBusiness_6", (String)"taxc-tsate-business", (Object[])new Object[]{timeout}));
                timeoutList.add(obj);
                continue;
            }
            normalList.add(obj);
        }
        if (timeoutList.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])timeoutList.toArray(new DynamicObject[0]));
        }
        return normalList;
    }

    public static boolean matchDeclareMain(DynamicObject declareMain, DynamicObject declareRecord) {
        Date skssqq1 = declareMain.getDate("skssqq");
        Date skssqz1 = declareMain.getDate("skssqz");
        Long orgId1 = declareMain.getLong("org");
        Date skssqq2 = declareRecord.getDate("skssqq");
        Date skssqz2 = declareRecord.getDate("skssqz");
        Long orgId2 = declareRecord.getLong("org");
        if (orgId1.compareTo(orgId2) != 0) {
            return false;
        }
        if (!DateUtils.format((Date)skssqq1).equals(DateUtils.format((Date)skssqq2))) {
            return false;
        }
        return DateUtils.format((Date)skssqz1).equals(DateUtils.format((Date)skssqz2));
    }

    public static void appendDetailLog(Long recordId, String detailLog) {
        if (recordId == null) {
            return;
        }
        DynamicObject record = BusinessDataServiceHelper.loadSingle((Object)recordId, (String)META_KEY);
        if (record == null) {
            return;
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)detailLog)) {
            StringBuilder logs = new StringBuilder(record.getString("detaillog_tag"));
            logs.append(detailLog);
            record.set("detaillog_tag", (Object)logs.toString());
            SaveServiceHelper.update((DynamicObject)record);
        }
    }

    public static DynamicObject newSbbfileObjectByDeclaremain(DynamicObject declaremain, SupplierEnum supplier) {
        return TsateDeclareRecordBusiness.newSbbfileObjectByDeclaremain(declaremain, supplier, null, null);
    }

    public static DynamicObject newSbbfileObjectByDeclaremain(DynamicObject declaremain, SupplierEnum supplier, Long taxTypeId, DeclareTypeEnum declareType) {
        ExecuteTypeEnums executeType = ExecuteTypeEnums.SBBFILE;
        HashMap<String, Object> objParams = new HashMap<String, Object>(16);
        objParams.put("org", DeclarationMainFormBusniess.getPropertyIdFromDeclare(declaremain, "org"));
        objParams.put("executestatus", ExecuteStatusEnum.PROCESSING.getCode());
        objParams.put("sbqj", declaremain.getDate("sbrq"));
        objParams.put("skssqq", declaremain.getDate("skssqq"));
        objParams.put("skssqz", declaremain.getDate("skssqz"));
        objParams.put("channel", supplier.getCode());
        objParams.put("declarechannel", supplier.getId());
        objParams.put("tasktype", executeType.getId());
        objParams.put("executetype", executeType.getExecuteType());
        if (declareType != null) {
            objParams.put("type", declareType.getCode());
        } else {
            objParams.put("type", DeclarationMainFormBusniess.getDeclareTypeByModel3(declaremain));
        }
        objParams.put("taxtype", taxTypeId);
        return TsateDeclareRecordBusiness.newObjectByMetakey(objParams);
    }

    public static DynamicObject newRecordByTaskBaseVo(TaskBaseVo vo) {
        return TsateDeclareRecordBusiness.newObjectByMetakey(TsateDeclareRecordBusiness.newRecordByTaskBaseVoParams(vo));
    }

    public static DynamicObject saveNewRecordByTaskBaseVo(TaskBaseVo vo) {
        Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{TsateDeclareRecordBusiness.newObjectByMetakey(TsateDeclareRecordBusiness.newRecordByTaskBaseVoParams(vo))});
        return (DynamicObject)save[0];
    }

    public static Map<String, Object> newRecordByTaskBaseVoParams(TaskBaseVo vo) {
        HashMap<String, Object> objParams = new HashMap<String, Object>(16);
        objParams.put("org", vo.getOrgId());
        objParams.put("executestatus", ExecuteStatusEnum.PROCESSING.getCode());
        objParams.put("channel", vo.getSupplier().getCode());
        objParams.put("declarechannel", vo.getSupplier().getId());
        objParams.put("tasktype", vo.getExecuteType().getId());
        objParams.put("executetype", vo.getExecuteType().getExecuteType());
        HashMap<String, TaskBaseVo> requestMap = new HashMap<String, TaskBaseVo>(8);
        requestMap.put("requestData", vo);
        objParams.put("detaillog_tag", JSON.toJSONString(requestMap));
        return objParams;
    }

    public static void addPic(Long recordId, List<String> picUrl) {
        DynamicObject[] dyns = BusinessDataServiceHelper.load((String)META_KEY, (String)"id,billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,importlogs,org,skssqq,skssqz,executetype,executestatus,deallog,type,detaillog,detaillog_tag,channel,sbbid,sbqj,piclog,declarechannel,tasktype,taxtype,importlogs.seq,importlogs.logtitle,importlogs.log", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)recordId)});
        if (dyns.length > 0) {
            TsateDeclareRecordBusiness.addPic(dyns[0], picUrl);
            SaveServiceHelper.update((DynamicObject)dyns[0]);
        }
    }

    public static void addPic(DynamicObject record, List<String> picUrl) {
        List<String> urls = TsateDeclareRecordBusiness.getPic(record);
        urls.addAll(picUrl);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put(PICLOG_URLLIST, urls);
        String content = JSON.toJSONString(map);
        LOGGER.info(ResManager.loadKDString((String)"\u56fe\u7247\u4fe1\u606f\uff1a{}", (String)"TsateDeclareRecordBusiness_2", (String)"taxc-tsate-business", (Object[])new Object[0]), (Object)content);
        if (content.length() > 240) {
            try (ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));){
                String billNo = record.getString("billno");
                if (StringUtil.isNotBlank((CharSequence)billNo)) {
                    String url;
                    String storePath = "/taxc/tsate/data/" + billNo;
                    content = url = FileUploadUtils.upload((String)(storePath + ".txt"), (String)(billNo + ".txt"), (InputStream)is);
                    LOGGER.info(ResManager.loadKDString((String)"\u4f7f\u7528\u6587\u4ef6\u5b58\u50a8\uff0c\u56fe\u7247URL\uff1a{}", (String)"TsateDeclareRecordBusiness_3", (String)"taxc-tsate-business", (Object[])new Object[0]), (Object)content);
                }
            }
            catch (IOException e) {
                LOGGER.error("DirectDeclareLogUtils dealPicxx", (Object)e.getMessage());
            }
        }
        record.set("piclog", (Object)content);
    }

    public static void cleanPic(DynamicObject record) {
        record.set("piclog", (Object)"");
    }

    public static List<String> getPic(Long recordId) {
        DynamicObject dyn = BusinessDataServiceHelper.loadSingle((Object)recordId, (String)META_KEY);
        return TsateDeclareRecordBusiness.getPic(dyn);
    }

    public static List<String> getPic(DynamicObject record) {
        JSONArray array;
        ArrayList<String> list = new ArrayList<String>();
        String picLog = record.getString("piclog");
        if (StringUtil.isEmpty((CharSequence)picLog)) {
            return list;
        }
        JSONObject jsonObj = null;
        try {
            jsonObj = JSON.parseObject((String)picLog);
        }
        catch (Exception e1) {
            String fileStr = FileUploadUtils.getFileString((String)picLog);
            if (StringUtil.isEmpty((CharSequence)fileStr)) {
                LOGGER.info(ResManager.loadKDString((String)"\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a", (String)"TsateDeclareRecordBusiness_4", (String)"taxc-tsate-business", (Object[])new Object[0]));
                return list;
            }
            try {
                jsonObj = JSON.parseObject((String)fileStr);
            }
            catch (Exception e2) {
                LOGGER.error(ResManager.loadKDString((String)"\u83b7\u53d6\u6587\u4ef6", (String)"TsateDeclareRecordBusiness_5", (String)"taxc-tsate-business", (Object[])new Object[0]));
                return list;
            }
        }
        if (jsonObj instanceof JSONObject && (array = jsonObj.getJSONArray(PICLOG_URLLIST)) != null) {
            for (int i = 0; i < array.size(); ++i) {
                String url = array.getString(i);
                list.add(url);
            }
        }
        return list;
    }
}

