/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.encrypt.EncryptException;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.business.bos.SecurityBusiness;
import kd.taxc.bdtaxr.business.bos.secret.LocalSecurity;

public class TsatePramSettingBusiness {
    private static final String SEC_PREFIX = "NzU4OGQyN2YxYzc1NDgw";
    private static final String PARAM_SUFFIX = "SEC_SUFFIX";

    private static String getSecSuffixCache() {
        QFilter q = new QFilter("key", "=", (Object)PARAM_SUFFIX);
        Map cacheMap = BusinessDataServiceHelper.loadFromCache((String)"tsate_param_setting", (String)"id,key,value,type", (QFilter[])new QFilter[]{q});
        ArrayList data = new ArrayList(2);
        data.addAll(cacheMap.values());
        if (data.size() == 0) {
            throw new KDBizException("suffix of SEC is not setting");
        }
        DynamicObject dyn = (DynamicObject)data.get(0);
        return dyn.getString("value");
    }

    private static LocalSecurity getLocalSecurity() {
        LocalSecurity sec = new LocalSecurity();
        sec.setPrefix(SEC_PREFIX);
        sec.setSuffix(TsatePramSettingBusiness.getSecSuffixCache());
        return sec;
    }

    private static LocalSecurity getLocalSecurityNotCache() {
        String sql = "select fkey,fvalue,ftype from t_tsate_param_setting where fkey = 'SEC_SUFFIX'";
        DataSet ds = DB.queryDataSet((String)"TsatePramSettingParamBusiness", (DBRoute)DBRoute.of((String)"taxc"), (String)sql);
        String suffix = null;
        while (ds.hasNext()) {
            Row row = ds.next();
            suffix = row.getString("fvalue");
        }
        LocalSecurity sec = new LocalSecurity();
        sec.setPrefix(SEC_PREFIX);
        sec.setSuffix(suffix);
        return sec;
    }

    public static String getDecodeValue(LocalSecurity sec, String encodeStr) throws EncryptException {
        return SecurityBusiness.decryptByLocal((LocalSecurity)sec, (String)encodeStr);
    }

    public static String getDecodeValue(String encodeStr) throws EncryptException {
        return TsatePramSettingBusiness.getDecodeValue(TsatePramSettingBusiness.getLocalSecurity(), encodeStr);
    }

    public static String getEncodeValue(LocalSecurity sec, String originStr) {
        return SecurityBusiness.encryptByLocal((LocalSecurity)sec, (String)originStr);
    }

    public static String getEncodeValue(String originStr) {
        return TsatePramSettingBusiness.getEncodeValue(TsatePramSettingBusiness.getLocalSecurity(), originStr);
    }

    public static String getEncodeValueInUpgrade(String originStr) {
        return TsatePramSettingBusiness.getEncodeValue(TsatePramSettingBusiness.getLocalSecurityNotCache(), originStr);
    }

    public static String getValue(DynamicObject paramSettingDyn) throws EncryptException {
        String dataType = paramSettingDyn.getString("type");
        String v = paramSettingDyn.getString("value");
        if ("2".equals(dataType)) {
            return TsatePramSettingBusiness.getDecodeValue(v);
        }
        return v;
    }
}

