/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.ExecuteStatusEnum;
import kd.taxc.tsate.common.enums.RequestTypeEnum;
import kd.taxc.tsate.common.metadata.MetadataUtil;
import org.apache.commons.collections.CollectionUtils;

public class TsateRequestInfoBusiness {
    public static final String TYPE_DECLARE = "1";
    public static final String TYPE_PAY = "2";
    public static final String TYPE_ZHUANKAI = "3";
    public static final String TYPE_VELIFY = "4";
    public static final String TYPE_SBZF = "5";
    public static final String TYPE_QCXZ = "6";
    public static final String TYPE_TBZT = "7";
    public static final String TYPE_LSXZ = "8";
    public static final String STATUS_RUNNING = "1";
    public static final String STATUS_SUCCESS = "2";
    public static final String STATUS_FAIL = "3";

    public static void saveRequestId(String requestId, String recordId, String sbbid, String type) {
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{TsateRequestInfoBusiness.buildDynamicObject(null, requestId, recordId, sbbid, type, null)});
    }

    public static void saveRequestId(String requestId, String recordId, String sbbid, String type, SupplierEnum supplier) {
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{TsateRequestInfoBusiness.buildDynamicObject(null, requestId, recordId, sbbid, type, supplier)});
    }

    public static void saveRequestId(String orgId, String requestId, String recordId, String sbbid, String type, SupplierEnum supplier) {
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{TsateRequestInfoBusiness.buildDynamicObject(orgId, requestId, recordId, sbbid, type, supplier)});
    }

    private static DynamicObject buildDynamicObject(String orgId, String requestId, String recordId, String sbbid, String type, SupplierEnum supplier) {
        DynamicObject dyn = BusinessDataServiceHelper.newDynamicObject((String)"tsate_declare_status_info");
        dyn.set("requestid", (Object)requestId);
        dyn.set("recordid", (Object)recordId);
        dyn.set("sbbid", (Object)sbbid);
        dyn.set("requesttype", (Object)type);
        dyn.set("executestatus", (Object)"1");
        if (supplier != null) {
            dyn.set("channel", (Object)supplier.getId());
        }
        if (orgId != null) {
            dyn.set("org", (Object)orgId);
        }
        return dyn;
    }

    public static void updateRequestId(String requestId, String recordId, DynamicObject requestObj) {
        requestObj.set("requestid", (Object)requestId);
        requestObj.set("recordid", (Object)recordId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{requestObj});
    }

    public static String queryOneRequesdId(String recordId, String type, String status) {
        DynamicObject dyn = TsateRequestInfoBusiness.queryOne(recordId, type, status);
        if (dyn != null) {
            return dyn.getString("requestid");
        }
        return null;
    }

    public static DynamicObject queryOne(String recordId, String type, String status) {
        List<DynamicObject> requestObjs = TsateRequestInfoBusiness.query(recordId, type, status);
        if (CollectionUtils.isEmpty(requestObjs)) {
            return null;
        }
        return requestObjs.get(0);
    }

    public static String queryOneRequestId(String recordId, String type, String status) {
        DynamicObject dyn = TsateRequestInfoBusiness.queryOne(recordId, type, status);
        return dyn == null ? null : dyn.getString("requestid");
    }

    public static List<DynamicObject> query(String recordId, String type, String status) {
        QFilter filter = new QFilter("recordid", "=", (Object)recordId);
        if (type != null) {
            filter.and("requesttype", "=", (Object)type);
        }
        if (status != null) {
            filter.and("executestatus", "=", (Object)status);
        }
        DynamicObject[] dyns = BusinessDataServiceHelper.load((String)"tsate_declare_status_info", (String)"id,billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,entryentity,type,skssqq,skssqz,requestid,org,detailinfo,detailinfo_tag,executestatus,sbbid,requesttype,recordid,entryentity.seq,entryentity.modifierfield,entryentity.modifydatefield", (QFilter[])new QFilter[]{filter});
        List<DynamicObject> list = Arrays.asList(dyns);
        return list;
    }

    public static void updateStatus(String requestId, ExecuteStatusEnum status) {
        DynamicObject[] dyns;
        QFilter filter = new QFilter("requestid", "=", (Object)requestId);
        for (DynamicObject dyn : dyns = BusinessDataServiceHelper.load((String)"tsate_declare_status_info", (String)"id,billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,entryentity,type,skssqq,skssqz,requestid,org,detailinfo,detailinfo_tag,executestatus,sbbid,requesttype,recordid,entryentity.seq,entryentity.modifierfield,entryentity.modifydatefield", (QFilter[])new QFilter[]{filter})) {
            dyn.set("executestatus", (Object)status.getCode());
        }
        SaveServiceHelper.update((DynamicObject[])dyns);
    }

    public static void updateStatusWithStatusInfo(Long id, ExecuteStatusEnum status, String info) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        DynamicObject request = BusinessDataServiceHelper.loadSingle((String)"tsate_declare_status_info", (String)"id,billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,entryentity,type,skssqq,skssqz,requestid,org,detailinfo,detailinfo_tag,executestatus,sbbid,requesttype,recordid,entryentity.seq,entryentity.modifierfield,entryentity.modifydatefield", (QFilter[])new QFilter[]{filter});
        if (request == null) {
            return;
        }
        request.set("executestatus", (Object)status.getCode());
        request.set("detailinfo_tag", (Object)info);
        SaveServiceHelper.update((DynamicObject)request);
    }

    public static DynamicObject getSzyhRequestBySbbIdAndStatus(String sbbid, String status) {
        return TsateRequestInfoBusiness.getRequest(sbbid, status, RequestTypeEnum.DECLARE, SupplierEnum.SZYH);
    }

    public static DynamicObject getRequest(String sbbid, String status, RequestTypeEnum requestType, SupplierEnum supplier) {
        String requestTypeCode = requestType == null ? " " : requestType.getCode();
        Long channelId = supplier == null ? Long.valueOf(0L) : supplier.getId();
        QFilter qFilter = new QFilter("sbbid", "=", (Object)sbbid).and(new QFilter("channel", "=", (Object)channelId)).and(new QFilter("requesttype", "=", (Object)requestTypeCode)).and(new QFilter("executestatus", "=", (Object)status));
        return BusinessDataServiceHelper.loadSingle((String)"tsate_declare_status_info", (String)MetadataUtil.getAllFieldString((String)"tsate_declare_status_info"), (QFilter[])new QFilter[]{qFilter});
    }
}

