/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.taxc.tsate.common.constant.SupplierEnum;

public class TsateTextMapBusiness {
    private static final String META_TSATE_TEXT_MAP = "tsate_text_map";
    private static final String FILDS_LIST = "number,name,targetdata";
    private static final String FILDS_TARGETDATA = "targetdata";

    public static String getByNumber(SupplierEnum channel, String funclabelNumber, String dataNumber) {
        List<DynamicObject> dyns = TsateTextMapBusiness.get(channel, funclabelNumber, dataNumber, null, true);
        if (dyns.size() > 0) {
            return dyns.get(0).getString(FILDS_TARGETDATA);
        }
        return null;
    }

    public static String getByName(SupplierEnum channel, String funclabelNumber, String dataName) {
        List<DynamicObject> dyns = TsateTextMapBusiness.get(channel, funclabelNumber, null, dataName, true);
        if (dyns.size() > 0) {
            return dyns.get(0).getString(FILDS_TARGETDATA);
        }
        return null;
    }

    private static List<DynamicObject> get(SupplierEnum channel, String funclabelNumber, String dataNumber, String dataName, boolean cache) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        QFilter filter = new QFilter("channel.number", "=", (Object)channel.getCode());
        filter.and("funclable.number", "=", (Object)funclabelNumber);
        if (StringUtils.isNotEmpty((String)dataNumber)) {
            filter.and("number", "=", (Object)dataNumber);
        }
        if (StringUtils.isNotEmpty((String)dataName)) {
            filter.and("name", "=", (Object)dataName);
        }
        if (cache) {
            Map map = BusinessDataServiceHelper.loadFromCache((String)META_TSATE_TEXT_MAP, (String)FILDS_LIST, (QFilter[])new QFilter[]{filter});
            list.addAll(map.values());
        }
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)META_TSATE_TEXT_MAP, (String)FILDS_LIST, (QFilter[])new QFilter[]{filter});
        list.addAll(dyns.stream().collect(Collectors.toList()));
        return list;
    }
}

