/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business.api.cms;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.tsate.business.api.cms.CmsRequest;
import kd.taxc.tsate.business.token.ApiTokenBusiness;
import kd.taxc.tsate.business.token.ApiTokenService;
import kd.taxc.tsate.common.api.cms.CmsBaseApiVo;
import kd.taxc.tsate.common.api.cms.CmsRepVo;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.util.CommonInfoUtil;
import org.apache.commons.lang3.StringUtils;

public class CmsApi {
    private static Log logger = LogFactory.getLog(CmsRepVo.class);

    public static CmsBaseApiVo buildAuthorizationVo() {
        Map configInfo = CommonInfoUtil.getCommonConfigInfo();
        CmsBaseApiVo vo = new CmsBaseApiVo((String)configInfo.get("by_base_url"), (String)configInfo.get("by_appId"), (String)configInfo.get("by_userName"), (String)configInfo.get("by_passWord"));
        vo.setBizCode("/Authorization");
        return vo;
    }

    public static CmsBaseApiVo buildBusinessVo(String bizCode) {
        CmsBaseApiVo cmsBaseApiVo = CmsApi.buildAuthorizationVo();
        cmsBaseApiVo.setToken(CmsApi.getToken(cmsBaseApiVo));
        cmsBaseApiVo.setBizCode(bizCode);
        return cmsBaseApiVo;
    }

    public static TaxResult<CmsRepVo> reTryErrorWithToken(TaxResult<CmsRepVo> repResult, String bizCode, Map<String, Object> params) {
        if (!repResult.isSuccess() && ("401".equals(repResult.getCode()) || repResult.getMessage().startsWith("token"))) {
            logger.info("reTryErrorWithToken");
            CmsApi.updateToken();
            return CmsApi.parseRep(CmsApi.doPost(CmsApi.buildBusinessVo(bizCode), params));
        }
        return repResult;
    }

    public static String getToken(CmsBaseApiVo cmsBaseApiVo) {
        String token = ApiTokenBusiness.getEnableToken(SupplierEnum.CMS);
        if (StringUtils.isBlank((CharSequence)token)) {
            TaxResult<CmsRepVo> authorizationResult = CmsApi.authorization(cmsBaseApiVo);
            if (!authorizationResult.isSuccess()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u83b7\u53d6token\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CmsApi_0", (String)"taxc-tsate-business", (Object[])new Object[0]));
            }
            token = ((CmsRepVo)authorizationResult.getData()).getData().toString();
            ApiTokenService.updateOrSaveToken(SupplierEnum.CMS, token);
        }
        return token;
    }

    public static void updateToken() {
        TaxResult<CmsRepVo> authorizationResult = CmsApi.authorization(CmsApi.buildAuthorizationVo());
        if (!authorizationResult.isSuccess()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u83b7\u53d6token\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CmsApi_0", (String)"taxc-tsate-business", (Object[])new Object[0]));
        }
        ApiTokenService.updateOrSaveToken(SupplierEnum.CMS, ((CmsRepVo)authorizationResult.getData()).getJSONObjectData().getString("token"));
    }

    public static TaxResult<CmsRepVo> authorization(CmsBaseApiVo cmsBaseApiVo) {
        cmsBaseApiVo.setBizCode("/Authorization");
        String rep = CmsApi.doPost(cmsBaseApiVo, CmsApi.buildAuthorizationMap(cmsBaseApiVo));
        return CmsApi.parseRep(rep);
    }

    protected static TaxResult<CmsRepVo> parseRep(String rep) {
        TaxResult result = new TaxResult();
        if (StringUtils.isBlank((CharSequence)rep)) {
            result.setSuccess(false);
            result.setMessage(ResManager.loadKDString((String)"\u63a5\u53e3\u672a\u6b63\u5e38\u8fd4\u56de\u6570\u636e\u3002\u8bf7\u91cd\u8bd5\u6216\u8054\u7cfb\u6280\u672f\u4eba\u5458\u3002", (String)"CmsApi_1", (String)"taxc-tsate-business", (Object[])new Object[0]));
            return result;
        }
        JSONObject jsonObject = JSON.parseObject((String)rep);
        CmsRepVo cmsRepVo = new CmsRepVo(jsonObject.get((Object)"Data"), jsonObject.getInteger("ErrorCode"), jsonObject.getBoolean("Success"), jsonObject.getString("Msg"));
        result.setSuccess(cmsRepVo.getSuccess().booleanValue());
        result.setMessage(cmsRepVo.getMsg());
        result.setCode(String.valueOf(cmsRepVo.getErrorCode()));
        result.setData((Object)cmsRepVo);
        return result;
    }

    private static Map<String, Object> buildAuthorizationMap(CmsBaseApiVo cmsBaseApiVo) {
        HashMap<String, Object> authorizationMap = new HashMap<String, Object>();
        authorizationMap.put("appId", cmsBaseApiVo.getAppId());
        authorizationMap.put("userName", cmsBaseApiVo.getUserName());
        authorizationMap.put("passWord", cmsBaseApiVo.getPwd());
        return authorizationMap;
    }

    public static String doPost(CmsBaseApiVo vo, Map<String, Object> params) {
        String resp;
        String url = vo.getBaseUrl() + vo.getBizCode();
        if (!"/Authorization".equals(vo.getBizCode())) {
            params.put("bizCode", vo.getBizCode());
            url = vo.getBaseUrl() + "/CommonService";
        }
        logger.info("CMS req url={} param={}", (Object)url, params);
        if (!StringUtils.isBlank((CharSequence)vo.getToken())) {
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("Authorization", vo.getToken());
            resp = CmsRequest.doPost(url, header, JSON.toJSONString(params));
        } else {
            resp = CmsRequest.doPost(url, null, JSON.toJSONString(params));
        }
        logger.info("CMS resp ={}", (Object)resp);
        return resp;
    }
}

