/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business.base;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.tsate.common.constant.annotation.AnnotationFactory;
import kd.taxc.tsate.common.util.ExceptionUtil;
import kd.taxc.tsate.common.util.ResourceUtils;

public abstract class AbstractAnnotationBaseFactory<T> {
    Log LOGGER = LogFactory.getLog(AbstractAnnotationBaseFactory.class);
    private List<Class> classCache = this.scanHanlerCalss();

    protected AbstractAnnotationBaseFactory() {
    }

    protected List<T> getHandler(Object params) {
        ArrayList handlers = new ArrayList(8);
        for (Class clazz : this.classCache) {
            Object anno = clazz.getAnnotation(this.annotionClass());
            if (!this.match(params, (Annotation)anno)) continue;
            try {
                handlers.add(clazz.newInstance());
            }
            catch (Exception e) {
                this.LOGGER.error("\u83b7\u53d6\u5904\u7406\u5668\u5931\u8d25\uff1a" + ExceptionUtil.toString((Exception)e));
            }
        }
        return handlers;
    }

    private List<Class> scanHanlerCalss() {
        List hanlerClasses = ResourceUtils.scanClassWithAnnotion((String)this.classPath(), (Class)this.annotionClass());
        Class clazz = this.handlerClass();
        if (clazz != null) {
            return hanlerClasses.stream().filter(item -> clazz.isAssignableFrom((Class<?>)item)).collect(Collectors.toList());
        }
        return hanlerClasses;
    }

    protected String classPath() {
        AnnotationFactory anno = this.checkFactoryAnnotation();
        String classPath = anno.classPath();
        if (classPath == null || classPath.length() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ce8\u89e3\u5de5\u5382\u9519\u8bef\uff1a\u626b\u63cf\u7c7b\u8def\u5f84\u672a\u914d\u7f6e", (String)"AbstractAnnotationBaseFactory_1", (String)"taxc-tsate-business", (Object[])new Object[0]));
        }
        return classPath;
    }

    protected Class annotionClass() {
        AnnotationFactory anno = this.checkFactoryAnnotation();
        Class clazz = anno.hanlderAnnotation();
        if (clazz == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ce8\u89e3\u5de5\u5382\u9519\u8bef\uff1a\u6ce8\u89e3\u7c7b\u672a\u914d\u7f6e", (String)"AbstractAnnotationBaseFactory_2", (String)"taxc-tsate-business", (Object[])new Object[0]));
        }
        return clazz;
    }

    protected abstract boolean match(Object var1, Annotation var2);

    protected Class handlerClass() {
        AnnotationFactory anno = this.checkFactoryAnnotation();
        Class clazz = anno.hanlderClass();
        if (clazz == null) {
            this.LOGGER.info(ResManager.loadKDString((String)"\u6ce8\u89e3\u5de5\u5382\u5c06\u4e0d\u5f3a\u5236\u8fc7\u6ee4\u5904\u7406\u5668\u7c7b\u578b", (String)"AbstractAnnotationBaseFactory_3", (String)"taxc-tsate-business", (Object[])new Object[0]));
        }
        return clazz;
    }

    private AnnotationFactory checkFactoryAnnotation() {
        AnnotationFactory anno = this.getClass().getAnnotation(AnnotationFactory.class);
        if (anno == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ce8\u89e3\u5de5\u5382\u7f3a\u5c11\u6ce8\u89e3AnnotationFactory", (String)"AbstractAnnotationBaseFactory_4", (String)"taxc-tsate-business", (Object[])new Object[0]));
        }
        return anno;
    }
}

