/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business.checklist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tpo.declare.DeclarePayServiceHelper;
import kd.taxc.tsate.business.TsateDeclareChecklistBusiness;
import kd.taxc.tsate.business.TsateDeclareRecordBusiness;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.ExecuteStatusEnum;
import kd.taxc.tsate.common.enums.ExecuteTypeEnums;
import kd.taxc.tsate.common.metadata.MetadataUtil;
import kd.taxc.tsate.common.util.ExceptionUtil;
import kd.taxc.tsate.common.util.JobUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class CheckListDownloadedDataBusiness {
    private static final String ERROR_MSG = "eroMsg";
    private static final String OEG_NAME = "orgname";

    public static void reverseElectrictaxnoAndYspznoById(Long id, SupplierEnum supplier) {
        DynamicObject payInfo = TsateDeclareChecklistBusiness.getById(id);
        if (payInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e\uff0c\u8bf7\u786e\u8ba4", (String)"CheckListDownloadedDataBusiness_0", (String)"taxc-tsate-business", (Object[])new Object[0]));
        }
        DynamicObjectCollection payInfos = payInfo.getDynamicObjectCollection("checklist");
        if (CollectionUtils.isEmpty((Collection)payInfos)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u8be6\u7ec6\u6570\u636e\uff0c\u8bf7\u786e\u8ba4", (String)"CheckListDownloadedDataBusiness_1", (String)"taxc-tsate-business", (Object[])new Object[0]));
        }
        long orgId = payInfo.getLong("org.id");
        DynamicObject record = TsateDeclareRecordBusiness.assembleDeclareRecord(orgId + "", ExecuteTypeEnums.JKPZFX, supplier);
        ExecuteStatusEnum status = ExecuteStatusEnum.FAIL;
        try {
            TaxResult result;
            HashMap<String, Object> commonMap = new HashMap<String, Object>(16);
            commonMap.put("org", orgId);
            commonMap.put(OEG_NAME, payInfo.getString("org.name"));
            StringBuilder errorMessage = new StringBuilder();
            ArrayList<Map<String, Object>> payInfoList = new ArrayList<Map<String, Object>>(16);
            for (DynamicObject info : payInfos) {
                CheckListDownloadedDataBusiness.validatePaidInfoAndAddData(info, errorMessage, payInfoList, commonMap);
            }
            if (CollectionUtils.isNotEmpty(payInfoList) && !(result = DeclarePayServiceHelper.setElectrictaxnoAndYspzno(payInfoList)).isSuccess()) {
                errorMessage.append(result.getMessage());
            }
            if (StringUtils.isBlank((String)errorMessage.toString())) {
                status = ExecuteStatusEnum.SUCCESS;
            }
            TsateDeclareRecordBusiness.updateRecord(record.getLong("id"), errorMessage.toString(), "", status);
        }
        catch (Exception e) {
            TsateDeclareRecordBusiness.updateRecord(record.getLong("id"), ResManager.loadKDString((String)"\u8fdb\u884c\u7f34\u6b3e\u6570\u636e\u53cd\u5199\u65f6\u51fa\u73b0\u5f02\u5e38\u3002", (String)"CheckListDownloadedDataBusiness_2", (String)"taxc-tsate-business", (Object[])new Object[0]), "", status);
            throw new KDBizException(ResManager.loadKDString((String)"\u8fdb\u884c\u7f34\u6b3e\u6570\u636e\u53cd\u5199\u65f6\u51fa\u73b0\u5f02\u5e38\uff1a%s", (String)"CheckListDownloadedDataBusiness_3", (String)"taxc-tsate-business", (Object[])new Object[]{ExceptionUtil.toString((Exception)e)}));
        }
    }

    private static void validatePaidInfoAndAddData(DynamicObject info, StringBuilder errorMessage, List<Map<String, Object>> payInfoList, Map<String, Object> commonMap) {
        String dzsph;
        Date skssqq = info.getDate(MetadataUtil.slipNumber((String)"checklist.skssqq"));
        Date skssqz = info.getDate(MetadataUtil.slipNumber((String)"checklist.skssqz"));
        Long zsxm = info.getLong("zsxm.id");
        Long zspm = info.getLong("zspm.id");
        String yzpzxh = info.getString(MetadataUtil.slipNumber((String)"checklist.yzpzxh"));
        if (!(CheckListDownloadedDataBusiness.validatePzNo(yzpzxh, dzsph = info.getString(MetadataUtil.slipNumber((String)"checklist.dzsph")), commonMap) && CheckListDownloadedDataBusiness.validateTaxPeriod(skssqq, skssqz, commonMap) && CheckListDownloadedDataBusiness.validateZsxmAndZspm(zsxm, zspm, commonMap))) {
            String prefixMsg = ResManager.loadKDString((String)"\u51ed\u8bc1\u53cd\u5199\u5931\u8d25\uff1a", (String)"CheckListDownloadedDataBusiness_4", (String)"taxc-tsate-business", (Object[])new Object[0]);
            errorMessage.append(commonMap.get(OEG_NAME)).append(info.getString(MetadataUtil.slipNumber((String)"checklist.sbsx"))).append(prefixMsg).append(commonMap.remove(ERROR_MSG)).append(System.lineSeparator());
            return;
        }
        HashMap<String, Object> infoMap = new HashMap<String, Object>(16);
        infoMap.putAll(commonMap);
        infoMap.put("id", info.getLong("id"));
        infoMap.put(MetadataUtil.slipNumber((String)"checklist.skssqq"), skssqq);
        infoMap.put(MetadataUtil.slipNumber((String)"checklist.skssqz"), skssqz);
        infoMap.put(MetadataUtil.slipNumber((String)"checklist.zsxm"), zsxm);
        infoMap.put(MetadataUtil.slipNumber((String)"checklist.zspm"), zspm);
        infoMap.put(MetadataUtil.slipNumber((String)"checklist.yzpzxh"), yzpzxh);
        infoMap.put(MetadataUtil.slipNumber((String)"checklist.dzsph"), dzsph);
        payInfoList.add(infoMap);
    }

    private static boolean validateZsxmAndZspm(Long zsxm, Long zspm, Map<String, Object> commonMap) {
        if (!(zsxm != null && zsxm != 0L || zspm != null && zspm != 0L)) {
            commonMap.put(ERROR_MSG, ResManager.loadKDString((String)"\u7f34\u6b3e\u7ed3\u679c\u4fe1\u606f\u4e2d\u5f81\u6536\u9879\u76ee\u3001\u5f81\u6536\u54c1\u76ee\u4e3a\u7a7a\u3002", (String)"CheckListDownloadedDataBusiness_5", (String)"taxc-tsate-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private static boolean validateTaxPeriod(Date skssqq, Date skssqz, Map<String, Object> commonMap) {
        if (skssqq == null || skssqz == null) {
            commonMap.put(ERROR_MSG, ResManager.loadKDString((String)"\u7f34\u6b3e\u7ed3\u679c\u4fe1\u606f\u4e2d\u6240\u5c5e\u7a0e\u671f\u8d77\u6b62\u4e0d\u5b8c\u6574\u3002", (String)"CheckListDownloadedDataBusiness_6", (String)"taxc-tsate-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private static boolean validatePzNo(String yzpzxh, String dzsph, Map<String, Object> commonMap) {
        if (StringUtils.isBlank((String)yzpzxh) && StringUtils.isBlank((String)dzsph)) {
            commonMap.put(ERROR_MSG, ResManager.loadKDString((String)"\u7f34\u6b3e\u7ed3\u679c\u4fe1\u606f\u4e2d\u7535\u5b50\u7a0e\u7968\u53f7\u3001\u5e94\u7a0e\u51ed\u8bc1\u53f7\u4e3a\u7a7a\u3002", (String)"CheckListDownloadedDataBusiness_7", (String)"taxc-tsate-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public static void sendDownloadQxySbqcMsg() {
        DynamicObject[] executerecords = BusinessDataServiceHelper.load((String)"tsate_declare_record", (String)"id,org,executetype,tasktype,skssqq,skssqz,type", (QFilter[])new QFilter[]{new QFilter("executestatus", "=", (Object)"1").and("declarechannel.number", "=", (Object)"8").and("tasktype.number", "=", (Object)ExecuteTypeEnums.SBQC.getExecuteType())});
        if (executerecords != null && executerecords.length > 0) {
            for (DynamicObject executerecord : executerecords) {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                TaxResult taxResult = TaxcOrgDataServiceHelper.queryTaxcOrgByOrgId((Long)executerecord.getLong("org.id"));
                DynamicObject taxorg = (DynamicObject)taxResult.getData();
                paramMap.put("nsrsbh", taxorg.get("unifiedsocialcode"));
                paramMap.put("org", executerecord.getDynamicObject("org").getLong("id"));
                paramMap.put("recordid", executerecord.getLong("id"));
                paramMap.put("key", ExecuteTypeEnums.SBQC.getKey());
                paramMap.put("supplier", SupplierEnum.QXY.getCode());
                paramMap.put("type", executerecord.getString("type"));
                paramMap.put("isQuery", Boolean.TRUE);
                paramMap.put("operatorid", UserServiceHelper.getCurrentUserId());
                paramMap.put("operatetime", System.currentTimeMillis());
                paramMap.put("taskId", ExecuteTypeEnums.SBQC.getId());
                try {
                    JobUtils.submitJob(paramMap);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }
}

