/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.tsate.business.config.IOrgBaseConfig;

public class OrgConfig
implements IOrgBaseConfig {
    private Map<Long, Long> orgTaxofficeMap = new HashMap<Long, Long>(64);

    @Override
    public Map<Long, Long> getOrgTaxofficeId(List<Long> orgIds) {
        HashSet<Long> uncached = new HashSet<Long>(8);
        for (Long orgId : orgIds) {
            if (this.orgTaxofficeMap.containsKey(orgId)) continue;
            uncached.add(orgId);
        }
        if (uncached.size() > 0) {
            ArrayList<Long> queryIds = new ArrayList<Long>(uncached.size());
            queryIds.addAll(uncached);
            TaxResult r = TaxcMainDataServiceHelper.queryTaxcMainByOrgIdsAndIsTaxpayer(queryIds);
            List data = (List)r.getData();
            for (DynamicObject item : data) {
                Long orgId = item.getLong("orgid.id");
                Long taxOfficeId = item.getLong("taxoffice.id");
                this.orgTaxofficeMap.put(orgId, taxOfficeId);
                uncached.remove(orgId);
            }
            for (Long orgId : uncached) {
                this.orgTaxofficeMap.put(orgId, null);
            }
        }
        HashMap<Long, Long> result = new HashMap<Long, Long>(8);
        for (Long orgId : orgIds) {
            result.put(orgId, this.orgTaxofficeMap.get(orgId));
        }
        return result;
    }
}

