/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tsate.business.config.ISupplierConfig;
import kd.taxc.tsate.business.config.ITaxofficeConfig;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.DeclareTypeEnum;
import kd.taxc.tsate.common.metadata.MetadataUtil;

public class SupplierConfig
implements ISupplierConfig {
    ITaxofficeConfig taxofficeCfg;
    private boolean channelInfoInit = false;
    Map<Unicode, SupplierEnum> supplierInfos = new HashMap<Unicode, SupplierEnum>(8);

    public SupplierConfig(ITaxofficeConfig taxofficeCfg) {
        this.taxofficeCfg = taxofficeCfg;
    }

    @Override
    public SupplierEnum getSupplier(Long orgId, DeclareTypeEnum declareType) {
        this.initChannelInfos();
        Map<Long, Long> orgTopOfficeId = this.taxofficeCfg.getTopTaxofficeId(Collections.singletonList(orgId));
        Unicode code = new Unicode(orgTopOfficeId.get(orgId), declareType.getId());
        return this.supplierInfos.get(code);
    }

    @Override
    public Set<SupplierEnum> getAllSupplier(Long orgId) {
        this.initChannelInfos();
        HashSet<SupplierEnum> sets = new HashSet<SupplierEnum>(8);
        Map<Long, Long> orgTopTaxofficeId = this.taxofficeCfg.getTopTaxofficeId(Collections.singletonList(orgId));
        for (Map.Entry<Unicode, SupplierEnum> item : this.supplierInfos.entrySet()) {
            Unicode unicode = item.getKey();
            SupplierEnum supplier = item.getValue();
            if (!unicode.getTaxofficeId().equals(orgTopTaxofficeId.get(orgId))) continue;
            sets.add(supplier);
        }
        return sets;
    }

    private void initChannelInfos() {
        if (this.channelInfoInit) {
            return;
        }
        QFilter q = new QFilter("enable", "=", (Object)"1");
        Map declareChannels = BusinessDataServiceHelper.loadFromCache((String)"tsate_declare_channel", (String)MetadataUtil.getAllFieldString((String)"tsate_declare_channel"), (QFilter[])new QFilter[]{q});
        for (DynamicObject dyn : declareChannels.values()) {
            String declareTypeCode = dyn.getString("declarechannel.number");
            DynamicObjectCollection taxOfficeDyns = dyn.getDynamicObjectCollection("taxorgancopy");
            DynamicObjectCollection declareTypesDyns = dyn.getDynamicObjectCollection("taxtypecopy");
            for (DynamicObject taxoffice : taxOfficeDyns) {
                Long taxofficeId = taxoffice.getLong("fbasedataid.id");
                for (DynamicObject declareType : declareTypesDyns) {
                    String declareTypeId = declareType.getString("fbasedataid.id");
                    Unicode code = new Unicode(taxofficeId, declareTypeId);
                    this.supplierInfos.put(code, SupplierEnum.valueOfCode((String)declareTypeCode));
                }
            }
        }
        this.channelInfoInit = true;
    }

    static class Unicode {
        private Long taxofficeId;
        private String declareTypeId;

        Unicode(Long taxofficeId, String declareTypeId) {
            this.taxofficeId = taxofficeId;
            this.declareTypeId = declareTypeId;
        }

        public Long getTaxofficeId() {
            return this.taxofficeId;
        }

        public void setTaxofficeId(Long taxofficeId) {
            this.taxofficeId = taxofficeId;
        }

        public String getDeclareTypeId() {
            return this.declareTypeId;
        }

        public void setDeclareTypeId(String declareTypeId) {
            this.declareTypeId = declareTypeId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Unicode unicode = (Unicode)o;
            return Objects.equals(this.taxofficeId, unicode.taxofficeId) && Objects.equals(this.declareTypeId, unicode.declareTypeId);
        }

        public int hashCode() {
            return Objects.hash(this.taxofficeId, this.declareTypeId);
        }
    }
}

