/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tsate.business.config.IOrgBaseConfig;
import kd.taxc.tsate.business.config.ITaxofficeConfig;
import kd.taxc.tsate.common.metadata.MetadataUtil;

public class TaxofficeConfig
implements ITaxofficeConfig {
    private boolean taxofficeInit = false;
    private IOrgBaseConfig orgCfg;
    private Map<Long, Long> taxofficeRelation = new HashMap<Long, Long>(64);
    private Map<Long, Map<String, Object>> taxofficeInfo = new HashMap<Long, Map<String, Object>>(64);

    public void setOrgCfg(IOrgBaseConfig orgCfg) {
        this.orgCfg = orgCfg;
    }

    @Override
    public Map<Long, Long> getTaxofficeId(List<Long> orgIds) {
        if (this.orgCfg == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u5e94\u8be5\u5148\u8c03\u7528setOrgCfg\u65b9\u6cd5", (String)"TaxofficeConfig_0", (String)"taxc-tsate-business", (Object[])new Object[0]));
        }
        return this.orgCfg.getOrgTaxofficeId(orgIds);
    }

    @Override
    public Map<Long, Long> getTopTaxofficeId(List<Long> orgIds) {
        this.initTaxoffice();
        Map<Long, Long> orgTaxoffice = this.getTaxofficeId(orgIds);
        HashMap<Long, Long> orgTopTaxofficeId = new HashMap<Long, Long>(8);
        for (Map.Entry<Long, Long> item : orgTaxoffice.entrySet()) {
            Long orgId = item.getKey();
            Long orgTaxofficeId = item.getValue();
            Long topOfficeId = this.taxofficeRelation.get(orgTaxofficeId);
            orgTopTaxofficeId.put(orgId, topOfficeId);
        }
        return orgTopTaxofficeId;
    }

    @Override
    public Map<String, Object> getTaxofficeInfo(Long taxofficeId) {
        this.initTaxoffice();
        return this.taxofficeInfo.get(taxofficeId);
    }

    private void initTaxoffice() {
        if (this.taxofficeInit) {
            return;
        }
        this.initTaxofficeInfo();
        this.initTaxofficeRelation();
        this.taxofficeInit = true;
    }

    private void initTaxofficeInfo() {
        Map taxOffices = BusinessDataServiceHelper.loadFromCache((String)"bastax_taxorgan", (String)MetadataUtil.getAllFieldString((String)"bastax_taxorgan"), (QFilter[])new QFilter[0]);
        for (DynamicObject dyn : taxOffices.values()) {
            Long id = dyn.getLong("id");
            HashMap<String, Object> info = new HashMap<String, Object>(8);
            info.put("id", id);
            info.put("name", dyn.getString("name"));
            info.put("number", dyn.getString("number"));
            info.put("longnumber", dyn.getString("longnumber"));
            info.put("parent", dyn.getLong("parent.id"));
            this.taxofficeInfo.put(id, info);
        }
    }

    private void initTaxofficeRelation() {
        for (Long id : this.taxofficeInfo.keySet()) {
            this.taxofficeRelation.put(id, this.getParent(id));
        }
    }

    private Long getParent(Long taxofficeId) {
        Long parentId;
        Map<String, Object> info = this.taxofficeInfo.get(taxofficeId);
        if (info != null && info.containsKey("parent") && (parentId = (Long)info.get("parent")) != null && parentId != 0L) {
            return this.getParent(parentId);
        }
        return taxofficeId;
    }
}

