/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business.config;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.taxc.tsate.business.config.IOrgBaseConfig;
import kd.taxc.tsate.business.config.ISupplierConfig;
import kd.taxc.tsate.business.config.ITaxofficeConfig;
import kd.taxc.tsate.business.config.OrgConfig;
import kd.taxc.tsate.business.config.SupplierConfig;
import kd.taxc.tsate.business.config.TaxofficeConfig;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.DeclareTypeEnum;

public class TsateCommonConfig
implements ITaxofficeConfig,
ISupplierConfig {
    private IOrgBaseConfig orgConfig = new OrgConfig();
    private ISupplierConfig supplierCfg;
    private ITaxofficeConfig taxofficeCfg;

    private TsateCommonConfig() {
        TaxofficeConfig taxofficeConfig = new TaxofficeConfig();
        taxofficeConfig.setOrgCfg(this.orgConfig);
        this.taxofficeCfg = taxofficeConfig;
        this.supplierCfg = new SupplierConfig(this.taxofficeCfg);
    }

    public static TsateCommonConfig getInstance() {
        TsateCommonConfig cfg = new TsateCommonConfig();
        return cfg;
    }

    @Override
    public SupplierEnum getSupplier(Long orgId, DeclareTypeEnum declareType) {
        return this.supplierCfg.getSupplier(orgId, declareType);
    }

    @Override
    public Set<SupplierEnum> getAllSupplier(Long orgId) {
        return this.supplierCfg.getAllSupplier(orgId);
    }

    @Override
    public Map<Long, Long> getTaxofficeId(List<Long> orgIds) {
        return this.taxofficeCfg.getTaxofficeId(orgIds);
    }

    @Override
    public Map<Long, Long> getTopTaxofficeId(List<Long> orgIds) {
        return this.taxofficeCfg.getTopTaxofficeId(orgIds);
    }

    @Override
    public Map<String, Object> getTaxofficeInfo(Long taxofficeId) {
        return this.taxofficeCfg.getTaxofficeInfo(taxofficeId);
    }
}

