/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business.creditlevel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.AppMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.taxc.tsate.common.util.ExceptionUtil;

public class TaxCreditLevelBusiness {
    private static final String ENTITY_NAME = "tsate_credit_level_list";
    private static final String KEY_COMPARERESULT = "compareresult";
    private static final String KEY_COMPAREMSG = "comparemsg";
    private static final String KEY_COVERRESULT = "coverresult";
    private static final String KEY_COVERMSG = "covermsg";
    private static final String KEY_YEAR = "year";
    private static final String KEY_LEVEL = "creditlevel";
    private static final String KEY_SCORE = "ratingscore";
    private static final String PERM_DIFF_ID = "3YVB/B8UZG/P";
    private static final String PERM_UPDATE_ID = "3YVB3XGYWQEF";
    private static Log logger = LogFactory.getLog(TaxCreditLevelBusiness.class);

    public static List<Map<String, Object>> compare(DynamicObject[] creditLevelObjects) {
        creditLevelObjects = TaxCreditLevelBusiness.getHasPermissionData(creditLevelObjects, PERM_DIFF_ID);
        List compareResultList = null;
        List<DynamicObject> list = Arrays.asList(creditLevelObjects);
        List paramList = list.stream().map(creditLevel -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("orgid", creditLevel.getDynamicObject("org").getLong("id"));
            map.put(KEY_YEAR, creditLevel.getInt("evaluationyear"));
            map.put(KEY_LEVEL, creditLevel.getString("evaluationlevel"));
            map.put(KEY_SCORE, creditLevel.getString("evaluationscore"));
            return map;
        }).collect(Collectors.toList());
        compareResultList = (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"TaxcMainCreditMService", (String)"compare", (Object[])new Object[]{paramList});
        return compareResultList;
    }

    public static void compareCredit(DynamicObject[] creditLevelObjects) {
        if (creditLevelObjects == null || creditLevelObjects.length == 0) {
            logger.info("\u7eb3\u7a0e\u4eba\u4fe1\u7528\u7b49\u7ea7\u5dee\u5f02\u5bf9\u6bd4--\u67e5\u8be2\u4e0d\u5230\u521d\u59cb\u4fe1\u7528\u7b49\u7ea7\u6570\u636e");
            return;
        }
        List<Map<String, Object>> compareResultList = TaxCreditLevelBusiness.compare(creditLevelObjects);
        if (compareResultList == null || compareResultList.isEmpty()) {
            logger.info("\u7eb3\u7a0e\u4eba\u4fe1\u7528\u7b49\u7ea7\u5dee\u5f02\u5bf9\u6bd4--\u4fe1\u7528\u7b49\u7ea7\u4fe1\u606f\u6216\u6bd4\u5bf9\u7ed3\u679c\u5217\u8868\u4e3a\u7a7a");
            return;
        }
        if (creditLevelObjects.length != compareResultList.size()) {
            logger.info("\u7eb3\u7a0e\u4eba\u4fe1\u7528\u7b49\u7ea7\u5dee\u5f02\u5bf9\u6bd4--\u4fe1\u7528\u7b49\u7ea7\u4fe1\u606f\u4e0e\u5bf9\u6bd4\u7ed3\u679c\u5217\u8868\u6570\u91cf\u4e0d\u4e00\u81f4");
            return;
        }
        int count = 0;
        for (DynamicObject creditLevel : creditLevelObjects) {
            Map<String, Object> compareResult = compareResultList.get(count);
            String result = (String)compareResult.get(KEY_COMPARERESULT);
            if ("diff".equals(result) || "notexist".equals(result)) {
                creditLevel.set("comparestatus", (Object)"diff");
                creditLevel.set("updatestatus", (Object)"undo");
                creditLevel.set(KEY_COMPAREMSG, null);
            } else if ("nodiff".equals(result)) {
                creditLevel.set("comparestatus", (Object)"same");
                creditLevel.set("updatestatus", (Object)"without");
                creditLevel.set(KEY_COMPAREMSG, null);
            } else {
                String msg = (String)compareResult.get(KEY_COMPAREMSG);
                creditLevel.set("comparestatus", (Object)"fail");
                creditLevel.set("updatestatus", (Object)"undo");
                creditLevel.set(KEY_COMPAREMSG, (Object)msg);
            }
            ++count;
        }
        SaveServiceHelper.update((DynamicObject[])creditLevelObjects);
    }

    public static void compareCreditWithDefaultFilter(DynamicObject[] creditLevelObjects) {
        try {
            if (creditLevelObjects == null || creditLevelObjects.length == 0) {
                logger.info("\u7a0e\u5c40\u4e0b\u8f7d\u89e6\u53d1\u7eb3\u7a0e\u4eba\u4fe1\u7528\u7b49\u7ea7\u5dee\u5f02\u5bf9\u6bd4--\u65e0\u521d\u59cb\u4fe1\u7528\u7b49\u7ea7\u6570\u636e");
                return;
            }
            ArrayList<Long> ids = new ArrayList<Long>(creditLevelObjects.length);
            for (DynamicObject creditLevel : creditLevelObjects) {
                ids.add(creditLevel.getLong("id"));
            }
            QFilter filter1 = new QFilter("id", "in", ids);
            QFilter filter2 = new QFilter("comparestatus", "in", (Object)new String[]{"undo", "fail"});
            QFilter filter3 = new QFilter("updatestatus", "=", (Object)"undo");
            DynamicObject[] objs = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)"id,comparestatus,comparemsg,updatemsg,updatestatus,evaluationyear,evaluationscore,evaluationlevel,org.id,org.name", (QFilter[])new QFilter[]{filter1, filter2, filter3});
            logger.info("\u7a0e\u5c40\u4e0b\u8f7d\u89e6\u53d1\u7eb3\u7a0e\u4eba\u4fe1\u7528\u7b49\u7ea7\u5dee\u5f02\u5bf9\u6bd4-objs " + (objs == null ? "null" : Integer.valueOf(objs.length)));
            objs = TaxCreditLevelBusiness.getHasPermissionData(objs, PERM_DIFF_ID);
            if (objs == null || objs.length == 0) {
                logger.info("\u7a0e\u5c40\u4e0b\u8f7d\u89e6\u53d1\u7eb3\u7a0e\u4eba\u4fe1\u7528\u7b49\u7ea7\u5dee\u5f02\u5bf9\u6bd4--\u65e0\u516c\u53f8\u5177\u6709\u5dee\u5f02\u5bf9\u6bd4\u6743\u9650");
            }
            TaxCreditLevelBusiness.compareCredit(objs);
        }
        catch (Exception e) {
            logger.error("\u7a0e\u5c40\u4e0b\u8f7d\u89e6\u53d1\u7eb3\u7a0e\u4eba\u4fe1\u7528\u7b49\u7ea7\u5dee\u5f02\u5bf9\u6bd4\u5931\u8d25" + ExceptionUtil.toString((Exception)e));
        }
    }

    public static List<Map<String, Object>> cover(DynamicObject[] creditLevelObjects) {
        List compareResultList = null;
        List<DynamicObject> list = Arrays.asList(creditLevelObjects);
        List paramList = list.stream().map(creditLevel -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("orgid", creditLevel.getDynamicObject("org").getLong("id"));
            map.put(KEY_YEAR, creditLevel.getInt("evaluationyear"));
            map.put(KEY_LEVEL, creditLevel.getString("evaluationlevel"));
            map.put(KEY_SCORE, creditLevel.getString("evaluationscore"));
            return map;
        }).collect(Collectors.toList());
        compareResultList = (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"TaxcMainCreditMService", (String)"cover", (Object[])new Object[]{paramList});
        return compareResultList;
    }

    public static void updateTaxMainInfo(DynamicObject[] creditLevelObjects) {
        if (creditLevelObjects == null || creditLevelObjects.length == 0) {
            return;
        }
        List<Map<String, Object>> updateResultList = TaxCreditLevelBusiness.cover(creditLevelObjects);
        if (updateResultList == null || updateResultList.isEmpty()) {
            return;
        }
        if (creditLevelObjects.length != updateResultList.size()) {
            return;
        }
        int count = 0;
        for (DynamicObject creditLevel : creditLevelObjects) {
            Map<String, Object> compareResult = updateResultList.get(count);
            String result = (String)compareResult.get(KEY_COVERRESULT);
            if ("success".equals(result)) {
                creditLevel.set("updatestatus", (Object)"updated");
                creditLevel.set("updatemsg", null);
            } else if ("noneed".equals(result)) {
                creditLevel.set("updatestatus", (Object)"without");
                creditLevel.set("updatemsg", null);
            } else {
                String msg = (String)compareResult.get(KEY_COVERMSG);
                creditLevel.set("updatestatus", (Object)"fail");
                creditLevel.set("updatemsg", (Object)msg);
            }
            ++count;
        }
        SaveServiceHelper.update((DynamicObject[])creditLevelObjects);
    }

    public static void updateTaxMainInfoWithDefaultFilter(DynamicObject[] creditLevelObjects) {
        try {
            if (creditLevelObjects == null || creditLevelObjects.length == 0) {
                return;
            }
            ArrayList<Long> ids = new ArrayList<Long>(creditLevelObjects.length);
            for (DynamicObject creditLevel : creditLevelObjects) {
                ids.add(creditLevel.getLong("id"));
            }
            QFilter filter1 = new QFilter("id", "in", ids);
            QFilter filter3 = new QFilter("comparestatus", "=", (Object)"diff");
            QFilter filter2 = new QFilter("updatestatus", "in", (Object)new String[]{"undo", "fail"});
            DynamicObject[] objs = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)"id,comparestatus,comparemsg,updatestatus,updatemsg,evaluationyear,evaluationscore,evaluationlevel,org.id,org.name", (QFilter[])new QFilter[]{filter1, filter2, filter3});
            logger.info("\u66f4\u65b0\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f-objs " + (objs == null ? "null" : Integer.valueOf(objs.length)));
            objs = TaxCreditLevelBusiness.getHasPermissionData(objs, PERM_UPDATE_ID);
            if (objs == null || objs.length == 0) {
                logger.info("\u66f4\u65b0\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f--\u65e0\u516c\u53f8\u5177\u6709\u66f4\u65b0\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u6743\u9650");
            }
            TaxCreditLevelBusiness.updateTaxMainInfo(objs);
        }
        catch (Exception e) {
            logger.error("\u7a0e\u5c40\u4e0b\u8f7d\u89e6\u53d1\u7eb3\u7a0e\u4eba\u4fe1\u7528\u7b49\u7ea7\u66f4\u65b0\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u5931\u8d25" + ExceptionUtil.toString((Exception)e));
        }
    }

    public static DynamicObject[] getHasPermissionData(DynamicObject[] creditLevelObjects, String permId) {
        if (creditLevelObjects == null || creditLevelObjects.length == 0) {
            logger.info("\u7a0e\u5c40\u4e0b\u8f7d\u89e6\u53d1\u7eb3\u7a0e\u4eba\u4fe1\u7528\u7b49\u7ea7\u5dee\u5f02\u5bf9\u6bd4--\u67e5\u8be2\u4e0d\u5230\u521d\u59cb\u4fe1\u7528\u7b49\u7ea7\u6570\u636e");
            return null;
        }
        List<DynamicObject> creditLevelList = Arrays.asList(creditLevelObjects);
        Set orgIds = creditLevelList.stream().map(creditLevel -> creditLevel.getDynamicObject("org").getLong("id")).collect(Collectors.toSet());
        String appId = AppMetadataCache.getAppInfo((String)"tsate").getId();
        Long userId = UserServiceHelper.getCurrentUserId();
        HashMap<Long, Boolean> hasPermissionMap = new HashMap<Long, Boolean>();
        Iterator iterator = orgIds.iterator();
        while (iterator.hasNext()) {
            Long orgid;
            hasPermissionMap.put(orgid, PermissionServiceHelper.checkPermission((Long)userId, (Long)(orgid = (Long)iterator.next()), (String)appId, (String)ENTITY_NAME, (String)permId) == 1);
        }
        List<DynamicObject> filteredList = creditLevelList.stream().filter(creditLevel -> hasPermissionMap.getOrDefault(creditLevel.getDynamicObject("org").getLong("id"), false)).collect(Collectors.toList());
        DynamicObject[] filteredArray = filteredList.toArray(new DynamicObject[0]);
        return filteredArray;
    }
}

