/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business.datafetch;

import com.alibaba.fastjson.JSON;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.taxc.tsate.business.datafetch.Calculate;
import kd.taxc.tsate.business.datafetch.Condition;
import kd.taxc.tsate.business.datafetch.Context;
import kd.taxc.tsate.business.datafetch.FetchData;
import kd.taxc.tsate.business.datafetch.params.CalCommand;
import kd.taxc.tsate.business.datafetch.params.FetchParam;
import kd.taxc.tsate.common.util.ExceptionUtil;

public class Fetcher {
    private static Log LOG = LogFactory.getLog(Fetcher.class);
    private Context context = new Context();
    private FetchData fetchData;
    private Condition condition = new Condition(this.context);
    private Calculate calculate;

    public Fetcher() {
        this.fetchData = new FetchData(this.context, this.condition);
        this.calculate = new Calculate(this.context, this.condition);
    }

    public void initContext(Map<String, Object> map) {
        this.context.setData(map);
    }

    public Context getContext() {
        return this.context;
    }

    public boolean condition(QFilter filter) {
        return this.condition.check(filter);
    }

    public void fetch(FetchParam p) {
        this.fetchData.query(p.getCondition(), p.getDataKey(), p.getMetaName(), p.getFilds().toArray(new String[0]), p.getFilters().toArray(new QFilter[0]));
    }

    public void cal(CalCommand command) {
        try {
            this.calculate.excute(command);
        }
        catch (Exception e) {
            LOG.error(ExceptionUtil.toString((Exception)e));
            StringBuilder err = new StringBuilder(ResManager.loadKDString((String)"FETCHRE\u8ba1\u7b97\u9519\u8bef,", (String)"Fetcher_0", (String)"taxc-tsate-business", (Object[])new Object[0]));
            err.append(ResManager.loadKDString((String)"\u6307\u4ee4\u4fe1\u606f\uff1a", (String)"Fetcher_1", (String)"taxc-tsate-business", (Object[])new Object[0])).append(command).append("\n");
            err.append(ResManager.loadKDString((String)"\u4e0a\u4e0b\u6587:", (String)"Fetcher_2", (String)"taxc-tsate-business", (Object[])new Object[0])).append(JSON.toJSONString((Object)this.context));
            LOG.error(err.toString());
        }
    }
}

