/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business.datafetch.params;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.orm.query.QFilter;
import kd.taxc.tsate.business.datafetch.Context;
import kd.taxc.tsate.business.datafetch.params.CalCommand;
import kd.taxc.tsate.business.datafetch.params.FetchParam;
import kd.taxc.tsate.business.datafetch.params.FetcherStep;

public class FetchParamHelper {
    private static final String KEY_STR = "k";
    private static final String QCP = "cp";
    private static final String VALUE = "v";
    private static final String SUBLIST = "nests";
    private static final String NEST = "op";
    private static final String NEST_AND = "AND";
    private static final String NEST_OR = "OR";
    private static final String FILTER = "filter";
    private static final String DATA_KEY = "dataKey";
    private static final String METANAME = "metaName";
    private static final String SELECT_FILDS = "selectFilds";
    private static final String FILTERS = "filters";
    private static final String SPLIT_SIMBOL = ",";
    private static final String CONDITION = "condition";
    private static final String METHDNAME = "methodName";
    private static final String METHDPARAMS = "params";
    private static final String STEP_NAME = "name";
    private static final String STEP_PARAM = "param";

    public static QFilter buildFilter(JSONObject json, Context context) {
        String key = json.getString(KEY_STR);
        String qcp = json.getString(QCP);
        Object value = json.getString(VALUE);
        value = context.buildData(value);
        QFilter filter = new QFilter(key, qcp, value);
        JSONArray subList = json.getJSONArray(SUBLIST);
        if (subList == null) {
            subList = new JSONArray();
        }
        for (Object obj : subList) {
            if (!(obj instanceof JSONObject)) continue;
            JSONObject subObj = (JSONObject)obj;
            String nest = subObj.getString(NEST);
            QFilter subFilter = FetchParamHelper.buildFilter(subObj.getJSONObject(FILTER), context);
            if (NEST_AND.equals(nest)) {
                filter.and(subFilter);
                continue;
            }
            filter.or(subFilter);
        }
        return filter;
    }

    public static JSONObject buildFilterJson(QFilter q) {
        JSONObject json = new JSONObject();
        json.put(KEY_STR, (Object)q.getProperty());
        json.put(QCP, (Object)q.getCP());
        json.put(VALUE, q.getValue());
        List sub = q.getNests(false);
        ArrayList<JSONObject> list = new ArrayList<JSONObject>(8);
        json.put(SUBLIST, list);
        for (QFilter.QFilterNest nest : sub) {
            String join = nest.isAnd() ? NEST_AND : NEST_OR;
            JSONObject nestJ = new JSONObject();
            nestJ.put(NEST, (Object)join);
            JSONObject subJ = FetchParamHelper.buildFilterJson(nest.getFilter());
            nestJ.put(FILTER, (Object)subJ);
            list.add(nestJ);
        }
        return json;
    }

    public static JSONObject buildFetchParamJson(FetchParam param) {
        JSONObject json = new JSONObject();
        json.put(DATA_KEY, (Object)param.getDataKey());
        json.put(METANAME, (Object)param.getMetaName());
        StringBuilder filds = new StringBuilder();
        param.getFilds().forEach(f -> filds.append((String)f).append(SPLIT_SIMBOL));
        filds.delete(filds.length() - 1, filds.length());
        json.put(SELECT_FILDS, (Object)filds);
        JSONArray jArray = new JSONArray();
        for (QFilter filter : param.getFilters()) {
            JSONObject qJson = FetchParamHelper.buildFilterJson(filter);
            jArray.add((Object)qJson);
        }
        json.put(FILTERS, (Object)jArray);
        return json;
    }

    public static FetchParam buildFetchParam(JSONObject json, Context context) {
        String dataKey = json.getString(DATA_KEY);
        dataKey = (String)context.buildData(dataKey);
        String metaName = json.getString(METANAME);
        metaName = (String)context.buildData(metaName);
        JSONObject conditionJ = json.getJSONObject(CONDITION);
        QFilter condition = null;
        if (conditionJ != null) {
            condition = FetchParamHelper.buildFilter(conditionJ, context);
        }
        String selectFilds = json.getString(SELECT_FILDS);
        String[] filds = selectFilds.split(SPLIT_SIMBOL);
        ArrayList<String> fildsList = new ArrayList<String>(8);
        for (String f : filds) {
            fildsList.add((String)context.buildData(f));
        }
        JSONArray filtes = json.getJSONArray(FILTERS);
        ArrayList<QFilter> qfilts = new ArrayList<QFilter>(8);
        for (int i = 0; i < filtes.size(); ++i) {
            JSONObject jFilter = filtes.getJSONObject(i);
            QFilter filter = FetchParamHelper.buildFilter(jFilter, context);
            qfilts.add(filter);
        }
        FetchParam param = new FetchParam();
        param.setDataKey(dataKey);
        param.setMetaName(metaName);
        param.setFilds(fildsList);
        param.setFilters(qfilts);
        param.setCondition(condition);
        return param;
    }

    public static CalCommand buildCalculateParams(JSONObject json, Context context) {
        JSONObject conditionJ = json.getJSONObject(CONDITION);
        QFilter condition = null;
        if (conditionJ != null) {
            condition = FetchParamHelper.buildFilter(conditionJ, context);
        }
        String methodName = json.getString(METHDNAME);
        JSONArray methodParams = json.getJSONArray(METHDPARAMS);
        ArrayList<Object> params = new ArrayList<Object>();
        for (Object item : methodParams) {
            if (item instanceof JSONArray) {
                JSONArray jArray = (JSONArray)item;
                params.add(jArray.toJavaList(Map.class));
                continue;
            }
            if (item instanceof JSONObject) {
                JSONObject j = (JSONObject)item;
                params.add(j.toJavaObject(Map.class));
                continue;
            }
            params.add(item);
        }
        CalCommand calCommand = new CalCommand();
        calCommand.setConditon(condition);
        calCommand.setMethodName(methodName);
        calCommand.setParams(params);
        return calCommand;
    }

    public static JSONObject buildCalculateParamsJSON(CalCommand calCommand) {
        JSONObject json = new JSONObject();
        json.put(CONDITION, (Object)FetchParamHelper.buildFilterJson(calCommand.getConditon()));
        json.put(METHDNAME, (Object)calCommand.getMethodName());
        json.put(METHDPARAMS, JSON.toJSON(calCommand.getParams()));
        return json;
    }

    public static FetcherStep buildFetcherStep(JSONObject json, Context context) {
        FetcherStep<Object> step = new FetcherStep<Object>();
        String name = json.getString(STEP_NAME);
        step.setClazzName(name);
        if (FetchParam.class.getName().equals(name)) {
            FetchParam fetchparam = FetchParamHelper.buildFetchParam(json.getJSONObject(STEP_PARAM), context);
            step.setStepParam(fetchparam);
        } else if (CalCommand.class.getName().equals(name)) {
            CalCommand calCommand = FetchParamHelper.buildCalculateParams(json.getJSONObject(STEP_PARAM), context);
            step.setStepParam(calCommand);
        }
        return step;
    }

    public static JSONObject buildFetcherStepJSON(FetcherStep step) {
        JSONObject json = new JSONObject();
        String name = step.getClazzName();
        json.put(STEP_NAME, (Object)step.getClazzName());
        if (FetchParam.class.getName().equals(name)) {
            FetchParam param = (FetchParam)step.getStepParam();
            JSONObject fJ = FetchParamHelper.buildFetchParamJson(param);
            json.put(STEP_PARAM, (Object)fJ);
        } else if (CalCommand.class.getName().equals(name)) {
            CalCommand param = (CalCommand)step.getStepParam();
            JSONObject fJ = FetchParamHelper.buildCalculateParamsJSON(param);
            json.put(STEP_PARAM, (Object)fJ);
        }
        return json;
    }
}

