/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business.declare;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.tsate.business.TsateChannelBusiness;
import kd.taxc.tsate.business.declare.TsateBaseDeclareService;
import kd.taxc.tsate.business.declare.api.ICancelDeclareService;
import kd.taxc.tsate.business.declare.declaremain.DeclarationMainFormBusniess;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.ExecuteTypeEnums;
import kd.taxc.tsate.common.util.JobUtils;

public class CancelDeclareServiceImpl
extends TsateBaseDeclareService
implements ICancelDeclareService {
    private static Log LOGGER = LogFactory.getLog(CancelDeclareServiceImpl.class);

    @Override
    public boolean support(List<Long> orgIds) {
        Map<Long, Map<String, Object>> channelConfigs = this.getOrgChannelConfigFromCache(orgIds);
        HashSet<SupplierEnum> suppliers = new HashSet<SupplierEnum>(8);
        for (Long orgId : orgIds) {
            suppliers.addAll(this.getSupplierFromConfig(channelConfigs, orgId));
        }
        boolean support = false;
        for (SupplierEnum s : this.getSupportSuppliers()) {
            support = support || suppliers.contains(s);
        }
        return support;
    }

    @Override
    public List<Map<String, Object>> sendTask(List<Long> declareIds) {
        Long declareId;
        List<DynamicObject> declares = DeclarationMainFormBusniess.queryByIdsNotThrowEx(declareIds);
        Map<Long, SupplierEnum> declareSupplers = TsateChannelBusiness.getDeclareChannelByData(declares);
        ArrayList<DynamicObject> tobeSend = new ArrayList<DynamicObject>(8);
        Map<Long, String> erros = this.validateSupplierConfig(declares, declareSupplers, tobeSend);
        ArrayList params = new ArrayList(8);
        for (DynamicObject declare : tobeSend) {
            String sbbid = String.valueOf(declare.get("id"));
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("messageId", UUID.randomUUID().toString().replaceAll("-", ""));
            paramMap.put("transrc", ExecuteTypeEnums.ZLSB.getKey());
            paramMap.put("businessId", sbbid);
            paramMap.put("isQuery", false);
            paramMap.put("operationType", ExecuteTypeEnums.SBZF.getKey());
            paramMap.put("nsrsbh", declare.getString("nsrsbh"));
            try {
                paramMap.put("recordtype", "SBZF");
                DynamicObject recordLog = CancelDeclareServiceImpl.assembleDeclareRecord(declare, "SBZF");
                paramMap.put("recordid", recordLog.getLong("id"));
                paramMap.put("key", ExecuteTypeEnums.SBZF.getKey());
                params.add(paramMap);
            }
            catch (Exception e) {
                LOGGER.error("invokeBizSerivce error:" + e);
            }
        }
        JobUtils.submitJobs(params);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(8);
        for (Map.Entry<Long, String> erro : erros.entrySet()) {
            declareId = erro.getKey();
            String erroMsg = erro.getValue();
            result.add(this.genTaskExecuteInfo(declareId, true, erroMsg));
        }
        for (DynamicObject pass : tobeSend) {
            declareId = pass.getLong("id");
            result.add(this.genTaskExecuteInfo(declareId, false, ResManager.loadKDString((String)"\u6210\u529f", (String)"CancelDeclareServiceImpl_0", (String)"taxc-tsate-business", (Object[])new Object[0])));
        }
        return result;
    }

    @Override
    public Set<SupplierEnum> getSupportSuppliers() {
        HashSet<SupplierEnum> sets = new HashSet<SupplierEnum>(8);
        sets.add(SupplierEnum.YZF);
        sets.add(SupplierEnum.GXSJ);
        sets.add(SupplierEnum.QXY);
        return sets;
    }

    @Override
    public Map<Long, String> validateCancelData(List<Long> declareIds) {
        HashMap<Long, String> erros = new HashMap<Long, String>(8);
        List<DynamicObject> declares = DeclarationMainFormBusniess.queryByIdsNotThrowEx(declareIds);
        this.validateOrgSubject(declares, erros);
        if (erros.size() > 0) {
            return erros;
        }
        this.validateStatus(declares, erros);
        return erros;
    }

    private void validateStatus(List<DynamicObject> declares, Map<Long, String> erros) {
        for (DynamicObject declare : declares) {
            Long declareId = declare.getLong("id");
            StringBuilder erro = new StringBuilder();
            if ("declared".equals(declare.getString("declarestatus")) && ("unpaid".equals(declare.getString("paystatus")) || "nopay".equals(declare.getString("paystatus")) || "payfailed".equals(declare.getString("paystatus")) || "yypayfailed".equals(declare.getString("paystatus")) || "yypaid".equals(declare.getString("paystatus"))) && "1".equals(DeclarationMainFormBusniess.getDeclareMethodByModel3(declare))) continue;
            erro.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7533\u62a5\u72b6\u6001\u4e3a\u201c\u7533\u62a5\u6210\u529f\u201d\uff0c\u7f34\u6b3e\u72b6\u6001\u4e3a\u201c\u672a\u7f34\u6b3e/\u65e0\u9700\u7f34\u6b3e/\u7f34\u6b3e\u5931\u8d25/\u9884\u7ea6\u5931\u8d25/\u9884\u7ea6\u6210\u529f\uff08\u672a\u5230\u9884\u7ea6\u65f6\u95f4\uff09\u201d\u4e14\u7533\u62a5\u65b9\u5f0f\u4e3a\u201c\u76f4\u8fde\u7533\u62a5\u201d\u7684\u8bb0\u5f55\uff0c\u624d\u80fd\u8fdb\u884c\u7533\u62a5\u4f5c\u5e9f\u64cd\u4f5c\uff1a%s \u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"CancelDeclareServiceImpl_1", (String)"taxc-tsate-business", (Object[])new Object[]{this.getDeclareDescr(declare)}), new Object[0]));
            erros.put(declareId, erro.toString());
        }
    }
}

