/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business.declare;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.enums.tpo.DeclareOperationEnum;
import kd.taxc.tsate.business.TsateChannelBusiness;
import kd.taxc.tsate.business.declare.TsateBaseDeclareService;
import kd.taxc.tsate.business.declare.api.IDirectDeclareService;
import kd.taxc.tsate.business.declare.declaremain.DeclarationMainFormBusniess;
import kd.taxc.tsate.business.declare.validete.helper.DeclareValidateService;
import kd.taxc.tsate.business.taxdialog.TasteDeclarePopupBusiness;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.constant.taxdialog.vo.qxy.PoppupStatusEnum;
import kd.taxc.tsate.common.enums.ExecuteTypeEnums;
import kd.taxc.tsate.common.metadata.MetadataUtil;
import kd.taxc.tsate.common.util.CommonInfoUtil;
import kd.taxc.tsate.common.util.ExceptionUtil;
import kd.taxc.tsate.common.util.JobUtils;

public class DirectDeclareServiceImpl
extends TsateBaseDeclareService
implements IDirectDeclareService {
    private static Log LOGGER = LogFactory.getLog(DirectDeclareServiceImpl.class);

    private DynamicObject dealTysbb(DynamicObject declare) {
        return this.dealTysbb(declare, false);
    }

    private DynamicObject dealTysbb(DynamicObject declare, boolean isValidate) {
        try {
            if (declare != null) {
                DynamicObject channelObj;
                DynamicObject org = declare.getDynamicObject("org");
                Date skssqq = declare.getDate("skssqq");
                Date skssqz = declare.getDate("skssqz");
                QFilter qFilter = new QFilter("org", "=", (Object)org.getLong("id"));
                QFilter billstatusFilter = null;
                if (!isValidate) {
                    billstatusFilter = new QFilter("billstatus", "=", (Object)"C");
                }
                QFilter declareTypeQfilter = new QFilter("declaretype", "!=", (Object)"0");
                QFilter delcareStatusQfilter = new QFilter("declarestatus", "!=", (Object)"declared");
                QFilter typeFilter = "qtsf_fsstysbb".equals(DeclarationMainFormBusniess.getDeclareTypeByModel3(declare)) ? new QFilter("type", "=", (Object)"qtsf_tysbb") : new QFilter("type", "=", (Object)"qtsf_fsstysbb");
                QFilter skssqqzFilter = new QFilter("skssqq", ">=", (Object)skssqq).and(new QFilter("skssqz", "<=", (Object)skssqz));
                DynamicObject tysbDeclare = BusinessDataServiceHelper.loadSingle((String)"tsate_declare_query_list", (String)MetadataUtil.getAllFieldString((String)"tsate_declare_query_list"), (QFilter[])new QFilter[]{qFilter, typeFilter, skssqqzFilter, declareTypeQfilter, billstatusFilter, delcareStatusQfilter});
                if (tysbDeclare != null && (channelObj = CommonInfoUtil.getChannel((Long)tysbDeclare.getLong("id"))) != null) {
                    String channelNumber = channelObj.getDynamicObject("declarechannel").getString("number");
                    if (SupplierEnum.SZYH.getCode().equals(channelNumber)) {
                        return tysbDeclare;
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(ResManager.loadKDString((String)"\u5408\u5e76\u5904\u7406\u5931\u8d25", (String)"DirectDeclareServiceImpl_0", (String)"taxc-tsate-business", (Object[])new Object[0]));
        }
        return null;
    }

    @Override
    public List<Map<String, Object>> validateDeclareData(List<Long> declareIds) {
        List<DynamicObject> declares = DeclarationMainFormBusniess.queryByIdsNotThrowEx(declareIds);
        HashMap<Long, String> failMsgs = new HashMap<Long, String>(8);
        HashMap<Long, String> riskMsgs = new HashMap<Long, String>(8);
        HashMap<Long, String> dialogMsgs = new HashMap<Long, String>(8);
        this.validateOrgSubject(declares, failMsgs);
        if (failMsgs.size() > 0) {
            return this.getValidateResult(failMsgs, riskMsgs, dialogMsgs);
        }
        Map<Long, SupplierEnum> declareChannels = TsateChannelBusiness.getDeclareChannelByData(declares);
        DeclareValidateService.validateDeclareData(declares, declareChannels, failMsgs, riskMsgs);
        this.validateDialog(declares, dialogMsgs);
        return this.getValidateResult(failMsgs, riskMsgs, dialogMsgs);
    }

    private List<Map<String, Object>> getValidateResult(Map<Long, String> failMsgs, Map<Long, String> riskMsgs, Map<Long, String> dialogMsgs) {
        ArrayList<Map<String, Object>> validateInfos = new ArrayList<Map<String, Object>>(8);
        HashSet<Long> notifyDeclareId = new HashSet<Long>(8);
        notifyDeclareId.addAll(failMsgs.keySet());
        notifyDeclareId.addAll(riskMsgs.keySet());
        notifyDeclareId.addAll(dialogMsgs.keySet());
        for (Long declareId : notifyDeclareId) {
            HashMap<String, Object> info = new HashMap<String, Object>(8);
            boolean isfail = false;
            boolean isrisk = false;
            boolean isdialog = false;
            if (failMsgs.containsKey(declareId)) {
                isfail = true;
                info.put("failmsg", this.removeSeperator(failMsgs.get(declareId)));
            }
            if (riskMsgs.containsKey(declareId)) {
                isrisk = true;
                info.put("riskmsg", this.removeSeperator(riskMsgs.get(declareId)));
            }
            if (dialogMsgs.containsKey(declareId)) {
                isdialog = true;
                info.put("dialogmsg", this.removeSeperator(dialogMsgs.get(declareId)));
            }
            info.put("isfail", isfail);
            info.put("isrisk", isrisk);
            info.put("isdialog", isdialog);
            info.put("sbbid", declareId);
            validateInfos.add(info);
        }
        return validateInfos;
    }

    private String removeSeperator(String str) {
        return str.replaceAll(System.lineSeparator(), "");
    }

    private void validateDialog(List<DynamicObject> declares, Map<Long, String> dialogMsgs) {
        List<Long> ids = declares.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
        List<Long> tobeSetList = TasteDeclarePopupBusiness.querySbbIdsWithPopup(ids);
        HashSet<Long> tobeSetIds = new HashSet<Long>(8);
        tobeSetIds.addAll(tobeSetList);
        for (DynamicObject declare : declares) {
            Long declareId = declare.getLong("id");
            if (!tobeSetIds.contains(declareId)) continue;
            StringBuilder dialogMsg = new StringBuilder();
            dialogMsg.append((CharSequence)this.getDeclareDescr(declare)).append(ResManager.loadKDString((String)" \u672a\u914d\u7f6e\u7a0e\u5c40\u53cd\u9988\u4fe1\u606f\u53ef\u80fd\u5bfc\u81f4\u7533\u62a5\u5931\u8d25\uff0c\u786e\u8ba4\u7ee7\u7eed\u7533\u62a5\u5417\uff1f", (String)"DirectDeclareServiceImpl_8", (String)"taxc-tsate-business", (Object[])new Object[0]));
            dialogMsgs.put(declareId, dialogMsg.toString());
        }
    }

    @Override
    public boolean support(List<Long> orgIds) {
        return true;
    }

    @Override
    public List<Map<String, Object>> sendTask(List<Long> declareIds) {
        Long declareId;
        List<DynamicObject> declares = DeclarationMainFormBusniess.queryByIdsNotThrowEx(declareIds);
        Map<Long, SupplierEnum> declareSupplers = TsateChannelBusiness.getDeclareChannelByData(declares);
        ArrayList<DynamicObject> tobeSend = new ArrayList<DynamicObject>(8);
        Map<Long, String> erros = this.validateSupplierConfig(declares, declareSupplers, tobeSend);
        ArrayList<DynamicObject> records = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> relationRecords = new ArrayList<DynamicObject>(8);
        HashMap<Long, Long> relationRecordIds = new HashMap<Long, Long>(8);
        this.saveDeclareStatusAndRecord(tobeSend, records, relationRecords, relationRecordIds, declareSupplers);
        List<Map<String, Object>> params = this.getTaskParams(records, relationRecordIds);
        JobUtils.submitJobs(params);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(8);
        for (Map.Entry<Long, String> erro : erros.entrySet()) {
            declareId = erro.getKey();
            String erroMsg = erro.getValue();
            result.add(this.genTaskExecuteInfo(declareId, true, erroMsg));
        }
        for (DynamicObject pass : tobeSend) {
            declareId = pass.getLong("id");
            result.add(this.genTaskExecuteInfo(declareId, false, ResManager.loadKDString((String)"\u6210\u529f", (String)"DirectDeclareServiceImpl_7", (String)"taxc-tsate-business", (Object[])new Object[0])));
        }
        return result;
    }

    public static List<Map<String, Object>> sendTaskBusines(String sbbid) {
        return new DirectDeclareServiceImpl().sendTask(Collections.singletonList(Long.parseLong(sbbid)));
    }

    private void saveDeclareStatusAndRecord(List<DynamicObject> declares, List<DynamicObject> records, List<DynamicObject> relationRecords, Map<Long, Long> relationDeclareIds, Map<Long, SupplierEnum> declareSuppliers) {
        ArrayList<DynamicObject> declarsFull = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> tysbObjs = new ArrayList<DynamicObject>();
        for (DynamicObject declare : declares) {
            Long declareId = declare.getLong("id");
            try {
                DynamicObject tysbbDeclare;
                declare.set("declarestatus", (Object)"submitted");
                declare.set("declaremethod", (Object)"1");
                declare.set("declarer", (Object)RequestContext.get().getUserId());
                declare.set("sbrq", (Object)new Date());
                SupplierEnum supplier = declareSuppliers.get(declareId);
                if (("qtsf_tysbb".equals(DeclarationMainFormBusniess.getDeclareTypeByModel3(declare)) || "qtsf_fsstysbb".equals(DeclarationMainFormBusniess.getDeclareTypeByModel3(declare))) && SupplierEnum.SZYH == supplier && (tysbbDeclare = this.dealTysbb(declare)) != null) {
                    tysbbDeclare.set("declarestatus", (Object)"submitted");
                    tysbbDeclare.set("declaretype", (Object)"1");
                    tysbbDeclare.set("declarer", (Object)RequestContext.get().getUserId());
                    tysbbDeclare.set("sbrq", (Object)new Date());
                    tysbObjs.add(tysbbDeclare);
                    DynamicObject tysbRecord = DirectDeclareServiceImpl.assembleDeclareRecord(tysbbDeclare, "ZLSB");
                    relationRecords.add(tysbRecord);
                    relationDeclareIds.put(declareId, tysbbDeclare.getLong("id"));
                }
                DynamicObject record = DirectDeclareServiceImpl.assembleDeclareRecord(declare, "ZLSB");
                records.add(record);
                declarsFull.add(declare);
                declarsFull.addAll(tysbObjs);
            }
            catch (Exception e) {
                LOGGER.error("invokeBizSerivce error:{}", (Object)ExceptionUtil.toString((Exception)e));
            }
        }
        DeclarationMainFormBusniess.updateDeclareMainTable(declarsFull, DeclareOperationEnum.DIRECTDECLARE);
    }

    private List<Map<String, Object>> getTaskParams(List<DynamicObject> records, Map<Long, Long> declareRelationId) {
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>(8);
        for (DynamicObject record : records) {
            String sbbid = record.getString("sbbid");
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("messageId", UUID.randomUUID().toString().replaceAll("-", ""));
            paramMap.put("transrc", ExecuteTypeEnums.ZLSB.getKey());
            paramMap.put("businessId", sbbid);
            paramMap.put("isQuery", false);
            paramMap.put("operationType", ExecuteTypeEnums.ZLSB.getKey());
            Long recordId = record.getLong("id");
            paramMap.put("recordid", recordId);
            paramMap.put("key", ExecuteTypeEnums.ZLSB.getKey());
            paramMap.put("supplier", record.get("channel"));
            if (declareRelationId.containsKey(Long.parseLong(sbbid))) {
                paramMap.put("relationid", declareRelationId.get(Long.parseLong(sbbid)));
            }
            params.add(paramMap);
        }
        return params;
    }

    @Override
    public Set<SupplierEnum> getSupportSuppliers() {
        HashSet<SupplierEnum> sets = new HashSet<SupplierEnum>(8);
        sets.add(SupplierEnum.YZF);
        sets.add(SupplierEnum.GXSJ);
        sets.add(SupplierEnum.SZYH);
        sets.add(SupplierEnum.CLOUDCC);
        sets.add(SupplierEnum.ZWY);
        sets.add(SupplierEnum.GZDZSJ);
        sets.add(SupplierEnum.HBDZSJ);
        sets.add(SupplierEnum.QXY);
        return sets;
    }

    public void setDialogStatus(List<Long> declareIds, String status) {
        PoppupStatusEnum statusEnum = PoppupStatusEnum.valueOfCode((String)status);
        if (statusEnum != null) {
            TasteDeclarePopupBusiness.updatePopupDataStatusBySbbids(declareIds, statusEnum);
        }
    }
}

